/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "lps_typ.h"

void	lps_typ::Init()
{
	Int4	arg,x,tm;
	double	dd;
	// time1=time(NULL); tckS=clock();
	CMA=0; NumThrds=0; fp=0;
        output_rtf=FALSE;
	Num2Retain=1000;
        percent_id=40;  // twkcma -U=40
	SizeGSM=2500;
        MinCol=0.80;

	TurnOffLicenseStatement();
	AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	if(argc < 2) PrintError();
        for(arg = 2; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_LAPIS);
	   if(argv[arg][1] == 'm'){
		if(sscanf(argv[arg],"-mincol=%lf",&dd) == 1){
		   if(dd > 1.0 || dd < 0.30) print_error(USAGE_LAPIS);
		   MinCol=dd; argv[arg][1]=' ';
		} else if(sscanf(argv[arg],"-maxseq=%d",&x) == 1){
		   // do nothing...pass along to gismo?
		} else print_error(USAGE_LAPIS);
	   } else if(argv[arg][1] == 'p'){
		if(sscanf(argv[arg],"-pcid=%d",&x) == 1){
		   if(x > 100 || x < 30) print_error(USAGE_LAPIS);
		   percent_id=x; argv[arg][1]=' ';
		} else print_error(USAGE_LAPIS);
	   } else if(argv[arg][1] == 'r'){
                if(strcmp("-rtf",argv[arg]) == 0){ output_rtf=TRUE; }
		else print_error(USAGE_LAPIS);
	   } else if(argv[arg][1] == 's'){
		if(sscanf(argv[arg],"-size=%d",&x) == 1){
		   if(x < 100 || x > 10000) print_error(USAGE_LAPIS);
		   SizeGSM=x;
		   argv[arg][1]=' ';
		} else if(sscanf(argv[arg],"-stages=%d",&x) == 1){
		   // do nothing...pass along to gismo?
		} else if(sscanf(argv[arg],"-seed=%d",&x) == 1){
		   // do nothing...pass along to gismo?
		} else print_error(USAGE_LAPIS);
	   } else if(argv[arg][1] == 't'){
		if(sscanf(argv[arg],"-thrds=%d",&NumThrds) == 1){
		   if(NumThrds < 2 || NumThrds > 100) print_error(USAGE_LAPIS);
		} else print_error(USAGE_LAPIS);
	   } else if(argv[arg][1] == 0){
		   print_error(USAGE_LAPIS);
           }
	}
}


