#if !defined (LAPIS_USAGE)
#define LAPIS_USAGE

#define LAPIS_VERSION "\
  ----------------------------------------------------\n\
     LAPIS v0.0.1 by aneuwald@som.umaryland.edu\n\
     www.igs.umaryland.edu/labs/neuwald/software/lapis/\n\
     Copyright 2015-2020 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define LAPIS_USAGE_PLUS "\
Lots of Accurately-aligned Proteins Initiated from Scratch\n\
Usage 1: lapis <dbs>  (run lapis using gismo & mapgaps)\n\
	type 'lapis <dbs> -' for usage options\n\
Usage 2: lapis <query> <dbs> (run jackhmmer search using a query sequence)\n\
	type 'lapis query <dbs> -' for usage options\n\
\n"

#define LAPIS_USAGE_JH "lapis <query> <dbs> \n\
  options:\n\
       -thrds=<int>    - Multithreading with <int> threads (range: 2 to 100; default: 1)\n\
  Reference:\n\
	Johnson LS, Eddy SR, Portugaly E. 2010. Hidden Markov model speed heuristic and iterative \n\
           HMM search procedure. BMC Bioinformatics 11:431. doi: 10.1186/1471-2105-11-431.\n\
\n"

#define USAGE_LAPIS "\
Lots of Accurately-aligned Proteins Initiated from Scratch\n\
Usage: lapis fastafile [options] \n\
  options:\n\
       -h=<int>        - Number of initial block-based alignments (2 to 50: default 2)\n\
       -H=<int>        - Number of candidate HMM alignments (2 to 50: default 2)\n\
       -iters=<int>    - Add/remove column interations in stages 2 to 4 (1 to 5: default 3)\n\
       -L              - Mask low complexity regions (default: off)\n\
       -mincol=<real>  - Template minimum fraction of matching columns (default: 0.8)\n\
       -pcid=<int>     - Template MSA percent sequence identity (default: 40)\n\
       -thrds=<int>    - Multithreading with <int> threads (range: 2 to 100; default: 1)\n\
                         Note: the best alignment among the threads will be saved.\n\
       -rtf            - Also output a MS-Word-viewable rich text file (*.rtf)\n\
       -seed=<int>     - Random seed\n\
       -size=<int>     - Number of GISMO input seqs (range: 100-10000; default: 2500)\n\
       -stages=<int>   - Specify the number of sampling stages (2 to 4: default 2)\n\
    Note:\n\
       Multithreading is used primarily to more extensively explore alignment\n\
         space rather than to speed up the program.\n\
    References:\n\
       Neuwald, A.F. LAPIS: Lots of Accurately-aligned Proteins Initiated from Scratch\n\
         In preparation.\n\
       Neuwald, A.F and S. F. Altschul. 2016. Bayesian Top-down Protein Sequence \n\
         Alignment with Inferred Position-Specific Gap Penalties. \n\
         Plos Comp. Biol. 12(5): e1004936\n\
       Fu, L., Niu, B., Zhu, Z., Wu, S. and Li, W. 2012. CD-HIT: accelerated for \n\
         clustering the next generation sequencing data. \n\
         Bioinformatics, 28:3150-3152.\n\
       Neuwald, A.F. 2009. Rapid detection, classification and accurate alignment \n\
         of up to a million or more related protein sequences.  \n\
         Bioinformatics 25: 1869-1875.\n\
    Funding: \n\
       National Institutes of Health, National Library of Medicine grant LM06747\n\
       National Institute of General Medical Sciences grants R01GM078541 & R01GM125878\n\
\n"


#endif

