/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "em_cma.h"
#include "goscan.h"
#include "blosum62.h"

int	main(Int4 argc,char *argv[])
{ 
	char	str[200],*psm_arg=0;
	Int4	iters=0;
	BooLean	quick=FALSE,use_hmm=FALSE;
     	double	map=0;
        Int4	max_rpts=1;
     	char	*tmp;
	char	*Argv[6];
	char	str0[]="cleancma";
	char	str2[50],str3[50],str4[50];

   // a_type A=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62,blsm62norm_kyte_doolittle);
   a_type A=MkAlpha(AMINO_ACIDS,GBLAST_BLOSUM62,blsm62_ins_emit_nats);
   for(Int4 arg=3; arg < argc; arg++){
		if(argv[arg][0] != '-') break;
		switch(argv[arg][1]) {
		   case 'P': psm_arg=argv[arg]; break;
		   case 'h': use_hmm=TRUE; break;
		   case 'Q': quick=TRUE; argv[arg][1] = ' '; break;
		   case 'N': max_rpts=IntOption(argv[arg],'N',
				1,1000,"scan2cma -N option input error"); break;
		   case 'R': 
			iters=IntOption(argv[arg],'R',1,200,"scan2cma -R option input error"); 
			argv[arg][1] = ' ';
		   break;
		}
   }
   if(iters <= 0){
	cma_typ cma = GOScanToCMSA(argc,argv, A);
        if(cma){ 
	  PutCMSA(stdout,cma);
	  // sprintf(str,"%s.n0",argv[1]); WriteMtfCMSA(str,cma,NULL);
	  // sprintf(str,"%s.n0.cma",argv[1]); WriteCMSA(str,cma); 
	  // PutAsDomTypCMSA(stdout,"unknown",cma);
	  TotalNilCMSA(cma); 
	}
   } else if(quick) {
     	tmp = argv[2];
        sprintf(str,"%s",argv[2]);
	argv[2]=str; Argv[0] = str0; Argv[1] = str; Argv[2] = str2; 
	Argv[3] = str3; Argv[4] = str4; Argv[5]=0;
     Int4	start=0, score=0, oper_len=0;
     Int4	stop=0;
     for(Int4 i=1; i <= iters && stop < 5; i++){
       std::cerr << "************************************ ITER ";
       std::cerr << i; std::cerr << "************************************\n";
       BooLean	flag=TRUE;
	cma_typ cma = GOScanToCMSA(argc,argv, A);
	double map2=RelMapCMSA(cma);
	fprintf(stderr,"oldmap = %.2f; newmap = %.2f\n",map,map2);
	if(map2 == map){ stop++; break; }else { map=map2; stop=0; }
	map=map2;

	sprintf(str,"%s%d",argv[1],i);
        if(use_hmm) cma=HMM_EMrunCMSA(max_rpts,psm_arg,str,cma);
        else cma=EMrunCMSA(max_rpts,psm_arg,str,cma);
	sprintf(str,"%s%d.em.msa",argv[1],i);
	TotalNilCMSA(cma);
     }
   } else {
     	tmp = argv[2];
        sprintf(str,"%s",argv[2]);
	argv[2]=str; Argv[0] = str0; Argv[1] = str; Argv[2] = str2; 
	Argv[3] = str3; Argv[4] = str4; Argv[5]=0;

     Int4	start=0, score=0, oper_len=0;
     Int4	stop=0;
     for(Int4 i=1; i < iters && stop < 5; i++){
       std::cerr << "************************************ ITER ";
       std::cerr << i; std::cerr << "************************************\n";
       BooLean	flag=TRUE;
       Int4	max_rpts=50;
       for(Int4 j=1; j <= 3; j++)  // for gradual improvement...
       {
	    cma_typ cma = GOScanToCMSA(argc,argv, A);
	    double map2=RelMapCMSA(cma);
	    fprintf(stderr,"oldmap = %.2f; newmap = %.2f\n",map,map2);
	    if(map2 == map){ stop++; } else { map=map2; stop=0; }
	    map=map2;

	    sprintf(str,"%s%d.n%d",argv[1],i,j);
            if(use_hmm) cma=HMM_EMrunCMSA(max_rpts,psm_arg,str,cma);
            else cma=EMrunCMSA(max_rpts,psm_arg,str,cma);
	    sprintf(str,"%s%d.n%d.em",argv[1],i,j); // old with CleanCMSA( );
	    TotalNilCMSA(cma);
	
	    if(j == 1) sprintf(str2,"-N0.05"); else if(j >= 2) sprintf(str2,"-N0.01");
	    sprintf(str3,"-C%d.0",j); sprintf(str4,"-c%d.0",j);
	    fprintf(stderr,"cleancma %s %s %s %s\n",Argv[1],Argv[2],Argv[3],Argv[4]);
// WHAT TO USE SAMPLING FOR CUTOFF SCORE IN CleanCMSA....
	    CleanCMSA(5,Argv,A);
	    sprintf(str,"%s%d.n%d.em.cln.cma",argv[1],i,j);
	    cma=ReadCMSA2(str,A);

#if 0	// NEW CLEAN: determine 'Clean2' cutoff score... for(psg_typ score)
	// Cutoff is determined by estimating the percentage of predicted false positives...
	// 10% (e.g., 40/400), 5% (20/400), 2% (8/400) ...
#endif
	    sprintf(str,"%s%d.n%dc",argv[1],i,j);
            if(use_hmm) cma=HMM_EMrunCMSA(max_rpts,psm_arg,str,cma);
            else cma=EMrunCMSA(max_rpts,psm_arg,str,cma);
	    sprintf(str,"%s%d.n%dc.em.msa",argv[1],i,j);
	    TotalNilCMSA(cma);
       }
     } argv[2] = tmp;
   } NilAlpha(A); 
   return 0;
}

