// A simple program that computes the square root of a number
#include <iostream>
#include <sstream>
#include <string>
#include <omp.h>

#include "gismoConfig.h"
#include "alphabet.h"
#include "residues.h"
#include "blosum62.h"

#include "cmsa.h"
#include "swaln.h"

#include "gsm_typ.h"
#include "gmb_typ.h"
#include "cma_gmb.h"
#include "chn_typ.h"
#include "gismo_usage.h"


int main(int argc, char* argv[])
{
#if 0
  if (argc < 5) {
    std::cout << argv[0] << " Version " << gismo_VERSION_MAJOR << "."
              << gismo_VERSION_MAJOR << std::endl;
    std::cout << "Usage: " << argv[0] << " number" << " cmafile " << " qsq " << " dbs " <<std::endl;
    return 1;
  }

  a_type AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
  PutAlpha(stdout,AB); 

  FILE *fp=open_file(argv[2],"","r");
  cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
  PutConsensusCMSA(stdout,cma);
  TotalNilCMSA(cma);
  
  e_type  Sq = ReadSeqFA(argv[3], 1, AB);
  ss_type data = SeqSet(argv[4],AB);
  e_type  Sq2 = SeqSetE(1,data);
  AlnSeqSW(stdout,11, 1,Sq, Sq2, AB);
  NilSeq(Sq);
  NilSeqSet(data);

  NilAlpha(AB);
  // std::cout << "The square root of " << inputValue << " is " << outputValue
  //          << std::endl;

#endif

  Int4 time1=time(NULL);
  Int4 arg,x;
  BooLean output_rtf=FALSE;
  for(arg = 2; arg < argc; arg++){
        if(argv[arg][0] != '-') print_error(USAGE_GISMO);
        if(argv[arg][1] == 'r'){
                if(strcmp("-rtf",argv[arg]) == 0){ output_rtf=TRUE; }
        }
  }
  RunGISMO(argc,argv,GISMO_VERSION,USAGE_GISMO);

  int ArgC=0;
  char *ArgV[20];
  if(output_rtf){
        // NEWP(ArgV, 12, char); 
	ArgV[0]=0; ArgV[ArgC]=AllocString(argv[0]);
        ArgC++; ArgV[ArgC]=AllocString(argv[1]);
        ArgC++; ArgV[ArgC]=AllocString("-S");
        ArgC++; ArgV[ArgC]=AllocString("-F7");
        ArgC++; ArgV[ArgC]=AllocString("-S=P");
        ArgC++; ArgV[ArgC]=AllocString("-N=6");
        ArgC++; ArgV[ArgC]=AllocString("-Q"); ArgC++; ArgV[ArgC]=0;
        chn_typ chn(ArgC,ArgV);
        chn.PutHierarchicalAlignment( );
        for(x=0; x < ArgC; x++) free(ArgV[x]); // free(ArgV);
  } FreeSets( ); // !!! CAUTION !!!: this will destory set_typ function...
  fprintf(stderr, "\ttime hsw write: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
  return 0;
}
