#if !defined (ConvertMSA_USAGE)
#define ConvertMSA_USAGE

#define CONVERT_MSA_VERSION "\
  ----------------------------------------------------\n\
     ConvertMSA v1.0.1 (October 23, 2020)\n\
     www.igs.umaryland.edu/labs/neuwald/software/mapgaps/\n\
     Copyright 2020 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_CONVERT_MSA "\n\
  Usage: ConvertMSA <mode> <infile> [options]\n\
  Input: \n\
    <mode>:\n\
      fa2cma: Convert <infile> MSA from mfasta to cma format.\n\
	      Note: columns with > 50 percent deletions are removed\n\
      cma2fa: Convert <infile> MSA from cma to mfasta format\n\
              Note: this option eliminates extensions on ends\n\
      cma2rtf: Convert <infile>.cma from cma to rich text format (<infile>.rtf)\n\
        note: To convert a fasta file to rich text format use fa2cma to create \n\
              an <infile>.cma file and then use cma2rtf.\n\
    <infile>: An alignment formated as mfasta (no suffix) or as cma (with suffix .cma).\n\
  Output: To stdout, except for cma2rtf mode (output as <infile>.rtf)\n\
  Options: \n\
    mode fa2cma:\n\
       -C=<int>    - Remove columns with <int> or more percent deletions (default: 50)\n\
    mode cma2rtf:\n\
       -F=<int>    - font size (6-12 points | default: 7 points)\n\
       -hide=<int> - hide inserts of length >= <int> (must be >2)\n\
       -Nth=<int>  - Use <int>th sequence for numbering display alignment\n\
       -S=<char>   - page setup option:\n\
                              'P' = 11 x 17 portrait\n\
                              'p' = 8.5 x 11 portrait\n\
                              'L' = 11 x 17 landscape\n\
                              'l' = 8.5 x 11 landscape\n\
  Reference:\n\
    Neuwald, A.F., Lanczycki, C.J., Hodges, T.K., & Marchler-Bauer, A. 2020.\n\
      Obtaining extremely large and accurate protein multiple sequence alignments\n\
      from curated hierarchical alignments. DATABASE Jan 1;2020:baaa042.\n\
  Funding: Provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n"
#endif

