/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

// Header file for a binary tree node data structure.
#if !defined (TBN_TYP)
#define TBN_TYP

#include "stdinc.h"
#include "afnio.h"
#include "alphabet.h"
#include "cmsa.h"
#include "hat_typ.h"
#include "dft_typ.h"

class tbn_typ  {	// tree binary node type.
public:		
		tbn_typ(Int4 id, char *Name);
		~tbn_typ();
	char	*Name() { return name; }
	Int4	MaxID();		// return the maximum id in subtree
	void	AddLeftChild(tbn_typ *child) { leftchild=child; child->parent=this; }
	void	AddRightChild(tbn_typ *child) { rightchild=child; child->parent=this; }
	void	SetParent(tbn_typ *node) { parent=node; }
	void	PrintBinary(FILE *fp);	// print as a binary tree in standard format
	Int4	Print(FILE *fp,Int4 depth);	// print as an N-ary tree in standard format
	Int4	PrintTree(FILE *fp,Int4 depth,Int4 NumRandom,cma_typ tpl_cma,cma_typ *in_cma,char *outname);
		// print as a hyperpartition
	Int4    PrintSubTree(FILE *fp, char *root_node_name, Int4 depth,cma_typ tpl_cma,cma_typ *in_cma,char *outname);
	BooLean	IsOkay();		// check for correct properties.
	BooLean	IsRightChild();		
	BooLean	IsLeftChild();		
	BooLean	IsRoot(){
			if(parent == 0) return TRUE; else return FALSE;
		}
	BooLean	IsLeafNode(){ if(leftchild==0) return TRUE; else return FALSE; }
	tbn_typ	*LeftChild() { return leftchild; }
	tbn_typ	*RightChild() { return rightchild; }
	tbn_typ	*Parent(){ return parent; }
	Int4    NumRightChildren();
	Int4    CountNodes(Int4 depth);
	void	Put(FILE *fp){
		   if(this != 0) fprintf(fp,"%d: %s\n",ID,name);
		}
private:		
	tbn_typ *ReturnNode(char *node_name);
	tbn_typ *FindNaryParent( );
	Int4	SubTreeIDs(Int4 &Index, Int4 N,Int4 *list);
	Int4	*GetSubTreeIDs();
	tbn_typ **OrderAsDFS(Int4 &rtnN, Int4 max_depth);
	Int4    OrderDFS(Int4 &Index, Int4 N, tbn_typ **nodes);
	Int4    OrderLimitedDFS(Int4 &Index, Int4 N, tbn_typ **nodes,
			Int4 depth, Int4 max_depth);
	char    **GetHPT(Int4 &N);
	char	Str[200];
	Int4	ID;			// integer identifier
	char	*name;			// name of protein family
	tbn_typ	*leftchild;		// = subtree of node
	tbn_typ	*rightchild;		// == siblings of node.
	tbn_typ	*parent;		
};



#endif

