/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

// Header file for a fasta to cma C++ object.
#if !defined (FTC_TYP)
#define FTC_TYP

#include "stdinc.h"
#include "afnio.h"
#include "alphabet.h"
#include "cmsa.h"

class ftc_typ {	// fasta to cma type.
public:		
		ftc_typ(){ print_error("ftc_typ() constructor disallowed"); }
		ftc_typ(const char *Name, a_type ab){
			// fafile=AllocString(fa); 
			name=AllocString(Name); AB=ab; Init();
		}
		~ftc_typ(){ free(name); }
	cma_typ FaToCMA(FILE *ifp,BooLean AddCsq=FALSE)
		{
		   FILE *tfp=tmpfile();
		   this->PressSeq(ifp,tfp); rewind(tfp);
		   cma_typ cma=this->FastaToCMSA(tfp); fclose(tfp);
		   if(AddCsq){ cma_typ tcma=AddConsensusCMSA(cma); TotalNilCMSA(cma); cma=tcma; }
		   return cma;
		}
private:		
	cma_typ FastaToCMSA(FILE *ifp);
	const	static Int4 MAXSIZE=1000000;
	void    put_cma_seq(FILE *ofp,char *text, Int4 leng);
	void    PressSeq(FILE *ifp, FILE *ofp);
	void	Init(){ Length=0; num=0; TotalSeq=0; Begin=ULONG_MAX; End=0; }
	char	*name,*fafile;
	unsigned long    num,TotalSeq;
	char    Seq[MAXSIZE];
	char    MasterSeq[MAXSIZE];
	char    SeqId[MAXSIZE];
	unsigned long Begin,End,Length;
	a_type	AB;
};



#endif

