#include "prb_typ.h"
#include "gmb_typ.h"

static char GISMO_USAGE[]= "\nUsage: gismo fastafile [options] \n\
  options (range:default):\n\
\t-a<int>      - algebraic operations setting (range: 1-3,default: 2)\n\
\t               '1' = fast & dirty mode (a minimum of complex operations)\n\
\t               '2' = intermediate mode (use split and fuse operations)\n\
\t               '3' = rigorous mode (many, time-consuming complex operations)\n\
\t-b<int>      - initial mean number of blocks (2-10:5)\n\
\t-c<int>      - initial mean number of columns per block (3-200:15)\n\
\t-f<int1:int2>- fix the number of blocks to within the range <int1> to <int2>.\n\
\t-g<int>,<int>- specify gap opening and extension penalties in nats/1000 (default: 10000,2000)\n\
\t-h<int>      - size of surviving alignments (i.e., heapsize) (2-1000:10)\n\
\t-L           - Don't mask low complexity regions\n\
\t-l<int>      - set rapid convergence limit (higher = longer to converge)(default: 5)\n\
\t-n           - mask potential nonglobular regions using 'seg x 45 3.4 3.75'\n\
\t-p<int>      - msa population size (2-10000:10)\n\
\t-s<int>      - random seed\n\
\t-v<int>      - maximum variation in map for convergence in optbreed (default = 1.0)\n\
\t-W<int>      - Maximum starting motif width (default: 25)\n\
\t-x           - dummy\n\n";


int	main(int argc, char *argv[])
{
	Int4 time1=time(NULL);
	a_type	AB=MkAlphabet(AMINO_ACIDS,PROT_BLOSUM62,SREL26_BLSM62);
	{ 
	  prb_typ	prb(GISMO_USAGE,argc,argv,AB);
	  // prb.purge();
	  prb.align();
	}
	//========== convert to one block and run gambit =============
	char str[100];
	sprintf(str,"%s.cma",argv[1]);
	cma_typ cma=ReadCMSA2(str,AB);
	cma_typ ocma=OneBlockCMSA(cma);
	FILE *fp=open_file(argv[1],"_I.cma","w");
	PutCMSA(fp,ocma); fclose(fp); NilCMSA(cma); cma=0;

	Int4    aa_per_io=75,aa_per_do=100,exp_ie=1,exp_de=1;
	char    method='S',mode='S';
	char    dms_mode=' ';   // 20 original components.
	Int4    i,similarity=0;
	double	temp=100.0;
	cma_typ	rcma[25]; rcma[0]=ocma;

	for(i=0; (temp >= 0.0); temp = temp - 50){
	    gmb_typ *gmb = new gmb_typ(aa_per_io,aa_per_do,exp_ie,exp_de,
					rcma[i],dms_mode);
            i++; rcma[i]=gmb->Sample(argv[1],mode,similarity,temp); 
	    sprintf(str,"_%d.cma",i);
	    fp=open_file(argv[1],str,"w");
	    PutCMSA(fp,rcma[i]); fclose(fp);
	    delete gmb;
	} 
	// TotalNilCMSA(cma); 
	NilAlpha(AB);
	fprintf(stderr, "\ttime hsw write: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

