/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "omc_typ.h"
#include "lha_typ.h"
#include "hierview.h"
#include "c2h_typ.h"
#include "bpps_usage.h"
#include "cmc_typ.h"
#include "rpm_typ.h"
#include "hsc_typ.h"

static void PrintError()
{
	// PrintLicenseStatement("bpps v1.0.8"); 
	fprintf(stderr,"%s",BPPS_VERSION); print_error(USAGE_BPPS); 
}

#if 1	// ================= for rapid debugging ===============
int     run_debug(int argc, char *argv[])
{
	int	i,a,A,Argc,x;
	Int4	rtn=0;
	double	d;
	char	**Argv,mode,str[200],c; 
	Int4    time1=time(NULL);

	// const char *s=argv[0];
	a_type AB = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	PutAlpha(stderr,AB);
	char *S=0;
	sst_typ	usst=0,sst=0;
#if 1
	const char s[]="TESH";
#else
	char s[30];
	s[0]='T'; s[1]='E'; S[2]='S'; s[3]='H'; s[4]=0;
#endif
        for(Int4 j=0; s[j]; j++){
fprintf(stderr,"%d. '",j);
                sst=SsetLet(AlphaCode(s[j],AB));
                usst=UnionSset(sst,usst);
PutSST(stderr,usst,AB); fprintf(stderr,"'\n",j);
        }
fprintf(stderr,"final: '");
PutSST(stderr,usst,AB); fprintf(stderr,"'\n");
	S=GetPatternFromSST(usst,AB);
	if(S) fprintf(stderr,"S='%s'\n",S);
	NilAlpha(AB);
	if(S) free(S);
	exit(1);

#if 1
	// S=AllocStringXX(s);
	S=AllocString(s);
#elif 1
	S = strdup(s);
#else
	if((S=(char*) calloc((strlen(s)+3),sizeof(char)))==NULL)
                print_error("Out of Memory");
        strcpy(S,s); 
#endif
	fprintf(stderr,"S='%s'\n",S);
	free(S);
	exit(1);
}
#endif	//============= end debugging  ===============

int     main(int argc, char *argv[])
{
	int	i,a,A,Argc,x;
	Int4	rtn=0;
	double	d;
	char	**Argv,mode,str[200],c; 
	Int4    time1=time(NULL);
	TurnOffLicenseStatement();
#if 0
return run_debug(argc, argv);
#endif
	if(argc < 2) PrintError(); else mode=argv[1][0];
	if(strchr("A123EQH",mode)==NULL) PrintError();
	if(argv[1][1] != 0) PrintError();
	NEWP(Argv,argc+8,char);
	Argv[0]=argv[0]; Argc=argc-1;	// skip over argv[1]...
	if(mode != 'H'); for(a=2,A=1; a < argc; a++,A++){ Argv[A]=argv[a]; }
#if 1
	FILE *fp = 0;
	if(argc > 2){
	  fp=open_file(argv[2],".cmd","w");
	  for(a = 0; a < argc; a++) fprintf(fp,"%s ",argv[a]);
	  fprintf(fp,"\n"); fclose(fp);
	}
#endif
	switch (mode){
	   case 'A':
	     {	
		char pdb[100];
		if(argc < 3) print_error(USAGE_BPPS);
		if(Argv[2] && Argv[2][0] != '-'){ sprintf(pdb,"-pdb=%s",Argv[2]); Argv[3]=pdb; }
		else Argv[3]=0;
		Int4 NumSets=0; Argc=2;
	        { 
		  omc_typ omc(1,Argc,Argv); rtn=omc.Run(); omc.PrintTime(stderr); 
		  hpt_typ *Hpt=omc.RtnHpt(); NumSets=Hpt->NumSets()-1; 
		} run_hieraln(2,Argc,Argv); 
		if(Argv[3]) Argc=4; else Argc=3;
		sprintf(str,"%s_himsa",Argv[1]); Argv[1]=AllocString(str);
		for(i=2; i <= NumSets; i++){
		    sprintf(str,"%d",i); Argv[2]=str; run_hierview(3,Argc,Argv); 
		} free(Argv[1]);
	     } break;
	   case 'Q': {
	      if(argc < 4){ omc_typ  omc('Q',Argc,Argv); } 
	      if(!isdigit(argv[3][0])) print_error("FATAL: The 3rd argument must be a positive integer.");
	      unsigned long X=strtoul(argv[3],(char **) NULL,10);
	      if(X < 1) print_error("FATAL: The 3rd argument must be a positive integer.");
	      // fprintf(stderr,"X=%u\n",X);
	      // if(X == ULONG_MAX) print_error(USAGE_BPPS);
	      if(X == ULONG_MAX) { omc_typ  omc('Q',Argc,Argv); }  // this triggers usage...
	      sprintf(str,"%s.chk",argv[2]);
	      fp=fopen(str,"r");
	      if(fp != NULL) print_error("FATAL: checkpoint (*.chk) output file present\n");
	      sprintf(str,"-Focus=1:%u",X); Argv[2]=AllocString(str);
              for(Int4 arg=3; arg < argc; arg++){
                if(argv[arg][0] != '-') break;	// this will be reported later.
                switch(argv[arg][1]) {
                 case 'm': 
		  if(sscanf(argv[arg],"-minnats=%lf",&d)==1) continue;
		  if(sscanf(argv[arg],"-minsize=%d",&x)==1) continue;
		  if(sscanf(argv[arg],"-maxdepth=%d",&x) == 1) continue;
		  if(sscanf(argv[arg],"-maxcol=%d",&x) == 1) continue;
		  if(sscanf(argv[arg],"-mtf=%s",&str) == 1) continue;
		  else argv[arg][1] = '#';	// triggers print usage for Q
		  break;
                case 'r': 
		  if(sscanf(argv[arg],"-rtfF=%d",&x)==1) continue;
		  if(sscanf(argv[arg],"-rtfP=%c",&c)==1) continue;
		  else argv[arg][1] = '#';	// triggers print usage for Q
		  break;
                case 's': 
		  if(sscanf(argv[arg],"-seed=%d",&x)!=1) continue;
		  else argv[arg][1] = '#';	// triggers print usage for Q
		  break;
                case 'u': 
		  if(strcmp("-usr",argv[arg]) == 0) continue; 
		  else argv[arg][1] = '#';	// triggers print usage for Q
		  break;
                default : argv[arg][1] = '#';	// triggers print usage for Q
               }
	      } omc_typ  omc('Q',Argc,Argv); rtn=omc.Run(); free(Argv[2]);
	    } break;
//	   case '1': { omc_typ	omc(1,Argc,Argv); rtn=omc.Run(); } break;
	   case '2': { run_hieraln(2,Argc,Argv); } break;
	   case '3': { run_hierview(3,Argc,Argv); } break;
	   case '1':  
	   case 'H': { 
		char *pdb_list=0;
		BooLean heatmap=FALSE,OutPutRTF=FALSE;
		Int4	maxcol=0,x,xx;
		for(a=0; a < argc; a++) fprintf(stderr,"%s ",argv[a]);
		fprintf(stderr,"\n");
		for(a=2,A=1; a < argc; a++){ 
		   BooLean skip=FALSE;
                   if(argv[a][0] == '-'){
                     switch(argv[a][1]) {
		       case 'c':	// pdb_list
		        if(mode=='H' && sscanf(argv[a],"-col=%d:%d",&x,&xx) == 2){
			   if(xx >= 5) maxcol=xx; skip=TRUE;
			} break;
		       case 'h':	// heatmaps
			// fprintf(stderr,"%d: '%s'\n",a,argv[a]);
		        if(strcmp("-heatmap",argv[a]) == 0){
			     heatmap=TRUE; skip=TRUE;
			     // fprintf(stderr,"%d(skip): '%s'\n",a,argv[a]);
			} break;
		       case 'p':	// pdb_list
		        if(sscanf(argv[a],"-pdb_list=%s",str) == 1){
			   pdb_list=AllocString(str); skip=TRUE;
			} break;
		       case 'R':	// *.CHK rtf output
		        if(mode=='H' && strcmp("-RTF",argv[a]) == 0){
			  OutPutRTF=TRUE; skip=TRUE;
			} break;
		     }
		   }
		   if(!skip){ Argv[A]=argv[a]; A++; }
		} Argc=A;
#if 0
		for(i=0;i < Argc; i++) fprintf(stderr,"%s ",Argv[i]);
		fprintf(stderr,"\n");
#endif
		if(mode=='1') { omc_typ	omc(1,Argc,Argv); rtn=omc.Run(); } 
		else {	// then mode=='H'
		   char HptIs=0;
		   if(OutPutRTF){ 	// debug using *.CHK file.
		        sprintf(str,"%s.CHK",Argv[1]);
		        if((fp=fopen(str,"r")) != NULL){    // call other constructor for hpt operations
			   if(Argc > 1){ Argv[Argc]=AllocString("-del"); Argc++; }
			   if(Argc > 1){ Argv[Argc]=AllocString("-rchk"); Argc++; }
			   fprintf(stderr,"===> %s.CHK file found.\n",Argv[1]);
           		   fclose(fp); fp=0;
			   cmc_typ *cmc = new cmc_typ(Argc, Argv);   // don't run program.
			   fprintf(stderr,"===> Printing %s rtf files.\n",Argv[1]);
		           cmc->PutRTF(FALSE); // cmc->Put();
			   fprintf(stderr,"===> Done printing %s rtf files.\n",Argv[1]);
		           delete cmc; exit(0);
		        } else {
			   fprintf(stderr,"===> %s.CHK file not found.\n",Argv[1]);
			   print_error("option -RTF requires a *.CHK file");
			}
		   }
		   if(Argc > 1){ Argv[Argc]=AllocString("-wchk"); Argc++; }
		   if(Argc > 1){ Argv[Argc]=AllocString("-del"); Argc++; }
		   //if(Argc > 1){ Argv[Argc]=AllocString("-hide=3"); Argc++; }
		   Int4 Rtn=RuncmcBPPS(Argc,Argv,HptIs); 
		   if(Rtn > 0) print_error("FATAL: input hyperpartition file failed");
		   Argc--; free(Argv[Argc]); Argv[Argc]=0;
		   fprintf(stderr,"DEBUG: HptIs=='%c'\n",HptIs);
		   if(HptIs=='T'){ // If the Hpt is a tree then optimize.
		      fprintf(stderr,"DEBUG: optimizing...\n");
		      Argc=2;  // bpps XXX -run=o
#if 0
		      Argv[0]=argv[0]; Argc=argc-1;	// skip over argv[1]...
	              for(a=2,A=1; a < argc; a++,A++){ Argv[A]=argv[a]; }
#else
		      if(maxcol > 0){
			sprintf(str,"-maxcol=%d",maxcol);
			 Argv[Argc]=AllocString(str); Argc++; 
		      }
		      Argv[Argc]=AllocString("-run=O"); Argc++;
#endif
		      for(i=0;i < Argc; i++) fprintf(stderr,"'%s' ",Argv[i]);
		      fprintf(stderr,"\n");
		      omc_typ omc(1,Argc,Argv); rtn=omc.Run();
		   }
		}
		if(pdb_list){
// fprintf(stderr,"!!!!!!!!!!!!!! ==> DEBUG pdb_list\n");
		  Argv[0] = AllocString("sarp");		
		  Argv[1] = AllocString(pdb_list); 
		  sprintf(str,"%s",argv[2]);	
		  Argv[2] = AllocString(str); Argc=3;
		  { hsc_typ hsc(Argc, Argv); hsc.Run( ); }
		  for(i=0;i < Argc; i++) free(Argv[i]);
		}
		if(heatmap){
// fprintf(stderr,"!!!!!!!!!!!!!! ==> DEBUG heatmap %s\n",argv[2]);
		  Argv[0] = AllocString("pttrn_mtch");		
		  Argv[1] = AllocString(argv[2]); Argc=2;
		  rpm_typ *rpm = new rpm_typ(Argc,Argv);
        	  rpm->PutHeatMaps(argv[2]); delete rpm;
		  for(i=0;i < Argc; i++) free(Argv[i]);
		}
	   } break;
	   case 'E': { c2h_typ c2h(mode,Argc,Argv); c2h.Run(); } break;
	   case 'U': { print_error("bpps U option not yet implemented"); } break;
	   default: print_error(USAGE_BPPS); break;
	} free(Argv); FreeSets();
	fprintf(stderr,"\ttotal run time: %d seconds (%0.2f minutes)\n\n",
		time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

