#if !defined (ADDPHYLUM_USAGE)
#define ADDPHYLUM_USAGE

#define ADDPHYLUM_VERSION "\
  ----------------------------------------------------\n\
     AddPhylum v1.4 (May 12, 2022)\n\
     www.igs.umaryland.edu/labs/neuwald/software/darc/\n\
     Copyright 2020-2022 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_ADDPHYLUM "\
Usage: addphylum <fa_file> [options] or addphylum stdin [options]\n\
      To conserve memory, pipe in very large input files: \n\
            cat fa_file | addtax stdin > output \n\
   options:\n\
      -C          Skip Chordate sequence in input\n\
      -n          Nucleotide sequences in input\n\
      -pdb        Input is pdbaa file; uses pdb.accession2id file\n\
      -T          transfer taxonomic information from <fa_file>.seq to a \n\
                     corresponding <fa_file>.cma (not yet implemented)\n\
      -u          Skip sequences from unknown phyla\n\
   Syntax of phylum information added to fasta sequence deflines: \n\
      >seq_id {|X(Y)|<P(K)>}...\n\
      where X is the start site (used for truncated sequences)\n\
       Y is the ncbi taxonomic identifier (an integer)\n\
       P is the phylum (e.g., 'Chordata')\n\
       K is the 'kingdom' (A=Archaea,B=bacteria,V=plants,M=metazoa,F=fungi,E=protozoa).\n\
      This information is used by associated programs, such as GISMO, BPPS, and DARC.\n\
-------------------------------------------------------------------------\n\
   Input files:\n\
     This program will seek to open three NCBI taxonomy files:\n\
           names.dmp  (lists phyla and kingdoms)\n\
           nodes.dmp  (lists the corrsponding taxonomic identifiers)\n\
           prot.accession2taxid  (maps protein accession codes to taxonomic identifiers)\n\
     Files are available at the NCBI ftp site:\n\
	   ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz \n\
	      (tarball for names.dmp, nodes.dmp)\n\
	   ftp://ftp.ncbi.nih.gov/pub/taxonomy/accession2taxid/prot.accession2taxid.gz\n\
     Put files in a directory corresponding to the enviromental variable $TAXDUMPDIR\n\
-------------------------------------------------------------------------\n\
   WARNINGS:\n\
     The input file needs to correspond to the NCBI nr fasta file available at:\n\
           ftp://ftp.ncbi.nih.gov/blast/db/FASTA/nr.gz\n\
     The release date for the nr  and taxonomy files should be the same.\n\
     The prot.accession2taxid file requires a lot of memory.\n\
   Reference: \n\
     Neuwald, A.F., Lanczycki, C. J., Hodges, T.K., and A. Marchler-Bauer. 2020. \n\
       Obtaining extremely large and accurate protein multiple sequence alignments\n\
       from curated hierarchical alignments. DATABASE doi:10.1093/database/baaa042.\n\
   Funding: National Institutes of Health, National Institute of General Medical \n\
       Sciences grant R01GM125878.\n\
   \n\n"

#endif
