
/*********************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 **********************************************************************************/
#if !defined(_TRM_TYP_)
#define _TRM_TYP_
#include "stdinc.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "dheap.h"
#include "set_typ.h"
#include "blosum62.h"
#include "tax_typ.h"

class trm_typ {		// term_list_type {
public:
	trm_typ( ) { assert(!"Illegal constructor"); }
        trm_typ(cma_typ *in_cma){
		IN_CMA=in_cma; head=tail=0;
                Init( );
        }
        ~trm_typ( ) { Free(); }
	Int4    Scan4Terms(FILE *fp);
private:
	void	Init(){
		   for(Int4 i=1; i <= 26; i++){ NEWP(Prfx[i],30,Int4); } } void	Free(){
		   for(Int4 i=1; i <= 26; i++){ free(Prfx[i]); }
		}
	Int4    **Prfx[30];
	Int4    CollectData(cma_typ cma,FILE *efp=0);
	class	tml_typ {
public:
		tml_typ(){ assert(!"Illegal constructor"); }
		tml_typ(char *s){
		   Num=1; str=AllocString(s);
		   this->next=0;
		}
        	~tml_typ( ){  
		    free(str); 
		    if(this->next) delete this->next;
		}
		void	SetNext(tml_typ *nxt){
			this->next=nxt;
		}
		Int4	Num;
		char	*str;
		tml_typ *next;
private:
	};
	tml_typ	*head,*tail;
	BooLean	IgnoreTerm(const char *term);
	Int4    CountTerms(tml_typ *head);
	Int4	PutRankedTerms(FILE *fp,tml_typ *head,Int4 cutoff);
	Int4	PutKeyTerms(cma_typ cma,const char *Prefix,Int4 cutoff,FILE *fp,FILE *efp=0);
	cma_typ *IN_CMA;
};

#endif

