/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

Int4	dcm_typ::RtnL()
// find the length of the array L
{
	Int4	i,j,n,m=0,LLL,N,II,JJ,x,MM=num_resC*num_resC;

	// 1a. Insert pairs into dH_pdb & dH_dca heaps with keys 3D-distance and DC-score.
	dh_type dH_pdb=dheap(MM+5,4),dH_dca=dheap(MM+5,4);
	if(TheOtherMtrx && OtherNumResC != num_resC)
		print_error("input error: # residues inconsistent"); 
	for(n=0,i=1; i < num_resC; i++){
	   II=ResidueID(ResALL[i]);
	   for(j=i+1; j <= num_resC; j++){	
	      JJ=ResidueID(ResALL[j]);
	      if(abs(II-JJ) <= MinSqSeparation) continue;  // for EV-fold |JJ-II| > 5.
	      // if(abs(II-JJ) <= MinSqSeparation){ m++; continue; }  // for EV-fold |JJ-II| > 5.
	      if(MtrxPDB[i][j] > 0 && Used[i][j]){	// is this a legitimate pair?
	        n++;	// pair identifier == n;
#if 0
		if(Split > 0 && UseSide==0 && !(II <= Split && JJ > Split))
		{
	          char cI=GetCharResidue(ResALL[i],AB),cJ=GetCharResidue(ResALL[j],AB);
		  fprintf(stderr,"%d: %c%d vs %c%d\n",n,cI,II,cJ,JJ);
		}
#endif
		insrtHeap(n,(keytyp)MtrxPDB[i][j],dH_pdb); 
	        insrtHeap(n,(keytyp)MtrxDCA[i][j],dH_dca); 
	      }
	   }
	} LLL=ItemsInHeap(dH_pdb); assert(n == LLL); assert(ItemsInHeap(dH_dca) == LLL);
// fprintf(stderr,"m=%d\n",m);
	Nildheap(dH_pdb); Nildheap(dH_dca); 
	return LLL;
}

char	dcm_typ::ConvertXtoRes(Int4 x,char cx,Int4 X, char cX,e_type xE, e_type pdbE)
{
	if(x < 1 || X < 1){
	    AlnSeqSW(stderr,11, 1,dcaE, pdbE, AB);
	    fprintf(stderr,"%c%d vs %c%d; dca2pdbOS=%d\n",cx,x,cX,X,dca2pdbOS);
	    PutSeq(stderr,pdbE,AB); // PutSeq(stderr,xE,AB); 
	    PutSeq(stderr,dcaE,AB);
	    print_error("ConvertXtoRes() input error 2.");
	}
	if(cX == 'X' && cx=='M') cX='M';
	else if(cX == 'X' && cx=='S') cX='S'; 	// phosphorylated residues S,T,Y
	else if(cX == 'X' && cx=='T') cX='T';
	else if(cX == 'X' && cx=='Y') cX='Y';
	else if(cX == 'X' && cx=='C') cX='C';   // ADDZ?
	// else if(cX == 'C' && cx=='X') cx='C';   // ADDZ? // doesn't work..
	if(cx != cX){
	   AlnSeqSW(stderr,11, 1,dcaE, pdbE, AB);
	   PutSeq(stderr,pdbE,AB); PutSeq(stderr,dcaE,AB); 
	   fprintf(stderr,"Error: %c%d != %c%d.\n",cx,x,cX,X);
	   fprintf(stderr,"Make sure that the DCA query sequence matches the pdb sequence.\n");
	   fprintf(stderr," ...check for selenomethionines.\n");
	   fprintf(stderr,"Skipping file %s\n",dca_file); return -1;
	   print_error("ConvertXtoRes() input error 3.");
	} else { // EqSeq(i,AlphaCode(cX,AB),xE); 
	} return cX;
}

BooLean	dcm_typ::GetMtrxDCA(char *dca_file)
//============= Move this routine to libpdb.a at some point: ================
// WARNING: make sure that EVfold corresponds to the residue numbering in pdb files!
{
	Int4	rI,rJ,r,I,J,i,j,ii,jj,xi,xj;
	// Construct minimum Res-Res distance matrix...
	h_type HG=0; // HG=Histogram("DCA scores as pseudo-distances",-1,1,0.05);
        res_typ ResI,ResJ;
	float	min,dd,**DM=MtrxDCA;  // 350 x 350 = 122,500 x 16 = 1,470 kBytes.
	double	Dd;
	char	Str[105],cI,cJ,ci,cj,CI,CJ;
	e_type	xE=0;
	Int4	os=OffSetSeq(pdbE);
	xE=MkEmptySeq(1,"DCA seq",LenSeq(pdbE)+ os + 5);
#if 0
	fprintf(stderr,"dca2pdbOS=%d; offset dcaE=%d; offset pdbE=%d\n",
		dca2pdbOS,OffSetSeq(dcaE),OffSetSeq(pdbE));
	AlnSeqSW(stderr,11, 1,dcaE, pdbE, AB);
#endif
#if 0
	if(!OverlappingSeqs(offset,dcaE,pdbE,30,0)){
		// OverlappingSeq() sets offset > 0 if query starts before pdbseq.
                // It also allows for 'X' residues in pdb files...
                // else it sets offset < 0.
	   fprintf(stderr,"Sequences mismatch\n");
	   PutSeq(stderr,dcaE,AB);
	   PutSeq(stderr,pdbE,AB);
	} else if(offset != 0) fprintf(stderr,"Offset = %d\n",offset);
#endif
	// PutSeq(stderr,pdbE,AB);
	FILE *fp=open_file(dca_file,"","r");
	while(fgets(Str,100,fp) != NULL){
	   Int4 dm[12];	// dummy variables; these are not used.
	   // WARNING: make sure to use %lf for Dd as double, or the values will be all wrong...
	   if(sscanf(Str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c,",
		   &xi,&xj,&Dd,&dm[1],&dm[2],&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&CI,&CJ) != 12) 
			print_error("GetMtrxDCA() input error 1.");
	   i = xi - dca2pdbOS; j = xj - dca2pdbOS; 	// i == position in ResALL.
	   ii= i - OffSetSeq(pdbE); ci=ResSeq(ii,pdbE);	// ii == ResI site...
	   jj= j - OffSetSeq(pdbE); cj=ResSeq(jj,pdbE);
	   if(ci == 0 || cj == 0) continue;	// residue not visible in pdb file.
if(0){
	fprintf(stderr,"xi=%d; i=%d; xj=%d; j=%d; os=%d; d2p=%d; ",
		xi,i,xj,j,OffSetSeq(pdbE),dca2pdbOS);
	fprintf(stderr,"ii = %d; jj = %d; Dd=%.4lf\n",ii,jj,Dd);
}
	   ii=this->FindIndex(i); jj=this->FindIndex(j);  // siteI == ResAll[ii]
if(0)fprintf(stderr,"\t\tii = %d; jj = %d\n",ii,jj);
	   if(ii == 0 || jj == 0) continue;	// not present in structure...
	   ci=AlphaChar(ci,AB); cj=AlphaChar(cj,AB);
	   cI=GetCharResidue(ResALL[ii],AB); cJ=GetCharResidue(ResALL[jj],AB);
	   CI=this->ConvertXtoRes(i,cI,ii,CI,xE,pdbE);
	   if(CI == -1){ NilSeq(xE); fclose(fp); return FALSE; }
	   CJ=this->ConvertXtoRes(j,cJ,jj,CJ,xE,pdbE);
	   if(CJ == -1){ NilSeq(xE); fclose(fp); return FALSE; }
	   if(ci != CI || cj != CJ){
	       fprintf(stderr,"i=%d; j=%d; ii=%c%d(%c); jj=%c%d(%c)\n", 
			i+dca2pdbOS, j+dca2pdbOS,ci,ii,CI,cj,jj,CJ);
	   }
	   if(cI != CI || cJ != CJ){
	       fprintf(stderr,"ii=%c%d(%c); jj=%c%d(%c)\n",ci,ii,cI,cj,jj,cJ);
	   }
	   // fprintf(stderr,"%s\n",Str);
	   ResI=ResALL[ii]; I=ResidueID(ResI);
           if(I < resStart || I > resEnd) continue;
	   ResJ=ResALL[jj]; J=ResidueID(ResJ);
           if(J < resStart || J > resEnd) continue;
	   if(abs(ii - jj) <= MinSqSeparation) continue; 
	   DM[ii][jj]=DM[jj][ii]=(float) -Dd; 
// fprintf(stderr,"DM[%d][%d]=%.4f\n",ii,jj,MtrxDCA[ii][jj]);
	   assert(I < J);
	   Int4	split=0;
	   if(Split < 0){ split=-Split; }
#if 0	// for heterodomain analysis
static Int4 Cnt=0;
if(Cnt==0) fprintf(stderr,"Split=%d; split=%d; use=%d\n",Split,split,UseSide);
Cnt++;
#endif
	   if(Split == 0 
		|| (UseSide == -1 && I <= Split && J <= Split)
		|| (UseSide == 1 && I > Split && J > Split)
		|| (UseSide == 0 && split > 0 &&
			((I <= split && J <= split) || (I > split && J > split)))
		|| (UseSide == 0 && Split > 0 && I <= Split && J > Split))
	   Used[ii][jj]=Used[jj][ii]=TRUE;
	   if(HG) IncdHist(-DM[ii][jj],HG);
	} fclose(fp); // PutSeq(stderr,xE,AB);
	// fprintf(stderr,"resStart = %d; resEnd = %d.\n",resStart,resEnd);
	NilSeq(xE);
	if(HG){ PutHist(stderr,60,HG); NilHist(HG); }
	return TRUE;
}

void	dcm_typ::CalcMtrxBPPS()
//============= Move this routine to libpdb.a at some point: ================
{
	Int4	i,j,I,J,N=0,ii,jj;

	set_typ SetBP=MakeSet(resEnd+9); ClearSet(SetBP);
	SetBPPS=MakeSet(num_resC + 9);
	Int4	*rank; NEW(rank, resEnd+9,Int4);
	for(i=1; i <= bpps[0]; i++){
		I=bpps[i]; 	// this appears to be the correct version...
		// I=bpps[i]-dca2pdbOS;
		if(I >= resStart && I <= resEnd){ AddSet(I,SetBP); rank[I]=i; }
		// ii=this->FindIndex(I); 
	}
	for(i=1; i <= num_resC; i++){
	   res_typ ResI=ResALL[i]; I=ResidueID(ResALL[i]);
	   if(I < resStart || I > resEnd) continue;
	   if(!MemberSet(I,SetBP)) continue;
#if 0
	   if(rank[I] > 0){
	     	char ci=GetCharResidue(ResI,AB);
		fprintf(stderr,"%d(%d).%c%d\n",i,(I+dca2pdbOS),ci,I);
	   }
#endif
	   for(j=i+1; j <= num_resC; j++){
	     res_typ ResJ=ResALL[j]; J=ResidueID(ResJ);
	     if(J < resStart || J > resEnd) continue;
	     if(abs(I - J) <= MinSqSeparation) continue;
	     AddSet(i,SetBPPS); // only position 'i' is a pattern residue.
	     MtrxBPPS[i][j]=MtrxBPPS[j][i]=(float) (rank[I]*rank[J]);	
#if 1
	    if(efptr && rank[I] > 0 && rank[J] > 0) {
	     	char ci=GetCharResidue(ResI,AB),cj=GetCharResidue(ResJ,AB);
	     	fprintf(efptr,"%d.%c%d  <--> %d.%c%d\n",i,ci,I,j,cj,J);
		N++;
	    }
#endif
	   }
	} if(efptr) fprintf(stderr,"N=%d; %d\n",N,CardSet(SetBP));
	NilSet(SetBP); free(rank); 
}

void	dcm_typ::CalcDistMtrx(BooLean UseUsed)
//============= Move this routine to libpdb.a at some point: ================
// MtrxPDB[i][j] is based on ResALL array, not sites in pdb sequence.
// this code looks okay.
{
	Int4	ai,aj,r,i,j,siteI,siteJ,h,ii,jj;
	char	cI,cJ,*SeqKey=0;
	atm_typ atmsI[200],atmsJ[200],*H,atmI,atmJ;
	res_typ	ResI,ResJ;
	float	min,dd;	
	h_type HG=0; // HG=Histogram("residue-residue 3D distances",0,100,1.0);

	if(NumAdjChns > 0){ NEW(SeqKey,resEnd+5,char); for(j=0; j <= resEnd; j++) SeqKey[j]=' '; }
	// 1. Set MtrxPDB[i][j] = the minimum distance between residues i & j.
	for(i=1; i <= num_resC; i++){
	   ResI=ResALL[i]; siteI=ResidueID(ResI); cI=GetCharResidue(ResI,AB);
	   if(siteI < resStart || siteI > resEnd){
		fprintf(stderr,"%s\n",pdb_file);
		PrintResidueAtoms(stderr,ResI,FALSE);
		print_error("Atypical residue found: consider editing pdb input file");
		// e.g., CXM = HETATOM = N-CARBOXYMETHIONINE.
		// Edited res_typ in pdb.cc to work around this for now; change later.
	   }
	   if(NumAdjChns > 0) SeqKey[siteI]=cI;
	   for(j=i + 1; j <= num_resC; j++){
	     ResJ=ResALL[j]; siteJ=ResidueID(ResJ);
	     if(siteJ < resStart || siteJ > resEnd){
		fprintf(stderr,"%s\n",pdb_file);
		PrintResidueAtoms(stderr,ResJ,FALSE);
		print_error("Atypical residue found: consider editing pdb input file");
	        assert(siteJ >= resStart && siteJ <= resEnd);
	     }
	     if(UseUsed && Used[i] && Used[i][j]==FALSE) continue;
	     assert(abs(siteI - siteJ) > MinSqSeparation);
	     cJ=GetCharResidue(ResJ,AB); min=FLT_MAX;
	     BooLean isI,isJ;
	     if(UseHydrogens){ // fprintf(stderr,"using hydrogens\n");
	        isI=isJ=TRUE;
		// Use sidechain and gly alpha-carbon atoms only.
		for(ii=0,ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		   atmI=AtomResidue(ai,ResI);
		   if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		   ii++; atmsI[ii]=atmI;
		   H=ResidueAtomHydrogens(ai,ResI);
		   if(H) for(h=1; H[h]; h++){ ii++; atmsI[ii]=H[h]; } 
		} ii++; atmsI[ii]=0;
		if(ii == 1) isI=FALSE;
		for(jj=0,aj=1; aj <= ResidueAtomNumber(ResJ); aj++){
		   atmJ=AtomResidue(aj,ResJ);
		   if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		   jj++; atmsJ[jj]=atmJ;
		   H=ResidueAtomHydrogens(aj,ResJ);
		   if(H) for(h=1; H[h]; h++){ jj++; atmsJ[jj]=H[h]; }
		} jj++; atmsJ[jj]=0;
		if(jj == 1) isJ=FALSE;
		for(ai=1; atmsI[ai]; ai++){
		   for(atmI=atmsI[ai],aj=1; atmsJ[aj]; aj++){
		      dd=DistanceAtoms(atmI,atmsJ[aj]);
		      if(dd < min) min=dd;
		   }
		}
	    } else { // fprintf(stderr,"ignoring hydrogens\n");
	        isI=isJ=FALSE;
		for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		  atmI=AtomResidue(ai,ResI);
		  if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		  isI=TRUE;
		  //fprintf(stderr,"%s: \n",ResidueName(ResI)); PutAtom(stderr,atmI);
		  for(aj = 1; aj <= ResidueAtomNumber(ResJ); aj++){
		    atmJ=AtomResidue(aj,ResJ);
		    if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		    isJ=TRUE; dd=DistanceAtoms(atmI,atmJ);
		    if(dd < min) min=dd;
		  }
		}
	    }
#if 0	// DEBUG
	    if(isI==FALSE){
		fprintf(stderr,"WARNING: %c%d is missing sidechain atoms\n",cI,siteI);
	    }
	    if(isJ==FALSE){
		fprintf(stderr,"WARNING: %c%d is missing sidechain atoms\n",cJ,siteJ);
	    }
#endif
	    MtrxPDB[i][j]=MtrxPDB[j][i]=min;	// pick the closest atom distances
#if 0	// DEBUG
if(siteI <= 481 && siteJ > 481){
   if(1 || Used && Used[i] && Used[i][j]){
	fprintf(stderr,"%c%d vs %c%d: dist=%f\n",cI,siteI,cJ,siteJ,min);
	// fprintf(stderr,"mtrxPDB[%d][%d]=%f\n",i,j,MtrxPDB[i][j]);
   }
}
#endif
	    if(HG && Used && Used[i] && Used[i][j]) IncdHist(min,HG); 
	   }
	} if(HG){ PutHist(stderr,60,HG); NilHist(HG); }
	if(NumAdjChns > 0){ this->GetAdjChainContacts(SeqKey); free(SeqKey); }
}

void	dcm_typ::GetAdjChainContacts(char *SeqKey)
{
	Int4	i,j,start,Cadj,MinOverlap=100,RtnNumX;
	char	rtn;
	e_type	adjE,kE=pdbE;
	float	maxRatioX=0.20;	// at most 20% X allowed.

	for(i=1; i <= NumAdjChns; i++){
		start=0; Cadj=GetChainNumberPDB(PDB,AdjacentChains[i]);
		adjE=GetPDBSeq(Cadj,PDB);
		if(adjE==0){
		    fprintf(stderr,"Adjacent chain '%c' not found.\n",AdjacentChains[i]); exit(1);
		} // AlnSeqSW(stderr,11, 1,adjE,kE,AB);
		rtn=IsSubSeqMaxRatioX(adjE,kE,start,maxRatioX);	// 
	// fprintf(stderr,"rtn=%d; start=%d\n",rtn,start);
		if(rtn==0){
		    // char    IsSameSeq(e_type E1, e_type E2,Int4 *Start,Int4 MinOverlap,BooLean IgnoreX)
		    // find out whether or not E1 and E2 are the same sequence.
		    // return 1 if seq E1 lacks an N-terminal extension.
		    // return 2 if seq E2 lacks an N-terminal extension.
		    // rtn=IsSameSeq(adjE, kE,&start,MinOverlap,TRUE);
		    rtn=IsSameSeqFast(adjE,kE,&start,&RtnNumX,MinOverlap); 
		    if(rtn > 0) rtn *= -1;
		}	//  adjE < kE rtn=1; kE < adjE rtn 2; E1 == E2 rtn 3; else rtn 0.
		if(rtn==0) { NilSeq(adjE); continue; }
		assert(rtn < 4 && rtn > -3);
// fprintf(stderr,"rtn=%d; start=%d\n",rtn,start);
		if(0) AlnSeqSW(stderr,11, 1,adjE,kE,AB);
		j=this->AddAdjctToDistMtrx(AdjacentChains[i]);
		if(0) fprintf(stderr,"%d residues paired with chain %c\nSeqKey=%s\n", 
					j,AdjacentChains[i],SeqKey);
		// for(j=0; j <= resEnd; j++) SeqKey[j]=' ';
		NilSeq(adjE); 
	} 
}

Int4	dcm_typ::AddAdjctToDistMtrx(char chainAdj)
//============= Move this routine to libpdb.a at some point: ================
{
	Int4	ai,aj,r,i,j,xj,startJ,siteK,siteA,Cadj;
	Int4	num_resAdj,resStartAdj,resEndAdj,PairsChanged=0,*AdjJ2KeyJ=0;	
	atm_typ	atmI,atmJ;
	res_typ	ResI,ResJ;
	char	cI,cJ;
	float	max,min,dd;	// 350 x 350 = 122,500 x 16 = 1,470 kBytes.

	// 1. Get Adjacent Chain residue array information.
        Cadj=GetChainNumberPDB(PDB,chainAdj); // = adjacent chain.
        if(Cadj==0){ fprintf(stderr,"chain = %c\n",chainAdj); print_error("chain not found!"); }
	e_type adjE=GetPDBSeq(Cadj,PDB);
	// if(chainAdj==0) chainAdj='?';
        res_typ *ResAllAdj=MakeResPDB(Cadj,&num_resAdj,PDB);
        resStartAdj=MinResPDB(Cadj,PDB); resEndAdj=MaxResPDB(Cadj,PDB);
	NEW(AdjJ2KeyJ,num_resAdj+5,Int4);

// fprintf(stderr,"resStart=%d; resEnd=%d; chain=%c; num_resAdj=%d\n", resStartAdj,resEndAdj,chainAdj,num_resAdj);

	// 2. map position in AdjChn to corresponding position in KeyChn.
	for(PairsChanged=0,startJ=1,i=1; i <= num_resC; i++){		// Key chain...
	   ResI=ResALL[i]; siteK=ResidueID(ResI);
	   if(siteK < resStart || siteK > resEnd) continue;
	   cI=GetCharResidue(ResI,AB); 
// fprintf(stderr,"%c%d%c: startJ=%d\n",cI,siteK,KeyChain,startJ);
	   for(j=startJ; j <= num_resAdj; j++){		// adjacent identical chain...
	     ResJ=ResAllAdj[j]; siteA=ResidueID(ResJ);
	     if(siteA < resStartAdj || siteA > resEndAdj) continue;	// Not used: keep equal to zero.
	     if(siteA == siteK){
		cJ=GetCharResidue(ResJ,AB); 
		if(!(cJ=='X' || cI == 'X' || cI == cJ)){ 		// check for consistency.
		  if(0){
		   AlnSeqSW(stderr,11,1,adjE, pdbE, AB);
		   PutSeq(stderr,adjE,AB); PutSeq(stderr,pdbE,AB);
		   fprintf(stderr,"Chain numbering inconsistency:\n\t %s\n",pdb_file);
		   fprintf(stderr,"%c%d%c != %c%d%c\n",cI,siteK,KeyChain,cJ,siteA,chainAdj);
		  }
		   // PrintResidueAtoms(stderr,ResI,FALSE); PrintResidueAtoms(stderr,ResJ,FALSE);
#if 0
		   print_error("Fatal: pdb coordinate input error");
#else
		   fprintf(stderr,"%s: pdb coordinate format error; skipping.\n",FilenamePDB(PDB));
		   for(Int4 x=1; x <= num_resAdj; x++){ NilRes(ResAllAdj[x]); } free(ResAllAdj);
		   free(AdjJ2KeyJ); NilSeq(adjE); return 0;
#endif
		}
		AdjJ2KeyJ[j]=i;			// found corresponding residue
		startJ=j+1;	// start at the next residue...
	     } else if(siteA > siteK){		// moved past the possible position...
		break;
	     } else startJ=j+1;			// siteA < siteK; start next round up one position.
// fprintf(stderr,"%c%d%c ==? %c%d%c\n",cI,siteK,KeyChain,cJ,siteA,chainAdj);
	   }
	}

	// 3. Reset distance matrix to close of the two distances.
	h_type HG=0;
	if(efptr) HG=Histogram("residue-residue 3D distances",0,100,1.0);
	// Convert input MtrxPDB to minimum Res-Res distance matrix...
	for(i=1; i <= num_resC; i++){		// Key chain...
	   ResI=ResALL[i]; siteK=ResidueID(ResI),siteA;
	   if(siteK < resStart || siteK > resEnd) continue;
	   cI=GetCharResidue(ResI,AB); 
	   for(xj=1; xj <= num_resAdj; xj++){
	     j=AdjJ2KeyJ[xj];			// j == corresponding position in KeyChain.
	     if(j == 0) continue;	// no corresponding residue in KeyChain.
	     if(i==j || Used[i][j]==FALSE) continue;
	     ResJ=ResAllAdj[xj]; if(ResJ==0) continue;
	     siteA=ResidueID(ResJ); cJ=GetCharResidue(ResJ,AB); 
	     // fprintf(stderr,"%d.%d(%d): %c%d --> %c%d\n",i,xj,j,cI,siteK,cJ,siteA);
	     if(siteA < resStartAdj || siteA > resEndAdj) continue;
	     min=FLT_MAX;
	     if(UseHydrogens){   // Consider sidechain and gly alpha-carbon atoms only.
		Int4	h,ii,jj;
		atm_typ atmsI[200],atmsJ[200],*H;
		for(ii=0,ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		   atmI=AtomResidue(ai,ResI);
		   if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		   ii++; atmsI[ii]=atmI;
		   H=ResidueAtomHydrogens(ai,ResI);
		   if(H) for(h=1; H[h]; h++){ ii++; atmsI[ii]=H[h]; } 
		} ii++; atmsI[ii]=0;
		for(jj=0,aj=1; aj <= ResidueAtomNumber(ResJ); aj++){
		   atmJ=AtomResidue(aj,ResJ);
		   if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		   jj++; atmsJ[jj]=atmJ;
		   H=ResidueAtomHydrogens(aj,ResJ);
		   if(H) for(h=1; H[h]; h++){ jj++; atmsJ[jj]=H[h]; }
		} jj++; atmsJ[jj]=0;
		for(ai=1; atmsI[ai]; ai++){
		   for(atmI=atmsI[ai],aj=1; atmsJ[aj]; aj++){
		      dd=DistanceAtoms(atmI,atmsJ[aj]);
		      if(dd < min) min=dd;
		   }
		}
	    } else {
		for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		  atmI=AtomResidue(ai,ResI);
		  if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		  // fprintf(stderr,"%s: \n",ResidueName(ResI)); PutAtom(stderr,atmI);
		  for(aj = 1; aj <= ResidueAtomNumber(ResJ); aj++){
		    atmJ=AtomResidue(aj,ResJ);
		    if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		    dd=DistanceAtoms(atmI,atmJ);
		    if(dd < min) min=dd;
		  }
		}
	    }   // pick the closest atom distances
	    float tmpF=min,oldF=MtrxPDB[i][j];
	    // if(i==155 && j==371)
	    if(MtrxPDB[i][j] > 0 && tmpF < MtrxPDB[i][j]) AdjChn[i][j]=chainAdj;
	    if(MtrxPDB[i][j] > 0) tmpF=MINIMUM(float,MtrxPDB[i][j],tmpF);
	    if(MtrxPDB[j][i] > 0) tmpF=MINIMUM(float,MtrxPDB[j][i],tmpF);
	    MtrxPDB[i][j]=MtrxPDB[j][i]=tmpF; 
	    if(oldF != tmpF && tmpF <= MaxDist){
		PairsChanged++; 
		// fprintf(stderr,"%s%d vs %s%d: %.3f (was %.3f)\n",ResidueName(ResI),siteK,ResidueName(ResJ),siteA,tmpF, oldF);
	    } if(HG && Used && Used[i] && Used[i][j] && tmpF == min) IncdHist(min,HG); 
	   }
	} if(HG){ PutHist(stderr,60,HG); NilHist(HG); }
	for(Int4 i=1; i <= num_resAdj; i++){ NilRes(ResAllAdj[i]); } free(ResAllAdj);
	if(AdjJ2KeyJ) free(AdjJ2KeyJ);	NilSeq(adjE);
	return PairsChanged;
}

