/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

dci_typ	*dcm_typ::PDBvsDCA(FILE *fp,char ColorCode, FILE *dcfp, Int4 num_dc,char *chns,
			set_typ SetUsd)
// find the pvalue for DCA versus PDB.
// II,JJ are sites in sequence; i and j are positions in ResALL array.
{
	Int4	i,j,n,m,LLL,N,II,JJ,ri=0,ro=0,bi=0,bo=0,Nb,Nr,nO,nI,x;
	Int4	*n2i,*n2j,*n2I,*n2J,MM=num_resC*num_resC,MMP=MM + num_resC; 
	char	*n2cI,*n2cJ; 
	float	*n2d,dD,*n2dc; 
	if(ColorCode==0) ColorCode=color_code;

	if(TheOtherMtrx && OtherNumResC != num_resC) 
		print_error("input error: # residues inconsistent"); 
	stdh_typ *stdh=0; stdh = new stdh_typ(MM,MMP,this);
	N=stdh->LoadUp(SetUsd);
	// fprintf(stderr,"NumDistinguished=%d; N=%d\n",NumDistinguished,N);
	if(NumDistinguished >= N/2){ delete stdh; return 0; } // then return 0
	stdh->MkArrayPDB(); 
	if(ShuffleRanks) stdh->ShuffleRanks();
	Int4 *SortedByScoreDCA=stdh->SortArrayDCA(fp,dcfp,num_dc,chns); 

	set_typ SetPDB=stdh->RtnSetPDB(),SetBP=stdh->RtnSetBP();
	Int4 *Rank=stdh->RtnRank();
	stdh->RtnN2Arrays(n2i,n2j,n2I,n2J,n2cI,n2cJ,n2d,n2dc);
	Int4  numX,numD,numB,numO,numAll;
	stdh->RtnBallInUrn(numX,numD,numB,numO,numAll,N);
	Nr=CardSet(SetPDB); 
	if(0) fprintf(stderr,"Nr = %d\n",Nr);

	Int4 red,black,redout;
Int4 R_out=0; // for BIU component...
	long double biu;
#if 0	// compute the influence of adding hydrogens to reference structures.
	ro=20; ri=78; bo=177; bi=21434;
	biu = CumHyperGeomProb(ro+ri,bo+bi,ro+bo,ro); 
	fprintf(stderr,"Pop=%d; sample=%d; red=%d; ro=%d\n",ro+ri+bo+bi,ro+bo,ro+ri,ro);
	fprintf(stderr,"prob=%Lg\n",biu); exit(1);
#endif
#if 1	//=================== turn off here when testing relative entropy ====================
	//========= 4. Do BPPS pairs correspond to 3D contacts? (Often true of root node.) ========
        if(MtrxBPPS){ 
	    bo=ri=ro=bi=0; redout=numO;
	    red = numB + numO; black = numAll - red; ro = numO;
	    ri=numB; bo = numD; bi=black-bo;
	    // biu = OneTailCumHyperGeomProb(ro+ri,bo+bi,ro); 
	    // ^should not use this!! assumes n==Nr
	    biu = CumHyperGeomProb(ro+ri,bo+bi,ro+bo,ro); 
	    if(afptr && fp){
               fprintf(afptr,"   symbols: 'B' = BPPS pair; 'D' = 3D contact pair;");
               fprintf(afptr," 'O' = 'B' & 'D'; '.' = none.\n");
               fprintf(afptr,"     #'B'=%d; #'D'=%d; #'O'=%d; total=%d.\n",
				numB,numD,numO,numAll);
	       fprintf(afptr,"     CumHypGeomProb(Nr=%d,Nb=%d,No=%d,ro=%d)=%.3Lg;",
			ro+ri,bo+bi,ro+bo,ro,biu);
	       fprintf(afptr," bo=%d;ri=%d,bi=%d; Ni=%d.\n\n",bo,ri,bi,ri+bi);
	    } numX=ro+bo;
        }	// end of if(MtrxBPPS).. 
#endif	//======================= turned off end. =========================

	//========= 5. Create ICA array of residue/column pairs =========
	Int4 L,D,*pos,X=0;
	long double dd,pval=1.0,prob=1.0,Pval;
	BooLean jf=0,cf=TRUE;
	if(UseJeffreys) jf=1;
#if 1
	LLL=N;
	L = N;
#else
	L = this->RtnL();
	LLL=this->RtnL();
#endif
// fprintf(stderr,"LLL=%d\n",LLL);
	D = Nr; NEW(pos,N+5,Int4); assert(LLL==L);
	// fprintf(stderr,"======== D = %d == %d? =========\n",D,NumDistinguished);
	if(DistPairSet != 0) NilSet(DistPairSet);
	DistPairSet=MakeSet(L + 3); 
	for(x=n=0,i=1; i <= N; i++){
	     n=SortedByScoreDCA[i];
	     if(MemberSet(n,SetPDB)){
		AddSet(n,DistPairSet);
		x++; pos[x]=i; assert(x <= D); 
	        // fprintf(stderr,"pos[%d]=%d (%d)\n",x,pos[x],n);
	     }
	}
	long double *Prob; NEW(Prob,D+3, long double);
	float F_factor=0.0;
	//============== -F=<real> = TruncateArray option ================
	if(TruncateArray > 0.0){ 
	  double frctn=(double) TruncateArray;
	  F_factor=TruncateArray;
	  Int4 len=LenSeq(dcaE);
#if 0
	  char str[10]; strncpy(str,pdb_file,5);
	  fprintf(stdout,"Summary: %5s\t%d\n",str,len); exit(1);
#endif
	  L=(Int4) floor(frctn*(double)len+0.5); //L=100;
	  Int4 DD=D;
	  for(D=0,i=1; i <= L; i++){
	     n=SortedByScoreDCA[i];
	     if(MemberSet(n,SetPDB)) D++;
	  }
	  ro=D; ri=DD-D; bo=L-ro; bi=LLL-L-ri;
	  assert(L < LLL); // N=LLL=L;
// fprintf(stderr,"truncated LLL=%d; L = %d\n",LLL,L);
	  //============== Combine both ball in urn p-values. ===============
	  long double LD=CumHyperGeomProb(ro+ri,bo+bi,ro+bo,ro); 
	  if(0) fprintf(stderr,
		" Summary: CHGP(Nr=%d,Nb=%d,No=%d,ro=%d)=%.1Lg; bo=%d;ri=%d,bi=%d; Ni=%d.\n",
			ro+ri,bo+bi,ro+bo,ro,LD,bo,ri,bi,ri+bi);
	  Int4 Po,Ri,Ro,Pi; Po=Ri=Ro=Pi=0; // Pink = low ranked red balls.
	  for(x=1; x <= ro; x++){  // pairs left of L == balls drawn out of urn.
	      i=pos[x]; n=SortedByScoreDCA[i];
	      if(MemberSet(n,SetPDB)){
		 if(Rank[n] <= ro) Ro++; else Po++; 
	      }
	  }
	  for(x=ro+1; x <= (ro+ri); x++){ // right of L == balls remaining in urn.
	      i=pos[x]; n=SortedByScoreDCA[i];
	      if(MemberSet(n,SetPDB)){ if(Rank[n] <= ro) Ri++; else Pi++; }
	  } 
	  assert((Ro+Ri)==ro); 
	  assert((Ro+Po)==ro);
	  assert(Ri==Po);
	  X=ro; pos[X]=L; D=ro+ri; L=LLL;	// for dci_typ.
// fprintf(stderr,"2: LLL=%d; L = %d\n",LLL,L);
	  Prob[X] = OneTailCumHyperGeomProb(Ro+Ri,Po+Pi,Ro); R_out=Ro;
	  if(0) fprintf(stderr,
		"Summary: (Nr=No=%d,Nb=%d,Ro=%d)=%.2Lg; Po=%d; Ri=%d,Pi=%d; Ni=%d.\n",
			Ro+Ri,Po+Pi,Ro,Prob[X],Po,Ri,Pi,Ri+Pi);
          pval=LD*Prob[X];          // multiply the two ball & urn P-values
          pval*=1-logl(pval);      // two-factor correction: Unified P-value.
	  if(Mode == 'I'){
	    pval=LD; R_out=-1;
	  }
	  if(0 || !std::isfinite(pval)){
	    fprintf(stderr,
		"Summary: CHGP(Nr=%d,Nb=%d,No=%d,ro=%d)=%.2Lg; bo=%d;ri=%d,bi=%d; Ni=%d.\n",
			ro+ri,bo+bi,ro+bo,ro,LD,bo,ri,bi,ri+bi);
	    fprintf(stderr,
	       "Summary: DD=%d; pval=%Lg; L=%d;  pos[L]=%d; biu=%Lg\n",
			DD,pval,X,L,pos[X],Prob[L]);
          } // assert(std::isfinite(pval));
	  if(UsePPV){
	    long double PPV=100.0*(long double)ro/(long double)(ro+bo);
	    pval=powl(10,-PPV); Prob[X]=1.0; R_out=-1;
	  } 
	//=================== end Truncate array option =========================
	//========== Optimize over ICA P-values only (-I option) ================
	} else if(Mode == 'I'){
// fprintf(stderr,"3: LLL=%d; L = %d\n",LLL,L);
	    X=pvcalcD(L,D,pos,pval,jf,cf); // don't use joint pval.
	    F_factor=(float)pos[X]/(float)LenSeq(dcaE); Prob[X] = 1.0; R_out=-1;
	//========== Also compute ball-in-urn component ================
	} else {
	  // Ball-in-Urn p-value; red & black balls = highest & lowest DCA scores.
	  for(X=1; X <=D; X++){
	    bo=ri=ro=bi=0;
	    for(x=1; x <= X; x++){  // pairs left of X == balls drawn out of urn.
	      i=pos[x]; n=SortedByScoreDCA[i];
	      if(MemberSet(n,SetPDB)){ if(Rank[n] <= X) ro++; else bo++; }
	    }
	    for(x=X+1; x <= D; x++){	// right of X == balls remaining in urn.
	      i=pos[x]; n=SortedByScoreDCA[i];
	      if(MemberSet(n,SetPDB)){ if(Rank[n] <= X){ ri++; } else { bi++; } }
	    } assert((ro+ri)==X); assert((ro+bo)==X); assert(ri==bo);
	    Prob[X] = OneTailCumHyperGeomProb(ro+ri,bo+bi,ro); R_out=ro;
	    if(0) fprintf(stderr,
		" CumHypGeomProb(Nr=%d,Nb=%d,No=%d,ro=%d)=%.3Lg; bo=%d;ri=%d,bi=%d; Ni=%d.\n",
			ro+ri,bo+bi,ro+bo,ro,Prob[X],bo,ri,bi,ri+bi);
	  }
// fprintf(stderr,"4: LLL=%d; L = %d\n",LLL,L);
	  X=pvcalcICA_BIU(L,D,pos,Prob,jf,cf,pval);   
	  F_factor=(float)pos[X]/(float)LenSeq(dcaE);
	}
	//================= pvcalc for BPPS input... ====================
	Int4 bpD=0,bpX=0,bpd=0,bpL=0;
	long double	pVal,bpS=0,bpBIU=0;
// fprintf(stderr,"5: LLL=%d; L = %d\n",LLL,L);
    if(bpps){
	Int4 DD=CardSet(SetBP),*Pos=0;
	NEW(Pos,L+5,Int4);
	for(x=n=0,i=1; i <= L; i++){
	     n=SortedByScoreDCA[i];
	     if(MemberSet(n,SetBP)){ x++; Pos[x]=i; assert(x <= DD); }
	}
	assert(LLL==L);
	x=pvcalcD(L,DD,Pos,pVal,jf,cf); // optimize over ICA not joint pval.
	//********* Testing Relative Entropy effect *****************************
	// see dcm_junk.cc for this code
	//**************** End of Relative Entropy test *************************
	if(0){	//==== see top scoring BPPS pairs... ====
	  Int4 Hits=0;
	  // fprintf(stderr,"dca2pdbOS=%d\n",dca2pdbOS); exit(1);
	  for(i=1,j=Pos[x]; i <= j; i++) {
	     n=SortedByScoreDCA[i];
	     if(MemberSet(n,SetBP)){ 
	 	Hits++;
	        Int4 xi=n2i[n],xj=n2j[n]; 
		float dD=-MtrxDCA[xi][xj];
	        Int4 ii=n2I[n]-dca2pdbOS,jj=n2J[n]-dca2pdbOS; 
	        char cii=n2cI[n],cjj=n2cJ[n];
	        fprintf(stderr,"%d. %c%d(%d)...%c%d(%d) = %.4f; DCA=%.4f\n",
				i,cii,ii,xi,cjj,jj,xj,n2d[n],dD);
	     }
	  } fprintf(stderr,"pVal=%Lg; hits=%d\n",pVal,Hits);
	}
	switch (Mode){
           case 'M': { bpS=-log10l(pVal); bpBIU=-log10l(biu);
		bpL=numAll; bpD=DD; bpX=Pos[x]; bpd=x; } break;
	   case 'm': { bpS=0; bpBIU=-log10l(biu); bpL=red+black;
		bpD=red; bpX=numX; bpd=redout; } break;
	   default:
	    {
#if 0
	     fprintf(stdout,"BPPS-DCA -log10(p)=%.3Lf; X=%d; d(#D before X)=%d; D=%d",
					-log10l(pVal),Pos[x],x,DD);
	     fprintf(stdout," (%.1f%c Ds in %.1f%c of array)\n",
			100.0*(double)x/(double)DD,'%',
			100.0*(double)Pos[x]/(double)L,'%');
	     fprintf(stdout,"DIST-DCA -log10(p)=%.3Lf; X=%d; d=%d; D=%d",
			-log10l(pval),pos[X],X,D);
	     fprintf(stdout," (%.1f%c Ds in %.1f%c of array)\n",100.0*(double)X/(double)D,'%',
						100.0*(double)pos[X]/(double)L,'%');
	     // fprintf(stdout,"BPPS & 3D-DCA BIU: -log10(p)=%.3Lf.\n",-log10l(biu));
#endif
             bpS=-log10l(pVal); bpBIU=-log10l(biu); bpL=numAll; bpD=DD; bpX=Pos[x]; bpd=x; 
	   } break;
       } free(Pos);
    }	//============== End if(bpps)... ===================================
	// NilSet(SetBP); 

	// print out top scoring pairs.
	// fprintf(stderr,"dca_file=%s; L=%d\n",dca_file,L);
	if(0) fprintf(stderr,"pdb_file=%s; L=%d; D=%d; chain=%c; %s\n",
			pdb_file,L,D,chain,dca_file);
	dci_typ *dci=0; assert(LLL==L);
// fprintf(stderr,"6: LLL=%d; L = %d\n",LLL,L);
	Int4 NumItems=CardSet(SetPDB); NumItems=L+3; //NumItems=150000;
	// fprintf(stderr,"NumItems=%d; X = %d\n",NumItems,X);
	// X = #distinguishing elements to left of cutoff X (i.e., mbest).
	if(X >= 0){	// if X < 0 then input doesn't make sense
	  if(X == 0){	// if X == 0 then something is probably wrong...
	     // fprintf(stderr,"X = %d; pval= %Lg; pos[X]=%d\n",X,pval,pos[X]);
// fprintf(stderr,"6a: LLL=%d; L = %d\n",LLL,L);
	     dci= new dci_typ(dca_file,MaxDist,NumItems,L,D,pos[X],X,pval,-1.0,-1,F_factor); 
	  } else {	// this should be the returned value of the cutoff point.
	     // fprintf(stderr,"X = %d; pval= %Lg; pos[X]=%d\n",X,pval,pos[X]);
// fprintf(stderr,"6b: LLL=%d; L = %d\n",LLL,L);
	     dci= new dci_typ(dca_file,MaxDist,NumItems,L,D,pos[X],X,pval,
							Prob[X],R_out,F_factor); 
	     dci->AddBPPS(bpS,bpBIU,bpL,bpD,bpX,bpd,ColorCode);
	  }
	  // PutSet(stderr,SetPDB);
#if 0	// DEBUG
	  for(i=1; i <= L; i++) 
#else
	  for(i=1,j=pos[X]; i <= j; i++) // pos[X] is the ICA partition cutoff 
#endif
	  {
	     n=SortedByScoreDCA[i];
	     if(0) fprintf(stderr,"i=%d; j=%d; n=%d; in set: %u\n",
				i,j,n,MemberSet(n,SetPDB));
	     if(MemberSet(n,SetPDB)){ 
		// Across adjacent homomeric subunits if included.
		Int4 ii=n2I[n]-dca2pdbOS,jj=n2J[n]-dca2pdbOS,xi=n2i[n],xj=n2j[n]; 
		char cii=n2cI[n],cjj=n2cJ[n],chn2=AdjChn[xj][xi];
#if 0	// DEBUG
		if(ii==122 || jj==122) fprintf(stderr,
			"%c%d vs %c%d; xi=%d; xj=%d; n=%d; in set=%u; chn2=%d\n",
			cii,ii,cjj,jj,xi,xj,n,MemberSet(n,SetPDB),chn2);
#endif
		if(chn2){ 
		   dci->add(i,cjj,jj,cii,ii,n2d[n],n2dc[n],chn2);
		   // fprintf(stderr,"%c%d...%c%d:%c = %.4f\n",cii,ii,cjj,jj,chn2,n2d[n]);
		} else {
		   chn2=AdjChn[xi][xj]; dci->add(i,cii,ii,cjj,jj,n2d[n],n2dc[n],chn2);
#if 0
		   if(chn2) fprintf(stderr,"%c%d...%c%d:%c = %.4f\n",
					cjj,jj,cii,ii,chn2,n2d[n]);
		   else fprintf(stderr,"%c%d...%c%d = %.4f\n",cjj,jj,cii,ii,n2d[n]);
#endif
		}
#if 1	// print out all top scores...
	     } else {
		Int4 ii=n2I[n]-dca2pdbOS,jj=n2J[n]-dca2pdbOS,xi=n2i[n],xj=n2j[n]; 
		char cii=n2cI[n],cjj=n2cJ[n],chn2=AdjChn[xj][xi];
#if 0	// DEBUG
		if(ii==122 || jj==122) fprintf(stderr,
			"%c%d vs %c%d; xi=%d; xj=%d; n=%d; in set=%u; chn2=%d\n",
			cii,ii,cjj,jj,xi,xj,n,MemberSet(n,SetPDB),chn2);
#endif
		if(chn2){ 
		   dci->add(i,cjj,jj,cii,ii,n2d[n],n2dc[n],chn2);
		   //fprintf(stderr,"%c%d...%c%d:%c = %.4f\n",cii,ii,cjj,jj,chn2,n2d[n]);
		} else {
		   chn2=AdjChn[xi][xj]; dci->add(i,cii,ii,cjj,jj,n2d[n],n2dc[n],chn2);
		   // if(chn2) fprintf(stderr,"%c%d...%c%d:%c = %.4f\n",cjj,jj,cii,ii,chn2,n2d[n]);
		}
	     }
#else
	     }
#endif
	  } // if(ShowPairs) for(i=1; i <= dci->rtnN(); i++){ dci->put(stderr,i); }
	} 
	// free(n2i); free(n2j); free(n2d); free(n2dc); free(n2I); free(n2J); free(n2cI); free(n2cJ);

#if 1	//====================== New score-ranked ICA: ========================
	if(X > 0 && fp && PermuteMillions > 0){
	    Int4 NN=0,*permute; NEW(permute,X+10,Int4);
	
	    for(x=1; x <= X; x++){		// if left of X == balls drawn out of urn.
	      i=pos[x]; n=SortedByScoreDCA[i];
	      if(MemberSet(n,SetPDB)){ 
		      NN++; permute[NN]=Rank[n];
		      // fprintf(efptr,"%d,",Rank[n]); 
	      } // if(i%50 == 0) fprintf(efptr,"\n");
	    }
#if 0
	    fprintf(stdout,"Permute[n]:"); 
	    for(i=1; i <= NN; i++) fprintf(stdout,"%d,",permute[i]); 
	    fprintf(stdout,"\nRank[n]:"); 
#endif
	    double d=PermutationPvalue(stdout,NN, permute);
	    fprintf(stdout,"\nNN=%d; p=%.3g\n",NN,d); 
	    free(permute);
	}
#endif	//=====================================================================

	if(X > 0 && fp){
	  //====================== ComputeOverRange option ======================
	  if(!ComputeOverRange){	// not used much; testing only
#if 1	
	     if(efptr){		// show ball-in-urn input and results.
		bo=ri=ro=bi=0;
		for(x=1; x <= X; x++){		// if left of X == balls drawn out of urn.
		     i=pos[x]; n=SortedByScoreDCA[i];
		     if(MemberSet(n,SetPDB)){ if(Rank[n] <= X) ro++; else bo++; }
		}
		for(x=X+1; x <= D; x++){	// right of X == balls remaining in urn.
		      i=pos[x]; n=SortedByScoreDCA[i];
		      if(MemberSet(n,SetPDB)){ if(Rank[n] <= X){ ri++; } else { bi++; } }
		}
		fprintf(fp,
		  " CumHypGeoPrb(Nr=%d,Nb=%d,No=%d,ro=%d)=%.3Lg; (bo=%d;ri=%d,bi=%d;Ni=%d).\n",
			ro+ri,bo+bi,ro+bo,ro,Prob[X],bo,ri,bi,ri+bi);
	    }
#endif
	  } else {	// for minimum seq separation...4 to 20.
	   // pdb     SqSep   mthd    maxDist score   L       BIU     D       X       d
	   // 1ayaA   m=5     CCM     5.00    48.03   3165    1.13535 101     82      47
	   dd=-expm1l(-pval);
	  }
	} 
	if(stdh) delete stdh;
	free(SortedByScoreDCA); free(Prob); free(pos); 
	// free(Rank); NilSet(SetPDB); 
	return dci;
}

