/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

void    dcm_typ::MinusBgMtrxDCA(dcm_typ *dcmBG)
// subtract BG MtrxDCA from foreground MtrxDCA
{
	Int4	I,J,i,j,BgL=0;
	h_type HG=0;	HG=Histogram("FG minus BG DC-scores",-10,10,0.05);
	float **BgDM=dcmBG->RtnMtrxDCA(BgL);
	assert(BgL == num_resC);
	for(i=1; i <= BgL; i++){
if(0){
res_typ ResI=ResALL[i]; I=ResidueID(ResALL[i]); if(I < resStart || I > resEnd) continue;
}
	   for(j=1; j <= BgL; j++){
		if(Used[i][j]){
		   // if(MtrxDCA[i][j] == BgDM[i][j]) MtrxDCA[i][j]=0.0; else 
if(0){
res_typ ResJ=ResALL[j]; J=ResidueID(ResJ); if(J < resStart || J > resEnd) continue;
if(abs(I - J) <= MinSqSeparation) continue;
}
		   MtrxDCA[i][j] -= BgDM[i][j]; 
		   // if(MtrxDCA[i][j] < 1e-14 && MtrxDCA[i][j] > -1e-14) MtrxDCA[i][j]=0.0;
		   if(HG) IncdHist(MtrxDCA[i][j],HG);
		}
	   }
	} if(HG){ 
	   double stdev=sqrt(VarianceHist(HG)),mean=MeanHist(HG);
	   if(stdev < 0.0001 && fabs(mean) < 0.001){
		print_error("Foreground DC-scores too similar to background scores to be reliable.");
	   }
	   if(0) PutHist(stderr,60,HG); NilHist(HG);
	}
}

void	dcm_typ::Init2(edc_typ *S)
{
	Int4	i,j;
#if 1	// moved here to avoid memory leak
	oldL=0; oldD=0;
#endif
	DistPairSet=0;
	InitOkay=TRUE;
        // don't copy over these unused parameters;
        time1=0; seed=0; pdb_file=0; dca_file=0; 
        // pass over these parameters;
	SetBPPS=0;
        AB=S->AB;
        Split=S->Split;
        UseSide=S->UseSide;
        TheOtherMtrx=S->TheOtherMtrx;
	NumAdjChns=S->NumAdjChns;
// fprintf(stderr,"NumAdjChns=%d\n",NumAdjChns);
	for(i=1; i <= NumAdjChns; i++) AdjacentChains[i]=S->AdjacentChains[i];
        TheOtherSet=S->TheOtherSet;
        OtherNumResC=S->OtherNumResC;
        program=S->program; 
        color_code=S->color_code; 
        TruncateArray=S->TruncateArray; 
        UsePPV=S->UsePPV; 
        bpps=S->bpps; 
        ShowPairs=S->ShowPairs; 
        ComputeOverRange=S->ComputeOverRange; 
        Mode =S->Mode; 
        MinSqSeparation=S->MinSqSeparation; 
        pdb_file=S->pdb_file; 
        dca_file=S->dca_file; 
        dcaE=S->dcaE; dca2pdbOS=S->dca2pdbOS;
        UseHydrogens=S->UseHydrogens;
        KeyChain=S->KeyChain; 
        Simulate=S->Simulate; 
        MaxDist=S->MaxDist; 
        MinDist=S->MinDist; 
        ShuffleRanks=S->ShuffleRanks; 
        UseJeffreys=S->UseJeffreys;
        efptr=S->efptr; 
        afptr=S->afptr; 
        PermuteMillions=S->PermuteMillions; 
	// strncpy(PDBID,S->PDBID,8); // S->PDBID appears to be empty.

	if(chain) CC=GetChainNumberPDB(PDB,chain); // CC = query residue chain.
	if(CC==0){ fprintf(stderr,"chain = %c\n",chain); print_error("chain not found!"); }
	if(chain==0) chain='?';
	pdbE=GetPDBSeq(CC,PDB);
	a_type ab=AminoAcidAlphabetPDB(PDB); 
	ResALL=MakeResPDB(CC,&num_resC,PDB);
	resStart=MinResPDB(CC,PDB); resEnd=MaxResPDB(CC,PDB);
	assert(resStart > 0); assert(resStart <= resEnd);
	Int4 YY=num_resC;
	NEWP(Used,YY+3, BooLean);
	for(i=1; i <= YY; i++){ NEW(Used[i], YY+ 3, BooLean); }
	NEWP(MtrxDCA, YY+ 3, float);
	for(i=1; i <= YY; i++){ NEW(MtrxDCA[i], YY+ 3, float); }
	if(!this->GetMtrxDCA(dca_file)) InitOkay=FALSE;
#if 0
	for(i=1; i <= YY; i++){ 
	  for(j=1; j <= YY; j++) fprintf(stderr,"FgDM[%d][%d]=%.4f\n",i,j,MtrxDCA[i][j]);
	}
#endif
	NEWP(AdjChn, YY + 3, char);
	for(i=1; i <= YY; i++){ NEW(AdjChn[i], YY+ 3, char); }
	NEWP(MtrxPDB, YY+ 3, float);
	for(i=1; i <= YY; i++){ NEW(MtrxPDB[i], YY+ 3, float); }
	this->CalcDistMtrx();
        if(MinDist > 0){ // Find residual indirect couplings by ignoring close contacts.
          for(i=1; i < YY; i++){
            for(j=i+1; j <= YY; j++){	// ignore closer residue pairs.
                if(MtrxPDB[i][j] < MinDist && Used[i][j]) Used[i][j]=Used[j][i]=FALSE;
            }
          }
        }
	Int4	End=0;
        if(MaxDist < FLT_MAX){  // Only those pairs within a MaxDist are discriminating.
          for(i=1; i < YY; i++){
            for(j=i+1; j <= YY; j++){
                if(Used[i][j] && MtrxPDB[i][j] && MtrxPDB[i][j] <= MaxDist) End++;
#if 0
		if(MtrxPDB[i][j] > 0 || Used[i][j])
			fprintf(stderr,"MtrxPDB[%d][%d]=%lf\n",i,j,MtrxPDB[i][j]);
#endif
            }
          }
          if(End==0){
                fprintf(stderr,"MaxDist=%.3f; chain='%c'; pdb = %s\n",
			MaxDist,chain,FilenamePDB(PDB));
#if 0
                fprintf(stderr,"num_resC=%d; i=%d\n",YY,i);
#endif
                fprintf(stderr,"Either the maximum distance is too small\n");
                fprintf(stderr,"\t (-D=<real> option)\n");
                fprintf(stderr,"   or there is a problem with the input\n");
                fprintf(stderr,"\t (e.g., disordered residues)\n");
	        InitOkay=FALSE;
          }
        } else {
           // Use up to 1/3rd of the pairs as discriminating.
           for(i=1; i < YY; i++){
             for(j=i+1; j <= YY; j++) if(MtrxPDB[i][j] > 0 && Used[i][j]) End++;
           } End=End/3;
        } NumDistinguished=End;
	if(bpps){
	   NEWP(MtrxBPPS, num_resC + 3, float);
           for(i=1; i <= num_resC; i++){ NEW(MtrxBPPS[i], num_resC + 3, float); }
	   this->CalcMtrxBPPS();
	} else MtrxBPPS=0;
	if(0) fprintf(stderr,"resStart=%d; resEnd=%d; chain=%c; MinDist=%.3f; num_resC=%d; End=%d\n",
			resStart,resEnd,chain,MinDist,num_resC,End);
	if(Simulate) this->Shuffle();    // Then shuffle the scores.
}

void    dcm_typ::Free2()
{       
        Int4 i,YY=num_resC;
        if(SetBPPS){ NilSet(SetBPPS); SetBPPS=0; }
	if(pdbE) NilSeq(pdbE);
        if(DistPairSet){ NilSet(DistPairSet); DistPairSet=0; }
        if(AdjChn){ for(i=1; i <= YY; i++) if(AdjChn[i]) free(AdjChn[i]); free(AdjChn); }
        if(Used){ for(i=1; i <= YY; i++) if(Used[i]) free(Used[i]); free(Used); }
        if(MtrxDCA){ for(i=1; i <= YY; i++) if(MtrxDCA[i]) free(MtrxDCA[i]); free(MtrxDCA); }
        if(ResALL){ for(i=1; i <= YY; i++) if(ResALL[i]) NilRes(ResALL[i]); free(ResALL); }
        if(MtrxPDB){ for(i=1; i <= YY; i++) if(MtrxPDB[i]) free(MtrxPDB[i]); free(MtrxPDB); }
        if(MtrxBPPS){ for(i=1; i <= YY; i++) if(MtrxBPPS[i]) free(MtrxBPPS[i]); free(MtrxBPPS); }
	// free the rest in calling environment; don't free twice!!!
        TheOtherSet=0; bpps=0;
        dcaE=0; pdb_file=0; TheOtherMtrx=0; program=0; dca_file=0;
	if (oldL) { free(lni); free(lrat); free(offset); }
        // fprintf(stderr,"====== AB = %Ld ========\n",(Int8) AB);
        // PutAlpha(stderr,AB);
        AB=0;        // not needed since not calling edc_typ::Free()???
}

void    dcm_typ::Shuffle()
{
	Int4	k,i,j,n,xx=num_resC; n=xx*xx;
        float *values; NEW(values,n+9,float);
        dh_type dH=dheap(n+5,4);
        for(k=0,i=1; i <= xx; i++){
           for(j=i+1; j <= xx; j++){
              if(!Used[i][j]) continue;
              k++;
              values[k]=MtrxDCA[i][j]; assert(values[k]==MtrxDCA[j][i]);
           }
        }
        for(i=1; i <=k; i++){ insrtHeap(i,(keytyp)Random(),dH); }
        for(i=1; i <= xx; i++){
            for(j=i+1; j <= xx; j++){
              if(!Used[i][j]) continue;
              k=delminHeap(dH);
              MtrxDCA[i][j]=MtrxDCA[j][i]=values[k];
            }
        } Nildheap(dH); free(values);
}

