/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_SCL_TYP_)
#define _SCL_TYP_

#include "stdinc.h"
#include "sequence.h"
#include "pdb.h"
#include "dheap.h"
#include "swaln.h"
#include "cmsa.h"
#include "set_typ.h"
#include "chn_vsi.h"
#include "sch_typ.h"

class scl_typ {         // protein structure clustering type
		friend class scm_typ;
public:
                scl_typ(){ time1=0; infile=0; program=0; PutPvals=FALSE; } // called by scm_typ...
                scl_typ(int argc,char *argv[],char mode=' ', const char *USG=0, const char *VRSN=0){
			// fprintf(stderr,"DEBUG SCL: '%c'\n",mode);
			KeyType=AllocString(" YROMGCBPTNLLLLL");
			usage=USG; version=VRSN;
			if(mode=='D') InitDCA(argc,argv); else Init(argc,argv);
		}
                ~scl_typ( ){ free(KeyType); KeyType=0; Free(); }
	Int4	Run(FILE *ofp=0);
	Int4	RunSPARC(FILE *ofp,char *mds_file,FILE *xfp=0);
	Int4	RunDCA();
private:
	const char	*usage,*version;
	BooLean	ShowPttrns;
	char	Mode;		// type of clustering ('S' 'C' 'H' 'B'...)
	Int4	OverlapOfSets();
	BooLean	FindOverlap;
	BooLean	PutAllSCH;
	static const Int4 nTypes=11;
	char	*KeyType;
// protected:
	class srh_typ { 	// == sipris results heap;
private:
	   static const Int4 nTypes=11;
	   char	*KeyTyp;
	   Int4	**KeyResSites; // Input from *.sprs file.
public:
	   srh_typ(){ print_error("srh_typ() constructor disallowed"); }
	   srh_typ(char kc, Int4 sz){
		size=sz; keyclass=kc; mH=Mheap(size,4);
		KeyTyp=AllocString( " YROMGCBPTNLLLLL");
		for(Int4 i=0; i <=nTypes; i++){
			use[i]=FALSE;
			NEW(DD[i], size+3,double); 
		}
		NEW(id, size+3, Int4); NEWP(pdbid, size+3, char);
		NEW(chn, size+3, char); NEW(adjcnt, size+3, char); 
		NEW(root_p, size+3,double); NEW(subfam_p, size+3,double); 
	   }
	   ~srh_typ(){
		free(KeyTyp); KeyTyp=0;
		while(!EmptyMheap(mH)){
                   Int4 ii=DelMinMheap(mH); free(pdbid[ii]); 
		} NilMheap(mH); free(id); free(pdbid); free(chn);
		free(adjcnt); free(root_p); free(subfam_p);
		for(Int4 i=0; i <=nTypes; i++){ free(DD[i]); }
	   }
	   void	Put(FILE *fp){
		double d,D;
		Int4 i,j,ii;
		if(EmptyMheap(mH)) fprintf(fp,"\nNothing significant found.\n");
		for(j=0; !EmptyMheap(mH); ){
		   if(j==0){ 
		     fprintf(fp,"  ID ");
		     if(use[1]) fprintf(fp," root_Y");
		     for(i=2; i <= nTypes; i++){
		  	if(use[i]) fprintf(fp," typ_%c",KeyTyp[i]);
		     } fprintf(fp,"  pdbid chain\n");
		   } j++; d=MinKeyMheap(mH); ii=DelMinMheap(mH);
                   fprintf(fp,"%4d",id[ii]);
		   // for(i=11; i > 0; i--)
		   for(i=1; i <= nTypes; i++)
		   {
		      D=DD[i][ii];
		      if(use[i]){
			if(i==1) fprintf(fp," ");
			if(D >= 1.0) fprintf(fp,"   -  ");
			else fprintf(fp," %5.1f",-log10(D));
		      }
		   }
		   fprintf(fp,"  %s %c",pdbid[ii],chn[ii]);
		   if(adjcnt[ii]) fprintf(fp,":%c\n",adjcnt[ii]); else fprintf(fp,"\n");
		   free(pdbid[ii]); pdbid[ii]=0;
           	}
	   }
	   void	Insert(Int4 i, double *d, char *pdb_file, char chain, char ac){
		Int4 x,ii,len=strlen(pdb_file);
		double	key=1.0;
		if(FullMheap(mH)){
		    if(MaxKeyMheap(mH) > d[2]){
		      ii=DelMaxMheap(mH); free(pdbid[ii]); pdbid[ii]=0;
		    } else return;
		} else if(EmptyMheap(mH)){ } 
		for(x=1; x <= nTypes; x++){
		   if(d[x] < 1.0){
			use[x]=TRUE; 
			if(x > 1){ if(d[x] < key) key=d[x]; }
		   }
	        }
		char *str=strrchr(pdb_file,'/');
		if(str == NULL) str=pdb_file; else str++;
		ii=InsertMheap(key,mH); assert(ii <= size);
		id[ii]=i; // root_p[ii]=d[1]; subfam_p[ii]=d[3];
		for(x=1; x <= nTypes; x++){ DD[x][ii]=d[x]; }
		if(0) for(x=1; x <= nTypes; x++){
			fprintf(stderr,"%c: d[%d]=%.1lf\n",
				KeyTyp[x],x,-log10(d[x])); 
		}
		pdbid[ii]=AllocString(str); chn[ii]=chain; adjcnt[ii]=ac; 
	   }
private:
	   mh_type mH;
	   BooLean use[20]; 
	   Int4	*id,size;
	   double *root_p,*subfam_p;
	   double *DD[20];
	   char	**pdbid,*chn,keyclass,*adjcnt;
	}; 
private:
	Int4	Driver(srh_typ *srh=0);	
	Int4	DriverSPARC(srh_typ *srh,char *pdb_paths,FILE *xfp);
	void	Free();
	void	Init(int argc,char *argv[]){
		   if(usage == 0) InitPrivate(argc,argv);
		   else InitPublic(argc,argv);
		}
	void	InitDefaults();
	void	InitPublic(int argc,char *argv[]);
	void	InitPrivate(int argc,char *argv[]);
	void	InitDCA(int argc,char *argv[]);
	Int4    ParseResSites(char *str, Int4 *values, const char *msg);
	Int4    ReadPttrnRes(FILE *fp, Int4 &Start, Int4 &End, set_typ &RtnSet,
			Int4 &nAln, char **&pdb_file, char *&chain, char *&clss,
			Int4 **&PttrnRes, char *&adjchn);
	Int4	ChainExistsPDB(char chain,pdb_typ pdb);	// returns chain id if it exists.
	UInt4   seed;
	time_t	time1;
	char	*program,*infile,PutTheRest,*outfile;
	BooLean	PutPvals,UnionCons;
	// BooLean OverlappingSeqs(Int4 &os,e_type E1, e_type E2, Int4 MinOL, Int4 MaxMsMtch);
	void	PrintError(char *);
private:	// accessed by scm_typ.
	BooLean	shuffle,BestOnly,dca_vs_pdb;	// if TRUE then shuffle, else permute.
	char	*dca_file,Ignore,FindHbonds,*ChainI,FullCluster,OnlyOne;
	e_type	dcaE;
	Int4	dcaOS;	// offset between dca and pdb sequence files.
	BooLean	FindKeyResPDB(char, Int4, pdb_typ);
	Int4	KeyRes;		// select a key (e.g., active site) residue as a starting point.
	res_typ	KeyResX;	// KeyRes within chain of interest.
	Int4	KeyPML;		// print out only one group.
	char	KeyChain;
	Int4	KeyAtmNum;
	BooLean	ShowKey;
	float	min_buried;
	Int4    MaxPrint,MaxNumPttrns,method,MaxMinAdj,EdgeDrop,Simulate,BackboneHbonds;
        double  cutoff;
	BooLean	vsi_file,UseHydrogens,UseJeffreys,AroPiBonds,OtherPiBonds;
	h_type  xHG,zHG,xxHG;
	FILE    *efptr,*vsifp,*outfp;
	FILE	*tab_fp;
	a_type	AB;
};

class scm_typ: private scl_typ {	// structural clustering method type
   public:
                scm_typ(){ print_error("scm_typ( ) constructor is disallowed"); }
                scm_typ(Int4 rS, Int4 rE, set_typ rSt, Int4 na, char ch, char *rcl,
			Int4 **PR, pdb_typ p,scl_typ *S, char ach=0,char pgm=0)
		{
			if(pgm == 'Z') prgrm='P'; else prgrm=' ';
        		resStart=rS; resEnd=rE; nAln=na; PttrnRes=PR;
			chain=ch; res_class=rcl; P=p; resSet=rSt; 
			adjchn=ach;
			Init(S); 

		}
                ~scm_typ( ){ Free2(); }
	BooLean	Run(FILE *fptr,FILE *vsifptr,FILE *tfp,const char *keyclass,
				double *RtnProb,Int4 **PttrnSites=0);
	Int4	RtnNumResC(){ return num_resC; }
	// float	**RtnDistMtrxPDB(){ return CalcDistMtrx(); }
	long double	DCAvsPDB(FILE *fp, Int4 NumRed, float **MtrxPDB, float **MtrxDCA, BooLean **Used);
	float   **CalcDistMtrx();
	float   GetMinDist(res_typ ResI, res_typ ResJ);
	float   **GetMtrxDCA(char *dca_file, BooLean **&Used);
   private:
	char	prgrm;	// calling program: SPARC or SIPRIS..
        void	Init(scl_typ *S);
	Int4    pvcalc(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jf=FALSE,BooLean cf=TRUE,BooLean pf=TRUE){
		  return pvcalcF(L,D,pos,pval,jf,cf,pf);
		}
	Int4    pvcalcD(Int4 L,Int4 D,Int4 *pos,long double &pval, BooLean jf=FALSE,BooLean cf=TRUE,BooLean pf=TRUE);
	Int4    pvcalcF(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jf=FALSE,BooLean cf=TRUE,BooLean pf=TRUE);
	Int4    pvcalc1(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jeff=FALSE,BooLean cflag=TRUE);
	Int4    pvcalc3(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jeff=FALSE,BooLean cflag=TRUE);
	Int4    pvcalc2(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jeff=FALSE);
	Int4    pvcalc0(Int4 L,Int4 D,Int4 *pos,double &pval, BooLean jeff=FALSE);
	float   **GetHbondDistMtrx();
	float   *CalcBuried( );
	Int4	Shuffle();
	Int4	Permute();
	Int4	FindIndex(Int4 s){
		   for(Int4 i=1; i <= num_resC; i++){ if(ResidueID(ResALL[i]) == s) return i; }
		   return 0;
		}
	//========= Methods =============
	double  FixedInterface(char *hits,Int4 *String, Int4 &L, Int4 &bestm, Int4 &D);
	double  SphericalClust(Int4 II,Int4 SR, char *hits,Int4 *Str, Int4 &L, Int4 &bestm, Int4 &D);
	double  CoreClust(Int4 II,Int4 SR, char *hits,Int4 *Str, Int4 &L, Int4 &bestm, Int4 &D);
	double  NetworkClust(Int4 II,Int4 SR, char *hits,Int4 *Str, Int4 &L, Int4 &bestm, Int4 &D);
	double  SurfaceClust(Int4 II,Int4 jj, char *hits,Int4 *Str, Int4 &L, Int4 &bestm, Int4 &D);
	double  OptInterfaceClust(char *hits,Int4 *String, Int4 &L, Int4 &bestm, Int4 &D);

	//=====================================
	Int4	C,resStart,resEnd,nAln,**PttrnRes,num_resC;
	char	chain,*res_class;
	pdb_typ P;
	set_typ resSet,SetX;	// SetX = discriminating residue set.
	set_typ	SetI;		// SetI = intersecting discriminating residue set.
	res_typ	*ResALL;
	//============== adjacent homomeric residues... ===============
	char	adjchn;
	Int4	num_resA;
	res_typ	*ResADJ;	// adjacent residues
	//=============================================================
	atm_typ	KeyAtm;		// Virtual atom from which ordering residues...
	float	*KeyAtmDist,**DistMtrx,*Buried;
	void	Free2(){ 	// free up in calling environment; don't free twice!!!
		   ChainI=0; program=0; infile=dca_file=0; xHG=zHG=xxHG=0; dcaE=0;
		   outfile=0; outfp=0;
		   for(Int4 i=1; i <= num_resC; i++){
			NilRes(ResALL[i]); if(DistMtrx) free(DistMtrx[i]); 
		   } free(ResALL); if(DistMtrx) free(DistMtrx);

		   if(ResADJ){
		     for(Int4 i=1; i <= num_resA; i++){
			NilRes(ResADJ[i]); 
		     } free(ResADJ); 
		   }

		   if(Buried) free(Buried);
		   if(SetX) NilSet(SetX);
		   if(SetI) NilSet(SetI);
		   if(KeyAtm) NilAtom(KeyAtm);
		   if(KeyAtmDist) free(KeyAtmDist);
		   KeyType=0;
		   KeyResX=0; // don't want inherited scl_typ to free this...
		   AB=0;	// not needed since not calling scl_typ::Free()???
		}
};

#endif

