/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#if !defined (_SPC_TYP_USAGE_)

#define _SPC_TYP_USAGE_

#define SPARC_VERSION "\
  ----------------------------------------------------\n\
     SPARC v1.0 (May 4, 2022)\n\
     Created by Andrew F. Neuwald\n\
     www.igs.umaryland.edu/labs/neuwald/sparc/\n\
     Copyright 2020-2021 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_SPARC_MDS_XXX "\
  Usage: sparc mds <infile> <PDBID>_<CHN> <chains> <pdb_list> [options]\n\
	Input: \n\
	   <infile> 	  	Multiple sequence alignment (MSA) in cma format.\n\
	                          MSA must contain the source sequence with PDBID.\n\
	   <PDBID>_<CHN>	Source sequence for simulated structures (e.g., 3GLF_B).\n\
	   <chains>		Chain or homologous protein chains to be scored.\n\
	   <pdb_list>		List of MD simulation coordinate files (in pdb format).\n\
	Output: \n\
	   <infile>_X.aln	PDB source sequence in aln format.\n\
	   <infile>_X.dca	DCA output file in PSICOV format.\n\
	   <infile>.sscr	S-scores output file (may be loaded into MS Excel).\n\
	Temporary output: \n\
	   <infile>.in  	MSA in PSICOV aln format.\n\
	   <infile>_X		DCA output file in EVcouplings format.\n\
        Options:\n\
           -thrds=<int>		Number of threads to be used for CCMpred (default: 1)\n\
           -dev=<int>		GPU device number to be used for CUDA CCMpred (default: -1 = none)\n\
     Notes:\n\
       Once the *_X.aln and *_X.dca files are generated they can be used for additional runs.\n\
       When comparing different sets of simulated structures use the same *_X.* files.\n\
       Molecular dynamics structures with S-scores trending higher or lower over time indicate\n\
        the simulation is converging or diverging, respectively, from biologically relevant\n\
        states. This allows comparison of structural states for biological relevance.\n\
\n"

#define USAGE_SPARC_MDS "\
  Mode: simul -> Compute S-scores for a time series set of MD simulated structures.\n\
  Usage: sparc simul <infile> <pdb_dir> <PDBID>_<CHN> <chains> <pdb_list> [options]\n\
	Input: \n\
	   <infile> 	  	Multiple sequence alignment (MSA) in cma format.\n\
	                          MSA must contain the source sequence with PDBID.\n\
	   <pdb_dir>		Directory containing the source pdb coordinates for <PDBID>\n\
				   named using the syntax <pdbid>_H.pdb; (e.g., '3glf_H.pdb')\n\
	   <PDBID>_<CHN>	Source sequence for simulated structures (e.g., 3GLF_B).\n\
	   <chains>		Chain or homologous protein chains to be scored.\n\
	   <pdb_list>		List of MD simulation coordinate files (in pdb format).\n\
	Output: \n\
	   <infile>_X.aln	PDB source sequence in aln format.\n\
	   <infile>_X.dca	DCA output file in PSICOV format.\n\
	   <infile>.sscr	S-scores output file (may be loaded into MS Excel).\n\
	Temporary output: \n\
	   <infile>.in  	MSA in PSICOV aln format.\n\
	   <infile>_X		DCA output file in EVcouplings format.\n\
        Options:\n\
           -thrds=<int>		Number of threads to be used for CCMpred (default: 1)\n\
           -dev=<int>		GPU device number to be used for CUDA CCMpred (default: -1 = none)\n\
     Notes:\n\
        Once the *_X.aln and *_X.dca files are generated they can be used for additional runs.\n\
       When comparing different sets of simulated structures be sure to use the same *_X.* files.\n\
        Molecular dynamics structures with S-scores trending higher or lower over time indicate\n\
       that the simulation is converging or diverging, respectively, from biologically relevant\n\
       states. This allows comparison of alternative structural states for biological relevance.\n\
   References:\n\
      Neuwald, A.F. & Altschul, S.F. 2018. Statistical investigations of protein\n\
        residue direct couplings. PLoS Comput Biol 14(12):e1006237. PMID: 30596639.\n\
      Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction\n\
        of protein residue-residue contacts from correlated mutations.\n\
        Bioinformatics 30(21):3128-30.\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n"

#define USAGE_SPARC_SC2SB "\
   Mode: sc2sb -> Search MD simulated structures for stable sidechain-to-sidechain\n\
          or sidechain-to-backbone hydrogen bond interactions.\n\
   Usage 1: sparc sc2sb <list> <str> [options]\n\
	  Exhaustive search without labeled constrained residues.\n\
     Input: <list> List of the paths to the coordinate files to be searched\n\
            <str> = adjacently-arranged string of identical chains;\n\
              for example: 'ABCDEF' for a homohexamer (capital letters only)\n\
   Usage 2: sparc sc2sb <list> <str>=<drc>:<pdb_id> [options]\n\
	  Do an exhaustive search for pattern residue interactions using\n\
	   constrained residues where:\n\
     Input: Same as for Usage 1 plus...\n\
            <drc> = DARC input MSA prefix; sparc will look for..\n\
              <drc>_fg = the DARC output MSA for the query's subgroup\n\
	      <drc>.darc = the DARC output file\n\
                 (these are obtained by running darc)\n\
	    <pdb_id> = query's coordinate file (e.g., 5DFF_A)\n\
               pdb sequence needs to be in the MSA file <drc>\n\
               and to correspond to the MD simulated structures.\n\
   Output: (For MD simulated structures)\n\
       <list>.stbl  Stable hydrogen bonds\n\
       <list>.flp   Hydrogen bonds that form and separate\n\
       <list>.xhpi  CH-pi, NH-pi, OH-pi and SH-pi hydrogen bonds\n\
       <list>.arom  Aromatic-aromatic interactions\n\
       <list>.log   Runtime log\n\
       <list>.vsi   File for generating PyMOL scripts for any of the MD structures\n\
       <list>.sis   Networks of stable cis & trans interacting residues\n\
       <list>_aro.pdb Coordinate file for interacting aromatic-aromatic rings\n\
       <list><char>_<int>.pml  Pymol scripts of conformations having the largest\n\
                       network of interacting residue (over all chains)\n\
   Note: Use sc2sb mode to create all of these output files\n\
   Options: \n\
    -heap=<int>  Set heap size to <int> (range: 10-100000; default: 300)\n\
    -pml=<file>  Output PyMOL script into <file>.pml (defunct)\n\
    -graph=<cmafile>  Output subsets of interacting residues where\n\
	           <cmafile> is a cma formatted multiple alignment file\n\
	            that consists of homologous sequencesfrom distinct phyla\n\
	            and which identifies highly conserved residues positions.\n\
    -space=<int> Minimum spacing between residues (default: 2).\n\
    -show        Show interactions for all residues (default: show constrained only).\n\
	   	   Note: this option is only relevant for Usage 2.\n\
    -verbose     Print out additional information.\n\
    -weak        Also consider weak hydrogen bond interactions.\n\
\n"

#define USAGE_SPARC_SIPRIS "\
   Mode:  sipris -> Find statistically signficant 3D clusters of constrained \n\
          residues within MD simulated structures\n\
   Usage: sparc sipris <sipris_in> <mode> <list> <pdbid>_<chns> [options]\n\
     Input: <sipris_in> = a SIPRIS input (DARC *.sprs output) file \n\
	         Must include the pdb_id used to seed the simulation.\n\
	     <mode> = Possible sipris modes: \n\
	         S   spherical clustering (fast)\n\
	         C   core clustering\n\
                 H   hydrogen bond network\n\
		      (sidechain-to-sidechain and sidechain-to-backbone)\n\
                      (slowest, but more discriminating and informative)\n\
	         B   hydrogen bond network \n\
                      (also includes backbone-to-backbone H-bonds)\n\
	     <list> = A list of paths to the simulated structure pdb files\n\
	     <pdbid>_<chns> = Source protein & adjacent homomeric chains\n\
                 used for MD simulations (e.g., '6BBM_ABCDEF').\n\
     Output: <stdout> = SIPRIS S-scores for each structure\n\
	     <sipris_in>.tmp = A temporary file that will be removed\n\
     Options: \n\
         -min_bond=<int> The minimum number of bonds to print out results.\n\
         -verbose     print out additional information.\n\
     Note: Weak hydrogen bonds are not considered currently.\n\
   References:\n\
     Altschul, S.F. & Neuwald, A.F. 2018. Initial Cluster Analysis. Journal of \n\
           Computational Biology 25(2):121-129. doi: 10.1089/cmb.2017.0050.\n\
           PMID: 28771374.\n\
     Neuwald, A.F., L. Aravind & S.F. Altschul. 2018. Inferring Joint\n\
           Sequence-Structural Determinants of Protein Functional Specificity.\n\
           eLife doi: 10.7554/eLife.29880.001. PMID: 29336305.\n\
\n"

#define USAGE_SPARC_HBONDS "\
   Mode:  hbonds -> find hydrogen bond networks among a set of residues\n\
   Usage: sparc hbonds <pdb_list> <str> <res_file> [options]\n\
      where: pdb_list lists the paths to the coordinate files to be searched\n\
        <str> is a string of (adjacently-arranged) identical subunit chains;\n\
          for example: 'ABCDEF' for a homohexamer (capital letters only).\n\
        <res_file> are integers indicating residue positions separated by commas.\n\
	   For example: 232,237,346,348,350,357,360,383,384 \n\
	        all on the first line with no space characters\n\
           The DARC program *.sprs output file (a SIPRIS input file) lists in\n\
		this way subgroup-specific residues for various structures.\n\
   Output: \n\
	<pdb_list>.vsi       vsi input file to create pymol output\n\
	<pdb_list>_<int>.pml PyMOL script for a largest network found.\n\
	<stdout>             List of all networks\n\
   Options: \n\
    -min_bond=<int> The minimum number of bonds to print out results.\n\
    -verbose     print out additional information.\n\
   Note: Weak hydrogen bonds are not considered.\n\
\n"
// ^ this is currently not used.

#define USAGE_SPARC_SC2SC "\
   Mode: sc2sc -> Print residue sidechain to sidechain hydrogen-bond distances\n\
   Usage 1: sparc sc2sc <list> <str> [options]\n\
	     Exhaustive search for all interactions\n\
   Usage 2: sparc sc2sc <list> <str>=<drc>:<pdb_id> [options]\n\
	     Exhaustive search for constrained residue interactions\n\
   Usage 3: sparc sc2sc <list> <str> <int>:<int><char> [options]\n\
	     Return distances for the specified interaction during the simulation\n\
   Usage 4: sparc sc2sc <list> <str> <int>:<int><char>_<int>:<int><char> [options]\n\
	     Correlated interactions involving two residue pairs\n\
    Input:\n\
        <list>  File listing the paths to coordinate files.\n\
        <str>   String of adjacently-arranged, identical chains.\n\
                for example: 'ABCDEF' for a homohexamer (capital letters only).\n\
        <int>   Integer indicating a residue position.\n\
        <char>  Letter 'C' or 'T' indicating a cis or trans contact, respectively.\n\
	<drc>   DARC input MSA file in cma format.\n\
	<drc>.darc   DARC output file with constrained residue information.\n\
	<pdb_id> PDB identifer corresponding to MD simulated structures\n\
                  (e.g., 5DFF_A) the sequence needs to be included in <drc> MSA\n\
    Output: \n\
      Usage 1:\n\
        <list>.stbl  Stable hydrogen bonds\n\
        <list>.flp   Hydrogen bonds that form and separate\n\
        <list>.log   Runtime log\n\
        <list>.vsi   File for generating PyMOL scripts for any of the MD structures\n\
        <list>.sis   Networks of stable cis & trans interacting residues\n\
        <list><char>_<int>.pml  Pymol scripts of conformations having the largest\n\
                       network of interacting residue (over all chains)\n\
     Usage 3:\n\
	<stdout>     Interaction distances for the specified residue pair\n\
     Usage 4:\n\
	<stdout>     Interaction distances for the two specified residue pairs\n\
                       To further investigate correl mode correlated pairs.\n\
   Options: \n\
      -heap=<int>   Heap size for first usage (range: 10-100000; default: 300)\n\
      -space=<int>  Minimum spacing between residues (default: 2).\n\
      -verbose      Print out additional information.\n\
      -show         Show interactions for all residues (default: constrained only).\n\
	   	       Note: this option is relevant only for Usage 2.\n\
      -weak         Also consider weak hydrogen bond interactions.\n\
      For Usage 1 only:\n\
      -pml=<file>   Output PyMOL script into <file>.pml (exhaustive search only)\n\
		      (in PyMOL 'run <file>.pml' after loading coordinates).\n\
      -graph=<file> where <file> Is a cma formatted MSA consisting of \n\
	              homologous sequences from distinct phyla and \n\
	   	      used to identify highly conserved residues positions.\n\
          Output: <list>.grph Interacting residue cliques\n\
		  <file>.pml  Pymol script showing locations of cliques\n\
		      in PyMOL 'run <file>.pml' after loading coordinates.\n\
\n"

// ^ the above strings have been checked over more carefully.

#define USAGE_SPARC_SC2BB "\
   Mode:  sc2bb -> Print residue sidechain to backbone H-bond distances\n\
   Usage: sparc sc2bb <pdb_list> <str> [options]\n\
	  (do exhaustive search for interactions)\n\
   Usage: sparc sc2bb <list> <str>=<drc>:<pdb_id> [options]\n\
	  (do exhaustive search for pattern residue interactions)\n\
	  using pattern positions in the DARC output file <drc>.darc\n\
	  and where <pdb_id> = query's coordinate file\n\
                (e.g., 5DFF_A; with sequence in MSA <drc>)\n\
   Usage: sparc sc2bb <pdb_list> <str> <int>:<int><char> [options]\n\
	  (look for the specified interaction)\n\
   Usage: sparc sc2bb <pdb_list> <str> <int>:<int><char>_<int>:<int><char> [options]\n\
	  (look for correlated interaction formation)\n\
      where: \n\
        <list>  File listing the paths to coordinate files.\n\
        <str>   String of adjacently-arranged, identical chains.\n\
                for example: 'ABCDEF' for a homohexamer (capital letters only).\n\
        <int>   Integer indicating a residue position.\n\
        <char>  Letter 'C' or 'T' indicating a cis or trans contact, respectively;\n\
   Options: \n\
    -heap=<int>  Heap size for first usage (range: 10-100000; default: 300)\n\
    -pml=<file>  Output PyMOL script into <file>.pml (exhaustive search only).\n\
    -verbose     Print out additional information.\n\
    -weak        Also consider weak hydrogen bond interactions.\n\
\n"

#define USAGE_SPARC_BB2BB "\
   Mode:  bb2bb -> Print residue backbone to backbone H-bond distances\n\
   Usage: sparc bb2bb <pdb_list> <str> [options]\n\
	  (do exhaustive search for interactions)\n\
   Usage: sparc bb2bb <list> <str>=<drc>:<pdb_id> [options]\n\
	  (do exhaustive search for pattern residue interactions)\n\
	  using pattern positions in the DARC output file <drc>.darc\n\
	  and where <pdb_id> = query's coordinate file\n\
                (e.g., 5DFF_A; with sequence in MSA <drc>)\n\
   Usage: sparc bb2bb <pdb_list> <str> <int>:<int><char> [options]\n\
	  (look for the specified interaction)\n\
   Usage: sparc bb2bb <pdb_list> <str> <int>:<int><char>_<int>:<int><char> [options]\n\
	  (look for correlated interaction formation)\n\
      where: \n\
        <list>  File listing the paths to coordinate files.\n\
        <str> is a string of (adjacently-arranged) identical subunit chains;\n\
          for example: 'ABCDEF' for a homohexamer (capital letters only).\n\
        <res1> and <res2> are integers indicating the residue positions\n\
        <char> == 'C' reports cis and 'T' trans distances;\n\
   Options: \n\
    -heap=<int>  Heap size for first usage (range: 10-100000; default: 300)\n\
    -verbose  print out additional information.\n\
   Note: Weak hydrogen bonds are not considered; polar sidechains required.\n\
\n"

#define USAGE_SPARC_H_BOND "\
   Usage: sparc <mode> <pdb_list> <str> [options]\n\
	  (do exhaustive search for interactions)\n\
   Usage: sparc <mode> <pdb_list> <str> <res1>:<res2><char> [options]\n\
	  (look for the specified interaction)\n\
   Usage: sparc <mode> <pdb_list> <str> <res1>:<res2><char>_<res3>:<res4><char> [options]\n\
	  (look for correlated interaction formation)\n\
      where: pdb_list lists the paths to the coordinate files to be searched\n\
        <str> is a string of (adjacently-arranged) identical subunit chains;\n\
          for example: 'ABCDEF' for a homohexamer (capital letters only).\n\
        <res1> and <res2> are integers indicating the residue positions\n\
        <char> == 'C' reports cis and 'T' trans distances;\n\
   Options: \n\
    -verbose     print out additional information.\n\
   Modes: \n\
    sc2sc: Print residue sidechain to sidechain H-bond distances\n\
    sc2bb: Print residue sidechain to backbone H-bond distances\n\
    bb2bb: Print residue backbone to backbone H-bond distances\n\
   Note: Weak hydrogen bonds are not considered; polar sidechains required.\n\
\n"

#define USAGE_SPARC_DIST "\
   Mode:  dist -> Find residue-to-residue or residue-to-ligand heavy atom distances\n\
   Usage 1: sparc dist <list> <str> <res>:<res2><char> [options]\n\
   Usage 2: sparc dist <list> <str> <res>@<lig> [options]\n\
   Usage 3: sparc dist <list> <str> <res>@<lig>_<atm> [options]\n\
   Usage 4: sparc dist <list> <str> <chn>@<lig> [options]\n\
	     Find all contacts to ligand. \n\
   Usage 5: sparc dist <list> <str>=<drc>:<pdb_id> <chn>@<lig> [options]\n\
	     Find all contacts to ligand. \n\
	      where <drc> is the input MSA for DARC\n\
	      using pattern positions in the DARC output file <drc>.darc\n\
	      and where <pdb_id> = query's coordinate file\n\
                (e.g., 5DFF_A; with sequence in MSA <drc>)\n\
   Input: \n\
	<list>  Lists the paths to the coordinate files to be searched\n\
        <str>   String of (adjacently-arranged) identical subunit chains;\n\
                    for example: 'ABCDEF' for a homohexamer\n\
        <res>   Integer indicating a residue position\n\
        <res2>  Integer indicating a 2nd residue position\n\
        <char>  Set to 'C' or 'T' reports cis or trans interactions, respectively\n\
        <chn>   Chain corresponding to the ligand\n\
        <lig>   Ligand molecule name (e.g, 'atp').\n\
        <atm>   Ligand atom (e.g, 'pg' = gamma phosphate).\n\
   Output: \n\
	<list>.het Search results (created only if significant hits are found)\n\
		this applies only to the fourth usage command above\n\
   Options: \n\
      -show     Show interactions for all residues (default: show constrained only).\n\
	   	   Note: this option is only relevant for Usage 5.\n\
      -verbose  print out additional information.\n\
\n"

#define USAGE_SPARC_HETMER "\
   Usage: sparc hetmer <msa1> <msa2> <pdb_file> <chns> [options]\n\
	  Exhaustive search for correlated and flipped interaction pairs.\n\
    Input:\n\
       <msa1>   Multiple alignment for first chain\n\
       <msa2>   Multiple alignment for second chain\n\
       <pdb_file>  3D coordinates for the heteromeric complex\n\
       <chns>   Capital letter designation for the two chains (e.g. 'AB').\n\
    Note:\n\
       The MSA files should be in cma format with NCBI taxids added, which \n\
       can be done using the addphylum program.  The two MSAs need to correspond \n\
       to the two interacting chains in the pdb structure, the sequences of which\n\
       need to be included in their corresponding MSAs and need to be labeled\n\
       with their NCBI pdb_identifiers (e.g., 5M4O_C and 5M4O_D for pdb file 5m4o).\n\
       Do not purge the MSAs, as this may remove corresponding chains for\n\
       some species.  SPARC reduces sequence redundancy by selecting pairs\n\
       of chains from the same species.\n\
    Output:\n\
       <msa1>_<msa2>_<chns>.het  File of S-scores for the two chains and other output.\n\
       <msa1>_<msa2>.pdb         File of coordinates for merged domains (for PyMol).\n\
       <msa1>_<msa2>_<chns>.pml  PyMOL script showing direct couplings.\n\
    Options: \n\
      -D=<real>     Maximum 3D contact distance (in Angstroms)(default: 5.0).\n\
      -thrds=<int>  Number of threads to be used for CCMpred (default: 1)\n\
      -dev=<int>    GPU device number to be used for CUDA CCMpred (default: -1 = none)\n\
      -verbose      print out additional information.\n\
    Note: Adding hydrogens is recommended.\n\
   References:\n\
      Neuwald, A.F. & Altschul, S.F. 2018. Statistical investigations of protein\n\
        residue direct couplings. PLoS Comput Biol 14(12):e1006237. PMID: 30596639.\n\
      Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction\n\
        of protein residue-residue contacts from correlated mutations.\n\
        Bioinformatics 30(21):3128-30.\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n"

#define USAGE_SPARC_VSI2PML "\
   Mode:  vsi2pml -> create a PyMOL script from a *.vsi file.\n\
   Usage: sparc vsi2pml <list> <id> [options]\n\
    Input:\n\
       <list>     List of the paths to the pdb coordinate files to be searched\n\
       <list>.vsi The vsi file to be used\n\
       <id>       Identifier corrseponding to the structure and chain \n\
                    to be visualized using PyMOL.\n\
    Output:\n\
       <list><chn>_<id>.pml PyMOL script\n\
    Options: \n\
      -verbose  print out additional information.\n\
\n"

#define USAGE_SPARC_CORREL "\
   Mode:  correl -> find correlated interaction pairs and 'flipped' interactions.\n\
   Usage 1: sparc correl <list> <str> [options]\n\
   Usage 2: sparc correl <list> <str>=<drc>:<pdb_id> [options]\n\
	      obtain pattern residue positions from DARC output <drc>.darc\n\
	      and where <pdb_id> = query's coordinate file\n\
                (e.g., 5DFF_A; with sequence in MSA <drc>)\n\
    Input:\n\
       <list>   List of the paths to the pdb coordinate files to be searched\n\
       <str>    A string of (adjacently-arranged) identical subunit chains;\n\
                    e.g. 'ABCDEF' for a homohexamer (capital letters only).\n\
    Output:\n\
       <list>.tab File of the most significant correlated residue interactions\n\
                shown as contingency tables with Fisher's exact test.\n\
       <list>.flp File of pairs likely to exhibit correlated interactions\n\
    Options: \n\
      -heap=<int>  Set heap size to <int> (range: 10-100000; default: 300)\n\
      -show     Show interactions for all residues (default: show constrained only).\n\
	   	   Note: this option is only relevant for Usage 2.\n\
      -verbose  print out additional information.\n\
    Note: Weak hydrogen bonds are not considered; polar sidechains required.\n\
      Exact test p-values are used for ordering only, as we cannot assume that\n\
        the time series of MD simulation data points are sampled independently\n\
\n"

#define USAGE_SPARC_RANK "\
   Search Procedures for Analysis of Residue Constraints (SPARC)\n\
   Usage: sparc rank <infile> <pdb_dir> [options]\n\
   Input:\n\
       <infile>  Multiple sequence alignment (MSA) in cma format with NCBI pdbaa\n\
                  identifiers for sequences corresponding to structures in <pdb_dir>.\n\
       <pdb_dir> Path to directory containing the pdb structural coordinate files.\n\
                  To be recognized file names must use the syntax <pdbid>_H.pdb\n\
                  where <pdbid> is the lowercase version of the pdb identifier\n\
                  (e.g., '1abc' for pdb identifier 1ABC_A).\n\
   Output: \n\
           <infile>.sprc  SPARC output file showing STARC S-scores.\n\
	   <infile>.paths Preferred paths to pdb files. (Use with other commands.)\n\
           <infile>.absent Aligned proteins absent from the pdb_dir.\n\
   Temporary output: \n\
           <infile>_sprc_X.in  Input alignment file for CCMpred\n\
           <infile>_sprc_X.mst Input file for STARC algorithm\n\
           <infile>_sprc_X.dca CCMpred output DCA file (input for STARC algorithm)\n\
           <infile>_sprc_X     DCA scores in EVC format\n\
      Note: Users may provide their own '<infile>_sprc_X.dca' file, which needs to be\n\
	    consistent with the MSA file: '<infile>'.  It must have a line for every\n\
            pair of columns with each line containing two integers corresponding\n\
            to columns i and j with i < j, followed by a real number 'score' where \n\
            higher scores corresponding to a stronger direct coupling or to a higher \n\
            probability of that column pair corresponding to a contact. \n\
            The following example conforms to this format: \"13 18 0.5234\".\n\
   Options: \n\
      -D=<real>       Maximum 3D contact distance (in Angstroms)(default: 4.0).\n\
      -I              Optimize over ICA P-values instead of unified P-values\n\
      -inCCM=<int>    Run using <int> (>= 250) randomly chosen aligned sequences\n\
      -m=<int>        Minimum sequence separation between paired residues (default: 5)\n\
      -pdbaa=<path>   Path to the NCBI pdbaa fasta file. Used to identify additional\n\
                        sequences of known structure in the MSA.\n\
      -sbsmpl=<x>:<y> Run <x> CCM subsamples of size <y> (default: x=5,y=1000).\n\
                        Range: <x> = 5-1000; <y> = 50-10000. \n\
                        Size needs to be less than 1/3rd of foregroud set.\n\
      -save           Save the temporary files (default: temp files are deleted).\n\
      -seed=<int>     Seed for random number generator\n\
      -thrds=<int>    Number of threads to use for CCMpred step (default: 1).\n\
      -dev=<int>      GPU device number to be used for CCMpred (default: -1 = none)\n\
   References:\n\
      Neuwald, A.F. & Altschul, S.F. 2018. Statistical investigations of protein\n\
        residue direct couplings. PLoS Comput Biol 14(12):e1006237. PMID: 30596639.\n\
      Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction\n\
        of protein residue-residue contacts from correlated mutations.\n\
        Bioinformatics 30(21):3128-30.\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n"

#if 0
      -ptrn=<path>    Path to BPPS pattern file. The file syntax is illustrated by:\n\
		   R: GAS108,ASP133,VIM103,WYF33,KR127,R173,ILM80,DE155,NQ139 \n\
		   Y: D105,G49,K50,G47,G44,ST51,DE106,AST137,R156,VIL102,IL53 \n\
		        where R=family,Y=superfamily patterns\n\

#endif

#define USAGE_SPARC_MAIN "\
   Search Procedures for Analysis of Residue Constraints (SPARC)\n\
   Usage: sparc <command> <inputs> [options]\n\
   Command modes: \n\
    Computing S-scores:\n\
      rank:   Rank various protein structures based on STARC S-scores.\n\
      hetmer: Compute STARC S-scores for interacting heteromeric subunits.\n\
      simul:  Compute S-scores for a time series set of MD simulated structures.\n\
    Finding interactions within a time series set of MD simulated structures\n\
              of a specific protein or protein complex:\n\
      dist:   Residue to residue or ligand heavy atom contact distances\n\
      correl: Show contingency tables for correlated residue interactions \n\
               and report interactions that form and dissociate\n\
      sc2sc:  Residue sidechain hydrogen bond interactions\n\
      sc2bb:  Residue sidechain to backbone hydrogen bond interactions\n\
      sc2sb:  Run both sc2sc and sc2bb modes\n\
		also reports CH-pi and aromatic-aromatic interactions\n\
      sipris: Run SIPRIS on MD simulated structures\n\
      bb2bb:  Find changes in backbone c=o to backbone n-h distances\n\
      vsi2pml:Create a PyMOL script from a *.vsi file (see sc2sb mode)\n\
   Notes:\n\
      For command usage and options type sparc <command>.\n\
      In sc2xx modes, hydrogen bond networks are also identified\n\
   Reference: \n\
      Neuwald, A.F., Yang, H. and B.T. Nixon. 2022. SPARC: Search Procedures\n\
        for Analysis of Residue Constraints. Computational and Structural \n\
           Biotechnology Journal. Revision under review.\n\
   Funding: The National Institutes of Health, National Institute of\n\
        General Medical Sciences grant R01GM125878.\n\
\n"

#define USAGE_SPARC_MAIN_OLD "\
   Structural Properties Associated with Residue Constraints (SPARC)\n\
   Usage: sparc <command> <inputs> [options]\n\
   Commands: \n\
    Computing S-scores:\n\
      rank:   Rank various protein structures based on STARC S-scores.\n\
      hetmer: Compute STARC S-scores for interacting heteromeric subunits.\n\
      simul:  Compute S-scores for a time series set of MD simulated structures.\n\
    Finding interactions within a time series set of MD simulated structures\n\
              of a specific protein or protein complex:\n\
      hbonds: Find hydrogen bond networks among pattern residues.\n\
      dist:   Residue to residue or ligand heavy atom contact distances\n\
      correl: Correlated and flipped residue pair interactions\n\
      sc2sc:  Residue sidechain hydrogen bond interactions\n\
      sc2bb:  Residue sidechain to backbone hydrogen bond interactions\n\
      sc2sb:  Run both sc2sc and sc2bb modes\n\
      sipris: Run SIPRIS on MD simulated structures.\n\
      bb2bb:  Find changes in backbone c=o to backbone n-h distances\n\
   Notes:\n\
      For command usage and options type sparc <command>.\n\
      In sc2xx modes, hydrogen bond networks are also identified\n\
   Reference: \n\
      Neuwald, A.F., Yang, H. and B.T. Nixon. 2022. SPARC: Search Procedures\n\
        for Analysis of Residue Constraints. Computational and Structural \n\
           Biotechnology Journal. Revision under review.\n\
   Funding: The National Institutes of Health, National Institute of\n\
        General Medical Sciences grant R01GM125878.\n\
\n"

#endif

