/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_SPC_TYP_)
#define _SPC_TYP_

#include <cstdlib>
# include <iostream>
# include <iomanip>
# include <omp.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "ccmpred.h"
#include "evaluate_cpu.h"
#include "evaluate_cpu_omp.h"
#include "evaluate_cuda.h"
#include "evaluate_cuda_kernels.h"
#include "io.h"
// #include "meta.h"
#include "numdif.h"
#include "parseopt.h"
// #include "reweighting.h"
#include "sequence.h"
#include "swaln.h"
#include "util.h"
#include <stdbool.h>
#include "conjugrad.h"

#include "c2a_typ.h"

#include "omc_typ.h"
#include "lha_typ.h"
#include "hierview.h"
#include "c2h_typ.h"
#include "hsc_typ.h"
#include "edc_typ.h"
#include "sprc_typ.h"
#include "scl_typ.h"
// #include "dds_typ.h"
#include "drc_typ.h"

#include "stdinc.h"
#include "histogram.h"
#include "alphabet.h"
#include "residues.h"
#include "cmsa.h"
#include "dheap.h"
#include "afnio.h"
#include "random.h"
#include "pdb.h"
#include "wdigraph.h"

// # using namespace std;

extern "C" int run_ccmpred(int argc, char **argv);

class spc_typ { // Distance Difference Score type.
public:
        spc_typ( ) { assert(!"Illegal constructor"); }
        spc_typ(int ac, char *av[]){
		sprintf(SbGrpCode," YROGMX    ");
		for(Int4 i=0; i < 4; i++) IsPutRes[i]=0;
		argc=ac; argv=av; Init( ); 
	}
        ~spc_typ( ) { Free(); }
	//============== spc_run.cc ======================
        int	Run( );
	//============== spc_sprs.cc ======================
#if 1	// SIPRIS: input to see stable H-bonds...
	Int4    PutSIPRIS(char *name);
#endif
private:
	BooLean	InputDCA;
	Int4    MkSubSIPRIS(char *sprs_file,char *PDBID);
	BooLean InvalidHbondPair(char rI, char rJ, char mode);
	//================= spc_vsi.cc ===================
	Int4	RunVSI2PyMOL(char *pdblist, Int4 vsi_id);
	//================= spc_init.cc ===================
	void	Init();
	void	Free();
	char	**argv;
	int	argc;
	char	mode;
	BooLean	verbose,SrchAll,rm_tmp_files,SkipWeakHBonds;
	Int4	MinSpacing,MaxSpacing;
	const	double UnDefHBond=500.0;
	//==== sc2sc,etc: look only for pattern residues ====
	set_typ	*QueryResiduesBPPS(char *darc_file,char *cma_file,
			char *pdb_id, a_type AB);
	void    PutSeqID_CMA(FILE *ofp,cma_typ cma, char *seq_id);
	BooLean	show_all;
	e_type	PtrnSeq;
	set_typ	*PtrnSet;
	set_typ TopDC_Set;  
	wdg_typ	TopDC_Grph;
	char	SbGrpCode[26];
	Int4	NumPtrn;
	char	RtnColorCode(Int4 n){
		   char rtn='W';
		   if(TopDC_Set){ if(MemberSet(n,TopDC_Set)) rtn='G'; }
                   if(PtrnSet){
                      for(Int4 ii=1; PtrnSet[ii]; ii++){
                        if(MemberSet(n,PtrnSet[ii])) rtn=SbGrpCode[ii];
		      }
                   }return rtn;
                }
	char	*PDB_ID;
	//================== spc_aro.cc (aai_typ) ==================
	//================ aromatic-aromatic interaction type. =====
	typedef struct aro_aro_i_struct_type {
	   res_typ ResA,ResB;
	   atm_typ RngA[10],hydA[10],cenA[4],RngAW[10],hydAW[10];
	   atm_typ RngB[10],hydB[10],cenB[4],RngBW[10],hydBW[10];
	   // atm_typ *atmNA,*atmNB,NA,NB;
	   a_type  AB,nAB;
	   Int4    CA,CB;
	   char	   *pdb_id;
	   Int4	   pdbX;	// current pdb file.
	   char	   aaA,aaB;
	   double  Rclo,Rcen,gamma,theta,delta;
	   char    ca,cb,Type;
	} aro_aro_i_type;
	typedef aro_aro_i_type   *aai_typ;
	aai_typ MakeAAI(res_typ ResA,res_typ ResB,a_type AB,a_type nAB){
		  BooLean na;
		  if(ResB == ResA) return 0;
		  if(ResB==0 || ResA==0) return 0;
		  //========== Make sure both residues are aromatic ==========
		  char aaA=GetResidueAtom(AtomResidue(1,ResA),AB,nAB,&na);
        	  aaA=AlphaChar(aaA,AB);
        	  if(na || strchr("FYHW",aaA)==NULL) return 0;
        	  char aaB=GetResidueAtom(AtomResidue(1,ResB),AB,nAB,&na);
        	  aaB=AlphaChar(aaB,AB);
        	  if(na || strchr("FYHW",aaB)==NULL) return 0;

		  aai_typ aai; NEW(aai,1,aro_aro_i_type);
		  for(Int4 i=0; i <4; i++) aai->cenA[i]=aai->cenB[i]=0;
		  aai->ResA=ResA; aai->ResB=ResB;
		  aai->aaA=aaA; aai->aaB=aaB;
		  aai->AB=AB; aai->nAB=nAB;
	   	  aai->Rclo=aai->Rcen=aai->gamma=aai->theta=aai->delta=this->BigDist;
		  return aai;
		}
	Int4	AromaticRingAtoms(aai_typ X,char c);
	void	NilAAI(aai_typ aai){
		    for(Int4 i=0; i <4; i++){
			 if(aai->cenA[i]) NilAtom(aai->cenA[i]);
			 if(aai->cenB[i]) NilAtom(aai->cenB[i]);
		    } free(aai);
		}
	double	FindAroAro(aai_typ X,BooLean UseAW5=FALSE, BooLean UseBW5=FALSE);
	BooLean	PrintAromaticRing(FILE *fp,aai_typ X,atm_typ Nrm,char c,set_typ WasPrint);

	//================== spc_aro.cc ==================
	const char *RingW5[6]={" CG "," CD1"," NE1"," CD2"," CE2"};
        const char *RingW6[7]={" CD2"," CE2"," CE3"," CZ2"," CZ3"," CH2"};
	const char *RingFY6[7]={" CG "," CD1"," CD2"," CE1"," CE2"," CZ "};
	const char *RingH5[6]={" CG "," ND1"," CD2"," CE1"," NE2"};
	double   ProjectOnPlane(atm_typ H, atm_typ X, atm_typ C0, atm_typ C1);
	atm_typ *PerpendicularAtom(atm_typ P, atm_typ Q,atm_typ R);
	set_typ	*IsPutRes[4];
	Int4	NumAroAro,NumAroAroPi;
	Int4	VirtualAromatic(res_typ ResA,atm_typ vtl[4],a_type AB,a_type nAB);
	double  Normal2NormalAngle(atm_typ P, atm_typ Q, atm_typ R, atm_typ S);
	Int4    AromaticRingAtoms(res_typ ResA,atm_typ rtn[10],atm_typ hyd[10],
			atm_typ vtl[4],a_type AB,a_type nAB,
			atm_typ Rtn[10],atm_typ Hyd[10]);
	double  GetAro_PiFast(FILE *fptr, Int4 resI,Int4 resJ, float dmax,
                Int4 cI, Int4 cJ, Int4 X, char &Typ);
	Int4    RunAllAroAroPi(FILE *ofp);
	double	RunOneAroAroFast(Int4 nI,Int4 nJ, BooLean trans,double cut,
                	FILE *outfp,char *Msg,char *StrI, char *StrJ);
	Int4	nChain;

	//================== spc_pi.cc ==================
	Int4    FindAromaticHbonds(FILE *fp, res_typ ResD, res_typ ResA,Int4 C, Int4 C2,
        		float dmax, char color, pdb_typ P, double &bst_HpX,
			double &bst_DV, double &bst_DHV,char &Typ,char Mode='X');
	Int4    FindOtherPiHbonds(FILE *fp,res_typ ResD,res_typ ResA,Int4 C,Int4 C2,
        		float dmax, char color, pdb_typ P, double &D_HpX, double &D_DV,
          		double &Angle_DHV, char &Typ, char Mode);
	BooLean OkayPiParameters(double  d_HpX,double d_DV,double angle_DHV);
	Int4    RunAllCH_Pi(FILE *ofp=stdout);
	double  GetCH_PiFast(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
                	Int4 cI, Int4 cJ, Int4 X, char &Typ);
	double  RunOneCH_PiFast(Int4 nI,Int4 nJ, BooLean trans,double cut,
                	FILE *outfp,char *Msg,char *StrI, char *StrJ);
	void    DebugCH_Pi(atm_typ Donor,atm_typ Accept,double d_HA,double d_DA,
                	double angle_DHA, Int4 num, a_type AB);
	//================== spc_typ.cc ==================
	double	GetHBonds(FILE *fp,res_typ ResI,res_typ ResJ, Int4 cI,
                        Int4 cJ,float dmax,pdb_typ P);
	double  GetContactsPDB(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
                Int4 cI, Int4 cJ, pdb_typ P);
	double  GetContactsPDB(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
                Int4 cI, Int4 cJ, pdb_typ P,char &rI,char &rJ);
	double  Res2HeteroDist(FILE *fptr, Int4 resI,Int4 C, pdb_typ P,
                const char *HeteroMol,const char *HetAtm=0);
	double  Res2ResDistance(FILE *fptr, Int4 resC,Int4 resD, Int4 C, Int4 D,
                                pdb_typ P, BooLean noMainChn=TRUE);
	void    PutContacts(FILE *fptr, Int4 file_id, set_typ SetB, float HA_dmax,
            	  float dmax,Int4 C, Int4 C2, char chain, BooLean *skip, char color,
                  pdb_typ pdb, char Mode);
	Int4	GetContacts(FILE *fptr, set_typ SetB, float HA_dmax, Int4 cI,
                        Int4 cJ, pdb_typ pdb, double Cutoff=2.5);

	//============== spc_het.cc ======================
	Int4    CompareAltStruct(char HetMol[],char HetAtm[],BooLean trans);
	Int4    RunAllHetMol(char HetChn, char HetMol[],char HetAtm[],BooLean trans);
	double  Res2HetDistance(res_typ ResI, char HetMol[], Int4 HetChn, 
			Int4 &R, BooLean noMainChn, pdb_typ P);
	double  Res2HetDriver(Int4 nII,char HetMol[], Int4 HetChn,
			BooLean noMainChn,Int4 setI=0);
	//============== spc_prep.cc ======================
	set_typ	*RunAllPairsPrep();
	double  RunOnePairPrep(Int4 nI,Int4 nJ, BooLean trans,double cut,
                char *Msg,char *StrI, char *StrJ, BooLean &Okay);
	double  GetContactsPrep(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
                Int4 cI, Int4 cJ, Int4 X);
	//============== spc_p2p.cc ======================
	Int4    RunAllTwoPairsFast(FILE *ofp=0);
	double  RunTwoPairs(Int4 nI,Int4 nJ,Int4 nK,Int4 nL, BooLean trans,
			BooLean trans2, double cut=0,FILE *ofp=stdout);
	double  RunTwoPairsFAST(Int4 nI,Int4 nJ,Int4 nK,Int4 nL, BooLean trans,
			BooLean trans2, double cut=0,FILE *ofp=stdout,char *Msg=0);
	char    **ExactTest(Int4 XY,Int4 xY,Int4 Xy,Int4 xy, char *Msg,char chn,
			a_type AB,double &tt);
	//============== spc_slow.cc ======================
	double	RunOnePair(Int4 nI,Int4 nJ,char HetMol[], char HetAtm[],
			BooLean trans,double cut=0,FILE *ofp=stdout,char *Msg=0);
	//============== spc_fast.cc ======================
	void    GetSeqContext(char *Str,Int4 start, Int4 length, e_type E, a_type A);
	Int4    RunAllPairsFast(FILE *ofp=stdout);
	double	RunOnePairFast(Int4 nI,Int4 nJ,BooLean trans,double cut=0,
			FILE *ofp=stdout,char *Msg=0,char *StrI=0, char *StrJ=0);
	double  GetContactsFast(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
                Int4 cI, Int4 cJ, Int4 X);
	//============== data structures ======================
	const double	BigDist=9999999.0;
	const char	Angstroms=197;
	char	*Chain;
	//============== spc_mds.cc ======================
	long double RunLoneSTARC(int argc, char *argv[],Int4 &hits);
	int     SetUpStarcMDS(Int4 argc,char *argv[]);
	char    *BaseName(char *path);
	char    *BaseName2(char *path);
	int     RunModeMDS();
	//============== spc_pml.cc ======================
	void	PutHeaderPyMOL(FILE *fp=0);
	void    PutResiduePyMOL(Int4 ri,char rI,Int4 nI,char HetMol[]);
	void    PutResPairPyMOL(Int4 ri,char rI,Int4 nI,Int4 rj,char rJ,Int4 nJ);
	void    PutTailPyMOL();

	const char AARes[22][4]= {"unk","cys","gly","ala","ser","thr",
		"asn","asp","glu","gln","lys","arg","his","trp","tyr",
		"phe","val","ile","leu","met","pro"};
	FILE	*pmlfp,*vsifp,*flpfp,*stblfp,*arofp[4],*logfp;
	//============== spc_net.cc ======================
	// Find mds structures with the most H-bonds...
	Int4    CountHbonds( );
	Int4	MinNumBonds;
	//============== spc_wdg.cc ======================
	// Contact matrix and graph routines and data structures.
	void    CreateMtrx(pdb_typ pdb);
	void    PutSubGraphs(FILE *gfp=stdout);
	BooLean	PlotGrph;
	char	**Mtrx,*ResMtrx,*wdgfile;
	Int4	StrtMtrx,EndMtrx;
	set_typ	*IsBB,*IsSC,UseSB;
	wdg_typ	wdg;
	enum	subunit: int { Lt, Ct, Rt };
	//============== sis_typ.cc ======================
	class sis_typ {		// stable interaction sites
public:
           sis_typ( ) { assert(!"Illegal constructor"); }
	   sis_typ(char *chn,Int4 Len){ Init(chn,Len); }
           ~sis_typ( ) { Free(); }
	  void	AddSite(subunit Su, Int4 chn, Int4 site);
	  Int4	Put(FILE *fp,Int4 chn);
	  Int4	PutAll(FILE *fp);
	  set_typ RtnSet(subunit Su, Int4 chn){ return StableSet[Su][chn]; }
private:
	  Int4	nChn;
	  char  *Chn;
	  void	Init(char *chn, Int4 Len);
	  void	InitOneChn(Int4 chn, Int4 Len);
	  void	Free();
	  set_typ *StableSet[5];
	  char	*StblChn[5];
	  Int4	*ListSet(subunit Su, Int4 chn){
		  Int4 *L,i,j=0,C,N;
		  N=SetN(StableSet[Su][chn]);
		  C=CardSet(StableSet[Su][chn]);
        	  NEW(L,C+3,Int4); L[0]=C;
        	  for(j=0,i=1;i < N; i++){
		     if(MemberSet(i,StableSet[Su][chn])){ L[j]=i; j++; }
		  } L[j]=0;
        	 return L;
	  }
	};
	//============== spc_sis.cc ======================
	Int4    PutHeaderHbondNet(FILE *ofp,Int4 Cut);
	Int4    FindHbondNetwork(FILE *ofp=stdout);
	Int4    CisHbonds(set_typ Set,char **buffer,char ChnC,Int4 &Hits,
                res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp,FILE *sfp=0);
	Int4    TransLeftHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
                res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp);
	Int4    TransRightHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
                res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp);
#if 0
	BooLean trans=FALSE;
        Int4    nI,nJ;
        char    chn[100],HetMol[200],HetAtm[100]; HetAtm[0]=0;
        Int4    nchn=0;
#endif
	sis_typ	*sis;
	//============== psd_typ.cc ======================
	class psd_typ {	// pdb structural data type.
public:
	   psd_typ( ) { assert(!"Illegal constructor"); }
	   psd_typ(char *name,char *chn,e_type PSq=0){ PtrnSq=PSq; Init(name,chn); }
           ~psd_typ( ) { Free(); }
	  pdb_typ RtnPDB(Int4 i){ assert(i > 0 && i <= nPDB); return PDB[i]; }
	  Int4	NumPDB(){ return nPDB; }
	  res_typ RtnResI(Int4 p,Int4 c,Int4 r);
	  char	GetResChar(Int4 p,Int4 c, Int4 r);
	  res_typ *RtnResAll(Int4 i,Int4 j,Int4 &n);
	  char	*RtnPath(Int4 i){ assert(i > 0 && i <= nPDB); return path[i]; }
private:
	  e_type PtrnSq;
	   int	IsSameSeq(e_type E1, e_type E2,Int4 &Start,Int4 MinOverlap,
                Int4 &NumX,Int4 &NumM,BooLean IgnoreX);
	   void Init(char *name,char *chain);
	   void Free();
	   pdb_typ *PDB;
	   char	   **path;
	   res_typ ***res_all;
	   Int4	   **nres_all,nChn,nPDB;
	   char	   *Chn;
	};
	psd_typ	*psd;
	//============== rph_typ.cc ======================
	class rph_typ {	// residue pair heap type 
public:
           rph_typ( ) { assert(!"Illegal constructor"); }
	   rph_typ(Int4 n,Int4 nc){ Init(n,nc); }
           ~rph_typ( ) { Free(); }
	   Int4 Put(FILE *fp);
	   Int4 PutHeader(FILE *fp,char mode,char *pdb_id);
	   Int4 Insert(keytyp key,char **str);
private:
	   mh_type mH;
	   Int4    N;
	   char    ***MSG;
	   void Init(Int4 n,Int4 nchn);
	   void Free( );
	};
	Int4	rpheap_size;
	rph_typ	*rphF,*rphS,*rphC,*rphH; // Flipped, Stable, Correlated, Hetero
	rph_typ	*rphWF,*rphWS;	// Weak
	rph_typ	*rphAF,*rphAS;	// flipped & stable Aromatic-Aromatic-Pi-Pi interactions
	//============== tri_typ.cc ======================
	class tri_typ {	// transient & stable residue interaction type
public:
           tri_typ( ) { assert(!"Illegal constructor"); }
	   tri_typ(char *chn, Int4 n_pdb, Int4 win=5){ nPDB=n_pdb; Init(chn,win); }
           ~tri_typ( ) { Free(); }
	   double AddValue(Int4 n, double dd, Int4 i,char typ=0);
	   void	  PutFlipped(FILE *fp,char *Msg,BooLean trans,double *value);
	   char   **RtnResults(keytyp &key,char *Msg,char *cmd, BooLean trans,
			double **value,char mode, char **typ=0);
	   void	  Reset();
	   void	  SetCut(Int4 cH, Int4 cD){ cutH=cH; cutD=cD; }
	   void	  Put(FILE *fp,Int4 n);
private:
	   const double	big_dist=9999999.0;
	   void	  PutMaxRuns(FILE *fp,Int4 i);
	   char   *StrMaxRuns(Int4 i,BooLean trans);
	   Int4   window,nChn;
	   Int4   **run,**max,**tot;
	   char   *State,*chain;
	   Int4	  *nType[251],nPDB;
	   double **array,*Sum;
	   void   Init(char *chn, Int4 w);
	   void   Free();
	   Int4	  cutH,cutD;
	};
	Int4	time1;
#if 0
	//============== spc_junk.cc ======================
	Int4    RunAllPairs(char HetMol[],char HetAtm[],FILE *ofp=stdout);
#endif
};


#endif

