/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"

Int4	spc_typ::PutSIPRIS(char *name)
{
	Int4	i,j,n,N=0,MinRes=0,MaxRes=0,nchn=0,ri,rj;
	FILE	*tfp=0,*sfp=0,*ofp=stdout,*vfp=0;
	char	str[305],c,C,a,b,*Seq;
	double	dd;

	pdb_typ pdb = psd->RtnPDB(1);
	for(nchn=i=0 ; Chain[i]; i++){
		nchn++; j=GetChainNumberPDB(pdb,Chain[i]);
		MinRes=MAXIMUM(Int4,MinRes,MinResPDB(j,pdb));
		MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));;
	}
	set_typ *SetStbl; NEW(SetStbl,nchn+3,set_typ);
	NEW(Seq,MaxRes+5,char);
	for(i=0 ; Chain[i]; i++){
		j=GetChainNumberPDB(pdb,Chain[i]);
		SetStbl[j]=MakeSet(MaxRes+3);
	}
	tfp=open_file(argv[2],".stbl","r");
	ri=rj=0;
	while(fgets(str,300,tfp) != NULL){
	   if(sscanf(str,"%d(%c): %c%d vs %c%d: %lf (sc2",
			&n,&c,&a,&i,&b,&j,&dd) == 7){
		ri=i; rj=j; Seq[i]=a; Seq[j]=b;
	   } else if(sscanf(str,"Chn:    %c\n",&c) ==1){
		if(ri && rj){
		   j=GetChainNumberPDB(pdb,c);
		   AddSet(ri,SetStbl[j]);
		   AddSet(rj,SetStbl[j]);
		} ri=rj=0;
	
	   }
	} fclose(tfp);
	sfp=open_file(argv[2],"_stbl.sprs","w");
	vfp=open_file(argv[2],"_stbl.vsi","w");
	for(N=0,nchn=i=0 ; Chain[i]; i++){
	   j=GetChainNumberPDB(pdb,Chain[i]);
	   // fprintf(ofp,"%d: ");
	   // PutSet(ofp,SetStbl[j]);
	   Int4 *pos=ListSet(SetStbl[j]);
	   NilSet(SetStbl[j]); SetStbl[j]=0;
	   fprintf(vfp,"~$=%d.\n",i+1);
	   for(Int4 X=1; X <= psd->NumPDB(); X++){
	     pdb=psd->RtnPDB(X);
	     // SIPRIS...
	     fprintf(sfp,"file: %s\n",FilenamePDB(pdb));
	     fprintf(sfp,"chain: %c.\n",Chain[i]);

	     // VSI...
	     N++;
	     fprintf(vfp,"File%d=%s:%c\n",N,FilenamePDB(pdb),Chain[i]);
	   } fprintf(vfp,"\n1-10000.W15\n\n");
	   // SIPRIS...
	   fprintf(sfp,"range: %d-%d(%d;0).\n",MinRes,MaxRes,MaxRes-MinRes+1);
	   fprintf(sfp,"Y=");
	   for(j=0; pos[j] >= 0; j++){
		if(j > 0) fprintf(sfp,",");
		fprintf(sfp,"%d",pos[j]);
	   } fprintf(sfp,"\n");
	   fprintf(sfp,"R=");
	   for(j=0; pos[j] >= 0; j++){
		if(j > 0) fprintf(sfp,",");
		fprintf(sfp,"%d",pos[j]);
	   } fprintf(sfp,"\n");

	   // VSI...
	   fprintf(vfp,"%d-%d.Y80\n",MinRes,MaxRes);
	   for(j=0; pos[j] >= 0; j++){
		if(j > 0) fprintf(vfp,",");
		fprintf(vfp,"%c%d.Y",Seq[pos[j]],pos[j]);
	   } fprintf(vfp,"\n\n");
	   
	} fclose(sfp); fclose(vfp);
	return N;
}

