/**************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 **************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

double	spc_typ::RunOnePair(Int4 nI,Int4 nJ,char HetMol[],char HetAtm[],
		BooLean trans,double cut,FILE *outfp,char *Msg)
{
	BooLean	noMainChn=TRUE; 
	char	pdbid[200];
	double	dd,Dd;
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*ifp,*efp=0,*ofp=0;
	Int4	i,j,k,N,cI,cJ,x,y,z;
	Int4	nChn;
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	double	*Sum; NEW(Sum, nChn+3,double);
	double	*MinDist; NEW(MinDist,nChn+3,double);
	Int4	*MinID; NEW(MinID,nChn+3,Int4);
	for(i=0 ; Chain[i]; i++) MinDist[i]=DBL_MAX; 
	tri_typ	*tri=0;

// fprintf(stderr,"DEBUG: RunOnePair...\n");
	if(cut > 0.0) ofp=tmpfile(); else ofp=outfp;
	if(verbose) efp=stderr;
#if 0
	if(tri==0){ tri=new tri_typ(Chain,psd->NumPDB()); }
#endif
	ifp=open_file(argv[2],"","r");
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ){
	  // fprintf(stderr,"%d.%s\n",N+1,pdbid);
	  pdb_typ pdb = MakePDB(pdbid); N++; 
#if 1
          x=HIDorHIEorHIP2HIS_PDB(pdb);
          if(N==1 && x > 0) fprintf(stderr,"%d histidine heteroatoms changed to HIS.\n",x);
          y=ChangeMSE2MET_PDB(pdb); 
          if(N==1 && y > 0) fprintf(stderr,"%d MSE atoms changed to MET.\n",y);
          z=ChangePO3toAtmPDB(pdb);
          if(N==1 && z > 0) fprintf(stderr,"%d phosphorylated amino acids changed.\n",z);
          k=x+y+z;
          if(k > 0){
            FILE *tfp=tmpfile(); PutPDB(tfp,pdb); rewind(tfp);
            NilPDB(pdb); pdb=MakePDB(tfp); fclose(tfp);

	  }
#endif
	  if(mode == 'D' && nJ == -999){
	    if(strlen(HetMol) > 3) print_error("molecule identifier syntax error");
	    if(N==1){
	      fprintf(ofp,"index");
	      for(Int4 x=0; Chain[x]; x++){ fprintf(ofp,"\t%c",Chain[x]); }
	      fprintf(ofp,"\n"); 
	    } fprintf(ofp,"%d",N);
	    for(i=0 ; Chain[i]; i++){
	      cI=GetChainNumberPDB(pdb,Chain[i]);
	      // dd=Res2HeteroDist(efp,nI,cI,pdb,HetMol,"pb");
	      if(HetAtm[0]){
	        if(strlen(HetAtm) > 4) print_error("atom identifier syntax error");
		dd=this->Res2HeteroDist(efp,nI,cI,pdb,HetMol,HetAtm);
	      } else dd=this->Res2HeteroDist(efp,nI,cI,pdb,HetMol);
	      if(dd >= BigDist){ fprintf(ofp,"\t>20.0"); dd = 20.0; }
	      else fprintf(ofp,"\t%.2lf",dd); 
	      Sum[i] += dd;
	      if(dd < MinDist[i]){ MinDist[i] = dd; MinID[i]=N; }
	    } fprintf(ofp,"\n");
	    NilPDB(pdb); continue;
	  }

	  if(trans) j=1; else j=0;
	  for(i=0 ; Chain[i]; i++,j++){
	   if(Chain[j]==0) j=0;
	   if(N==1 && i==0){
	     fprintf(ofp,"index\t");
	     for(Int4 x=0,y=1; Chain[x];y++,x++){
		if(Chain[y]==0) y=0; 
		if(trans) fprintf(ofp,"%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"%c",Chain[x]);
		if(y != 0) fprintf(ofp,"\t");
	     } fprintf(ofp,"\n"); 
	   }
	   if(i==0) fprintf(ofp,"%d\t",N);
	   cI=GetChainNumberPDB(pdb,Chain[i]); cJ=GetChainNumberPDB(pdb,Chain[j]);
	   if(cI == 0 || !IsProteinPDB(cI,pdb)){
		// if(efp) fprintf(stderr,"chain '%c' absent; skipping...\n",Chain[i]); 
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	   } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		// if(efp) fprintf(stderr,"chain '%c' absent; skipping...\n",Chain[j]); 
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	   } // fprintf(stderr,"%s %c=%d\n",pdbid,Chain[j],j);
	   switch(mode){
	     case 'D': {
		dd=this->Res2ResDistance(efp,nI,nJ,cI,cJ,pdb,noMainChn);
	       } break;
	     default: //========================================================
	      {
	        if(efp) fprintf(efp,"============ %d%c:%d%c ==================\n",
				nI,Chain[i],nJ,Chain[j]);
		dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,pdb);
#if 0
		if(i != j){
		   if(efp) fprintf(efp,"============ %d%c:%d%c ==================\n",
				nI,Chain[j],nJ,Chain[i]);
		   Dd=this->GetContactsPDB(efp, nI,nJ, HA_dmax, cJ,cI,pdb);
		   dd=MINIMUM(double,dd,Dd);
		} if(efp) fprintf(efp,"------------------------------\n");
#endif
	      } break;
	   }
#if 1
	   if(dd < MinDist[i]){ MinDist[i] = dd; MinID[i]=N; }
#endif
	   if(mode != 'D' && dd >= BigDist){
#if 1
	        fprintf(ofp,"....");
	        // fprintf(ofp,"%.1lf",dd);
#else
		fflush(ofp); 
		print_error("\nCommand invalid for non-polar residues; try 'dist'.");
#endif
	   } else if(dd == 0.0) fprintf(ofp,"-");
	   else fprintf(ofp,"%.2lf",dd);
#if 0
tri->AddValue(N,dd,i);
#endif
	   if(Chain[i+1]) fprintf(ofp,"\t"); Sum[i] += dd;
	  } fprintf(ofp,"\n"); NilPDB(pdb);
#if 0
tri->Put(ofp,N);
#else
// tri->Put(stderr,N);
#endif
	}
	double	*Value; NEW(Value,nChn +3, double);
	double	rtn=DBL_MAX;
	char	nhits=0;
	if(1 || efp && nChn > 0){
	   fprintf(ofp,"avg.\t");
	   for(Int4 x=0; Chain[x];x++){
	     dd=Sum[x]/(double) N; fprintf(ofp,"%.2lf",dd);
Value[x]=dd;
	     if(Chain[x+1]) fprintf(ofp,"\t");
	     rtn=MINIMUM(double,rtn,dd);
	     if(dd <= 2.5){
		Int4 y,r;
		if(trans){	// x = Ct & y = Rt or x = Lt & y = Ct
	   	   if(Chain[x+1]==0) y=0; else y=x+1;
		   if(sis){
		     sis->AddSite(Ct,x,nI); sis->AddSite(Rt,x,nJ);
		     sis->AddSite(Lt,y,nI); sis->AddSite(Ct,y,nJ);
		   }
		} else {	// x = Ct & x = Ct
		   if(sis){ sis->AddSite(Ct,x,nI); sis->AddSite(Ct,x,nJ); }
		}
	     }
	   } fprintf(ofp,"\n"); 
	} free(Sum);
	if(MinDist[0] < 9999.9){
	  fprintf(ofp,"min.\t");
	  for(Int4 x=0; Chain[x];x++){
	     fprintf(ofp,"%.2lf",MinDist[x]);
	     if(Chain[x+1]) fprintf(ofp,"\t");
	  } fprintf(ofp,"\n");
#if 0
	  fprintf(ofp,"index\t");
	  for(Int4 x=0; Chain[x];x++){
	     // fprintf(ofp,"%d",MinID[x]);
	     fprintf(ofp,"%c",Chain[x]);
	     if(Chain[x+1]) fprintf(ofp,"\t");
	  } fprintf(ofp,"\n");
#endif
	} free(MinDist); free(MinID);
	if(cut > 0){
	   if(rtn <= cut){ 
		if(Msg) fprintf(outfp,"%s",Msg);
		char c; rewind(ofp); 
		while((c=fgetc(ofp)) != EOF) fprintf(outfp,"%c",c); fclose(ofp);
	   }
	}
#if 0
	if(flipfp=open_file(argv[2],".flip","w");
	tri->PutFlipped(flipfp,Msg,trans,Value); 
#endif
	if(tri) delete tri; tri=0;
	free(Value);
	return rtn;
}

