/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

Int4    spc_typ::RunVSI2PyMOL(char *pdblist,Int4 vsi_id)
{
        char    *Argv[20],str[202],path[200],chn;
        Int4    i,Argc;
        sprintf(str,"chn_vsi %s.vsi 1 %d -T -skip=W -d2.5 -D",pdblist,vsi_id);
// fprintf(stderr,"%s\n",str);
        Argc=string2argv(Argv,str);       // mode == 'T'
// for(i=0; i < Argc; i++) fprintf(stderr,"Argv[%d] = %s\n",i,Argv[i]);
	FILE *xfp = tmpfile();
        FILE *vfp=open_file(pdblist,".vsi","r");
        ChainVSI(Argc,Argv,vfp,xfp); rewind(xfp);
	assert((fgets(str,100,xfp)) != NULL);  rewind(xfp);
	assert(sscanf(str,"File1=%[^:]:%c",path,&chn) == 2); 
fprintf(stderr,"==== input structure: \"%s\"; chain %c ====\n",path,chn);
        for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);

        sprintf(str,"chn_vsi %s.vsi.crs 1 -d2.5 -c -D -pml=%s%c_%d",
                pdblist,pdblist,chn,vsi_id);
        Argc=string2argv(Argv,str);
        ChainVSI(Argc,Argv,xfp,0); fclose(xfp);
        for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
#if 1	// create *pse files straightaway
        xfp=open_file(pdblist,"_script.py","w");
        fprintf(xfp,"\nfrom pymol import cmd\n\n");
        fprintf(xfp,"cmd.do('@%s%c_%d.pml')\n",pdblist,chn,vsi_id);
        fprintf(xfp,"cmd.sync()\n");
        fprintf(xfp,"cmd.save('%s%c_%d.pse' )\n\n",pdblist,chn,vsi_id);
        fclose(xfp);
        sprintf(str,"pymol -cqr %s_script.py >& /dev/null\n",pdblist);
        Int4 rtn=system(str);
	if(rtn==0){	// save *.pml for merging into pymol
           sprintf(str,"%s%c_%d.pml",pdblist,chn,vsi_id); remove(str);
	} sprintf(str,"%s_script.py",pdblist); remove(str);
#endif
	return 0;
}

Int4    spc_typ::PutHeaderHbondNet(FILE *ofp,Int4 Cut)
{
	fprintf(ofp,
	   "============= Networks with at least %d hydrogen bonds: =============\n",Cut);
	if(PDB_ID){
	   fprintf(ofp,"   Source pdb file for MD simulations = %s\n",PDB_ID);
	}
	fprintf(ofp,
	  "   syntax = <id>:<res1><chn1>_<res2><chn2> <dist>; <code> (grp1:grp2)\n");
	fprintf(ofp,"   semantics = <id>: identifier for a residue pair.\n");
	fprintf(ofp,"               <res1>: first residue.\n");
	fprintf(ofp,"               <chn1>: chain for the first residue.\n");
	fprintf(ofp,"               <res2>: second residue.\n");
	fprintf(ofp,"               <chn2>: chain for the second residue.\n");
	fprintf(ofp,"               <dist>: hydrogen bond distance in Angstroms.\n");
	fprintf(ofp,"               <code>: 'C' = cis; 'L' = trans left; 'R' = trans right.\n");
	fprintf(ofp,"                  For sidechain-to-backbone hydrogen bonds:\n");
	fprintf(ofp,"                     lower case = res1 and res2 switched.\n");
	fprintf(ofp,"               (grp1:grp2): single letter group code.\n");
	fprintf(ofp,"                  'Y' = BPPS main group residue.\n");
	fprintf(ofp,"                  'R' = BPPS subgroup residue.\n");
	fprintf(ofp,"                  'O' = BPPS sub-subgroup residue.\n");
	fprintf(ofp,"                  'G' = member of a top DC-scoring pair.\n");
	fprintf(ofp,"                  '-' = unclassified.\n\n");
	fprintf(ofp,
           "====================================================================\n\n");
}

Int4    spc_typ::FindHbondNetwork(FILE *ofp)
// return the number of residues in that form Hbonds with each other
// print out PyMOL scripts
{
        Int4    i,j,k,x,y,N,X,Hits,nchn,chn,*TotHits=0;
        Int4    MinRes=0,MaxRes=0;
        char    Str[500],**buffer=0,c,str[100];
        set_typ **Set;
        h_type  *HGM,*tHG,HG;

        //====================================================================
        //============== Get 1st structure for residue ranges ================
        //====================================================================
        assert(psd != 0);
        pdb_typ pdb = psd->RtnPDB(1); // MakePDB(Str);
        NEW(TotHits,nChainsPDB(pdb)+3,Int4);
        NEW(HGM,nChainsPDB(pdb)+3,h_type); NEW(tHG,nChainsPDB(pdb)+3,h_type);
        for(nchn=i=0 ; Chain[i]; i++){
              sprintf(str,"the number of H-bonds for chain %c",Chain[i]);
              HGM[i]=Histogram(str,-2,100,1.0);
              sprintf(str,"the number of H-bonds for chain %c over time",Chain[i]);
              tHG[i]=Histogram(str,0,1000,20);
              nchn++; j=GetChainNumberPDB(pdb,Chain[i]);
              MinRes=MAXIMUM(Int4,MinRes,MinResPDB(j,pdb));
              MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
        }
	sprintf(str,
		"the number of hydrogen bonds for %d structures, each with %d chains",
				psd->NumPDB(),nchn);
        HG=Histogram(str,-2,100,1.0);
        //===================================================================
        //=============== Get Interacting Residue Positions =================
        //===================================================================
        for(i=0 ; Chain[i]; ) i++;
        NEWP(Set,i+3,set_typ);
        x = MaxRes;
        y = x*(x-1)/2; NEWP(buffer,y+2,char);
        for(i=0 ; Chain[i]; i++){
           NEW(Set[i],5,set_typ);
	   if(sis->RtnSet(Lt,i)) Set[i][Lt]=CopySet(sis->RtnSet(Lt,i)); 
	   else Set[i][Lt]=MakeSet(MaxRes+4);
	   if(sis->RtnSet(Ct,i)) Set[i][Ct]=CopySet(sis->RtnSet(Ct,i)); 
	   else Set[i][Ct]=MakeSet(MaxRes+4);
	   if(sis->RtnSet(Rt,i)) Set[i][Rt]=CopySet(sis->RtnSet(Rt,i));
	   else Set[i][Rt]=MakeSet(MaxRes+4);
        }
#if 0	// DEBUG
for(i=1; i <= psd->NumPDB(); i++){
	pdb = psd->RtnPDB(i); 
	fprintf(stderr,"%d: %s\n",i,FilenamePDB(pdb));
} exit(1);
#endif
        //===================================================
        //=========== Make each pdb & res_typ ===============
        //===================================================
        Int4    *max_hits=0,vsi_id=0,*bst_id=0;
        NEW(max_hits,nchn+3,Int4); NEW(bst_id,nchn+3,Int4);
        FILE *vfp=open_file(argv[2],".vsi","w");
        FILE *ifp=open_file(argv[2],"","r");
        //=========================================================================
	//============== print out vsi file and find hits for all =================
	//=========================================================================
        Int4    nn=0,*PDBdH,*CHNdH;
	char	**path; 
        X=nchn*psd->NumPDB();
        dh_type dH=dheap(X+3,4);
        NEW(PDBdH,X+3,Int4); NEW(CHNdH,X+3,Int4); NEWP(path,psd->NumPDB()+3,char); 
        FILE    *tfp=0;
FILE *sfp=0,*sprs_fp=0;
        for(nn=N=0,X=1,vsi_id=0; X <= psd->NumPDB(); X++){
          //============================================
          //=========== Make the res_typ ===============
          //============================================
          if(fscanf(ifp,"%s\n",Str) != 1) print_error("pdb_paths input error");
	  path[X]=AllocString(Str);
          // fprintf(stderr,"%d.%s\n",N+1,Str);
          pdb = psd->RtnPDB(X); N++;
          if(verbose) fprintf(stderr,"%d.%d. %s\n",N,X,FilenamePDB(pdb));
          res_typ  **ResALL;
          Int4     *num_res;
          NEWP(ResALL,nChainsPDB(pdb)+3,res_typ);
          NEW(num_res,nChainsPDB(pdb)+3,Int4);
          for(i=0 ; Chain[i]; i++){
            j=GetChainNumberPDB(pdb,Chain[i]);
            ResALL[j]=psd->RtnResAll(X,i,num_res[j]);
	    if(0) fprintf(stderr,"%s: num_res[%d]=%d\n",FilenamePDB(pdb),j,num_res[j]);
          }
          for(i=0,j=nchn-1,k=1; Chain[i]; i++,k++,j=i-1){
            // if(Chain[k]==0) k=0; tfp=0; Hits=0;
	    if(Chain[k]==0) k=0; tfp=tmpfile(); Hits=0;
#if 0	// sipris file
if(sprs_fp==0) sprs_fp=open_file(argv[2],".sprs","w");
sfp=tmpfile();
#endif
            this->CisHbonds(Set[i][Ct],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp,sfp);
            if(nchn > 1){
              this->TransLeftHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
              this->TransRightHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
            }
#if 0	// sipris file
if(1 || strstr(Str,"14") != NULL){
fprintf(sprs_fp,"file: %s\n",Str);
fprintf(sprs_fp,"chain: %c.\n",Chain[i]);
fprintf(sprs_fp,"range: %d-%d(%d;0).\n",MinRes,MaxRes,MaxRes-MinRes+1);
fprintf(sprs_fp,"Y=");
rewind(sfp); c=fgetc(sfp); // skip initial ',' character.
while((c=fgetc(sfp)) != EOF) fprintf(sprs_fp,"%c",c); fprintf(sprs_fp,"\n");
fprintf(sprs_fp,"R=");
rewind(sfp); c=fgetc(sfp); // skip initial ',' character.
while((c=fgetc(sfp)) != EOF) fprintf(sprs_fp,"%c",c); fprintf(sprs_fp,"\n\n");
}
fclose(sfp);
#elif 1	
#endif
            vsi_id++;
            fprintf(vfp,"~$=%d.\n",vsi_id);
            fprintf(vfp,"File1=%s:%c  // \n\n1-10000.W15\n\n",Str,Chain[i]);
            fprintf(vfp,"%d-%d:%c.G80\n",MinRes,MaxRes,Chain[j]); // G=palegreen
            fprintf(vfp,"%d-%d:%c.B80\n",MinRes,MaxRes,Chain[i]); // B=lightblue
            fprintf(vfp,"%d-%d:%c.M80\n\n",MinRes,MaxRes,Chain[k]); // M=lightpink
            rewind(tfp); c=fgetc(tfp); // skip initial ',' character.
            while((c=fgetc(tfp)) != EOF) fprintf(vfp,"%c",c); fclose(tfp);
            fprintf(vfp,"\n\n");


            IncdHist(Hits,HG); TotHits[i] += Hits;
            if(Hits > max_hits[i]){ bst_id[i]=vsi_id; max_hits[i]=Hits; }
            IncdMHist(N,Hits,tHG[i]); IncdHist(Hits,HGM[i]); 
            for(j=1; buffer[j]; j++){ free(buffer[j]); buffer[j]=0; }
            nn++;
            insrtHeap(nn,-(keytyp)Hits,dH); PDBdH[nn]=X; CHNdH[nn]=i;
	    assert(!fullHeap(dH));
          } free(ResALL); free(num_res);
        } 
        //===========================================================
        //============== Output header & histogram ==========================
        //===========================================================
	this->PutHeaderHbondNet(ofp,3);
	PutHist(ofp,60,HG); NilHist(HG);
if(verbose) fprintf(stderr,
		"//================== Order the output by # hits =====\n");
	fclose(ifp); ifp=open_file(argv[2],"","r");
MinNumBonds=0;
	for(N=0,j=1; (nn=delminHeap(dH)) != 0; j++) {
	  X=PDBdH[nn]; i=CHNdH[nn]; pdb = psd->RtnPDB(X); N++; 
          if(verbose) fprintf(stderr,"%d.%d. %s\n",N,X,FilenamePDB(pdb));
	  //============================================
	  //=========== Make the res_typ ===============
	  //============================================
	  res_typ  **ResALL; NEWP(ResALL,nChainsPDB(pdb)+3,res_typ);
	  Int4     *num_res; NEW(num_res,nChainsPDB(pdb)+3,Int4);
          for(Int4 ii=0 ; Chain[ii]; ii++){
	    j=GetChainNumberPDB(pdb,Chain[ii]);
	    ResALL[j]=psd->RtnResAll(X,ii,num_res[j]);
	    if(0) fprintf(stderr,"%s: chain %c num_res[%d]=%d\n",
			FilenamePDB(pdb),Chain[ii],j,num_res[j]);
	  }
	  k=i+1; 
	  if(i==0) j=nchn-1; else j=i-1;
	  // if(Chain[k]==0) k=0; tfp=tmpfile(); Hits=0;
	  if(Chain[k]==0) k=0; tfp=0; Hits=0;
	  this->CisHbonds(Set[i][Ct],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	  if(nchn > 1){
	      this->TransLeftHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	      this->TransRightHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	  }
	  fprintf(ofp,"%d.%d: %d hits(chain %c) '%s'\n",X,i,Hits,Chain[i],BaseName2(path[X]));
	  if(N <= 10){
	     for(j=1; buffer[j]; j++) fprintf(ofp,"%d:%s\n",j,buffer[j]); fprintf(ofp,"\n");
	  } for(j=1; buffer[j]; j++){ free(buffer[j]); buffer[j]=0; }
	  free(ResALL); free(num_res);
	} free(buffer);  Nildheap(dH);
	fprintf(vfp,"\n"); fclose(vfp); fclose(ifp); 
	fprintf(stderr,"vsi file done.\n");
	for(i=1; i <= psd->NumPDB(); i++) if(path[i]) free(path[i]); free(path);
        //============================================================
        //================ Create best PyMOL file. ===================
        //============================================================
        char    *Argv[20];
        Int4    Argc;
        for(i=0; Chain[i]; i++){
          if(bst_id[i] == 0) continue;
          sprintf(str,"chn_vsi %s_X 1 %d -T -skip=W -d2.5 -D",argv[2],bst_id[i]);
// fprintf(stderr,"%d: %s\n",i,str);
          Argc=string2argv(Argv,str);       // mode == 'T'
          FILE *xfp = tmpfile();
          vfp=open_file(argv[2],".vsi","r");
          ChainVSI(Argc,Argv,vfp,xfp); rewind(xfp);
	  fclose(vfp); vfp=0;
          for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
          sprintf(str,"chn_vsi %s_X.crs 1 -d2.5 -c -D -pml=%s%c_%d",
                argv[2],argv[2],Chain[i],bst_id[i]);
          Argc=string2argv(Argv,str);
          ChainVSI(Argc,Argv,xfp,0); fclose(xfp);
          for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
#if 1	// add the Top DC scoring pairs as rods
	  if(TopDC_Set && TopDC_Grph){
	    wdg_typ G = TopDC_Grph;
            sprintf(str,"%s%c_%d",argv[2],Chain[i],bst_id[i]);
	    fprintf(stderr,"%s.pml\n",str);
	    xfp=open_file(str,".pml","a");
            char chn=Chain[i];
	    // fprintf(stderr,"N=%d\n",CardSet(TopDC_Set));
	    Int4 vI,vJ,eI,eJ,e,v;
	    for(Int4 vI=1; vI < SetN(TopDC_Set); vI++){
	      if(MemberSet(vI,TopDC_Set)){
	       for(e=FirstOutWdgraph(vI,G); e!= 0; e=NextOutWdgraph(e,G)){ 
		// vJ=TailWdgraph(e,G);
		vJ=HeadWdgraph(e,G);
		Int4 wt=WeightWdgraph(e,G);
	        if(MemberSet(vJ,TopDC_Set)){
		   fprintf(xfp,"dist dc%d%c_%d%c, chain %c and name ca and resid %d, ",
                                vI,chn,vJ,chn,chn,vI);
                   fprintf(xfp,"chain %c and name ca and resid %d, label=0\n",chn,vJ);
		   if(wt > 800){
                     fprintf(xfp,"set dash_radius,0.1, dc%d%c_%d%c\n",vI,chn,vJ,chn);
                     fprintf(xfp,"set dash_gap,0.4, dc%d%c_%d%c\n",vI,chn,vJ,chn);
		   } else {
                     fprintf(xfp,"set dash_radius,0.250, dc%d%c_%d%c\n",vI,chn,vJ,chn);
                     fprintf(xfp,"set dash_gap,0.075, dc%d%c_%d%c\n",vI,chn,vJ,chn);
		   }
                   fprintf(xfp,"set dash_length,0.925, dc%d%c_%d%c\n",vI,chn,vJ,chn);
                   fprintf(xfp,"color lime, dc%d%c_%d%c\n",vI,chn,vJ,chn);
		}
	       }
	      }
	    } fprintf(xfp,"set cartoon_transparency, 0.40"); fclose(xfp);
	  }
#endif
#if 1	  // create *pse files straightaway
          xfp=open_file(argv[2],"_script.py","w");
          fprintf(xfp,"\nfrom pymol import cmd\n\n");
          fprintf(xfp,"cmd.do('@%s%c_%d.pml')\n",argv[2],Chain[i],bst_id[i]);
          fprintf(xfp,"cmd.sync()\n");
          fprintf(xfp,"cmd.save('%s%c_%d.pse' )\n\n",argv[2],Chain[i],bst_id[i]);
          fclose(xfp);
          sprintf(str,"pymol -cqr %s_script.py >& /dev/null\n",argv[2]);
          Int4 rtn=system(str);
	  if(rtn==0){
            sprintf(str,"%s%c_%d.pml",argv[2],Chain[i],bst_id[i]); remove(str);
	  } sprintf(str,"%s_script.py",argv[2]); remove(str);
#endif
        }
        //===========================================================
        //=========== output other histograms =======================
        //===========================================================
	fprintf(ofp,"\n\n");
        for(i=0; Chain[i]; i++){
            PutHist(ofp,60,HGM[i]); NilHist(HGM[i]);
            PutHist(ofp,60,tHG[i]); NilHist(tHG[i]);
        } free(HGM); free(tHG);
        //===========================================================
        //============= free data structures ========================
        //===========================================================
        for(i=0; Chain[i]; i++){
            fprintf(ofp,"chain %c: %d\n",Chain[i],TotHits[i]);
            NilSet(Set[i][Lt]); NilSet(Set[i][Ct]); NilSet(Set[i][Rt]);
            free(Set[i]);
        } free(Set); free(TotHits);
        free(max_hits); free(bst_id);
        free(PDBdH); free(CHNdH); 
        //===========================================================
        //===========================================================
        //===========================================================
	this->sis->PutAll(ofp);
if(sprs_fp) fclose(sprs_fp);
        return N;
}

Int4	spc_typ::CisHbonds(set_typ Set,char **buffer,char ChnC,Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp,FILE *sfp)
// This goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,chnI,chnJ;
	Int4	cC,nI,nJ,nchn,i,j,k,N;
	res_typ *ResC;
	set_typ	SetC=Set,SetX=CopySet(SetC); ClearSet(SetX);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get cis chain ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	cC=GetChainNumberPDB(pdb,ChnC);
	ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MaxResC=MaxResPDB(cC,pdb);

	//========= Go through all of the pairs in SetC ======
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
           for(nJ=nI+1; nJ <= MaxResC; nJ++) {
             if(!MemberSet(nJ,SetC)) continue;
	     //=============== color code residues in vsi file... ========
	     char sbgrpI=this->RtnColorCode(nI);
	     char sbgrpJ=this->RtnColorCode(nJ);

	     Int4  IL,IC,IR,JL,JC,JR;
	     //============ cis Interaction ==================
	     for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI == ResidueID(ResC[k])){ IC=k; break; } 
	     } assert(IC != 0);
	     for(JC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nJ == ResidueID(ResC[k])){ JC=k; break; } 
	     } assert(JC != 0);

	     double  dC,DC,dR,DR,dL,DL,dB;
	     //============ cis Interaction ==================
	     dC=this->GetHBonds(efp,ResC[IC],ResC[JC],cC,cC,HA_dmax,pdb);
	     DC=this->GetHBonds(efp,ResC[JC],ResC[IC],cC,cC,HA_dmax,pdb);

// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);

	     chnI=chnJ=ChnC; Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResC[JC],AB);
	     if(dC < DC){ dB=dC; bst='c'; } else { dB=DC; bst='C'; }
	     if(dB <= 2.5){
		char str[100];
		//================ vsi file.. =====================
		switch (bst){
		  case 'c': case 'C':
		   if(!MemberSet(nI,SetX)){
		     if(tfp) fprintf(tfp,",%c%d:%c.%c",Ci,nI,chnI,sbgrpI);
if(sfp) fprintf(sfp,",%d",nI);
		     AddSet(nI,SetX);
		   }
		   if(!MemberSet(nJ,SetX)){
		     if(tfp) fprintf(tfp,",%c%d:%c.%c",Cj,nJ,chnJ,sbgrpJ);
if(sfp) fprintf(sfp,",%d",nJ);
		     AddSet(nJ,SetX);
		   } break;
		  default: print_error("This should not happen");
		}
		//================ end vsi file.. =====================
		if(sbgrpI=='W') sbgrpI='-';
		if(sbgrpJ=='W') sbgrpJ='-';
		if(sbgrpI=='-' && sbgrpJ=='-') {
		    sprintf(str,"%c%d%c_%c%d%c %.2lf; %c",Ci,nI,chnI,Cj,nJ,chnJ,dB,bst);
		} else {
		    sprintf(str,"%c%d%c_%c%d%c %.2lf; %c (%c:%c)",
				Ci,nI,chnI,Cj,nJ,chnJ,dB,bst,sbgrpI,sbgrpJ);
		}
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} NilSet(SetX);
	return Sum;
}

Int4	spc_typ::TransLeftHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp)
// this goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,ChnL,chnI,chnJ;
	Int4	nI,nJ,rtn=0,nchn,i,j,k,N,cL,cC,nL,nC;
	res_typ *ResL,*ResC;
	set_typ	SetC=Set[Ct],SetL=Set[Lt];
	set_typ	SetXL=CopySet(SetL); ClearSet(SetXL);
	set_typ	SetXC=CopySet(SetC); ClearSet(SetXC);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get Adj. chains ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	k = (i-1); if(k < 0) k=nchn-1; ChnL=Chain[k];

	cC=GetChainNumberPDB(pdb,ChnC);
	cL=GetChainNumberPDB(pdb,ChnL);
	assert(!(cL == 0 || !IsProteinPDB(cL,pdb)));
	assert(!(cC == 0 || !IsProteinPDB(cC,pdb)));
	ResL=ResALL[cL]; ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MinResL=MinResPDB(cL,pdb);
        Int4 MaxResC=MaxResPDB(cC,pdb),MaxResL=MaxResPDB(cL,pdb);
// fprintf(stderr,"Entering  TransLeftHbonds(): chains: %s '%c:%c'\n",FilenamePDB(pdb),ChnL,ChnC);

	Int4 IL,IC,JL,JC;
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
	   for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI==ResidueID(ResC[k])){ IC=k; break; } 
	   } 
	   if(IC == 0){
		// fprintf(stderr,"nI=%d\n",nI);
		// PutSet(stderr,SetC);
		print_error("spc_typ::TransLeftHbonds() input error 1"); // assert(IC != 0);
	   }
	   //=========== left trans interating residue ===============
           for(nJ=MinResL; nJ <= MaxResL; nJ++) {
	     if(nJ == nI) continue;
             // if(nJ > SetN(SetL)) continue;	// bug fix for Prasanth; afn_1_6_2023.
             if(!MemberSet(nJ,SetL)) continue;
             // if(num_resALL[cL] == 0) continue;
	     for(JL=0,k=num_resALL[cL]; k >= 1; k--){
		// fprintf(stderr,"ResL[%d]=%d == %d?\n",k,ResidueID(ResL[k]),nJ);
		if(nJ == ResidueID(ResL[k])){
		    JL=k; // fprintf(stderr,"Found JL=%d==%d!\n",JL,k);
			break; 
		} 
	     } 
	     // fprintf(stderr,"Found JL=%d==%d! nI=%d; nJ=%d\n",JL,k,nI,nJ);
	     if(JL == 0){
		fprintf(stderr,"nI=%d; nJ=%d; num_res_cL=%d\n",nI,nJ,num_resALL[cL]);
		PutSet(stderr,SetC);
		PutSet(stderr,SetL);
		assert(JL != 0);
		print_error("spc_typ::TransLeftHbonds() input error 2"); // assert(JL != 0);
	     }

	     double  dL,DL,dB=DBL_MAX;
//if(0) fprintf(stderr,"%d%c vs %d%c: IJ=%d; JJ=%d\n", nI,adjChn,nJ,adjChn,IJ,JJ);
	     //=========== left trans interation ===============
	     DL=this->GetHBonds(efp,ResC[IC],ResL[JL],cC,cL,HA_dmax,pdb);
	     dL=this->GetHBonds(efp,ResL[JL],ResC[IC],cL,cC,HA_dmax,pdb);
// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);
	     //=============== color code residues in vsi file... ========
	     char sbgrpI=this->RtnColorCode(nI);
	     char sbgrpJ=this->RtnColorCode(nJ);
	     bst='L'; dB=DL; chnI=ChnC; chnJ=ChnL;
	     Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResL[JL],AB);
	     if(DL > dL){ bst='l'; dB=dL; }

	     if(dB <= 2.5){
		char str[100];
		//=================== for vsi file =====================
		if(!MemberSet(nI,SetXC)){
		   if(tfp) fprintf(tfp,",%c%d:%c.%c",Ci,nI,chnI,sbgrpI);
		   AddSet(nI,SetXC);
		}
		if(!MemberSet(nJ,SetXL)){
		   if(tfp) fprintf(tfp,",%c%d:%c.%c",Cj,nJ,chnJ,sbgrpJ);
		   AddSet(nJ,SetXL);
		} 
		//================= for stdout file ====================
		if(sbgrpI=='W') sbgrpI='-';
		if(sbgrpJ=='W') sbgrpJ='-';
		sprintf(str,"%c%d%c_%c%d%c %.2lf; %c (%c:%c)",
				Ci,nI,chnI,Cj,nJ,chnJ,dB,bst,sbgrpI,sbgrpJ);
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} return Sum;
}

Int4	spc_typ::TransRightHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp)
// this goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,ChnR,chnI,chnJ;
	Int4	nI,nJ,rtn=0,nchn,i,j,k,N,cR,cC,nR,nC;
	res_typ *ResR,*ResC;
	set_typ	SetC=Set[Ct],SetR=Set[Rt];
	set_typ	SetXR=CopySet(SetR); ClearSet(SetXR);
	set_typ	SetXC=CopySet(SetC); ClearSet(SetXC);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get Adj. chains ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	k = (i+1); if(k >= nchn) k=0; ChnR=Chain[k];

	cC=GetChainNumberPDB(pdb,ChnC);
	cR=GetChainNumberPDB(pdb,ChnR);
	assert(!(cR == 0 || !IsProteinPDB(cR,pdb)));
	assert(!(cC == 0 || !IsProteinPDB(cC,pdb)));
	ResR=ResALL[cR]; ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MinResR=MinResPDB(cR,pdb);
        Int4 MaxResC=MaxResPDB(cC,pdb),MaxResR=MaxResPDB(cR,pdb);

	Int4 IR,IC,JR,JC;
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
	   for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI==ResidueID(ResC[k])){ IC=k; break; } 
	   } 
	   if(IC == 0){
		fprintf(stderr,"nI=%d\n",nI);
		PutSet(stderr,SetC);
		print_error("spc_typ::TransRightHbonds() input error 1"); // assert(IC != 0);
	   }
	   //=========== left trans interating residue ===============
           for(nJ=MinResR; nJ <= MaxResR; nJ++) {
	     if(nJ == nI) continue;
             if(!MemberSet(nJ,SetR)) continue;
	     for(JR=0,k=num_resALL[cR]; k >= 1; k--){
		if(nJ == ResidueID(ResR[k])){ JR=k; break; } 
	     } 
	     if(JR == 0){
		fprintf(stderr,"nI=%d\n",nJ);
		PutSet(stderr,SetC);
		PutSet(stderr,SetR);
		print_error("spc_typ::TransRightHbonds() input error 2"); // assert(IC != 0);
	     }

	     double  dR,DR,dB;
//if(0) fprintf(stderr,"%d%c vs %d%c: IJ=%d; JJ=%d\n", nI,adjChn,nJ,adjChn,IJ,JJ);
	     //=========== left trans interation ===============
	     DR=this->GetHBonds(efp,ResC[IC],ResR[JR],cC,cR,HA_dmax,pdb);
	     dR=this->GetHBonds(efp,ResR[JR],ResC[IC],cR,cC,HA_dmax,pdb);
// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);

	     Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResR[JR],AB);
	     //=============== color code residues in vsi file... ========
	     char sbgrpI=this->RtnColorCode(nI);
	     char sbgrpJ=this->RtnColorCode(nJ);
	     bst='R'; dB=DR; chnI=ChnC; chnJ=ChnR;
	     if(DR > dR){ bst='r'; dB=dR; }

	     if(dB <= 2.5){
		char str[100];
		//=================== vsi file. ======================
		if(!MemberSet(nI,SetXC)){
		     if(tfp) fprintf(tfp,",%c%d:%c.R",Ci,nI,chnI); AddSet(nI,SetXC);
		}
		if(!MemberSet(nJ,SetXR)){
		     if(tfp) fprintf(tfp,",%c%d:%c.R",Cj,nJ,chnJ); AddSet(nJ,SetXR);
		}
		//================= stdout file. =====================
		if(sbgrpI=='W') sbgrpI='-';
		if(sbgrpJ=='W') sbgrpJ='-';
		sprintf(str,"%c%d%c_%c%d%c %.2lf; %c (%c:%c)",
				Ci,nI,chnI,Cj,nJ,chnJ,dB,bst,sbgrpI,sbgrpJ);
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} return Sum;
}

