/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

Int4	spc_typ::MkSubSIPRIS(char *sprs_file,char *PDBID)
// output is in sprs_file.tmp; returns the number of files found...
{
	char pdbid[20],str[505],chns[30],*st,ch,cc,*fstr;
	Int4 nHits=0;
	if(sscanf(PDBID,"%6[^_]_%26[A-Z]",pdbid,chns) != 2){
		print_error(USAGE_SPARC_SIPRIS);
	} // fprintf(stderr,"pdb=%s; chains=%s\n",pdbid,chns);
	for(int ii=0; pdbid[ii]; ii++) pdbid[ii]=tolower(pdbid[ii]);
	FILE *ifp=open_file(sprs_file,"","r");
	FILE *ofp=open_file(sprs_file,".tmp","w");
	char	state=0;
	for(state=0; fgets(str,500,ifp) != NULL; ){
	   // fprintf(ofp,"*** %s",str);
	   switch (str[0]) {
		case 'f': {  // file last seen.
		   if(strstr(str,pdbid) != 0){
			fstr=AllocString(str);
		        if(fgets(str,500,ifp) == NULL){
				print_error("SIPRIS syntax error");
			} else if(sscanf(str,"chain: %c.",&ch) == 1){
			      if(strchr(chns,ch) != 0){
				fprintf(ofp,"%s%s",fstr,str); state='u'; nHits++;
			      }
			} else print_error("SIPRIS syntax error");
			free(fstr);
		   }
	 	  } break;
		 case 'c': {  // chain: ...
			if(sscanf(str,"chain: %c.",&ch) != 1){
			     print_error("SIPRIS syntax error");
			  }
			  // if(state=='u') print_error("SIPRIS syntax error");
		  } break;
		 case 'r': {  // range: ...
			 if(state=='u'){
			  if(strstr(str,"range: ") == 0){
			    print_error("SIPRIS syntax error");
			  } fprintf(ofp,"%s",str);
			 }
		  } break;
		 case 'Y': {  //  Y=...
			 if(str[1] != '=') print_error("SIPRIS syntax error");
			 if(state=='u') fprintf(ofp,"%s",str);
		  } break;
		 case 'R': {  //  R=...
			 if(str[1] != '=') print_error("SIPRIS syntax error");
			 if(state=='u') fprintf(ofp,"%s",str);
		  } break;
		 case 'O': {  //  O=...
			 if(str[1] != '=') print_error("SIPRIS syntax error");
			 if(state=='u') fprintf(ofp,"%s",str);
		  } break;
		 case '\n': {  // newline only (end of section.
			  if(state=='u') fprintf(ofp,"\n"); state=0;
		  } break;
		 default: // ignore other lines.  
			break;
	   }
	} fclose(ifp); fclose(ofp);
	return nHits;
}

int	spc_typ::Run()
{
	Int4	i,j,k,N,nI,nJ;
	char	c,c2=' ';
	BooLean trans=FALSE; 
	// fprintf(stderr,"DEBUG: %s...'%c'\n",argv[1],mode);
	switch (mode){
	  case 'm': { return this->RunModeMDS(); } break;
	  case 'r': {	// rank mode
	    char **ArgV; NEWP(ArgV,argc+2,char);
	    int ArgC = 0; ArgV[0]=argv[0]; ArgC++;
	    for(i=1,j=2; j < argc; i++,j++){ ArgV[i]=argv[j]; ArgC++; }
	    fprintf(stderr,"running %s...\n",argv[1]);
	    drc_typ drc(ArgC,ArgV,'S',TRUE,InputDCA); 
	    drc.SaveFiles();
	    drc.run_sparc();
	    if(!drc.ModeIsMDS()) drc.ScoreSeqs();  
	    free(ArgV); return 0;
	   } break;
	  case 'Z': {	// sipris mode...
		SrchAll=TRUE; 
		// scl_typ scl(argc,argv,' ',SIPRIS_USAGE,SPRS_VERSION);
		// get source pdb and chains and create sub *.sprs file...
	        char str[505];
	        if(this->MkSubSIPRIS(argv[2],argv[5]) < 1){
		      print_error("SIPRIS input file error");
	        }
		char	*Argv[20];
		Int4	Argc=3;
		Argv[0]=argv[1];	// sipris
		// Argv[1]=argv[2];	// sprs input file
		sprintf(str,"%s.tmp",argv[2]);
		Argv[1]=AllocString(str);	// sprs input file
		Argv[2]=argv[3];	// mode
		Argv[3]=0;
		scl_typ scl(Argc,Argv,'Z',USAGE_SPARC_SIPRIS);
		FILE *xfp=open_file(argv[4],".sprs","w");
		Int4 rtn=scl.RunSPARC(xfp,argv[4],stdout); fclose(xfp);
		xfp=open_file(argv[4],".sprs","r");
		while((c=fgetc(xfp)) != EOF) fprintf(stdout,"%c",c);
		fclose(xfp); 
		remove(Argv[1]); free(Argv[1]);
		return 0; 
	   } break;
	  case 'h': {	// h-bonds mode...
		nI=nJ=0; SrchAll=TRUE; 
	        fprintf(stdout,"%s %s %s %s \n",argv[0],argv[1],argv[2],argv[3]);
		mode = 'm'; this->CountHbonds(); mode='h'; return 0; 
	   } break;
	  default: { } break;	// do nothing
	}
//===========================================================================
	Int4	nK,nL;
	char	HetMol[200]; HetMol[0]=0;
	char	HetAtm[100]; HetAtm[0]=0;
	char	HetChn=0;	SrchAll=FALSE;
	if(argc == 4 || argv[4][0]=='-'){ 
		if(mode=='D') print_error(USAGE_SPARC_DIST);
		nI=nJ=0; SrchAll=TRUE;
	} else if(mode=='D'){
	   if(sscanf(argv[4],"%d@%[^_]_%s",&nI,HetMol,HetAtm) == 3){ 
		fprintf(stderr,"%s %s %s %s %d@%s_%s\n",
		  argv[0],argv[1],argv[2],argv[3],nI,HetMol,HetAtm);
		nJ=-999; trans=FALSE; 
	   } else if(sscanf(argv[4],"%d@%s",&nI,HetMol) == 2){ 
		fprintf(stderr,"%s %s %s %s %d@%s\n",
		  argv[0],argv[1],argv[2],argv[3],nI,HetMol);
		nJ=-999; trans=FALSE;
	   } else if(sscanf(argv[4],"%c@%s",&HetChn,HetMol) == 2){ 
// fprintf(stderr,"DEBUG: XYZ\n");
		fprintf(stderr,"%s %s %s %s %c@%s\n",
			argv[0],argv[1],argv[2],argv[3],HetChn,HetMol);
		nI=nJ=-999; trans=FALSE; SrchAll=TRUE; 
	        assert(psd==0); psd = new psd_typ(argv[2],Chain);
#if 1	// afn 5/4/2022.
	   } else if(sscanf(argv[4],"%d:%d%c",&nI,&nJ,&c) == 3){ 
	      if(c == 'T'){ trans=TRUE; }
	      //fprintf(stderr,"DEBUG 2\n");
#endif
	   } else print_error(USAGE_SPARC_DIST); 
	} else if(sscanf(argv[4],"%d:%d%c_%d:%d%c",&nI,&nJ,&c,&nK,&nL,&c2) != 6){ 
	     if(sscanf(argv[4],"%d:%d%c",&nI,&nJ,&c) != 3){ 
	       if(mode=='D') print_error(USAGE_SPARC_DIST); 
	       else print_error(USAGE_SPARC_H_BOND); 
	     } else {
		if(c == 'T') trans=TRUE;
	        else if(c != 'C'){
	     	   if(mode=='D') print_error(USAGE_SPARC_DIST);
		   else print_error(USAGE_SPARC_H_BOND); 
		} c2=' ';
	     }
	} else if(c == 'T'){ trans=TRUE; }
	else if(c != 'C'){
	     if(mode=='D') print_error(USAGE_SPARC_DIST);
	     else print_error(USAGE_SPARC_H_BOND); 
	} 	// else c == 'C'.
// } else if(mode=='D') print_error(USAGE_SPARC_DIST);
// else print_error(USAGE_SPARC_H_BOND); 
//===========================================================================
	if(SrchAll){
	    fprintf(stdout,"%s %s %s %s \n",argv[0],argv[1],argv[2],argv[3]);
	} else if(nJ < 0){
	    fprintf(stdout,"%s %s %s %s %s \n",
		argv[0],argv[1],argv[2],argv[3],argv[4]);
	} else {
	    fprintf(stdout,"%s %s %s %s %s == %d:%d%c\n",
		argv[0],argv[1],argv[2],argv[3],argv[4],nI,nJ,c);
	}
//===========================================================================
	if(0) fprintf(stderr,"SrchAll = %d; mode = '%c'.\n",SrchAll,mode);
	if(SrchAll){
	   switch (mode) {
	     case 'B': { this->RunAllPairsFast(); } break; // bb2bb mode..
	     case 'D': {
		if(0) fprintf(stderr,"%s %s %s %s %s :%c\n",
			argv[0],argv[1],argv[2],argv[3],argv[4],HetChn);
		// This appears to never be called:
		if(HetChn == 0)  return this->CompareAltStruct(HetMol,HetAtm,trans);
		else this->RunAllHetMol(HetChn,HetMol,HetAtm,trans);
		if(rphH){
		   FILE *hfp=open_file(argv[2],".het","w");
		   if(PDB_ID) rphH->PutHeader(hfp,'H',PDB_ID);
		   rphH->Put(hfp); fclose(hfp);
		   hfp=open_file(argv[2],".het","r");
		   while((c=fgetc(hfp)) != EOF) fprintf(stdout,"%c",c); fclose(hfp);
		}
	     } break;
	     case 'H': {	// sc2sb mode..
		mode = 'S'; this->RunAllPairsFast(); 
		this->RunAllAroAroPi(stderr);
		this->RunAllCH_Pi();
		mode = 's'; this->RunAllPairsFast(); 
		mode = 'H';
	     } break;
	     case 'h': {
	     } break;
	     case 'p': {
		if(0) fprintf(stderr,"--> %s %s %s %s\n",
			argv[0],argv[1],argv[2],argv[3]);
// fprintf(stderr,"1.SrchAll = %d; mode = '%c'.\n",SrchAll,mode);
	        this->RunAllTwoPairsFast();
// fprintf(stderr,"2.SrchAll = %d; mode = '%c'.\n",SrchAll,mode);
	     } break;
	     case 'S': 
	     case 's': {
		this->RunAllPairsFast(); // sc2sc or sc2bb mode..
	     } break;
	     default: { print_error("This should not happen"); } break;
	   }

//===========================================================================
	   char rph_mode=0;
	   if(rphF){	// flipped residue interactions
// fprintf(stderr,"============= DEbUG RPHF=============\n");
		if(flpfp==0){
		  if(mode=='B'){
		     if(PDB_ID) rph_mode='F'; 
		     flpfp=open_file(argv[2],".b2b","w");
		  } else {
		     if(PDB_ID) rph_mode='F'; 
		     flpfp=open_file(argv[2],".flp","w");
		  }
	        }
		if(rph_mode) rphF->PutHeader(flpfp,rph_mode,PDB_ID);
		rphF->Put(flpfp); fclose(flpfp); flpfp=0;
	   }
	   if(rphS){	// stable residue interactions.
// fprintf(stderr,"============= DEbUG RPHS=============\n");
		if(PDB_ID) rph_mode='S'; 
		if(stblfp==0) stblfp=open_file(argv[2],".stbl","w");
		if(rph_mode) rphS->PutHeader(stblfp,rph_mode,PDB_ID);
           	rphS->Put(stblfp); fclose(stblfp); stblfp=0;
	   }
	   if(rphWS){	// stable residue CH-pi interactions.
// fprintf(stderr,"============= DEbUG RPHS=============\n");
		if(PDB_ID) rph_mode='S'; 
		if(stblfp==0) stblfp=open_file(argv[2],".xhpi","w");
		if(rph_mode) rphWS->PutHeader(stblfp,rph_mode,PDB_ID);
           	rphWS->Put(stblfp); fclose(stblfp); stblfp=0;
	   }
	   if(rphAS){	// stable residue aromatic-aromatic interactions.
// fprintf(stderr,"============= DEbUG RPHS=============\n");
		if(PDB_ID) rph_mode='S'; 
		if(stblfp==0) stblfp=open_file(argv[2],".arom","w");
		if(rph_mode) rphAS->PutHeader(stblfp,rph_mode,PDB_ID);
           	rphAS->Put(stblfp); fclose(stblfp); stblfp=0;
	   }
	   if(sis){
// fprintf(stderr,"============= DEbUG SIS =============\n");
		if(mode=='H'){ 
     		  FILE   *sfp=open_file(argv[2],".sis","w");
		  mode='m'; this->FindHbondNetwork(sfp); mode='H';
		  fclose(sfp); 
		} delete sis; sis=0; 
	   } return 0;
	} else {
	   if(c2==' '){ 
		if(mode == 'H') print_error(USAGE_SPARC_SC2SB);
		else this->RunOnePair(nI,nJ,HetMol,HetAtm,trans);
		return 0;
	   }else {
		BooLean trns2=TRUE;
		if(c2 == 'C') trns2=FALSE;
	   	return this->RunTwoPairs(nI,nJ,nK,nL,trans,trns2);
	   }
	}
	return 0;
}

