
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

set_typ *spc_typ::RunAllPairsPrep( )
{
	Int4	N,NN,i,j,k,x,p,MinRes,MaxRes,nI,nJ;
	char	pdbid[200];
	FILE	*efp=0;
	Int4	nChn,MaxLen=0,NumOkay=0;

	assert(mode != 'D');
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	// 1. open up one of the structures for reference.
	fprintf(stderr,"Done.\n"); // exit(1);
	pdb_typ	pdb=psd->RtnPDB(1); 
	Int4	nPDB=psd->NumPDB();
	MinRes=999999; MaxRes=0;
	for(i=0; Chain[i]; i++){
	        j=GetChainNumberPDB(pdb,Chain[i]);
		if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
		if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		Int4 Len=MaxRes-MinRes+1;
		MaxLen = MAXIMUM(Int4,Len,MaxLen);
	} // Only need to look at one; they are all the same.
#if 1
	set_typ *Pairs; NEW(Pairs,MaxRes+3,set_typ);
#endif

    {
	i=GetChainNumberPDB(pdb,Chain[0]);
	e_type Sq=GetPDBSeq(i,pdb);
	a_type AB=AminoAcidAlphabetPDB(pdb); StrtMtrx=MinRes; EndMtrx=MaxRes;
	set_typ useSB=0;
	{ useSB=MakeSet(MaxRes+4); FillSet(useSB); }
	Int4 NumVSI=0;
	for(nI=MinRes; nI <= MaxRes; nI++) {
	   if(!MemberSet(nI,useSB)) continue;
	   for(nJ=nI+1; nJ <= MaxRes; nJ++)
	   {
	     if(!MemberSet(nJ,useSB)) continue;
	     if(abs(nI-nJ) < MinSpacing) continue;
	     if(mode=='s' && nJ < nI) continue;  // only need to check one way.
	     Int4	cI,cJ;
	     float	HA_dmax=2.5,dmax=3.6; 
	     double	dIJ,dJI,dII,cut=2.5,cutX=3.0,Cut=0.01;
	     double	d=BigDist,dd,D=BigDist,DD=BigDist,Dd=BigDist;
	     cI=GetChainNumberPDB(pdb,Chain[0]);
	     char rI=psd->GetResChar(1,cI,nI),rJ=psd->GetResChar(1,cI,nJ);
#if 1
	     if(this->InvalidHbondPair(rI,rJ,mode)) continue;
#else
	     if(mode == 's'){	// sc2bb
	        if(strchr("GAFVILMP",rI) && strchr("GAFVILMP",rJ)) continue;
	     } else if(mode == 'S'){ // sc2sc
	        if(strchr("GAFVILMP",rI) != NULL) continue;
	        if(strchr("GAFVILMP",rJ) != NULL) continue;
		if(strchr("DE",rI) &&  strchr("DE",rJ)) continue;
		if(strchr("RK",rI) &&  strchr("RK",rJ)) continue;
	     }
#endif
	     for(i=0; Chain[i]; i++){
	       double	td=BigDist,tD=BigDist,cd=BigDist,cD=BigDist;
	       // find residues relatively near each other.
	       cI=GetChainNumberPDB(pdb,Chain[i]);
	       j=i+1;
	       if(Chain[j]==0) j=0;
	       cJ=GetChainNumberPDB(pdb,Chain[j]);
	       dIJ=DistancePDB(nI,"CA",cI,nJ,"CA",cJ,pdb);
	       dJI=DistancePDB(nI,"CA",cJ,nJ,"CA",cI,pdb);
	       dII=DistancePDB(nI,"CA",cI,nJ,"CA",cI,pdb);
	       if(0) fprintf(stderr,
			"%d -> %d%c vs %d%c: dIJ=%lf; dJI=%lf; dII=%lf\n",
		  	N,nI,Chain[i],nJ,Chain[j],dIJ,dJI,dII);
	       if(dIJ > 30.0 && dJI > 30.0 && dII > 30.0){
		  continue;
	       }
	       for(k=0,p=1; k <= 1; k++,p=nPDB){ 
		 if(nChn > 1){
	           td=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cJ,p);
	           tD=this->GetContactsFast(efp,nI,nJ,HA_dmax,cJ,cI,p);
		 } else td=tD=BigDist;
	         cd=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cI,p);
	         cD=this->GetContactsFast(efp,nJ,nI,HA_dmax,cI,cI,p);
		 
	         if(td > 0.0) d=MINIMUM(double,d,td);	// trans
	         if(tD > 0.0) D=MINIMUM(double,D,tD);	// trans
	         if(cd > 0.0) DD=MINIMUM(double,DD,cd);	// cis
	         if(cD > 0.0) Dd=MINIMUM(double,Dd,cD);	// cis
		 dd= td; dd=MINIMUM(double,tD,dd);
		 dd=MINIMUM(double,cd,dd); dd=MINIMUM(double,cD,dd);
		 if(verbose && dd < cutX) fprintf(stderr,
		   "%d -> %d%c vs %d%c: td=%lf; tD=%lf; cd=%lf; cD=%lf; dd=%lg\n",
		      p,nI,Chain[i],nJ,Chain[j],td,tD,cd,cd,dd);
	       }
	     }
	     if((d < cutX && d > Cut) || (D < cutX && D > Cut) ||
		(DD < cutX && DD > Cut) || (Dd < cutX && Dd > Cut)) {
		char Str[150],str[10],StrI[100],StrJ[100];
		Int4 os=OffSetSeq(Sq);
		char rI=AlphaChar(ResSeq(nI-os,Sq),AB);
		char rJ=AlphaChar(ResSeq(nJ-os,Sq),AB);
		if(mode=='s') sprintf(str,"sc2bb");
		else if(mode=='S') sprintf(str,"sc2sc");
		else sprintf(str,"bb2bb");
		sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf %.2lf %.2lf (%s)\n",
				rI,nI,rJ,nJ,d,D,DD,Dd,str);
		this->GetSeqContext(StrI,nI-os-1,3,Sq,AB); 
		this->GetSeqContext(StrJ,nJ-os-1,3,Sq,AB);
		// if(verbose){ fprintf(stderr,"%s\n",Str); }
BooLean	Okay=FALSE;
		if(d <= cutX){		// trans: I vs J
		   d=this->RunOnePairPrep(nI,nJ,TRUE,cut,Str,StrI,StrJ,Okay);
		}
		if(!Okay && D <= cutX){		// trans: J vs I
		   D=this->RunOnePairPrep(nJ,nI,TRUE,cut,Str,StrI,StrJ,Okay);
		}
		if(!Okay && DD <= cutX){		// cis: I vs J
		   Dd=DD=this->RunOnePairPrep(nI,nJ,FALSE,cut,Str,StrI,StrJ,Okay);
		} else if(!Okay && Dd <= cutX){ 	// cis: J vs I.
		   DD=Dd=this->RunOnePairPrep(nJ,nI,FALSE,cut,Str,StrI,StrJ,Okay);
		}
if(Okay){
	NumOkay++;
	// fprintf(stdout,"%d: %d vs %d\n",NumOkay,nI,nJ);
	if(Pairs[nI] == 0){ Pairs[nI]=MakeSet(MaxRes + 3); ClearSet(Pairs[nI]); }
	if(Pairs[nJ] == 0){ Pairs[nJ]=MakeSet(MaxRes + 3); ClearSet(Pairs[nJ]); }
	AddSet(nJ,Pairs[nI]); AddSet(nI,Pairs[nJ]);
}
	     } // end if((d < cutX && d > Cut) || (D < cutX && D > Cut)...
	  } // end for(nJ=nI+1; nJ <= MaxRes; nJ++)
	} // end for(nI=MinRes; nI <= MaxRes; nI++)
	if(useSB) NilSet(useSB); NilSeq(Sq); 
    }
	return Pairs;
}

double	spc_typ::RunOnePairPrep(Int4 nI,Int4 nJ, BooLean trans,double cut,
		char *Msg,char *StrI, char *StrJ, BooLean &Okay)
{
	BooLean	noMainChn=TRUE; 
	char	pdbid[200];
	double	dd,Dd;
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0; // stderr;
	Int4	i,j,z,N,cI,cJ,nChn;
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	double	*Sum; NEW(Sum, nChn+3,double);
	double	*Value[9]; Value[0]=Value[1]=Value[2]=Value[3]=Value[4]=0;
	tri_typ	*tri=0;

	assert(mode != 'D');
	assert(psd != 0);
	Int4 nPDB=psd->NumPDB(),Mid=nPDB/2;
	if(tri==0){ tri=new tri_typ(Chain,nPDB); }
	tri->SetCut(25,25);
	Int4 *NN=0; NEW(NN, nChn +3, Int4);
	for(N=1; N <= nPDB; N++){
	  // fprintf(stderr,"%d.%s\n",N+1,pdbid);
	  pdb_typ pdb = psd->RtnPDB(N);
	  if(trans) j=1; else j=0;
	  for(i=0 ; Chain[i]; i++,j++){
	   if(Chain[j]==0) j=0;
	   cI=GetChainNumberPDB(pdb,Chain[i]);
	   cJ=GetChainNumberPDB(pdb,Chain[j]);
	   if(cI == 0 || !IsProteinPDB(cI,pdb)) continue;
	   if(cJ == 0 || !IsProteinPDB(cJ,pdb)) continue;
	   if(efp) fprintf(efp,"============ %d%c:%d%c ==================\n",
				nI,Chain[i],nJ,Chain[j]);
	   dd=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cJ,N);
	   tri->AddValue(N,dd,i);
	   if(N==1){
		if(i==0) NEW(Value[0],nChn+3,double);
		Value[0][i]=dd;
	   } else if(N==Mid){
		if(i==0) NEW(Value[1],nChn+3,double);
		Value[1][i]=dd;
	   } else if(N==nPDB){
		if(i==0) NEW(Value[2],nChn+3,double);
		Value[2][i]=dd;
	   }
	   if(dd < this->UnDefHBond){ Sum[i] += dd; NN[i]++; }
	  } 
	  // tri->Put(stderr,N);
	}
	NEW(Value[3],nChn +3, double);
	double	rtn=DBL_MAX;
	char	nhits=0;
	if(1 || efp && nChn > 0){
	   for(Int4 x=0; Chain[x];x++){
	     dd=Sum[x]/(double) NN[x]; 
// if(dd > 99999.9) fprintf(stderr,"Sum[%d]=%.3lf; NN[%d]=%d\n",x,Sum[x],x,NN[x]);
	     Value[3][x]=dd;
	     rtn=MINIMUM(double,rtn,dd);
	     if(dd <= 2.5){
		Int4 y,r;
		if(trans){	// x = Ct & y = Rt or x = Lt & y = Ct
	   	   if(Chain[x+1]==0) y=0; else y=x+1;
		} else {	// x = Ct & x = Ct
		}
	     }
	   } 
	} free(Sum); free(NN);
	char cmd[200],str[10],CT='C';
	if(trans) CT='T';
	if(mode == 'S') sprintf(str,"sc2sc");
	else if(mode == 's') sprintf(str,"sc2bb");
	else if(mode == 'B') sprintf(str,"bb2bb");
	else print_error("This should not happen");
	sprintf(cmd,"sparc %s %s %s %d:%d%c\n",str,argv[2],argv[3],nI,nJ,CT);
	keytyp key=0;
	char **msgF=tri->RtnResults(key,Msg,cmd,trans,Value,'F');
	if(msgF){
	   if(rphF==0) rphF = new rph_typ(rpheap_size,nChn);
	   for(z=0; msgF[z]; ) z++;
	   msgF[z] = AllocString(StrI); z++; msgF[z] = AllocString(StrJ);
	   rphF->Insert(key,msgF);
Okay=TRUE;
	} else Okay=FALSE;
	char **msgS=tri->RtnResults(key,Msg,cmd,trans,Value,'S');
	if(msgS){
#if 0
	   for(z=0; msgS[z]; z++) fprintf(stdout,"%s",msgS[z]);
	   fprintf(stdout,"\n");
	   for(z=0; msgS[z]; ) z++;
	   msgS[z] = AllocString(StrI); z++; msgS[z] = AllocString(StrJ);
	   if(rphS==0) rphS = new rph_typ(rpheap_size,nChn);
	   rphS->Insert(-key,msgS);
#else
	   for(z=0; msgS[z]; z++) free(msgS[z]);
#endif
	}
	for(i=0; i<=3; i++) if(Value[i]) free(Value[i]);
	delete tri; tri=0;
	return rtn;
}

double	spc_typ::GetContactsPrep(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
		Int4 cI, Int4 cJ, Int4 X)
// Move this routine to libpdb.a at some point:
{
	if(cI==0 || cJ==0){ print_error("chain not found!"); }
	assert(psd != 0);
	pdb_typ P=psd->RtnPDB(X);
	res_typ ResI=psd->RtnResI(X,cI,resI);
	res_typ ResJ=psd->RtnResI(X,cJ,resJ);
	double Dd,dd=0.0;
	assert(ResI != 0  && ResJ != 0);
	if(ResI != 0  && ResJ != 0){
	   dd=this->GetHBonds(fptr,ResI,ResJ,cI,cJ,HA_dmax,P);
	   // I == donor; J == acceptor.
	   Dd=this->GetHBonds(fptr,ResJ,ResI,cJ,cI,HA_dmax,P);
	   // J == donor; I == acceptor.
	   dd = MINIMUM(double,dd,Dd);
	} return dd;
} 

