/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

double	spc_typ::Res2HetDriver(Int4 nII, char HetMol[], Int4 HetChn,
			BooLean noMainChn,Int4 setI)
{
     Int4   N,x,i,j,*num_resC,nI,nJ,nChn;
     char   chr=0,cI,hetchn=' ';
     a_type AB=0;
     for(nChn=0,i=0; Chain[i]; i++) nChn++;
     assert(psd);
     double dd,MinAvgDD=99999.0,*AvgDD; NEW(AvgDD,nChn+2,double);
     double *DD[5]; 
     Int4    nPDB=psd->NumPDB(),Mid=nPDB/2;
     char    **str,Str[200],s[50];
     pdb_typ pdb;
     NEW(DD[1],nChn+2,double); NEW(DD[2],nChn+2,double);
     NEW(DD[3],nChn+2,double);
     for(N=1,nI=0; N <= nPDB; N++){
	// fprintf(stderr,"N=%d; nPDB=%d\n",N,nPDB);
	pdb=psd->RtnPDB(N);
	res_typ	*ResI NEW(ResI,nChn+2,res_typ);
	for(i=0; Chain[i]; i++){
           j=GetChainNumberPDB(pdb,Chain[i]);
	   ResI[i]=psd->RtnResI(N,j,nII);
	}
	if(N==1){
	   AB=AminoAcidAlphabetPDB(pdb);
	   hetchn=ChainCharPDB(HetChn,pdb);
	   nI=ResidueID(ResI[0]); chr=GetCharResidue(ResI[0],AB);
	   if(PtrnSet){
	      char c='W';
	      if(setI) c=SbGrpCode[setI];
     	      sprintf(Str,".%c%d(%c) vs %c@%s\nchn: ",chr,nI,c,hetchn,HetMol);
	   } else {
     	      sprintf(Str,".%c%d vs %c@%s\nchn: ",chr,nI,hetchn,HetMol);
	   }
	   for(i=0; Chain[i]; i++){
		 sprintf(s,"\t%c",Chain[i]); strcat(Str,s);
	   } sprintf(s,"\n"); strcat(Str,s);
	}
	for(i=0; Chain[i]; i++){
	  dd=Res2HetDistance(ResI[i],HetMol,HetChn,nJ,noMainChn,pdb);
	  AvgDD[i]+=dd;
	  if(N==1) DD[1][i]=dd;
	  else if(N==Mid) DD[2][i]=dd;
	  else if(N==nPDB) DD[3][i]=dd;
	} free(ResI); 
     }
     for(i=0; Chain[i]; i++){
	 AvgDD[i]=AvgDD[i]/(double)nPDB;
	 MinAvgDD=MINIMUM(double,MinAvgDD,AvgDD[i]);
     }
     if(MinAvgDD > 3.0){ free(DD[1]); free(DD[2]); free(DD[3]); return 9999.0; }
     NEWP(str,20,char);
     str[0]=AllocString(Str);
     for(Int4 x=1; x <= 3; x++){
       for(i=0; Chain[i]; i++){
	if(i==0){
	  switch (x){
	    case 1: sprintf(Str,"Fst: "); break;
	    case 2: sprintf(Str,"Mid: "); break;
	    case 3: sprintf(Str,"Lst: "); break;
	    default: print_error("This should not happen\n");
	  }
	} sprintf(s,"\t%.2lf",DD[x][i]); strcat(Str,s);
       } strcat(Str,"\n"); str[x]=AllocString(Str);
     }
     for(i=0; Chain[i]; i++){
	if(i==0) sprintf(Str,"Avg: ");
	sprintf(s,"\t%.2lf",AvgDD[i]); strcat(Str,s);
     } strcat(Str,"\n"); str[4]=AllocString(Str);
     keytyp k=-MinAvgDD; 
     if(rphH == 0) rphH = new rph_typ(rpheap_size,nChn);
     rphH->Insert(k,str);
     free(DD[1]); free(DD[2]); free(DD[3]); free(AvgDD);
     return MinAvgDD;
}

double	spc_typ::Res2HetDistance(res_typ ResI, char HetMol[], Int4 HetChn,
			Int4 &R, BooLean noMainChn, pdb_typ P)
// Return minimum Res-HetMol distance ...
{
	Int4	ai,aj,r,i,j,h,x,nI,nJ;
	if(HetChn == 0){ print_error("chain not found!"); }
	a_type	AB=AminoAcidAlphabetPDB(P);
	atm_typ	atmI,atmJ,H;
	char	cI=GetCharResidue(ResI,AB); nI=ResidueID(ResI);
	double	d,dd=99999.0;
	Int4	a,c=HetChn;
	// fprintf(stderr,"%c%d: %d atoms.\n",cI,nI,P->natoms[c]);
	for(a=1; a <= P->natoms[c]; a++){
	   atmJ=P->atom[c][a];
	   // fprintf(stderr,"%d. %s\n",a,AtomResName(atmJ));
	   if(strncmp(HetMol,AtomResName(atmJ),4) == 0){
	     for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
	        atmI=AtomResidue(ai,ResI);
		if(noMainChn){
		    if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI))))
				continue;
		}
	   	d=(double)DistanceAtoms(atmI,atmJ);
		if(d < dd){ dd=d; R=ResAtom(atmJ); }
		if(!ResidueAtomHydrogens(ai,ResI)) continue;
		for(h=1; (H=ResidueAtomHydrogen(ai,h,ResI)); h++){
	   	   d=(double)DistanceAtoms(atmJ,H);
		   if(d < dd){ dd=d; R=ResAtom(H); }
		}
	     }
	   }
	}
	// resC=nI=ResidueID(ResI);
	// if(dd < 3.0) fprintf(stderr,"%d.%d: %d atoms\n",resC,c,P->natoms[c]);
	return dd;
} 

Int4	spc_typ::RunAllHetMol(char HetChn, char HetMol[],char HetAtm[],BooLean trans)
{
	Int4	N,i,j,x,MinRes,MaxRes,nI,nJ;
	pdb_typ	pdb=0;
	FILE	*ifp,*ofp=stdout,*efp=0;
	Int4	nChn,HetChnID;

	if(pmlfp) this->PutHeaderPyMOL();
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
        // 1. open up one of the structures for reference.
	pdb=psd->RtnPDB(1);
        MinRes=999999; MaxRes=0;
	HetChnID=GetChainNumberPDB(pdb,HetChn);
        for(i=0; Chain[i]; i++){
            j=GetChainNumberPDB(pdb,Chain[i]);
            if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
            if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
            else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
	}
        Int4	cI,cJ=GetChainNumberPDB(pdb,HetChn);
	a_type	AB=AminoAcidAlphabetPDB(pdb);
	set_typ Use=MakeSet(MaxRes+4); ClearSet(Use);
	double	dd,cut=2.5,cutX=3.0,Cut=0.01;
cut=3.0;
	BooLean	noMainChn=FALSE;
	for(nI=MinRes; nI <= MaxRes; nI++) {
#if 1
	     char setI=0;
	     if(PtrnSet && !MemberSet(nI,PtrnSet[0])){
		// if(!show_all && TopDC_Set && !MemberSet(nI,TopDC_Set)) continue;
		if(!show_all) continue;
	     }
	     if(PtrnSet){
                for(Int4 ii=1; PtrnSet[ii]; ii++){
                   if(MemberSet(nI,PtrnSet[ii])) setI=ii;
                }
             }
#endif
	     dd=Res2HetDriver(nI,HetMol,HetChnID,noMainChn,setI);
	     if(dd <= cut){
		if(pmlfp){
		   cI=GetChainNumberPDB(pdb,Chain[0]);
		   e_type Sq=GetPDBSeq(cI,pdb);
	     	   Int4 os=OffSetSeq(Sq);
		   Int4 ri=ResSeq(nI-os,Sq);
	     	   char rI=AlphaChar(ri,AB);
		   this->PutResiduePyMOL(ri,rI,nI,HetMol);
		}
	     }
	} NilSet(Use); // NilPDB(pdb);
	if(pmlfp) this->PutTailPyMOL();
	return 0;
}

Int4	spc_typ::CompareAltStruct(char HetMol[],char HetAtm[],BooLean trans)
// compare a pair of alternative structures to find changes in 3D contacts.
{
	Int4	N,i,j,x,MinRes,MaxRes,nI,nJ;
	char	pdbid[200];
	pdb_typ	pdb=0,PDB=0;
	FILE	*ifp,*ofp=stdout,*efp=0;
	Int4	nChn;

	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	// 1. open up one of the structures for reference.
	ifp=open_file(argv[2],"","r");
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ){
	  pdb = MakePDB(pdbid); N++; 
	  MinRes=999999;
	  MaxRes=0;
	  for(i=0; Chain[i]; i++){
		j=GetChainNumberPDB(pdb,Chain[i]);
		if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
		if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
	  } break;
	}
	assert(N > 0);
	PDB = MakePDB(pdbid); 
	fclose(ifp);
		
#if 0
	Int4	space=4;
    if(key==0){
	for(nI=key; nI == key; nI++){
	   for(nJ=MinRes; nJ <= MaxRes-space; nJ++) {
	      fprintf(stdout,"nI=%d; nJ=%d\n",nI,nJ);
	      this->RunOnePair(nI,nJ,Chain,HetMol,HetAtm,trans);
	   }
	}
    } else
#endif
    {
	i=GetChainNumberPDB(pdb,Chain[0]);
	Int4 II=GetChainNumberPDB(PDB,Chain[0]);
	e_type Sq=GetPDBSeq(i,pdb);
	a_type AB=AminoAcidAlphabetPDB(pdb);
	set_typ Use=MakeSet(MaxRes+4); ClearSet(Use);
	for(nI=MinRes; nI <= MaxRes; nI++) {
	   for(nJ=MinRes; nJ <= MaxRes; nJ++){
	     if(abs(nI-nJ) < 5) continue;
	     if(mode=='s' && nJ < nI) continue;  // only need to check one way.
	     double d=BigDist,dd,D=BigDist,DD=BigDist,Dd=BigDist,dD;
	     double e=BigDist,ee,E=BigDist,EE=BigDist,Ee=BigDist,eE;
	     double f,ff,F,FF,Ff;
#if 0
	     dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,pdb);
	     case 'D': { dd=this->Res2ResDistance(efp,nI,nJ,cI,cJ,pdb,noMainChn); } break;
#else
#endif
	     Int4	cI,cJ,cII,cJJ;
	     float	HA_dmax=2.5,dmax=3.6; 
	     double	cut=2.5,Cut=0.01,kut=30.0;
	     f=F=FF=Ff=0.0;
	     double	tmp;
	     double	Diff=2.0; // cut=4.0;
	     for(i=0; Chain[i]; i++){
	       j=i+1;
	       if(Chain[j]==0) j=0;
	       BooLean found=FALSE;
	       cI=GetChainNumberPDB(pdb,Chain[i]);
	       cJ=GetChainNumberPDB(pdb,Chain[j]);
	       cII=GetChainNumberPDB(PDB,Chain[i]);
	       cJJ=GetChainNumberPDB(PDB,Chain[j]); dd=ee=0.0;

	       if(DistancePDB(nI,"CA",cI,nJ,"CA",cJ,pdb) < 30.0){
	         dd=this->Res2ResDistance(efp,nI,nJ,cI,cJ,pdb,TRUE); 
	       }
	       if(DistancePDB(nI,"CA",cII,nJ,"CA",cJJ,PDB) < 30.0){
	         ee=this->Res2ResDistance(efp,nI,nJ,cII,cJJ,PDB,TRUE); 
	       } 
	       if(dd > 0.0 && ee > 0.0) tmp=fabs(dd-ee); else tmp=0.0;
	       if(tmp >= Diff && ((dd < cut && dd > Cut) ||
			(ee < cut && ee > Cut))){
		    if(f < tmp){ f=tmp; d=dd; e=ee; }
	       } dd=ee=0.0;

	       if(DistancePDB(nI,"CA",cJ,nJ,"CA",cI,pdb) < 30.0){
	         dd=this->Res2ResDistance(efp,nI,nJ,cJ,cI,pdb,TRUE); 
	       }
	       if(DistancePDB(nI,"CA",cJJ,nJ,"CA",cII,PDB) < 30.0){
	         ee=this->Res2ResDistance(efp,nI,nJ,cJJ,cII,PDB,TRUE); 
	       } 
	       if(dd > 0.0 && ee > 0.0) tmp=fabs(dd-ee); else tmp=0.0;
	       if(tmp >= Diff && ((dd < cut && dd > Cut) ||
			(ee < cut && ee > Cut))){
		    if(F < tmp){ F=tmp; D=dd; E=ee; }
	       } dd=ee=dD=eE=0.0;

	       if(DistancePDB(nI,"CA",cI,nJ,"CA",cI,pdb) < 30.0 ||
			DistancePDB(nI,"CA",cII,nJ,"CA",cII,PDB) < 30.0){
	         dd=this->Res2ResDistance(efp,nI,nJ,cI,cI,pdb,TRUE); 
	         ee=this->Res2ResDistance(efp,nI,nJ,cII,cII,PDB,TRUE); 
	       } 
	       if(dd > 0.0 && ee > 0.0) tmp=fabs(dd-ee); else tmp=0.0;
	       if(tmp >= Diff && ((dd < cut && dd > Cut) ||
			(ee < cut && ee > Cut))){ 
		  if(FF < tmp){ FF=tmp;  DD=dd; EE=ee; } 
	       }

#if 0
fprintf(stderr,"%d. --> %s; %.2f %.2f %.2f %.2f\n",i,Chain,d,D,DD,Dd);
fprintf(stderr,"       -->  %.2f %.2f %.2f %.2f\n",e,E,EE,Ee);
fprintf(stderr,"%d%c vs %d%c: %.2f %.2f %.2f %.2f\n",nI,Chain[i],nJ,Chain[j],f,F,FF,Ff);
#else
#endif
	     }
	     char Str[100];
	     Int4 os=OffSetSeq(Sq);
	     char rI=AlphaChar(ResSeq(nI-os,Sq),AB);
	     char rJ=AlphaChar(ResSeq(nJ-os,Sq),AB);
if(0) fprintf(stderr,"%c%d%c vs %c%d%c: %.2f %.2f %.2f\n",
			rI,nI,Chain[i],rJ,nJ,Chain[j],f,F,FF);
	     if(f > 0.0){
		   sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf.\n",rI,nI,rJ,nJ,d,e);
		   d=this->RunOnePair(nI,nJ,HetMol,HetAtm,TRUE,kut,ofp,Str);
		   PutSeqRegion(ofp,nI-os-1,3,Sq,AB);
		   fprintf(ofp,"  %.2f\n",f);
		   PutSeqRegion(ofp,nJ-os-1,3,Sq,AB); fprintf(ofp,"\n\n"); fflush(ofp);
	     }
	     if(F > 0.0){
		   sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf.\n",rI,nI,rJ,nJ,D,E);
		   D=this->RunOnePair(nJ,nI,HetMol,HetAtm,TRUE,kut,ofp,Str);
		   PutSeqRegion(ofp,nI-os-1,3,Sq,AB);
		   fprintf(ofp,"  %.2f\n",F);
		   PutSeqRegion(ofp,nJ-os-1,3,Sq,AB); fprintf(ofp,"\n\n"); fflush(ofp);
	     }
	     if(FF > 0.0){
		   sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf.\n",rI,nI,rJ,nJ,DD,EE);
		   Dd=DD=this->RunOnePair(nI,nJ,HetMol,HetAtm,FALSE,kut,ofp,Str);
		   PutSeqRegion(ofp,nI-os-1,3,Sq,AB);
		   fprintf(ofp,"  %.2f\n",FF);
		   PutSeqRegion(ofp,nJ-os-1,3,Sq,AB); fprintf(ofp,"\n\n"); fflush(ofp);
	     }
	  }
	} NilSet(Use);
	NilSeq(Sq); 
    }
	NilPDB(pdb);
	// free(MinRes); free(MaxRes);
	return 0;
}

