/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "spc_typ.h"

void spc_typ::sis_typ::AddSite(subunit Su, Int4 c, Int4 site)
{
	assert(c >= 0 && c < nChn);
	AddSet(site,StableSet[Su][c]);
}

void spc_typ::sis_typ::Init(char *chn, Int4 Len)
{
   StblChn[Lt]=StblChn[Ct]=StblChn[Rt]=0;
   for(nChn=0; chn[nChn]; ) nChn++;

   NEW(StableSet[Lt], nChn+4, set_typ);
   NEW(StableSet[Ct], nChn+4, set_typ);
   NEW(StableSet[Rt], nChn+4, set_typ);

   NEW(Chn,nChn+3,char);
   for(Int4 i=0; chn[i]; i++) Chn[i]=chn[i];
// fprintf(stderr,"--> nChn=%d; Len=%d\n",nChn,Len);
   if(StblChn[Lt]==0) NEW(StblChn[Lt],nChn,char);
   if(StblChn[Rt]==0) NEW(StblChn[Rt],nChn,char);
   if(StblChn[Ct]==0){
      NEW(StblChn[Ct],nChn,char);
      for(Int4 l=nChn-1,c=0,r=1; Chn[c]; c++,r++,l++){
	if(Chn[l]==0) l=0;
	if(Chn[r]==0) r=0;
	StblChn[Lt][c] = Chn[l];
	StblChn[Ct][c] = Chn[c];
	StblChn[Rt][c] = Chn[r];
      }
   }
   for(Int4 i=0; i < nChn; i++){ this->InitOneChn(i,Len); }
// fprintf(stderr,"--> Lt=%d; Ct=%d; Rt=%d\n",Lt,Ct,Rt);
}

void spc_typ::sis_typ::InitOneChn(Int4 c, Int4 Len)
{
   StableSet[Lt][c]=MakeSet(Len+4); ClearSet(StableSet[Lt][c]);
   StableSet[Ct][c]=MakeSet(Len+4); ClearSet(StableSet[Ct][c]);
   StableSet[Rt][c]=MakeSet(Len+4); ClearSet(StableSet[Rt][c]);
}

Int4  spc_typ::sis_typ::PutAll(FILE *fp)
{
	for(Int4 i=0; Chn[i]; i++){
		fprintf(fp,"===== residues forming stable H-bonds involving chain %c ======\n",Chn[i]);
		this->Put(fp,i); fprintf(fp,"\n");
	} return 0;
}

Int4  spc_typ::sis_typ::Put(FILE *fp,Int4 chn)
{
	int	i,j,left,right,N;
	char	c;
	Int4 *Lst=0;
	if(nChn > 1 && StableSet[Lt][chn]){
	  Lst=ListSet(Lt,chn);
	  for(j=1; Lst[j]; j++) fprintf(fp,"%d%c ",Lst[j],StblChn[Lt][chn]);
	  fprintf(fp,"\n"); free(Lst);
	}
	if(StableSet[Ct][chn]){
	  Lst=ListSet(Ct,chn);
	  for(j=1; Lst[j]; j++) fprintf(fp,"%d%c ",Lst[j],StblChn[Ct][chn]);
	  fprintf(fp,"\n"); free(Lst);
	}
	if(nChn > 1 && StableSet[Rt][chn]){
	  Lst=ListSet(Rt,chn);
	  for(j=1; Lst[j]; j++) fprintf(fp,"%d%c ",Lst[j],StblChn[Rt][chn]);
	  fprintf(fp,"\n"); free(Lst);
	} return 0;
}

void	spc_typ::sis_typ::Free()
{
	if(StblChn[Lt]) free(StblChn[Lt]);
	if(StblChn[Ct]) free(StblChn[Ct]);
	if(StblChn[Rt]) free(StblChn[Rt]);
	for(Int4 c=0; Chn[c]; c++){
	   if(StableSet[Lt][c]) NilSet(StableSet[Lt][c]);
	   if(StableSet[Ct][c]) NilSet(StableSet[Ct][c]);
	   if(StableSet[Rt][c]) NilSet(StableSet[Rt][c]);
	} 
	free(StableSet[Lt]); free(StableSet[Ct]); free(StableSet[Rt]);
	if(Chn) free(Chn);
	fprintf(stderr,"Hydrogen bond network analysis done.\n");
}

