/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "spc_typ.h"

Int4 spc_typ::rph_typ::PutHeader(FILE *fp,char mode,char *pdb_id)
/************************************************************
1(C): R396(R) vs E435(R): 16.45 20.25 1.60 1.60 (sc2sc)
Chn:    A       B       C       D       E       F
Fst:    1.837   1.758   1.829   1.741   1.605   1.714
Mid:    1.854   1.619   4.586   1.696   1.713   1.748
Lst:    1.773   1.739   6.056   1.692   1.682   1.800
Avg:    1.734   2.903   5.531   1.701   1.731   2.026
B: max H-bond=499/517; max close=2/5; max dist=153/160.
sparc sc2sc pdbPaths ABCDEF=3BA:6BBM_A 396:435C
 395  LNRSLEQRAD KRP VNSDLRESGS  397
 434  YHENSDLKGI AEI IIGKQRNGPI  436
 ************************************************************/
{
	if(mode=='F') 
         fprintf(fp,
	   "========== Residue pairs that both interact and separate: ==========\n");
	else if(mode=='p') 
         fprintf(fp,
	   "================ Correlated residue interactions: ================\n");
	else if(mode=='B') 
         fprintf(fp,
	   "========== Residue backbones that interact and separate: ==========\n");
	else if(mode=='H') 
         fprintf(fp,
	   "=============== Residue interactions with ligand: ===============\n");
	else if(mode !='S') print_error("rph_typ::PutHeader() error");
	else fprintf(fp,
	   "=============== Residue pairs that stably interact: ===============\n");
        if(pdb_id){
           fprintf(fp,"   Source pdb file for MD simulations = %s\n",pdb_id);
        }
        fprintf(fp,"syntax for first line:\n");
        if(mode == 'H') fprintf(fp,"  <id>. <res1>(grp1) vs <chn><ligand>:");
        else if(mode == 'p') fprintf(fp,
			"  <rank>. <res1>:<res2><code>_<res3>:<res4><code>\n");
        else fprintf(fp,"  <id>(<code>): <res1>(grp1) vs <res2>(grp2):");
        if(mode != 'p') fprintf(fp," <dst1> [<dst2>] (mode)\n");
        fprintf(fp," semantics for first line:\n");
	if(mode == 'p') fprintf(fp,"   <rank>: rank based on p-value.\n");
        else fprintf(fp,"   <id>: residue pair identifier.\n");
        if(mode != 'H') fprintf(fp,"   <code>: 'C' = cis; 'T' = trans.\n");
        if(mode != 'p'){
           fprintf(fp,"   <res1>: first residue and position.\n");
	}
	switch (mode){
	  case 'H':{
            // fprintf(fp,"        'W' = unclassified (white)\n");
            fprintf(fp,"   <chn>: second residue and position.\n");
            fprintf(fp,"   <ligand>: second residue and position.\n");
	  } break;
	  case 'p':{
           fprintf(fp,"   <res1>: 1st residue and position.\n");
           fprintf(fp,"   <res2>: 2nd residue and position.\n");
           fprintf(fp,"   <res3>: 3rd residue and position.\n");
           fprintf(fp,"   <res4>: 4th residue and position.\n");
	  } break;
	  default: {
           fprintf(fp,"        ' ' = unclassified (white)\n");
           fprintf(fp,"   <res2>: second residue and position.\n");
           fprintf(fp,"   <grp2>: single letter group code for second residue.\n");
           fprintf(fp,"   <dst1>: minimum cis distance in Angstroms\n");
           fprintf(fp,
		"   <dst2>: minimum trans distance (between homomeric subunits)\n");
	   fprintf(fp,
	   "====================================================================\n");
           fprintf(fp,"syntax for hydrogen bond lines:\n");
           fprintf(fp,
	   "  <chn>: H-bond=<int1>/<int2>; close=<int3>/<int4>; dist=<real1>/<real2>\n");
           fprintf(fp," semantics:\n");
           fprintf(fp,"   <chn>:         chain identifier\n");
           fprintf(fp,
	   "   <int1>/<int2>: longest stretch of hydrogen bonds/total bonds\n");
           fprintf(fp,
	   "   <int3>/<int4>: longest stretch of near hydrogen bonds/total\n");
           fprintf(fp,
	   "   <int5>/<int6>: longest stretch of separated residues/total\n");
	  } break;
	}
	fprintf(fp,"   <grp>: single letter group code for constrained residue.\n");
        fprintf(fp,"        'Y' = BPPS main group residue (yellow in pml file).\n");
        fprintf(fp,"        'R' = BPPS subgroup residue (red)\n");
        fprintf(fp,"        'O' = BPPS sub-subgroup residue (orange)\n");
        fprintf(fp,"        'G' = member of a top DC-scoring pair (green)\n");
	fprintf(fp,"            if -show option used:\n");
	fprintf(fp,"        'W' = unclassified (white)\n");
	fprintf(fp,
	   "====================================================================\n\n");
}

Int4 spc_typ::rph_typ::Put(FILE *fp)
{
    Int4 i,x,n=0;
    for(n=0; ItemsInMheap(mH) > 0; ){
      keytyp key = MaxKeyMheap(mH);
      x=DelMaxMheap(mH); n++;
      if(0) fprintf(stderr,"Delete: %d items in heap of size %d; x=%d; key=%.3lf\n",
              ItemsInMheap(mH),SizeMheap(mH),x,key);
      char **msg=MSG[x]; MSG[x]=0;
      fprintf(fp,"%d",n);
      for(i=0; msg[i]; i++){
// fprintf(stderr,"%s",msg[i]); 
         fprintf(fp,"%s",msg[i]); free(msg[i]);
      } free(msg); fprintf(fp,"\n"); fflush(fp);
    } return n;
}

Int4 spc_typ::rph_typ::Insert(keytyp key,char **str)
{
    Int4 x=0;
    keytyp k;
    if(FullMheap(mH)){
      if(k <= MinKeyMheap(mH)) return 0;
      x=DelMinMheap(mH);
      char **msg=MSG[x]; MSG[x]=0;
      for(x=0; msg[x]; x++) free(msg[x]);
    }
    if(0) fprintf(stderr,"Insert: %d items in heap of size %d; key=%.3lf\n",
              ItemsInMheap(mH),SizeMheap(mH),key);
    x=InsertMheap(key,mH); MSG[x]=str;
    return x;
}

void spc_typ::rph_typ::Init(Int4 n,Int4 nchn){
	N=n; mH=Mheap(N,3); NEWPP(MSG,N+5,char); 
}

void spc_typ::rph_typ::Free( ){
    Int4 i,x;
    for(i=1; ItemsInMheap(mH) > 0; i++){
      x=DelMinMheap(mH);
      char **msg=MSG[x]; MSG[x]=0;
      for(x=0; msg[x]; x++) free(msg[x]); free(msg);
    } NilMheap(mH); free(MSG);
}

