/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_IHD_TYP_)
#define _IHD_TYP_

#include "spc_typ.h"
#include "edc_typ.h"

// # using namespace std;

extern "C" int run_ccmpred(int argc, char **argv);

class ihd_typ { // Interacting heterodomain type.
public:
        ihd_typ( ) { assert(!"Illegal constructor"); }
        ihd_typ(int ac, char *av[]) { argc=ac; argv=av; Init( ); }
        ~ihd_typ( ) { Free(); }
	//============== ihd_run.cc ======================
        int	Run( );
private:
	//================= ihd_typ.cc ===================
	void	Init();
	void	Free();
	set_typ	GetDSets(Int4 run);
	Int4    FindProteinPairs( );
	void    RunCCMpred();
	char    *GetSubAln(char *filename,e_type SqX,BooLean Left);
	Int4    MakeJointAln(char *chn);
	pdb_typ MergeChainsPDB(char chnA, char chnB, pdb_typ P);
	//================= data types ===================
	double	nsd;	// number of stdev below the mean cutoff.
	FILE	*outfp;
	a_type  AB;
	Int4	device,thrds;
	float	MaxDist;
	cma_typ	cmaA,cmaB;
	char	ChnA,ChnB;
	char	*nameA,*nameB;
	pdb_typ	pdb,pdbAB;
	e_type  KeySqA,KeySqB;
	Int4	CA,CB;
	const Int4 LINESIZE=200;
	char	**argv,*Str;
	int	argc;
	Int4	time1;
};

#endif

