/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "scc_typ.h"

//***************** statistical tests for merging and ordering sets. *********************
double	*scc_typ::ConvertHGtoProb(h_type HG, Int4 &numbins,char mode)
	{
         double  *xval, *yval,*Prob=0,total;
         Int4    i,Total,NumBins=RtnHistArray(&xval,&yval,&Total,HG);
	 numbins=NumBins;
         if(Total < 1) print_error("ConvertHGtoProb( ) input error");
	 NEW(Prob,NumBins+5,double);
	 if(mode=='R'){
	   double tiny=0.0000000001;
	   total = (double) Total + (NumBins+2)*tiny;
           for(i=0; i<=NumBins+1; i++){ Prob[i]=(yval[i] + tiny)/total; }
	 } else {
	   total = (double) Total;
           for(i=0; i<=NumBins+1; i++){ Prob[i]=yval[i]/total; }
	 } free(xval); free(yval);
	 return Prob;
	}

double	scc_typ::ComputeJSD(h_type HG1,h_type HG2)
	{
	  Int4	   i,n1,n2;
	  double   t1,t2,*m,JSD,*p=ConvertHGtoProb(HG1,n1,0),*q=ConvertHGtoProb(HG2,n2,0);
	  if(p == 0 || q == 0 || n1 != n2) print_error("ComputeJSD() input error");
	  NEW(m,n1+3,double);
	  for(i=0; i <= n1; i++){ m[i] = (p[i]+q[i])/2.0; }
	  for(JSD=0.0,i=0; i <= n1; i++){
	        if(m[i] > 0){
			if(p[i] > 0) t1 = p[i]*log(p[i]/m[i]); else t1=0;
			if(q[i] > 0) t2 = q[i]*log(q[i]/m[i]); else t2=0;
			JSD += (t1 + t2)/2.0; 
		}
	  } free(p); free(q); free(m);
	  return JSD;
	}
double	scc_typ::ComputeRelativeEntropy(h_type HG1,h_type HG2)
	{
	  Int4 i,n1,n2;
	  double   RE,*p=ConvertHGtoProb(HG1,n1,'R'),*q=ConvertHGtoProb(HG2,n2,'R');
	  if(p == 0 || q == 0 || n1 != n2){
		 print_error("ComputeRelativeEntropy() input error");
	  }
	  for(RE=0.0,i=0; i <= n1; i++){ RE += p[i]*log(p[i]/q[i]); }
	  free(p); free(q); 
	  return RE;
	}
long double	scc_typ::DoExactTest(set_typ SetI, set_typ SetJ, long double &onetail)
	// double onetail,twotail;
                // twotail=DoExactTest(SetI,SetJ,onetail);
                // fprintf(ptrn_fp,"  Exact 2-tail(%d,%d) = %.3f\n",SetID[i],SetID[j],-log(twotail));
	{
		Int4 red_in,black_in,red_out,black_out;
		long double twotail;
		red_out=CardInterSet(SetI,SetJ); 
		black_out=CardInterSetINotJ(SetI,SetJ);
		red_in=CardInterSetNotIJ(SetI,SetJ);
		black_in = (SetSize -1) - (red_in  + black_out + red_out) - NumRandom;
		twotail=FisherExactTest(0, red_in,black_in,red_out,black_out,onetail);
		return twotail;
	}

