/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "omc_typ.h"
#include "blosum62.h"

double	*omc_typ::FindCrossConserved(Int4 key, FILE *ofp)
// double  *omc_typ::CrossConservedPttrn(Int4 key, FILE *ofp)
// find and return cross conserved patterns.
{
	FILE *efp=0; // efp=stderr;
	this->ScoreFGvsEachBG(key, ofp); // return 0;
	// 0. Make sure that key is a leaf node so that ncludes all of lineage.
	if(Hpt->IsLeafNode(key) == FALSE) return 0;
	// fprintf(stderr,"key=%d;Length=%d\n",key,LengthCMSA(1,TrueMainCMA));
	// 1. Get the Hpt node sets.
	if(0 && ofp) mcs->PutHyperPartition(ofp);
	set_typ	FGSet,LineSet;
	FGSet=MakeSet(Hpt->NumSets()+3); ClearSet(FGSet); AddSet(key,FGSet);

	// 2. Get the corresponding sequence sets.
	mcs->RestoreBest();
	set_typ	setFG,*SqSet=mcs->CopyOfSeqSets();
	setFG=SqSet[key]; 
	// if(ofp) fprintf(ofp,"FG=%d\n",CardSet(setFG)); 

	// 3. Get optimum residue patterns at each position
	double	DD,Lpr=0.0,*subLPR=0;
	Int4	r,s;
	sst_typ *xsst=lpr->GetOptPttrnLPR(efp,setFG,Lpr,'M',subLPR);

#if 1	// check relationship of FG to each BG set individually
	Int4	*Parent;
	Hpt->IsScrambledTree(Parent);
	set_typ	BGSet=Hpt->DescendantSet(Parent[key]);
	AddSet(Parent[key],BGSet);
	for(Int4 i=1; i <= Hpt->NumSets(); i++){
	   if(MemberSet(i,FGSet)) DeleteSet(key,BGSet);
	}
	// set_typ	FGset=Hpt->DescendantSet(key);
	// AddSet(key,FGset);
	// if(ofp){ PutSet(ofp,FGSet); PutSet(ofp,BGSet);}
	set_typ allBG=CopySet(setFG); ClearSet(allBG);
	sst_typ *zsst=0;
	unsigned char *rtn_csq=0;
	if(ofp) fprintf(ofp,"=== %d.%s (%d) pattern LPR for:\n",
			key, Hpt->SetName(key),CardSet(setFG));
	if(ofp) fprintf(ofp,"row\tset\tsize\tLPR\n");
	for(Int4 i=1; i <= Hpt->NumSets(); i++){
	   if(MemberSet(i,BGSet)){
		set_typ setBG=SqSet[i];
		zsst=lpr->GetOptPttrnLPR(efp,setFG,setBG,FALSE,Lpr,25,rtn_csq);
		// 'M',TmpE,pRi);
		if(ofp)fprintf(ofp,"%d\t%s\t%d\t\t%.1lf\n",i,Hpt->SetName(i),
			 CardSet(setBG),Lpr);
		UnionSet(allBG,setBG); free(zsst); free(rtn_csq);
	   }
	}
	zsst=lpr->GetOptPttrnLPR(efp,setFG,allBG,FALSE,Lpr,25,rtn_csq);
	if(ofp) fprintf(ofp," all (%d): Lpr=%.2lf\n",CardSet(allBG),Lpr);
	free(zsst); free(rtn_csq);
#endif

	// 4. For each position and each residue patterns at each position
	BooLean	skip;
	che_typ **che=mcs->RtnChe( );   
	set_typ LngSet=Hpt->MkLineageSet(key);
	// che[key]->PutBestPatterns(stderr,TRUE);

	// 4.1 print out xcs file for PyMOL.
	static Int4 calls=0;
        if(calls==0){ sprintf(str,"%s.xcs",infile); remove(str); } calls++;
	FILE	*xfp=0; 
	Int4	ptrn=0,hits=0;
	dh_type   dH=dheap(LengthCMSA(1,TrueMainCMA)+9,3);
	for(r=1; r <= LengthCMSA(1,TrueMainCMA); r++){ 
	    // 6.1. Skip over 
	    if(xsst[r]){
	        if(che[1]->PttrnPos(r)){ subLPR[r] = -1.0; continue; }
	        for(skip=FALSE,s=1; s <= Hpt->NumSets(); s++){
		  if(MemberSet(s,LngSet) && che[s]->PttrnPos(r)){ skip=TRUE; break; }
	        }
	        if(skip){ subLPR[r] = -1.0; continue; }
		if(subLPR[r] >= 1.0){
#if 0		  // output cross conserved residues.
		  if(ptrn==0){
		    xfp=open_file(infile,".xcs","a");
		    fprintf(xfp,"%d.%s:",key,Hpt->SetName(key));
		  } ptrn++;
		  che_typ **che=mcs->RtnChe( );
              	  if(ptrn > 1) fprintf(xfp,",");
		  PutSST(xfp,xsst[r],AB); fprintf(xfp,"%d",r); 
#else
		  insrtHeap(r,(keytyp)-subLPR[r],dH);
#endif
		  if(ofp){
		    if(hits==0) fprintf(ofp,"======== Cross conserved residues =======\n");
		    PutSST(ofp,xsst[r],AB); fprintf(ofp,"%d ",r); 
		    fprintf(ofp,"Lpr=%.3lf\n",subLPR[r]);
		  } 
		  hits++;
		} else subLPR[r]=-1.0;
	    } else subLPR[r] = -1.0;
	} if(ofp) fprintf(ofp,"\n");
#if 1
	for(ptrn=1; !emptyHeap(dH); ptrn++){
	    r=delminHeap(dH);
	    if(ptrn==1){
		xfp=open_file(infile,".xcs","a");
		fprintf(xfp,"%d.%s:",key,Hpt->SetName(key));
	    }
	    che_typ **che=mcs->RtnChe( );
            if(ptrn > 1) fprintf(xfp,",");
	    PutSST(xfp,xsst[r],AB); fprintf(xfp,"%d",r); 
	}
#endif
	if(xfp){ fprintf(xfp,"\n"); fclose(xfp); xfp=0; }
	NilSet(LngSet); NilSet(FGSet); free(xsst); 
	for(Int4 g=1; g <= Hpt->NumSets(); g++){ NilSet(SqSet[g]); }
	free(SqSet);
	return subLPR;
}

double	omc_typ::ScoreFGvsEachBG(Int4 key, FILE *ofp)
// check relationship of each FG set to each BG set individually
{
	FILE *efp=0; // efp=stderr;
	double	Lpr=0.0,*subLPR=0,*subFG=0;
	Int4	i,j,k,r,s,x,*Parent;

	// 0. Make sure that key is not the root node.
	if(key <= 1 || key > Hpt->NumSets()) return 0.0;
	// fprintf(stderr,"key=%d;Length=%d\n",key,LengthCMSA(1,TrueMainCMA));

	// 1. Get the Hpt FG  and BG node sets.
	mcs->RestoreBest();
	set_typ	allBG,setFG,setBG,*SqSet=mcs->CopyOfSeqSets();
	set_typ	FGSet=Hpt->DescendantSet(key); AddSet(key,FGSet);
	Hpt->IsScrambledTree(Parent);
	set_typ	BGSet=Hpt->DescendantSet(Parent[key]);
	AddSet(Parent[key],BGSet); 
	for(i=1; i <= Hpt->NumSets(); i++){
	   if(MemberSet(i,FGSet)) DeleteSet(i,BGSet); 
	}
	if(ofp){ fprintf(ofp,"FG:"); PutSet(ofp,FGSet); }
	if(ofp){ fprintf(ofp,"BG:"); PutSet(ofp,BGSet); }

	// 2. Get Lpr and residue pattern for each set
	allBG=CopySet(SqSet[key]); 
	sst_typ *zsst=0,*psst=0;
	unsigned char *rtn_csq=0;
	che_typ **che=mcs->RtnChe( );
	float *prctMtch=0,*prctFG=0;
	for(i=1; i <= Hpt->NumSets(); i++){
	  if(MemberSet(i,FGSet)){
	    setFG=SqSet[i];
	    if(0 && ofp) fprintf(ofp,"=== %d.%s (%d) FG vs shuffled FG as BG\n",
		key,Hpt->SetName(i),CardSet(setFG));
	    ClearSet(allBG);
	    Int4 Hits=0;
	    for(x=0; x <= Hpt->NumSets(); x++){
	      if(x==0) j=key; else j=x;
	      if(x==0 || MemberSet(j,BGSet)){
		setBG=SqSet[j];
		psst=this->RtnCopyOfSST(i);
		// BG as FG set vs FG pattern with shuffled as BG set.
		subLPR=lpr->GetPttrnSubLPR(efp,setBG,Lpr,'M',psst,prctMtch);
		if(x > 0 && ofp) fprintf(ofp," %d.%s (%d): Lpr=%.1lf\n",
				j,Hpt->SetName(j),CardSet(setBG),Lpr);
	    	for(k=1; k <= mcs->RtnLengthMainCMSA(); k++){
	           if(che[i]->PttrnPos(k)){ 
		     if(ofp && x > 0 && psst[k] && subLPR[k] > 0.0){
		        if(Hits ==0){
			   fprintf(ofp,
			    "    pttrn     LprBG(vs random) LprFG(vs random)\n");
			} Hits++;
#if 1			// need about 8 byte length
			char STR[23],istr[50];
			// Int4 sz=CardSST(psst,AB);
			PutSST(STR,psst[k],AB);
			sprintf(istr,"%s%d",STR,k);
			Int4 sz = strlen(istr);
			fprintf(ofp,"%9s",istr);
			fprintf(ofp," %8.1lf (%4.1f%c)",subLPR[k],prctMtch[k],'%'); 
			fprintf(ofp," %8.1lf (%4.1f%c)\n",subFG[k],prctFG[k],'%'); 
#else
			fprintf(ofp," "); PutSST(ofp,psst[k],AB); 
			fprintf(ofp,"%d\t%.1lf\t%.1f%c",k,subLPR[k],prctMtch[k],'%'); 
			fprintf(ofp,"\t%.1lf\t%.1f%c\n",subFG[k],prctFG[k],'%'); 
#endif
		     }
		   } 
		} free(psst); 
		if(x > 0){ free(subLPR); delete [] prctMtch; prctMtch=0; }
		else { subFG=subLPR; prctFG=prctMtch; }
		// 'M',TmpE,pRi);
		// bpps_typ *pps=che[j]BPPS();
		// double  *RtnSubLPR(UInt4 **CntBG,UInt4 **CntFG);
		// double  *SubLPR(UInt4 **CntBG,UInt4 **CntFG);
		UnionSet(allBG,setBG); 
		if(zsst){ free(zsst); zsst=0; }
		if(rtn_csq){ free(rtn_csq); rtn_csq=0; }
	      }
	      if(x==0 && ofp) fprintf(ofp,"=== %d.%s (%d) pattern for BG sets as FG:\n",
				key,Hpt->SetName(i),CardSet(setFG));
	    }
	    if(subFG) free(subFG);
	    if(prctFG){ delete [] prctFG; prctFG=0; }
	    zsst=lpr->GetOptPttrnLPR(efp,setFG,allBG,FALSE,Lpr,25,rtn_csq);
	    if(ofp) fprintf(ofp," all (%d): Lpr=%.1lf\n",CardSet(allBG),Lpr);
	    if(zsst){ free(zsst); zsst=0; }
	     if(rtn_csq){ free(rtn_csq); rtn_csq=0; }
	  }
	}
	NilSet(FGSet); NilSet(BGSet); 
	for(Int4 g=1; g <= Hpt->NumSets(); g++){ NilSet(SqSet[g]); }
	free(SqSet);
	return 0.0;
}

