#if !defined (MAPGAPS_USAGE)
#define MAPGAPS_USAGE

#define MGS_VERSION "\
  ----------------------------------------------------\n\
     MAPGAPS v2.1.5 (March 19, 2020)\n\
     www.igs.umaryland.edu/labs/neuwald/software/mapgaps/\n\
     Copyright 2016-2020 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_START "\
  Multiply Aligned Profiles for Gapped Alignment of Protein Sequences\n\
  Usage 1(for creating profiles): mapgaps <prefix> \n\
    Options: none\n\
    Input (required): \n\
	   <prefix>.tpl: Template alignment in cma format.\n\
	   <prefix>.cma: concatenated alignments in cma format.\n\
             (Use the ftc program to convert fasta MSA files to cma format.)\n\
             Note: CDD-based concatenated alignments require an .mma suffix.\n\
          (optional): \n\
           <prefix>.xpa concatenated cma formatted MSAs of false positive proteins.\n\
    Output: <prefix>.mpa: profiles required for searches.\n\
           <prefix>.dft: Depth first search tree.\n\
           <prefix>.xpq: excluded profiles query seqs; if *xpa file was provided).\n\
           <prefix>.xup: excluded unaligned profiles; if *xpa file was provided).\n\
  Usage 2(for searches): mapgaps <prefix> <database> [options]\n\
    Options: type 'mapgaps -' for search options\n\
    Input (required): \n\
	   <prefix>.mpa: profiles.\n\
           <prefix>.tpl: Template alignment in cma format.\n\
          (optional): \n\
           <prefix>.dft: depth first search tree representing the template hierarchy.\n\
           <prefix>.xpq: excluded profiles query seqs.\n\
           <prefix>.xup: excluded unaligned profiles.\n\
    Output: <database>_A.cma: alignment of sequences found.\n\
            <database>_A.seq: fasta file of sequences found.\n\
  References:\n\
    Neuwald, A.F. Rapid detection, classification and accurate alignment of up to \n\
     a million or more related protein sequences.  Bioinformatics 2009. 25: 1869-1875\n\
    Neuwald, A.F., L. Aravind & S.F. Altschul. Inferring Joint Sequence-Structural\n\
      Determinants of Protein Functional Specificity. eLife 2018. \n\
      doi: 10.7554/eLife.29880.001 .\n\
  Funding: National Institutes of Health, National Institute of \n\
      General Medical Sciences grants GM078541 and R01GM125878.\n\
\n"

#define USAGE_MGS "Usage: mapgaps <query_prefix> <dbsfile> [options]\n\
    Input: <prefix>.mpa: profiles.\n\
           <prefix>.tpl: Template alignment in cma format.\n\
           <prefix>.dft: Optional depth first search tree.\n\
    Output: <dbsfile>_A.cma: alignment of sequences found.\n\
            <dbsfile>_A.seq: fasta file of sequences found.\n\
    Options:\n\
        -D        Don't mask low complexity regions in template sequences.\n\
        -e=<real> E-value cutoff (after accounting for the database size).\n\
                  default: 0.01/number of profiles\n\
        -H=<int>  heapsize (default: 2,000,000)\n\
        -I=<int>:<int> - lengths of left & right flanking regions to be retained (default: 10:10)\n\
        -l        do low complexity masking of database sequences\n\
        -L        do low complexity and coiled coil masking of database sequences\n\
        -O        output sequence hits in separate files for each profile\n\
        -pdbaa=<file> After the initial search, also search the NCBI pdbaa=<file>\n\
                  so that proteins of known structure may be added to the output MSA\n\
                  with identical sequences in the initial alignment removed.\n\
        -Refine=<int1>:<int2> Refine the output alignment by retaining \n\
                  sequences with no more than <int1> percent identity and \n\
                  with more than <int2> percent aligned residues. \n\
                  (default: 100% identity; 0% aligned residues).\n\
            Note: By default all sequences are retained; pdbaa sequences are always retained.\n\
        -sense=<real>  sensitivity parameter for heuristic search \n\
                   range: 0.01...1.0; lower values: > sensitivity (default: 0.05)\n\
        -size=<int>  set effective length of the database (default: actual database size)\n\
        -T=<int>  blast word hit threshold (default: 11)\n\
        -trigger=<real>  Number of bits to trigger gapping = <real> (default: 22.0)\n\
        -X=<int>  X dropoff for BLAST gapxdrop (default: 25)\n\
\n"

#endif

