/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "stdinc.h"
#include "afnio.h"
#include "random.h"
#include "histogram.h"

#define LOGSUM_TBL 20000

#if 0	// Spouge Gaussian random Variable code...
Hi, Andy.

The easiest thing is to give you the routine below.  It requires a uniform
variate on [-1.0, 1.0], easily derived from a random number generator, and
the log function.  The idea is that the coordinates of a two-dimensional
normal random variate can be generated by an exponential (0.5) variate,
derived here from the log (uniform variate) for its radius, multiplied by
cos and sin for the individual coordinates.

If you are in any way dissatisfied with the service, it will cost you
double, but let me know :)

John
double Nks::Normal::StandardVariate () // returns RV normal (0, 1)
{
   	static bool logGot = false;
        static double gotVariate;
        double factor, v1, v2, rsquare;
        if(logGot){ logGot = false; return gotVariate; }
	else {
          logGot = true;
          do {
         	v1 = Nks::Uniform::Variate (-1.0, 1.0);
         	v2 = Nks::Uniform::Variate (-1.0, 1.0);
                rsquare = v1 * v1 + v2 * v2;
          } while (rsquare > 1.0);
          factor = sqrt (-2.0 * log (rsquare) / rsquare);
          gotVariate = factor * v1;
	  return factor * v2;
        }
}
#endif

double	Uniform_MinusOneToOne( )
{
	register double v;
	do { v=(2.0*SampleUniformProb()) - 1.0; } while(v > 1.0 && v < -1.0);
	return v;
}

double	StandardVariate() // returns RV normal (0,1)
{
	static BooLean logGot = FALSE;
        static double gotVariate;
        register double factor, v1, v2, rsquare;

        if(logGot){
                logGot = FALSE;
		return gotVariate;
        } else {
                logGot = TRUE;
                do {
         		v1 = Uniform_MinusOneToOne( );
         		v2 = Uniform_MinusOneToOne( );
                        rsquare = v1 * v1 + v2 * v2;
                } while (rsquare > 1.0);
                factor = sqrt (-2.0 * log (rsquare) / rsquare);
                gotVariate = factor * v1;
		return factor * v2;
        }
}

double	GaussRandom(double mean, double stddev)
{ return (StandardVariate()*stddev + mean); }

#if 0
double ExtremeValueP(float x, float mu, float lambda)
{
  double y;
                        /* avoid overflow fp exceptions */
  if ((lambda * (x - mu)) < -1. * log(log(DBL_MAX))) return 1.0;
                        /* avoid underflow fp exceptions */
  if ((lambda * (x - mu)) > log(DBL_MAX)) return 0.0;
                        /* a roundoff issue arises; use 1 - e^-x --> x for small x */
  y = exp(-1. * lambda * (x - mu));
  if (y < 1e-7) return y;
  else          return (1.0 - exp(-1. * y));
}
#endif

double EVD_Pvalue(float x, float mu, float lambda)
// Calculate P(S>x)  for an extreme value distribution with
// characteristic value mu and decay constant lambda.
{
  double y;
  static double log_dbl_max=0;

  if(log_dbl_max==0) log_dbl_max = log(DBL_MAX);
  if((lambda * (x-mu)) < -1.*log(log_dbl_max)) return 1.0; // avoid overflow 
  if((lambda * (x-mu)) > log_dbl_max) return 0.0; // avoid underflow 
  y = std::exp(-1. * lambda * (x - mu));
  if (y < 1e-7) return y; // avoids roundoff error because 1-e^-x -> x as x -> 0.
  else return (1.0 - std::exp(-1. * y)); 
}

#define sreEXP2(x)  (std::exp((x) * 0.69314718 ))
#define sreLOG2(x)  ((x) > 0 ? log(x) * 1.44269504 : -9999.)

double EVD_Evalue(float x, float mu, float lambda, int N)
{
	double pval;
	if(x >= sreLOG2(DBL_MAX)) pval = 0.0;
	else pval = 1. / (1.+sreEXP2(x));

	// double pval2 = ExtremeValueP(x,mu,lambda);
	double pval2 = EVD_Pvalue(x,mu,lambda);
	if (pval2 < pval) pval = pval2;
//	fprintf(stderr,"score = %g; pval = %g; mu = %g; lambda = %g\n",
//        		x,pval,mu,lambda);
	return N*pval;
	// return (double)N * EVD_Pvalue(x,mu,lambda); 
}



////// Sean Eddy's routine! ////////

/* Function: ILogsum()
 *      
 * Purpose:  Return the scaled integer log probability of
 *           the sum of two probabilities p1 and p2, where
 *           p1 and p2 are also given as scaled log probabilities.
 *
 *           log(exp(p1)+exp(p2)) = p1 + log(1 + exp(p2-p1)) for p1 > p2
 *
 *           For speed, builds a lookup table the first time it's called.
 *
 * Args:     p1,p2 -- scaled integer log_2 probabilities to be summed
 *                    in probability space.  
 *
 * Return:   scaled integer log_2 probability of the sum.
 */
Int4 ILogsum(Int4 p1, Int4 p2, Int4 INTSCALE)
{
  static Int4 firsttime = 1;
  static Int4 lookup[LOGSUM_TBL];
  Int4    diff;
  Int4    i;
        
  if (firsttime) {
    for (i = 0; i < LOGSUM_TBL; i++)
      lookup[i] = (int) (INTSCALE * 1.44269504 *
                         (log(1.+std::exp(0.69314718 * (float) -i/INTSCALE))));
    firsttime = 0;
  }
        
  diff = p1-p2;
  if      (diff >=  LOGSUM_TBL) return p1;
  else if (diff <= -LOGSUM_TBL) return p2;
  else if (diff > 0)            return p1 + lookup[diff];
  else                          return p2 + lookup[-diff];
}
        

