#if !defined (GISMO_USAGE)
#define GISMO_USAGE

#define GISMO_VERSION "\
  ----------------------------------------------------\n\
     GISMO v3.1.1 by aneuwald@som.umaryland.edu\n\
     www.igs.umaryland.edu/labs/neuwald/software/gismo/\n\
     Copyright 2015-2020 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_GISMO "\
Gibbs Sampler for Multi-alignment Optimization\n\
Usage: gismo fastafile [options] \n\
  options:\n\
       -h=<int>        - Number of initial block-based alignments = N (2 to 50: default 2)\n\
       -H=<int>        - Number of candidate HMM alignments (2 to 50: default 2)\n\
       -iters=<int>    - Add/remove column interations in stages 2 to 4 (1 to 5: default 3)\n\
       -L              - Mask low complexity regions (default: off)\n\
       -maxseq=<int>   - Set the maximum number of input sequences (default: 20,000)\n\
       -msa            - save the best block-based msa found in the 1st phase.\n\
       -thrds=<int>    - Use multithreading with <int> threads (range: 2 to 100; default: 1)\n\
                         Note: the best alignment among the threads will be saved.\n\
       -rtf            - Also output a MS-Word-viewable rich text file (*.rtf)\n\
       -seed=<int>     - Random seed\n\
       -stages=<int>   - Specify the number of sampling stages (2 to 4: default 2)\n\
    References:\n\
       Neuwald, A.F. A fast, parallelized version of the GISMO multiple sequence \n\
         alignment program. In preparation.\n\
       Neuwald, A.F and S. F. Altschul. 2016. Bayesian Top-down Protein Sequence \n\
         Alignment with Inferred Position-Specific Gap Penalties. \n\
         Plos Comp. Biol. 12(5): e1004936\n\
       Neuwald A.F. and Liu J.S. 2004. Gapped alignment of protein sequence motifs\n\
         through Monte Carlo optimization of a hidden Markov model.\n\
         BMC Bioinformatics 5: 157 \n\
    Funding: \n\
       National Institutes of Health, National Library of Medicine grant LM06747\n\
       National Institute of General Medical Sciences grants R01GM078541 & R01GM125878\n\
\n"


#endif

