/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_SSD_TYP_)
#define _SSD_TYP_

#include "stdinc.h"
#include "histogram.h"
#include "dheap.h"
#include "afnio.h"
#include "cmsa.h"

// # using namespace std;

class ssd_typ {         // subsample darc type
public:
        ssd_typ(){ print_error("ssd_typ( ) constructor disallowed"); }
        ssd_typ(Int4 co, Int4 sl,Int4 ct){ Init(co,sl,ct); }
        ~ssd_typ( ){ Free(); }
	BooLean	IsEmpty(){ return emptyHeap(dH); }
	Int4	**PutSorted(FILE *fp,ssd_typ *ssd2,ssd_typ *ssd3,ssd_typ *ssd4,
							FILE *pfp=0,char chn=0,Int4 OS=0);
	// void	Put(FILE *fp,FILE *pfp=0);
        Int4    RtnCut(){ return AmongTop; }
        unsigned short   RtnXY(Int4 x, Int4 y){ return XY[x][y]; }
	Int4	AddToHeap(Int4 x, Int4 y, Int4 ii, Int4 jj, Int4 cI, Int4 cJ, double d);
	void	IncXY(Int4 x, Int4 y){ XY[x][y]++; XY[y][x]++; } // increment the number of hits
	void	SetXY(Int4 x, Int4 y, unsigned short v){ XY[x][y]=XY[y][x]=v; } // set number of hits
	Int4	RtnNumInHeap(){ if(dH) return ItemsInHeap(dH); else return 0; }
private:
	void	Free();
	void	Init(Int4 co, Int4 sl,Int4 ct);
        UInt2   *I,*J,*Y,*X;
        char    *CI,*CJ;
        double  *D;
        dh_type dH;
        unsigned short **XY, Cut;         // Cut to print score...1..50/100
        Int4    NN,k,sqlen,AmongTop;	// AmongTop = 20, 10, 5, 2...
	Int4	maxPairs;
};

#endif

