/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "ssd_typ.h"

void	ssd_typ::Init(Int4 co,Int4 sl,Int4 ct)
{
	assert(ct > 0 && ct <= 100);  NN=0;
        AmongTop=co; sqlen=sl; Cut=(unsigned short) ct; k=0;
	maxPairs=sqlen*(sqlen-1)/2;	// guarranteed to be an integer;
	dH=dheap(maxPairs+2,4);
        NEW(I,maxPairs+2,UInt2); NEW(J,maxPairs+2,UInt2);
        NEW(X,maxPairs+2,UInt2); NEW(Y,maxPairs+2,UInt2);
        NEW(CI,maxPairs+2,char); NEW(CJ,maxPairs+2,char);
        NEW(D,maxPairs+2,double); NEWP(XY,sqlen+2,unsigned short);
        for(Int4 j=1; j <= sqlen; j++) NEW(XY[j],sqlen+2,unsigned short);
}

void	ssd_typ::Free( )
{
        free(I); free(J); free(X); free(Y); free(CI); free(CJ); free(D);
        for(Int4 j=1; j <= sqlen; j++) free(XY[j]); free(XY);
        Nildheap(dH);
}

Int4	**ssd_typ::PutSorted(FILE *fp,ssd_typ *ssd2,ssd_typ *ssd3,ssd_typ *ssd4, FILE *pfp,char chn,Int4 OS)
{
	Int4	K,i,x,y,ii,jj,sum,Nout;
	char	cI,cJ;
	double d,Dd,max=0.0;
	// fprintf(stderr,"Items in heap=%d; seqlen=%d\n",ItemsInHeap(dH),sqlen); fflush(stderr);
	dh_type dH2=dheap(maxPairs+2,4);
	for(i=1; !emptyHeap(dH); i++){
           	    d=minkeyHeap(dH); assert((K=delminHeap(dH)) != 0);
           	    x=X[K]; y=Y[K]; ii=I[K]; jj=J[K]; cI=CI[K]; cJ=CJ[K];
		    sum=XY[x][y]+ssd2->RtnXY(x,y)+ssd3->RtnXY(x,y)+ssd4->RtnXY(x,y);
		    Dd = (double)sum + D[K]/10.0;
		    max=MAXIMUM(double,max,Dd);
		    insrtHeap(K,-Dd,dH2);
	} K=0;
	x=(Int4)ceil(max+1.0); d=ceil((max/25.0));
	h_type  HG=0;	// HG=Histogram("Subsampling scores",0,x,d);
        // fprintf(fp,"rank\tresI\tresJ\tcolI\tcolJ\tDCA\ttop20\ttop10\ttop5\ttop2\tsum\tscore\n");
	Int4	**ColPair; 
	NEWP(ColPair,4, Int4);
	NEW(ColPair[1], (ItemsInHeap(dH2))+5,Int4);
	NEW(ColPair[2], (ItemsInHeap(dH2))+5,Int4);
	for(Nout=0,i=1; !emptyHeap(dH2); i++){
           d=-minkeyHeap(dH2); assert((K=delminHeap(dH2)) != 0);
           x=X[K]; y=Y[K]; ii=I[K]; jj=J[K]; cI=CI[K]; cJ=CJ[K];
	   sum=XY[x][y]+ssd2->RtnXY(x,y)+ssd3->RtnXY(x,y)+ssd4->RtnXY(x,y);
	   if(HG) IncdHist(sum,HG);
ii=ii - OS; jj=jj - OS;
if(ii < 1 || jj < 1) continue;
	   if(Nout == 0) fprintf(fp,
	       "Rank\tresI\tresJ\tcolI\tcolJ\tDCA\ttop20\ttop10\ttop5\ttop2\tsum\tscore\n");
	   Nout++;
           // fprintf(fp,"%d %c%d %c%d %d %d %.2lf %d %d %d %d %d %.3f\n",
	   // use round(), roundf() or roundl() to round to percentages?
           fprintf(fp,"%d\t%c%d\t%c%d\t%d\t%d\t%.2lf\t%d\t%d\t%d\t%d\t%d\t%.2f\n",
		i,cI,ii,cJ,jj,x,y,D[K],XY[x][y],
	   	ssd2->RtnXY(x,y),ssd3->RtnXY(x,y),ssd4->RtnXY(x,y),sum,d);
	   ColPair[1][i]=x; ColPair[2][i]=y; 
	   if(pfp && chn){
		fprintf(pfp,"dist dc%d%c_%d%c, chain %c and name ca and resid %d, ",
				ii,chn,jj,chn,chn,ii);
		fprintf(pfp,"chain %c and name ca and resid %d, label=0\n",chn,jj);
		fprintf(pfp,"set dash_radius,0.250, dc%d%c_%d%c\n",ii,chn,jj,chn);
		fprintf(pfp,"set dash_gap,0.075, dc%d%c_%d%c\n",ii,chn,jj,chn);
		fprintf(pfp,"set dash_length,0.925, dc%d%c_%d%c\n",ii,chn,jj,chn);
		fprintf(pfp,"color lime, dc%d%c_%d%c\n",ii,chn,jj,chn);
	   }
	} Nildheap(dH2); 
	if(Nout==0) fprintf(fp,"Sub-sampling failed.\n"); else fprintf(fp,"\n");
	if(HG){ PutHist(fp,60,HG); NilHist(HG); }
	return ColPair;
}

Int4	ssd_typ::AddToHeap(Int4 x, Int4 y, Int4 ii, Int4 jj, Int4 cI, Int4 cJ, double d)
{
	if(XY[x][y] >= Cut){
		k++; assert(k <= maxPairs);
		Y[k]=y; X[k]=x; I[k]=ii; J[k]=jj; CI[k]=cI; CJ[k]=cJ; D[k]=d;
		if(0) fprintf(stderr,"%d %c%d %c%d %d %d %.4lf %d\n",
                       	k,cI,ii,cJ,jj,x,y,D[k],XY[x][y]);
		insrtHeap(k,-(keytyp)d,dH); NN+=XY[x][y];
		return k;
	} return 0;
}


