/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "drc_typ.h"
#include "darc_usage.h"
#include "sparc_usage.h"

void	drc_typ::Init()
//========= Initialize data structures ============
{
	Dmax=4.0;
	RmFiles=TRUE;
	mds_file=0; src_pdb=0; ptrn_file=0;
	UseBG=FALSE; MkSIPRIS=FALSE; MkSIPRIS=TRUE;
	pdbaa_path=0; pdbUnique=0;
	num_dc=25; num_thrds=1; query_id=2; MaxDepth=4;
	gpu_num=-1;
	ccm_wt=ccm_LF=0.0f; // i.e., use defaults.
	NumPdbID=0; pdbID=0;
	numF=0; maxF=0;
	bpps_ptrns=0; SeqID=0; PathSPARC=0; pdbAllID=0; PdbPath=0;
	IDs=0; File=0; SizeInCCM=0;
	SbSmplSize=SbSmplNum=0;
	SbSmplKey=0;
	MinResDist=5;
	mst2vsi=0; 
	X2id=0; X2file=0;
}

void	drc_typ::Free()
{
	Int4	f,i,j;
	if(0) fprintf(stderr,"Mode='%c'=%d; rmfiles=%d; %s\n",Mode,Mode,RmFiles,argv[1]); 
	if(RmFiles){		// remove temporary files.
	  if(Mode=='S' || Mode=='C'){	// rankDCA
		sprintf(str,"%s_sprc_X.mst",argv[1]); std::remove(str);
		sprintf(str,"%s_sprc_X.dca",argv[1]); std::remove(str);
		sprintf(str,"%s_sprc_X",argv[1]); std::remove(str);
		sprintf(str,"%s_sprc.in",argv[1]); std::remove(str);
	  } else if(Mode == 0){		// == darc mode; 
		sprintf(str,"%s.cmd",argv[1]); std::remove(str);
		sprintf(str,"%s.paths",argv[1]); std::remove(str);
		sprintf(str,"%s_fg_X.mst",argv[1]); std::remove(str);
		sprintf(str,"%s_fg_X.dca",argv[1]); std::remove(str);
		sprintf(str,"%s_fg_X",argv[1]); std::remove(str);
		sprintf(str,"%s_fg.in",argv[1]); std::remove(str);
	  } else if(Mode != 'B'){		// darc mode; keep some of these around??
		sprintf(str,"%s_X.mst",argv[1]); std::remove(str);
		sprintf(str,"%s_X.dca",argv[1]); remove(str);
		sprintf(str,"%s_fg_X",argv[1]); std::remove(str);
		sprintf(str,"%s_fg.in",argv[1]); std::remove(str);
	  }
	}
	if(bpps_ptrns){
	  assert(numF);
	  for(f=1; f <= maxF; f++){
	    if(bpps_ptrns[f]){
		for(j=0; j <= numF[f]; j++){ if(bpps_ptrns[f][j] != 0) free(bpps_ptrns[f][j]); }
		free(bpps_ptrns[f]);
	    }
	  } free(bpps_ptrns); free(numF); 
	}
	if(mds_file) free(mds_file);
	if(ptrn_file) free(ptrn_file);
	if(src_pdb) free(src_pdb);
	if(pdbaa_path) free(pdbaa_path); 
	if(SeqID){
	  for(f=1; SeqID[f]; f++){
	     if(0) fprintf(stderr,"Freeing up SeqID[%d]\n",f);
             for(i=1; SeqID[f][i]; i++){ free(SeqID[f][i]); } free(SeqID[f]);
	  } free(SeqID);
	} 
	if(pdbID){ for(i=1; pdbID[i]; i++) free(pdbID[i]); free(pdbID); }
	if(Argv) free(Argv); 
	if(IDs) free(IDs); 
	if(File) free(File);
	if(PdbPath){ for(f=1; PdbPath[f]; f++) free(PdbPath[f]); free(PdbPath); }
	if(pdbAllID){
	  for(f=1; pdbAllID[f]; f++){
             for(i=0; pdbAllID[f][i]; i++){ free(pdbAllID[f][i]); } free(pdbAllID[f]);
	  } free(pdbAllID);
	}
	if(pdbUnique){ for(f=1; pdbUnique[f]; f++){ free(pdbUnique[f]); } free(pdbUnique); }
	if(mst2vsi) free(mst2vsi);
	if(X2id) free(X2id); 
	if(SbSmplKey) free(SbSmplKey); 
	if(X2file) free(X2file);
	if(PathSPARC) free(PathSPARC);
}

void	drc_typ::PrintError(const char *usage, const char *version)
{ fprintf(stderr,"%s",version); print_error(usage); }

void	drc_typ::GetArg(const char *suffix)
{
	Int4    arg,i,j,k,a,A,x,rtn=0;
	double	dd;
	char	c;
	UInt4	Seed=18364592;
	FILE	*fp=0;

	// purify: Uninitialized memory read in libgomp.so.1
        if(argc < 2) this->PrintError(USAGE_DARC,DRC_VERSION); 
        TurnOffLicenseStatement();
	for(a=0; a < argc; a++) fprintf(stderr,"%s ",argv[a]); fprintf(stderr,"\n");
	if(argc == 2 && strcmp("-bpps",argv[1]) == 0){ omc_typ  omc('q',1,argv); }
	else if(argc < 3) this->PrintError(USAGE_DARC,DRC_VERSION);
	// if(argc == 2 && strcmp("-dca",argv[1]) == 0){ omc_typ  omc('Q',1,argv); }
	set_typ	SkipSet=MakeSet(500);	// set of argv to blank out.

        NEWP(Argv,argc+20,char); Argc=0;
        Argv[Argc]=argv[0]; Argc++;   	// == 1
        Argv[Argc]=argv[1]; Argc++;     // == 2
	if(argv[2][0] == '-') this->PrintError(USAGE_DARC,DRC_VERSION);
	// skip over pdb_paths...
        for(a=3; a < argc; a++){ Argv[Argc]=argv[a]; Argc++; }
        for(arg=3; arg < argc; arg++){
           if(argv[arg][0] != '-') break;  // this will be reported later.
           switch(argv[arg][1]) {
               case 'B': 
                  if(strcmp("-BG",argv[arg]) == 0){ UseBG=TRUE; argv[arg][1]=' '; }
		  else print_error("-SbSmpl option input error");
                  break;
               case 'D':
                  if(sscanf(argv[arg],"-D=%f",&Dmax)==1){
		    if(Dmax < 2.0 || Dmax > 10.0){
		      print_error("-D option input out of range (2-10)");
		    } AddSet(arg,SkipSet); continue;
		  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'd':
                  if(sscanf(argv[arg],"-dev=%d",&x)==1){
		     if(x >= 0 && x <= 100) gpu_num=x;
		     else { print_error("-dev option input error"); }
                     argv[arg][1] = ' ';      // ignored by bpps
		  } else if(sscanf(argv[arg],"-dc=%d",&x)==1){
		     if(x >= 0 && x <= 500) num_dc=x;
		     else print_error("-dc option input error");
		     AddSet(arg,SkipSet); continue;
		  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'h':
                  if(0 && strcmp("-help",argv[arg]) == 0){ omc_typ  omc('Q',1,argv); }
                  else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'i':
		  if(sscanf(argv[arg],"-inCCM=%d",&SizeInCCM)==1){ 
			if(SizeInCCM < 250) print_error("-inCCM=<int> option input error"); 
                        argv[arg][1] = ' ';      // ignored by bpps
			continue;
		  } break;
               case 'm':
                  if(sscanf(argv[arg],"-minnats=%lf",&dd)==1) continue;
                  if(sscanf(argv[arg],"-minsize=%d",&x)==1) continue;
                  if(sscanf(argv[arg],"-maxdepth=%d",&x) == 1){
			MaxDepth=x;
			if(x > 4) print_error("Input error: maxdepth > 4."); continue;
		  }
                  if(sscanf(argv[arg],"-maxcol=%d",&x) == 1) continue;
                  else if(sscanf(argv[arg],"-m=%d",&x)==1){
			if(x < 1 || x > 12) print_error("-m option out of range");
			MinResDist=x;
                  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'p':
                  if(strncmp("-pdbaa",argv[arg],6) == 0){ 
          		if(sscanf(argv[arg],"-pdbaa=%s",str)==1){
			   pdbaa_path=AllocString(str);
		    	   AddSet(arg,SkipSet); continue;
			} else print_error("-pdbaa option input error");
		  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'q':
                  if(sscanf(argv[arg],"-query=%d",&x)==1){
		     if(x > 1) query_id=x;
		     else print_error("-query option input error");
		     AddSet(arg,SkipSet); continue;
		  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'r':
                  if(sscanf(argv[arg],"-rtfF=%d",&x)==1) continue;
                  if(sscanf(argv[arg],"-rtfP=%c",&c)==1) continue;
                  else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'S': 
                  if(sscanf(argv[arg],"-SbSmpl=%d:%d=%s",&SbSmplNum,&SbSmplSize,str)==3){
			if(SbSmplNum < 2 || SbSmplNum > 1000) print_error("-SbSmpl number out of range");
			if(SbSmplSize < 50 || SbSmplSize > 10000) print_error("SbSmpl size out of range");
			SbSmplKey=AllocString(str);
                        argv[arg][1] = ' ';      // ignored by bpps
		  } else print_error("-SbSmpl option input error");
                  break;
               case 's':
#if 0
                  if(strncmp(argv[arg],"-sipris",7) == 0){ 
			MkSIPRIS=TRUE; argv[arg][1] = ' '; 
		  } else if(strcmp(argv[arg],"-save")==0){ 
		  } else if(strcmp(argv[arg],"-sparc")==0){ 
			PathSPARC=AllocString(argv[2]); continue;
		  } else 
#endif
		  if(sscanf(argv[arg],"-seed=%u",&Seed)==1){ AddSet(arg,SkipSet); continue; }
		  else if(strcmp(argv[arg],"-save")==0){ 
		     AddSet(arg,SkipSet); continue;
                  } else argv[arg][1] = '#';      // triggers print usage for bpps Q
                  break;
               case 't':
                  if(sscanf(argv[arg],"-thrds=%d",&x)==1){
		     if(x > 0 && x < 100) num_thrds=x;
		     else print_error("-thrds option input error");
		     AddSet(arg,SkipSet); continue;
		  } else this->PrintError(USAGE_DARC,DRC_VERSION);
		  break;
               case 'u':
                  if(strcmp("-usr",argv[arg]) == 0) continue;
                  else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               default : // argv[arg][1] = '#';   // triggers print usage for Q
		  this->PrintError(USAGE_DARC,DRC_VERSION);
                  break;
           }
	}
	if(SbSmplSize > 0 && src_pdb){
	    fprintf(stderr,"WARNING: -sbsmpl option ignored with -mds option!\n");
	}
	// fp=open_file(argv[1],".cmd","w");
	if(suffix != 0){ fp=open_file(argv[1],suffix,"w"); } else fp=NULL;
	if(fp) for(A=0; A < Argc; A++){ if(A==2) fprintf(fp,"%s ",argv[2]); fprintf(fp,"%s ",Argv[A]); }
        for(arg=3; arg < argc; arg++){ if(MemberSet(arg,SkipSet)) argv[arg][1] = ' '; }
	NilSet(SkipSet);
	if(Seed == 18364592){
		Seed = (UInt4) time(NULL);  	// else Seed was set above
        	if(fp) fprintf(fp,"-seed=%u",Seed); 
	} sRandom(Seed);	// this will not be reseeded again...
	if(fp){ fprintf(fp,"\n"); fclose(fp); }
	// nothing left to free in Argv.
}

void	drc_typ::GetArgSPARC()
{
	Int4    arg,i,j,k,a,A,x,rtn=0;
	double	dd;
	char	c;
	UInt4	Seed=18364592;
	FILE	*fp=0;

	// purify: Uninitialized memory read in libgomp.so.1
        if(argc < 2) this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION); 
        TurnOffLicenseStatement();
	for(a=0; a < argc; a++) fprintf(stderr,"%s ",argv[a]); fprintf(stderr,"\n");
	if(argc == 2 && strcmp("-bpps",argv[1]) == 0){ omc_typ  omc('q',1,argv); }
	else if(argc < 3) this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
	// if(argc == 2 && strcmp("-dca",argv[1]) == 0){ omc_typ  omc('Q',1,argv); }
	set_typ	SkipSet=MakeSet(500);	// set of argv to blank out.

        NEWP(Argv,argc+20,char); Argc=0;
        Argv[Argc]=argv[0]; Argc++;   	// == 1
        Argv[Argc]=argv[1]; Argc++;     // == 2
	if(argv[2][0] == '-') this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
	// skip over pdb_paths...
        for(a=3; a < argc; a++){ Argv[Argc]=argv[a]; Argc++; }
        for(arg=3; arg < argc; arg++){
           if(argv[arg][0] != '-') break;  // this will be reported later.
           switch(argv[arg][1]) {
               case 'c': 
                  if(sscanf(argv[arg],"-ccm_wt=%f",&ccm_wt)==1){
		    if(ccm_wt > 2.0f || ccm_wt  < 0.01f){	// default: 0.8f
		      print_error("-ccm_wt option input out of range (.01-2)");
		    } argv[arg][1] = ' ';      // ignored by bpps
		  } else if(sscanf(argv[arg],"-ccm_LF=%f",&ccm_LF)==1){
		    if(ccm_LF > 2.0f || ccm_LF  < 0.01f){	// default: 0.2f
		      print_error("-ccm_LF option input out of range (.01-2)");
		    } argv[arg][1] = ' ';      // ignored by bpps
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
               case 'D':
                  if(sscanf(argv[arg],"-D=%lf",&dd)==1){
		    Dmax=dd;
		    if(Dmax < 2.0 || Dmax > 10.0){
		      print_error("GetArgSPARC(): -D option input out of range (2-10)");
		    } AddSet(arg,SkipSet); continue;
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
               case 'd':
                  if(sscanf(argv[arg],"-dev=%d",&x)==1){
		     if(x >= 0 && x <= 100) gpu_num=x;
		     else { print_error("-dev option input error"); }
                     argv[arg][1] = ' ';      // ignored by bpps
                  } else if(sscanf(argv[arg],"-dc=%d",&x)==1){
		     if(x >= 0 && x <= 100) num_dc=x;
		     else print_error("-dc option input error");
		     AddSet(arg,SkipSet); continue;
		  } else argv[arg][1] = '#';      // triggers print usage for Q
                  break;
               case 'i':
		  if(sscanf(argv[arg],"-inCCM=%d",&SizeInCCM)==1){ 
			if(SizeInCCM < 250) print_error("-inCCM=<int> option input error"); 
			continue;
		  } break;
               case 'p':
		  if(strncmp("-pdbaa",argv[arg],6) == 0){ 
          		if(sscanf(argv[arg],"-pdbaa=%s",str)==1){
			   pdbaa_path=AllocString(str);
		    	   AddSet(arg,SkipSet); continue;
			} else print_error("-pdbaa option input error");
		  } else if(sscanf(argv[arg],"-ptrn=%s",str) == 1){ 
			ptrn_file=AllocString(str);
			fprintf(stderr,"mds patterns=%s\n",ptrn_file);
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
               case 'q':
                  if(sscanf(argv[arg],"-query=%d",&x)==1){
		     if(x > 1) query_id=x;
		     else print_error("-query option input error");
		     AddSet(arg,SkipSet); continue;
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
               case 's':
                  if(sscanf(argv[arg],"-sbsmpl=%d:%d",&SbSmplNum,&SbSmplSize)==2){
			if(SbSmplNum < 2 || SbSmplNum > 1000) print_error("-sbsmpl number out of range");
			if(SbSmplSize < 50 || SbSmplSize > 10000) print_error("sbsmpl size out of range");
                        argv[arg][1] = ' ';      // ignored by bpps
		  } else if(sscanf(argv[arg],"-seed=%u",&Seed)==1){ AddSet(arg,SkipSet); continue; }
		  else if(strcmp(argv[arg],"-save")==0){ 
		     AddSet(arg,SkipSet); continue;
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
               case 't':
                  if(sscanf(argv[arg],"-thrds=%d",&x)==1){
		     if(x > 0 && x < 100) num_thrds=x;
		     else print_error("-thrds option input error");
		     AddSet(arg,SkipSet); continue;
		  } else this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
		  break;
               default : // argv[arg][1] = '#';   // triggers print usage for Q
		  this->PrintError(USAGE_SPARC_DARC,SPRC_VERSION);
                  break;
           }
	}
	if(SizeInCCM == 0) SizeInCCM=10000;
#if 1
	static BooLean	created=FALSE;
	if(this->clobber){
	   if(Mode=='C') fp=0; // fp=open_file(argv[1],".cmps","w"); 
	   else fp=open_file(argv[1],".sprc","w"); 
	} else {
	   if(Mode=='C') fp=0; // fp=open_file(argv[1],".cmps","a"); 
	   else fp=open_file(argv[1],".sprc","a");
	}
	if(fp) for(A=0; A < Argc; A++){ 
	   if(A==2) fprintf(fp,"%s ",argv[2]); fprintf(fp,"%s ",Argv[A]); 
	} 
#endif
        for(arg=3; arg < argc; arg++){ if(MemberSet(arg,SkipSet)) argv[arg][1] = ' '; }
	NilSet(SkipSet);
	if(Seed == 18364592){
		Seed = (UInt4) time(NULL);  	// else Seed was set above
		if(fp) fprintf(fp,"-seed=%u",Seed); 
	} sRandom(Seed);	// this cannot be reseeded again...
	if(fp){ fprintf(fp,"\n"); fclose(fp); }
	// nothing left to free in Argv.
}


