/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

Int4	cmc_typ::Seq2SeedCsqScore(Int4 sq,Int4 set)
{
	Int4 score=0,s,r,R;
	assert(SeedCMA[1]);
#if 0
	// char *TypeOfSet=Hpt->TypeOfSet();
        e_type Ei=FakeSeqCMSA(1,SeedCMA[set]);
	e_type Ej=FakeSeqCMSA(sq,MainCMA);
	if(LenSeq(Ej) != LenSeq(Ei)){
		if(1 || LenSeq(Ei) != LengthCMSA(1,TrueMainCMA)) PutSeq(stderr,Ei,AB);
		if(1 || LenSeq(Ej) != LengthCMSA(1,TrueMainCMA)) PutSeq(stderr,Ej,AB);
		fprintf(stderr,"Input alignment formating error: aligned lengths inconsistent.\n");
		print_error("Seq2SeedCsqScore() fatal error");
	}
	for(s=1; s <= LenSeq(Ej); s++) score += valAlphaR(ResSeq(s,Ei),ResSeq(s,Ej),AB);
        return score;
#else
        assert(LengthCMSA(1,MainCMA) == LengthCMSA(1,SeedCMA[set]));
assert(strcmp(NameCMSA(SeedCMA[set]),Hpt->SetName(set))==0);
        for(s=1; s <= LengthCMSA(1,MainCMA); s++){
	   if(1 || MemberSet(s,PttrnPos[set])){
                r=ResidueCMSA(1,sq,s,MainCMA); R=ResidueCMSA(1,1,s,SeedCMA[set]);
                score += valAlphaR(r,R,AB);
	   }
        } return score;
#endif
}

Int4    *cmc_typ::SortByScoreCMSA(FILE *fp,char mode,Int4 &first_best,
			cma_typ cma,Int4 set)
#if 0
  Return a list of array indices for sequences within InitSet[set] from 
  the minimum to maximum score.  "first_best" is the index to the first
  sequence on the list with a score above 'cut' = MinSeed2CsqScore[set].
#endif
{
	keytyp key=0,first_best_key=0;
	h_type HG=0;
	BooLean	found=FALSE;
	set_typ Set=InitSet[set];
	Int4	score,*list,i,j,Item,*ItemToSq,NumSq=NumSeqsCMSA(cma),N=CardSet(Set);
	double	cut=(double) MinSeed2CsqScore[set];
	first_best=0;

	if(nBlksCMSA(cma) > 1){ print_error("SortByScoreCMSA() requires single blk cma file"); }
	NEW(list,N+3,Int4); NEW(ItemToSq,N+4,Int4);
	mh_type mH=Mheap(N+2,3);
#if 1
	char	str[202];
	// score=Seq2SeedCsqScore(1,set); 
	score=PseudoAlnScoreCMSA(1,1,cma);
	double	dd = floor((double)score/50.0);
	// sprintf(str,"scores for %s",NameCMSA(cma));
	sprintf(str,"scores for %s",Hpt->ElmntSetName(set));
	HG=Histogram(str,-10,score,dd);
#else
HG=Histogram("scores",-10,N,5);
#endif
	for(i=1; i <= NumSq; i++){
	   if(MemberSet(i,Set)){
#if 0
		if(set != Hpt->NumSets()){
		   score=Seq2SeedCsqScore(i,set); 
		Item = InsertMheap((keytyp)score,mH);
		assert(Item > 0 && Item <= N+2); ItemToSq[Item]=i;
// fprintf(stderr,"Okay: score =%d\n",score);
		} else { 
		   score=i; 
// fprintf(stderr,"Failed: score =%d\n",score);
		}
IncdHist((double)score,HG);
#else
		if(set != Hpt->NumSets()){ score=Seq2SeedCsqScore(i,set); }
		else { score=-999; }
IncdHist((double)score,HG);
		Item = InsertMheap((keytyp)score,mH);
		assert(Item > 0 && Item <= N+2); ItemToSq[Item]=i;
#endif
	   }
	}
// efp=stderr;
if(efp) PutHist(efp,60,HG); NilHist(HG); HG=0;
// exit(1);
        if(efp != 0 && ItemsInMheap(mH) > 0){
	   Int4 start=(Int4) floor(MinKeyMheap(mH));
	   Int4 end=(Int4) ceil(MaxKeyMheap(mH));
	   if(start==end) end++;
	   double inc=ceil((double)(end-start+1)); inc = inc/30.0;
#if 0
	   if(mode == 'T') HG=Histogram("gapped log-odds scores",start,end,inc);
	   else HG=Histogram("ungapped log-odds scores",start,end,inc);
#else
	   char tmpstr[100];
	   sprintf(tmpstr,"ungapped csq scores for set %d (%s)",set,Hpt->ElmntSetName(set));
	   HG=Histogram(tmpstr,start,end,inc);
#endif
        }
	for(i=0; ItemsInMheap(mH) > 0; ){	// list from minimum to maximum score...
		Item=MinItemMheap(mH); key=MinKeyMheap(mH);
		if(HG) IncdHist((double)key,HG);
		assert(DelMinMheap(mH)==Item); i++; list[i]=ItemToSq[Item];
		if(!found && key >= cut){ found=TRUE; first_best=i; first_best_key=key; }
	}
	if(!found) first_best=N+1;
	if(HG && efp){
	     fprintf(fp,"%s:\n num-to-label: %d (score=%.1f) cutoff = %.1f\n",
			NameCMSA(cma),N-first_best+1,first_best_key,cut);
	     PutHist(efp,60,HG); NilHist(HG); 
	} NilMheap(mH); free(ItemToSq);
	return list;
}


Int4	cmc_typ::SortDisplaySets( )
// *.cma files; *.mma file; *.sma file.
{
	Int4	i,j,n,InSet;
#if 0
	cma_typ	*NewDisplayCMA,*OldDisplayCMA=0;
        if(passed_in_sma){      // Make sure not to clobber passed_in_sma files...
                NEW(OldDisplayCMA,NumDisplayCMA + 3, cma_typ);
                for(i=0; i <= NumDisplayCMA; i++) OldDisplayCMA[i]=DisplayCMA[i];
        } else OldDisplayCMA=DisplayCMA;
	NEW(NewDisplayCMA,NumDisplayCMA + 3, cma_typ); DisplayCMA = NewDisplayCMA;
#else
	cma_typ	*OldDisplayCMA=DisplayCMA;
	// Note: passed_in_sma array != DisplayCMA array.
	NEW(DisplayCMA,NumDisplayCMA + 3, cma_typ); 
#endif
	for(i=1; i <= Hpt->NumSets(); i++){
	   char	*name=Hpt->ElmntSetName(i),mode='t'; // 'T' = gapped; 't' = ungapped scores.
	   WorstToBest[i]=SortByScoreCMSA(stderr,mode,Index1stBest[i],MainCMA,i);
	   // Adjust starting point for labeling sorted sequence list for each set.
	   if(Hpt->FixedElmntSet(i)){	// e.g., 'Random=' set.
		Index1stBest[i]=1; // don't sample sets with == definition...
	   	if(efp) fprintf(stderr,"%d.%s ***** WILL NOT BE SAMPLED *****\n", i,name);
	   } else if((InSet=CardSet(InitSet[i])) > 0){
#if 0
		Int4 tenthway = (Int4) ceil(0.90*InSet);
		assert(tenthway > 0);
	   	if(Index1stBest[i] > tenthway) Index1stBest[i] = tenthway; 
		// don't let it go beyond 90% of each input subset .
#endif
#if 1	// let empty sets exist?
	   } else if(Hpt->TypeOfSet(i) == '?'){ 	// a Misc set...
	   	fprintf(stderr,"(\"%s?\"): Index1stBest[%d] = %d\n",name,i,Index1stBest[i]);
		Index1stBest[i]=1;	// doesn't matter as set is empty
#endif
	   } else {
		fprintf(stderr,"Too few sequences (%d) assigned to subgroup %d ('%s').\n",
			InSet,i,Hpt->ElmntSetName(i));
		// print_error("fatal error: Consider modifying the hyperpartition.");
	   }
	   if(efp) fprintf(stdout,"(%s): Index1stBest[%d] = %d\n",name,i,Index1stBest[i]);
	   if(Index1stBest[i] == 0) print_error("fatal error in cmc_typ::SortDisplaySets()");

	   if(i > NumDisplayCMA) continue;	// temporary kluge; put non-display sets last.
	   BooLean found=FALSE;
	   for(Int4 jj=1; jj <= NumDisplayCMA; jj++){
		if(OldDisplayCMA[jj] && strcmp(name,NameCMSA(OldDisplayCMA[jj]))==0){
		  if(!found){
			DisplayCMA[i] = OldDisplayCMA[jj]; OldDisplayCMA[jj]=0; found=TRUE;
		  } else print_error("*.sma file contains multiple labeled alignments");
		}
	   } if(!found){
		 fprintf(stderr,"'%s': ",name);
		 // fprintf(stderr,"display set not found within *.sma input file!\n");
		 print_error("display set not found within *.sma input file!");
	   } else if(efp) fprintf(efp,"%d.%s == %d.%s\n",i,name,i,NameCMSA(DisplayCMA[i]));
	} free(OldDisplayCMA);
	return Hpt->NumSets();
}

