/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

void	cmc_typ::ComputeMinSeed2CsqScores()
// Compute the lowest score between the consensus seq vs a display seq
// MinSeed2CsqScore[i] 
{
	Int4    i,j,s,score;
	//=========== GetSeedCMAs() ============
	assert(NumDisplayCMA < MAX_NUM_ELMENTARY_SETS);
	for(Int4 i=1; i <= NumDisplayCMA; i++){
	   SeedCMA[i] = AddConsensusCMSA(DisplayCMA[i]); 
#if 0
	   fprintf(stderr,"======> %d. NumSeqsCMSA=%d; seed=%d\n",i,
			NumSeqsCMSA(DisplayCMA[i]), NumSeqsCMSA(SeedCMA[i]));
	   // PutCMSA(stdout,DisplayCMA[i]);
#endif
	} assert(SeedCMA[1]);
#if 0
	char *TypeOfSet=Hpt->TypeOfSet();
	for(i=1; i <= NumDisplayCMA; i++){
         	e_type Ei=FakeSeqCMSA(1,SeedCMA[i]);
         	MinSeed2CsqScore[i]=INT4_MAX;
		for(j=2; j <= NumSeqsCMSA(SeedCMA[i]); j++){
		   e_type Ej=FakeSeqCMSA(j,SeedCMA[i]);
		   Int4 score=0;
		   for(s=1; s <= LenSeq(Ej); s++) score += valAlphaR(ResSeq(s,Ei),ResSeq(s,Ej),AB);
		   if(TypeOfSet[i] != '?' && score < MinSeed2CsqScore[i]) MinSeed2CsqScore[i]=score;
         	}
        } return;
#endif	//============= From mcs_misc.cc code ==============
        Int4    r1,rj,Length=LengthCMSA(1,SeedCMA[1]);
        char *TypeOfSet=Hpt->TypeOfSet();
        for(i=1; i <= NumDisplayCMA; i++){
                assert(SeedCMA[i]); assert(LengthCMSA(1,SeedCMA[i]) == Length);
                MinSeed2CsqScore[i]=INT4_MAX;
		if(TypeOfSet[i] == '?') continue; 
if(efp) fprintf(stderr,"%d.%s ==? %s\n",i,NameCMSA(SeedCMA[i]),Hpt->SetName(i));
assert(strcmp(NameCMSA(SeedCMA[i]),Hpt->SetName(i))==0);
		if(fixed_cutoff == 0){
		   // compute using Seed alignment scores against the consensus.
                   e_type Ei=FakeSeqCMSA(1,SeedCMA[i]);    // assume the first is a consensus seq.
                   assert(Ei); assert(i <= NumDisplayCMA);
                   for(j=2; j <= NumSeqsCMSA(SeedCMA[i]); j++){
                     e_type Ej=FakeSeqCMSA(j,SeedCMA[i]);
                     for(score=0,s=1; s <= Length; s++){
			if(1 || MemberSet(s,PttrnPos[i])){
                           r1=ResidueCMSA(1,1,s,SeedCMA[i]);
			   rj=ResidueCMSA(1,j,s,SeedCMA[i]);
                           score += valAlphaR(r1,rj,AB);
			}
                     }
                     if(score < MinSeed2CsqScore[i]) MinSeed2CsqScore[i]=score;
                   }
		} else { 	// compute using fixed % of consensus self score...
		  assert(fixed_cutoff > 0 && fixed_cutoff <= 100);
		  double percent=(double)fixed_cutoff/100.0;
		  e_type  Ei=MkConsensusCMSA(SeedCMA[i]);
		  for(score=0,s=1; s <= LenSeq(Ei); s++){
		    if(1 || MemberSet(s,PttrnPos[i])){
		      unsigned char r=ResSeq(s,Ei);
		      score += valAlphaR(r,r,AB);
		    }
		  } NilSeq(Ei); MinSeed2CsqScore[i]=(Int4) floor(percent*(double)score);
		}
        }
}

Int4	*cmc_typ::ComputeMinScore(FILE *ofp,Int4 NumSeedAln, FILE *efp)
// Compute the minimum score vs 1st seq for each seed MSA;
{
	ofp=0;// if(ofp) efp=0;
	Int4 *MinScoreInSet; NEW(MinScoreInSet,NumSeedAln+3,Int4);
	char *TypeOfSet=Hpt->TypeOfSet();
	for(Int4 i=1; i <= NumSeedAln; i++){
	  if(ofp) fprintf(ofp,"%2d: ",i);
if(efp) fprintf(stderr,"%d.%s ==? %s\n",i,NameCMSA(SeedCMA[i]),Hpt->SetName(i));
assert(strcmp(NameCMSA(SeedCMA[i]),Hpt->SetName(i))==0);
	  MinScoreInSet[i]=INT4_MAX;
	  cma_typ cma=SeedCMA[i]; assert(nBlksCMSA(cma) == 1);
	  for(Int4 sq=2; sq <= NumSeqsCMSA(cma); sq++){
	     Int4 score=0,blk=1;
	     for(Int4 s=1; s <= LengthCMSA(1,cma); s++){
		if(1 || MemberSet(s,PttrnPos[i])){
		  unsigned char R=ResidueCMSA(blk,1,s,cma);
		  unsigned char r=ResidueCMSA(blk,sq,s,cma);
		  score += valAlphaR(R,r,AB);
		}
	     }
	  // if(ofp) fprintf(ofp,"%5d ",score);
	     if(score < MinScoreInSet[i]){ MinScoreInSet[i]=score; }
	  } if(MinScoreInSet[i] < 0) MinScoreInSet[i] = 0;
#if 0
	  if(ofp) fprintf(ofp," %s%c min=%d\n",
                        NameCMSA(SeedCMA[i]),TypeOfSet[i],MinScoreInSet[i]);
#endif
	  if(efp){
	    fprintf(efp,"%d(\"%s\"): minscore=%d; %d ",
			i,NameCMSA(cma),MinScoreInSet[i],NumSeqsCMSA(cma));
	    if(NumSeqsCMSA(cma) < 10){
		fprintf(efp,"< 10 seqs!\n",
			i,NameCMSA(cma),NumSeqsCMSA(cma));
		// MinScoreInSet[i]=0; continue;
		// print_error("FATAL: bpps H input error.n");
	    } else fprintf(efp,"seqs\n");
	  }
	} return MinScoreInSet;
}

Int4	*cmc_typ::ComputeMaxScore(FILE *ofp,Int4 NumSeedAln,Int4 *MinScoreInSet,
				FILE *efp)
{
	if(ofp) efp=0;
	Int4	j,*MaxScoreNonID;
	char *TypeOfSet=Hpt->TypeOfSet();
	NEW(MaxScoreNonID,NumSeedAln+3,Int4);
	for(Int4 i=2; i <= NumSeedAln; i++){
	  if(MinScoreInSet[i] > 0) continue;
if(efp) fprintf(stderr,"%d.%s ==? %s\n",i,NameCMSA(SeedCMA[i]),Hpt->SetName(i));
assert(strcmp(NameCMSA(SeedCMA[i]),Hpt->SetName(i))==0);
	  e_type Ei=FakeSeqCMSA(1,SeedCMA[i]);
	  if(ofp) fprintf(ofp,"%2d: ",i);
	  MaxScoreNonID[i]=INT4_MIN;
	  assert(MaxScoreNonID[i] < 0);
	  for(j=1; j <= NumSeedAln; j++){
	     e_type Ej=FakeSeqCMSA(1,SeedCMA[j]);
	     assert(LenSeq(Ei) == LenSeq(Ej));
	     Int4 score=0;
	     for(Int4 s=1; s <= LenSeq(Ej); s++){
		if(1 || MemberSet(s,PttrnPos[i])){
		  unsigned char ri=ResSeq(s,Ei);
		  unsigned char rj=ResSeq(s,Ej);
		  score += valAlphaR(ri,rj,AB);
		}
	     } if(ofp) fprintf(ofp,"%5d ",score);
	     if(i != j && TypeOfSet[j] != '?' && score > MaxScoreNonID[i]){
		MaxScoreNonID[i]=score;
	     }
	  } if(ofp) fprintf(ofp," %s%c max=%d\n",
			NameCMSA(SeedCMA[i]),TypeOfSet[i],MaxScoreNonID[i]);
MinScoreInSet[i]=MaxScoreNonID[i];
	  fprintf(stderr,"%d: maxscore_nonident=%d\n",i,MaxScoreNonID[i]);
	}
	if(ofp){
	  fprintf(ofp,"---");
	  for(j=1; j <= NumSeedAln; j++) fprintf(ofp,"------",j);
	  fprintf(ofp,"\n   ");
	  for(j=1; j <= NumSeedAln; j++) fprintf(ofp, " %5d",MaxScoreNonID[j]);
	  fprintf(ofp,"\n");
	} return MaxScoreNonID;
}

