/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

double	cmc_typ::RestoreBest()
{
	if(!SaveBest || DidRestoreBest) return CalcTotalLPR(0,FALSE);	// don't want to restore it again.
	Int4	s,sq,n,i,Length=LenSeq(che[1]->KeyE());
	char	**HP=HyperPartition;
fprintf(stderr,"Restoring Best: %.2f --> %.2f\n",TotalLPR,BestLPR);
	// if(Hpt) delete Hpt; Hpt=InitHpt->Copy();	// WARNING: this assumes Hpt does not change except for deleted nodes.
	if(Hpt) delete Hpt; Hpt=BestHpt->Copy();	// WARNING: this assumes Hpt does not change except for deleted nodes.
	for(s=1; s<= Hpt->NumSets(); s++){ HyperPartition[s] = Hpt->RtnHyperPartition(s); }
	for(s=1; s<= Hpt->NumSets(); s++){	
		IsFailedSet[s]=IsFailedBestSet[s];
		CopySet(GrpSet[s],BestSet[s]);	// copies BestSet[s] to GrpSet[s].
	}
        Int4 num_sq = NumSeqsCMSA(MainCMA);
     	for(sq=1; sq <= num_sq; sq++){
	  if(MemberSet(sq,Labeled)) continue; // no need to reset this; never changes.
	  for(n=1; n<= Hpt->NumBPPS(); n++){
	    for(s=1; s<= Hpt->NumSets(); s++){	
	        if(MemberSet(sq,GrpSet[s])){ che[n]->SetPartition(HP[s][n],sq); }
	    }
	  }
	}
	for(n=1; n<= Hpt->NumBPPS(); n++){
	  IsFailedBPPS[n]=IsFailedBestBPPS[n];
          for(i=1; i <= Length; i++){
		che[n]->RmColButKeepLPR(i);
		if(best_sst[n][i]) che[n]->AddColumn(i,best_sst[n][i]);
	  }
	}
	DidRestoreBest=TRUE;
	// ReSetRelations();
	double d=CalcTotalLPR(0,FALSE);	// don't want to store it again.
	this->PutHyperPartition(stderr); 
	assert(this->ConsistencyCheck()); 
	return d;
}

void	cmc_typ::StoreBest()
{
	Int4	s,n,i,Length=LenSeq(che[1]->KeyE());
// fprintf(stderr,"Storing Best: %.2f --> %.2f\n",BestLPR,TotalLPR);
	SaveBest=TRUE;
	BestLPR=TotalLPR;
// if(BestLPR > 7057.0){ assert(this->ConsistencyCheck()); this->PutHyperPartition(stderr); }
	if(BestHpt) delete BestHpt; BestHpt=Hpt->Copy();
	for(s=1; s<= Hpt->NumSets(); s++){	
		IsFailedBestSet[s]=IsFailedSet[s];
		CopySet(BestSet[s],GrpSet[s]);	// copies GrpSet[s] to BestSet[s].
	}
     	for(n=1; n<= Hpt->NumBPPS(); n++){
	    IsFailedBestBPPS[n]=IsFailedBPPS[n];
	    bpps_typ *bpps=che[n]->BPPS();
            for(i=1; i <= Length; i++) best_sst[n][i]=bpps->RtnSST(i);
	}
}

#if 1

#include "lnNumRootedTrees.h"

#define SQRT_OF_PI 1.7724538509055160272981674833411 

double	cmc_typ::TreeCalcTotalLPR(FILE *fp,BooLean StoreBestOK)
{
	Int4	n,sq;
	BooLean	okay=TRUE;
	// 1. Calculate the contribution from pattern partitions..
     	for(TotalLPR=0.0, n=1; n<= Hpt->NumBPPS(); n++){
		if(che[n]->NumColumns() > MaxNumCol[n]){
			// che[n]->RtnMaxNumColumns();
#if 0
	fprintf(stderr,"che[%d]->NumColumns() = %d; MaxNumCol[%d] = %d\n",
			n,che[n]->NumColumns(), n,MaxNumCol[n]);
#endif
			StoreBestOK = FALSE;
		} 
		SubLPR[n]=che[n]->SubMap( ); Map[n]=SubLPR[n][0]; // CheckValue(Map[n]);
		if(fp){ che[n]->PutInfo(fp,n); }
		TotalLPR+=Map[n];
// if(n > 1) assert(!(Map[n-1] > 0.0 && Map[n] < -99856392.0));	// DEBUG!!!
		if(this->NoFailureMode && Map[n] <= 0.0) okay = FALSE;
	}
	// 2. MDL: Adjust for number of n-ary trees (very conservative as only depth=5 allowed).
	// this is based on the number of unlabeled, unordered rooted trees.
	static double SumCn=0;
	static double lnCn[515];
	static Int4 Nmax=MaxNodesForlnNumRootedTrees;
	n=Hpt->NumSets(); 
	assert(n <= Nmax);
	double D = (double) lnNumRootedTrees[n];
	// fprintf(stderr,"Catalan number (%d nodes) = %.3g\n",Hpt->NumSets(),D);
	TotalLPR -= D;
#if 1	// 3. Adjust for the freedom to assign sequences to alternative nodes.
	UInt4	WtFactor=che[1]->GetWtFactor();
     	for(n=1; n<= Hpt->NumBPPS(); n++){
	   for(D=0.0,sq=1; sq <=NumSeqsCMSA(TrueMainCMA); sq++){
	      if(this->IsInSet(sq,n)){
		UInt4 wt=che[n]->RtnAveSqIWt(sq);
		double dd = (double)wt/(double)WtFactor;
		D+= dd*log(GlobalRi);
	      }
	   } TotalLPR += D;
	}
	double DD=0.0;
	set_typ setBG=che[1]->RtnBG_Set();
	for(D=0.0,sq=1; sq <=NumSeqsCMSA(TrueMainCMA); sq++){
	   if(MemberSet(sq,setBG)){
		UInt4 wt=che[1]->RtnAveSqIWt(sq);
		double dd = (double)wt/(double)WtFactor;
		DD += dd;
		D+= dd*log(RejectRi);
	   }
	} TotalLPR += D;
	// fprintf(stderr,"Rejected #wtsq = %.1lf; logLike=%.1f\n",DD,D);
#endif
	Map[0]=TotalLPR;

	CheckValue(TotalLPR);
	if(fp) fprintf(fp,"Total LPR = %.3f (%.1f K)\n",TotalLPR,temperature);
#if 0	// DEBUG...
	fprintf(stderr,"Total LPR = %.3f\n", TotalLPR);
	fprintf(stderr,"okay = %d\n", okay);
	fprintf(stderr,"StoreBestOK = %d\n", StoreBestOK);
	fprintf(stderr,"BestLPR=%.2f\n",BestLPR);
#endif
	if(okay && StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR){
			StoreBest();
	} // if(StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR) StoreBest();
	return TotalLPR;
}

double	cmc_typ::NthLPR(Int4 n,FILE *fp)
{
	SubLPR[n]=che[n]->SubMap( ); Map[n]=SubLPR[n][0]; // CheckValue(Map[n]);
	if(fp){ che[n]->PutInfo(fp,n); }
	return Map[n];
}

double	cmc_typ::NotTreeCalcTotalLPR(FILE *fp,BooLean StoreBestOK)
{
	Int4	n;
	// BooLean	okay=TRUE;
     	for(TotalLPR=0.0, n=1; n<= Hpt->NumBPPS(); n++){
		if(che[n]->NumColumns() > MaxNumCol[n]){
			// che[n]->RtnMaxNumColumns();
			// okay = FALSE;
			StoreBestOK = FALSE;
		} TotalLPR+=NthLPR(n,fp); 
	}
	CheckValue(TotalLPR);
	if(fp) fprintf(fp,"Total LPR = %.3f (%.1f K)\n",TotalLPR,temperature);
	// if(okay && StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR) StoreBest();
	if(StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR) StoreBest();
	return TotalLPR;
}
#else

#include "lnNumRootedTrees.h"

double	cmc_typ::CalcTotalLPR(FILE *fp,BooLean StoreBestOK)
{
double RejectRi=0.5;
	Int4	n,sq;
	BooLean	okay=TRUE;
	// 1. Calculate the contribution from pattern partitions..
     	for(TotalLPR=0.0, n=1; n<= Hpt->NumBPPS(); n++){
		if(che[n]->NumColumns() > MaxNumCol[n]){
			// che[n]->RtnMaxNumColumns();
#if 0
	fprintf(stderr,"che[%d]->NumColumns() = %d; MaxNumCol[%d] = %d\n",
			n,che[n]->NumColumns(), n,MaxNumCol[n]);
#endif
			StoreBestOK = FALSE;
		} 
		SubLPR[n]=che[n]->SubMap( ); Map[n]=SubLPR[n][0]; // CheckValue(Map[n]);
		if(fp){ che[n]->PutInfo(fp,n); }
		TotalLPR+=Map[n];
// if(n > 1) assert(!(Map[n-1] > 0.0 && Map[n] < -99856392.0));	// DEBUG!!!
// if(this->NoFailureMode && Map[n] <= 0.0) okay = FALSE;
	}
	// 2. MDL: Adjust for number of n-ary trees (very conservative as only depth=5 allowed).
	// this is based on the number of unlabeled, unordered rooted trees.
	static double SumCn=0;
	static double lnCn[515];
	static Int4 Nmax=MaxNodesForlnNumRootedTrees;
	n=Hpt->NumSets(); 
	assert(n <= Nmax);
	double D = (double) lnNumRootedTrees[n];
	// fprintf(stderr,"Catalan number (%d nodes) = %.3g\n",Hpt->NumSets(),D);
	TotalLPR -= D;
#if 1	// 3. Adjust for the freedom to assign sequences to alternative nodes.
	UInt4	WtFactor=che[1]->GetWtFactor();
     	// for(n=1; n<= Hpt->NumBPPS(); n++)
     	for(n=1; n < Hpt->NumSets(); n++)
	{
	   for(D=0.0,sq=1; sq <=NumSeqsCMSA(TrueMainCMA); sq++){
	      if(this->IsInSet(sq,n)){
		UInt4 wt=che[n]->RtnAveSqIWt(sq);
		double dd = (double)wt/(double)WtFactor;
		D+= dd*log(GlobalRi);
	      }
	   } TotalLPR += D;
	}
	double DD=0.0;
	set_typ setBG=che[1]->RtnBG_Set();
	for(D=0.0,sq=1; sq <=NumSeqsCMSA(TrueMainCMA); sq++){
	   if(MemberSet(sq,setBG)){
		UInt4 wt=che[1]->RtnAveSqIWt(sq);
		double dd = (double)wt/(double)WtFactor;
		DD += dd;
		D+= dd*log(RejectRi);
	   }
	} TotalLPR += D;
	// fprintf(stderr,"Rejected #wtsq = %.1lf; logLike=%.1f\n",DD,D);
#endif
	Map[0]=TotalLPR;

	CheckValue(TotalLPR);
	if(fp) fprintf(fp,"Total LPR = %.3f (%.1f K)\n",TotalLPR,temperature);
#if 0	// DEBUG...
	fprintf(stderr,"Total LPR = %.3f\n", TotalLPR);
	fprintf(stderr,"okay = %d\n", okay);
	fprintf(stderr,"StoreBestOK = %d\n", StoreBestOK);
	fprintf(stderr,"BestLPR=%.2f\n",BestLPR);

	if(okay && StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR){
			StoreBest();
	} // if(StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR) StoreBest();
#endif
	if(StoreBestOK && TotalLPR > 0.0 && TotalLPR > BestLPR) StoreBest();
	return TotalLPR;
}
#endif

BooLean	cmc_typ::CheckValue(double x)
{
        if(!std::isfinite(x)){       // this is not a valid floating point number.
          if(isnan(x)){
		print_error("No signficant hyperpartition found (LPR:NaN).");
	  } else if(isinf(x)){
                  if(isinf(x) == 1) print_error("No signficant hyperpartition found (LPR:+infinity).");
                  else if(isinf(x) == -1){      // negative infinity
                        print_error("No signficant hyperpartition found (LPR: neg. infinity).");
                  } else print_error("No signficant hyperpartition found (LPR: infinite).");
          } else {
	    print_error("No signficant hyperpartition found (LPR: not finite).");
            return FALSE;
	  }
        } return TRUE;
}

double	**cmc_typ::GetResEvals(Int4 n)
// Get res_evals and pvals for passing into tmpchn();
{
     	assert(n > 0 && n<= Hpt->NumBPPS());
	bpps_typ *tmp_bpps=che[n]->BPPS();
	sst_typ *sst=tmp_bpps->RtnSST( );
	Int4 s,r,len=tmp_bpps->LenPattern();
	double	**ResEvals,*tmp_pval=che[n]->SubMap( ); 
	NEWP(ResEvals,len+3,double);
	for(s=1; s <= len; s++){
	    NEW(ResEvals[s],nAlpha(AB) +3, double);
	    if(sst[s]==0) continue;
	    ResEvals[s][0]=tmp_pval[s]; 
	    for(r=1; r <= nAlpha(AB); r++){
		if(MemSset(r,sst[s])){ ResEvals[s][r] = tmp_pval[s]; }
	    }
	} return ResEvals;
}

