/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

void    cmc_typ::FWriteSST(FILE *fp)
{
	Int4 N=Hpt->NumBPPS();
	Int4 rtn=fwrite(&N,sizeof(Int4),1,fp);
       	for(Int4 i=1; i<=Hpt->NumBPPS(); i++){
	    bpps_typ *bpps=che[i]->BPPS();
	    sst_typ *tmpsst=bpps->RtnSST();
	    Int4 k=bpps->LenPattern( );
#if 0
	    if(k != LenSeqCMSA(1,MainCMA)){
		fprintf(stderr,"k=%d; LenSeqCMSA = %d\n",k,LenSeqCMSA(1,MainCMA));
	        assert(k == LenSeqCMSA(1,MainCMA));
	    }
#else
	    if(k != LengthCMSA(1,MainCMA)) {
		fprintf(stderr,"k=%d; LenSeqCMSA = %d\n",k,LengthCMSA(1,MainCMA));
	        assert(k == LengthCMSA(1,MainCMA));
	    }
#endif
	    rtn=fwrite(&k,sizeof(Int4),1,fp);
       	    rtn=fwrite(tmpsst,sizeof(sst_typ),k+2,fp);      // made in cmc_typ
       	    if(rtn != k+2) print_error("WriteSST() input error 4");
       	}
}

sst_typ	**cmc_typ::FReadSST(FILE *fp,Int4 &numBPPS,Int4 &len)
{
	Int4 K,k,rtn=0;
	rtn=fread(&numBPPS,sizeof(Int4),1,fp);
	sst_typ **tmpsst; NEWP(tmpsst, numBPPS+3,sst_typ);
       	for(Int4 i=1; i<=numBPPS; i++){
	    rtn=fread(&k,sizeof(Int4),1,fp);
	    NEW(tmpsst[i], k+3,sst_typ);
	    if(i==1) K=k; else assert(K==k);
       	    rtn=fread(tmpsst[i],sizeof(sst_typ),k+2,fp);      // made in cmc_typ
       	    if(rtn != k+2) print_error("ReadSST() input error 4");
       	} len=K;
	return tmpsst;
}

void	cmc_typ::ReadCheckpoint(char *chkfilename)
{
	Int4	i,j,k,NumSMA;
	char	str[202];
	FILE	*fp=0;

	if(chkfilename==0) chkfilename=infile;

	fprintf(stderr,"Reading checkpoint file\n");
	NEW(checkpoint,1,cmc_checkpt_type);
#if 0	// tease out mma and hsw files from chk...
	// problem is some sequences end up in the Reject set 
        fp=open_file(infile,".mma","r");
        checkpoint->main_cma=ReadCMSA(fp,AB); fclose(fp);

        fp=open_file(infile,".hsw","r");
        checkpoint->hsw=FReadHSW(fp,AB,checkpoint->main_cma);
        fclose(fp);
        fp=open_file(chkfilename,".CHK","r");
#else
        fp=open_file(chkfilename,".CHK","r"); 
	fprintf(stderr,"===> Reading *.CHK files.\n");
	checkpoint->main_cma=ReadCMSA(fp,AB);
	fprintf(stderr,"===> main *.cma file read.\n");
	checkpoint->hsw=FReadHSW(fp,AB,checkpoint->main_cma);
	fprintf(stderr,"===> main *.hsw file read.\n");
#endif
        checkpoint->set=ReadSets(fp,checkpoint->num_sets); 
	checkpoint->set[checkpoint->num_sets]=0;
	checkpoint->num_sets--;
	if(efp) for(i=1; i <= checkpoint->num_sets; i++){
		fprintf(stderr,"%d.%d seqs\n",i,CardSet(checkpoint->set[i]));
	}
	fprintf(stderr,"===> %d set files read.\n",i-1);
	// NumSMA=checkpoint->num_sets;
	fscanf(fp,"seed=%lu; N=%d.\n",&RandomSeed,&NumDisplayCMA);
	// fprintf(stderr,"seed=%lu; N=%d.\n",RandomSeed,NumDisplayCMA);

	NEW(DisplayCMA,NumDisplayCMA+3,cma_typ);
        for(i=1; i<=NumDisplayCMA; i++){
           if((DisplayCMA[i]=ReadCMSA(fp,AB))==NULL){
		print_error("*.CHK file input error 3.");
	   } else if(efp) fprintf(stderr,"%d.%s (%d)\n", i,
			NameCMSA(DisplayCMA[i]),NumSeqsCMSA(DisplayCMA[i]));
        } if(efp) fprintf(stderr,"\n");
	fprintf(stderr,"===> %d sma files read.\n",i-1);

	set_typ *tmp_set=ReadSets(fp,k);
        checkpoint->labeled=tmp_set[1]; free(tmp_set);
	fprintf(stderr,"labeled(%d): %d seqs\n",k,CardSet(checkpoint->labeled));

	checkpoint->hpt= new hpt_typ(fp); 
	if(efp) checkpoint->hpt->Put(stderr); 
	fprintf(stderr,"===> hpt file read.\n");
	checkpoint->sst=FReadSST(fp,checkpoint->num_ssts,k); // read patterns.
	if(efp) for(i=1; i <= checkpoint->num_ssts; i++){
	    for(k=0,j=1; j <= TotalLenCMSA(DisplayCMA[1]); j++){
		if(checkpoint->sst[i][j]){
		  if(k > 0) fprintf(stderr,","); k++;
		  PutSST(stderr,checkpoint->sst[i][j],AB);
		  fprintf(stderr,"%d",j);
		}
	    } fprintf(stderr,"\n");
	}
	// read elementary sets.
	// checkpoint->labeled=checkpoint->set[checkpoint->num_sets];
        // assert(k == LenSeqCMSA(1,checkpoint->main_cma));
	fclose(fp);
	fprintf(stderr,"===> all CHK files read.\n");
	return;
}

BooLean	cmc_typ::WriteCheckpoint(char *chkfilename)
{
	Int4	i,j;
	char	str[500];
        FILE *fp=0;
	if(chkfilename==0) chkfilename=infile;
	if(Hpt->NumSets() < 3) return FALSE; // Don't print if only root node.

	//============== Save sequence sets ==========
	set_typ *set=this->CopyOfSeqSets();
	cma_typ *sma=0;
	// cma_typ *sma=passed_in_sma;
	sma=DisplayCMA;

	Int4 *P=0;
	if(Hpt->IsTree(P)){
	  fp=open_file(chkfilename,".chk","w");
          if(fp){
            bpcp_typ bpcp(RandomSeed,Hpt->NumSets(),set,Hpt->NumSets()-1,sma,Hpt);
            bpcp.Write(fp); fclose(fp); fp=0;
          } 
        } else {
	  fp = open_file(chkfilename,".CHK","w");
#if 1	// keeping main.mma and main.hsw out for checkpoint file.
	  PutCMSA(fp,MainCMA);
	  // write sequence weights...
          if(passed_in_hsw) FWriteHSW(fp,passed_in_hsw);
          else if(checkpoint && checkpoint->hsw) FWriteHSW(fp,checkpoint->hsw);
          else {
            hsw_typ hsw=chn[1]->RtnHSW(1);       // created in cmc_typ.cc
            FWriteHSW(fp,hsw); // NilHSW(hsw);  
	    // this is owned by chn[1]->swt; don't delete it!
          }
#endif

#if 1	// don't use this if using a new Main.cma and Main.hsw!!!
          WriteSets(fp,Hpt->NumSets()+1,set);	// + 1 for Reject set...
#endif
	  fprintf(fp,"seed=%lu; N=%d.\n",RandomSeed,NumDisplayCMA);
	  for(j=1; j <= NumDisplayCMA; j++){ PutCMSA(fp,sma[j]); }
	  //============= save Hpt with patterns: =============
	  set_typ tmp_set[3]; tmp_set[1]=Labeled;
          WriteSets(fp,1,tmp_set);
	  // Hpt->Put(fp,TRUE,FALSE,TRUE); fprintf(fp,"End.\n");
	  this->PutHptPttrns(fp); fprintf(fp,"End.\n");
	  this->FWriteSST(fp);
	  fclose(fp); fp=0;
	} if(P) free(P);

	return TRUE;
}



