/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"
#include "blosum62.h"

Int4    RuncmcBPPS(Int4 argc,char *argv[],char &HptIs)
{
        Int4   iter=0;
	BooLean	Converged=FALSE;
        time_t  time1=time(NULL);
	cmc_typ	*cmc=0;
	FILE *fp=0; 
	hsw_typ hsw=0; swt_typ *swt=0;
	cma_typ TrueMainCMA=0;
	Int4	arg,Argc=argc,Rtn=0;
	char	**Argv; NEWP(Argv,argc +3,char);

	for(arg=0; arg < argc; arg++){ Argv[arg]=AllocString(argv[arg]); }
	if(argc < 2) cmc = new cmc_typ( );	// print usage only...
	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	char	str[1000];
	Int4 NumRandom=0;
#if 0	// debug using *.CHK file; CAN DELETE THIS ONCE TEST -RTF OPTION!!!
        sprintf(str,"%s.CHK",argv[1]);
        if((fp=fopen(str,"r")) != NULL){    // call other constructor for hpt operations
fprintf(stderr,"===> %s.CHK file found.\n",argv[1]);
	   fclose(fp); fp=0;
           cmc = new cmc_typ(argc, argv);   // don't run program.
fprintf(stderr,"===> Printing %s rtf files.\n",argv[1]);
	   cmc->PutRTF(FALSE); // cmc->Put(); 
fprintf(stderr,"===> Done printing %s rtf files.\n",argv[1]);
fprintf(stderr,"!!! WARNING: with *.CHK file will alwys create rtf files!!!!\n");
fprintf(stderr,"!!! Edit RuncmcBPPS( ) in libcmc/cmcBPPS.cc!!!!\n");
fprintf(stderr,"!!! Edit and BPPS/run_bpps.cxx after debugging!!!!\n");
	   delete cmc; exit(0);
	}
#endif
        sprintf(str,"%s.mma",argv[1]);
        if((fp=fopen(str,"r")) == NULL){    // call other constructor for hpt operations
           cmc = new cmc_typ(argc, argv);   // don't run program.
	   delete cmc; return 0;
	} else { TrueMainCMA=ReadCMSA(fp,AB); fclose(fp); fp=0; }
        if(NumRandom==0) NumRandom=1+(NumSeqsCMSA(TrueMainCMA)/3); // sam

        sprintf(str,"%s.hsw",argv[1]);
        if((fp=fopen(str,"r")) == NULL){        // create file...
                swt = new swt_typ(TrueMainCMA);
                hsw=swt->RtnHSW( );
                fp = open_file(argv[1],".hsw","w");
                FWriteHSW(fp,hsw); fclose(fp);
        } else { hsw=FReadHSW(fp,AB,TrueMainCMA); swt = new swt_typ(hsw); }
	fclose(fp);

	cma_typ rcma,in_mcma=MkMainFileCMSA(TrueMainCMA,NumRandom,rcma);
        hsw_typ HSW=AddRandomHSW(hsw,TrueMainCMA,rcma,in_mcma);
        TotalNilCMSA(rcma);     // destroy the temporary Random sequence alignment.
	cmc = new cmc_typ(TrueMainCMA,in_mcma,HSW,argc,argv);
#if 0
	cmc->PutHyperPartition(stderr);
	cmc->Debugger(); exit(1);
#endif
	fflush(stdout);
	cmc->PutHyperPartition(stderr); // cmc->ResetPruneIter(9);
        do {
		iter++;
		// Converged=cmc->Sample(1,3);
		// if(iter >= 1){ cmc->SampleHpt(stderr,2); } 
 		Converged=cmc->Sample( );	// use -Rounds=<int> to specify # rounds.
 		// Converged=cmc->Sample(1,1);	// use -Rounds=<int> to specify # rounds.
		// Converged=cmc->Sample(start,num_iters);
		// cmc->RestoreBest(); cmc->WriteCheckpoint("junk");
		// cmc->RestoreBest();
		double lpr=cmc->CalcTotalLPR();
		if(lpr <= 0.0)
			print_error("Set assignments for Hyperpartition failed.");
		else cmc->ResetPruneIter(1);  // prune from the start after first run.
		if(iter >= cmc->MaxIterations()) break;
	} while(!Converged);
	cmc->RestoreBest();
        cmc->Put();     // creates <infile>_grp.chn
	hpt_typ *Hpt=cmc->GetHpt();
	Int4 *P; 
	if(Hpt->IsTree(P)) HptIs='T'; else HptIs='H'; 
	if(P) free(P);
#if 0	// Test Read Write routines.
	fp = open_file(argv[1],".amc","w"); cmc->WritePttrnSets(fp); fclose(fp);
	fp = open_file(argv[1],".amc","r");
	set_typ *set; sst_typ **sst; Int4 Len;
	Int4 x=cmc->ReadPttrnSets(fp,set,sst,Len); fclose(fp);
	fprintf(stderr,"N = %d; Len = %d\n",x,Len);
	PutSet(stderr,set[1]);
	// scc_typ *scc=scc_typ(fp,TrueMainCMA,swt);
	exit(1);
#endif
	fprintf(stderr,"done printing results\n");
	cmc->PutHyperPartition( );
	// fprintf(stderr,"IsTreeHpt=%d\n",cmc->HptIsTree()); 
        if(cmc->HptIsTree()){
	   fp = open_file(argv[1],".cntrb","w");
	   cmc->PutHyperPartition(fp);
	   fprintf(fp,"LLR contribution of each set (row) ");
	   fprintf(fp,"to each contrast alignment (column):\n");
	   fprintf(fp,"Row. set(seqs): (col) nats [(col) nats]\n");
	   cmc->PutMapContributions(fp); fclose(fp);
	}
#if 1   // save sets...
	if(cmc->SaveSets){
           set_typ *sets=cmc->CopyOfSeqSets();
           Int4 NumSets=cmc->RtnNumElmntSetCMA( );
           fp=open_file(argv[1],".sets","w");
           WriteSets(fp,NumSets,sets); fclose(fp);
	   hpt_typ *hpt=cmc->GetHpt( );
	   for(Int4 s=1; s <= hpt->NumSets(); s++) NilSet(sets[s]); free(sets);
	}
	if(0 && TRUE){ // replace with a cmc->xxx()? 
           fp=open_file(argv[1],"_sq.lpr","w");
           FILE *hfp=open_file(argv[1],"_sq.hst","w");
	   FILE *sfp=open_file(argv[1],"_bst.mma","w");
	   FILE *pfp=open_file(argv[1],"_pdb.mma","w");
	   cmc->PutSeqContrib(fp,hfp,sfp,pfp); 
	   fclose(fp); fclose(hfp); fclose(sfp); fclose(pfp);
	}
	fp=open_file(argv[1],"_new.hpt","w");        // writes a new hpt.
        // cmc->PutSARPHpt(fp);  fclose(fp); // saves hpt settings.
        // cmc->PutHpt(fp);  fclose(fp); // saves hpt settings.
        cmc->PutHptPttrns(fp);  fclose(fp); // saves hpt settings.
#endif
	if(cmc->WriteCheckPoint){ cmc->WriteCheckpoint(0); }

#if 0	// create new cmc_typ to output optimal sequences (pdb seqs in particular)...
	char *tmp_arg=Argv[1]; sprintf(str,"%s_sarp",Argv[1]);
	Argv[1]=AllocString(str); 
	cmc_typ *cmc2 = cmc->OptimizeDisplaySet(HSW,Argc,Argv);
        delete cmc;
	if(cmc2){	// == 0 if hpt is not a tree or if some nodes failed.
		cmc2->PutRTF(FALSE); // cmc2->Put(); 
		delete cmc2; 
	} free(Argv[1]); Argv[1]=tmp_arg; 
#else
	Rtn=cmc->RtnNumFailed();
	if(Rtn > 0) fprintf(stderr,"ERRPR: %d Hpt sets failed\n",Rtn);
        delete cmc;
#endif
	if(swt->OwnHSW() == FALSE){ delete swt; NilHSW(hsw); } else delete swt; 
	NilHSW(HSW);
	if(TrueMainCMA) TotalNilCMSA(TrueMainCMA);
	// ^needed with new random sequence method...
	TotalNilCMSA(in_mcma); NilAlpha(AB);
	for(arg =0; arg < argc; arg++) free(Argv[arg]); free(Argv);
        double runtime=difftime(time(NULL),time1);
        fprintf(stderr, "\ttime(BHPS): %0.1f seconds (%0.2f minutes)\n",
		runtime,runtime/60.0);
	return Rtn;
}

