/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined(_XCS_TYP_)
#define _XCS_TYP_
#include "afnio.h"
#include "stdinc.h"
// #include "alphabet.h"

class xcs_typ {         // cross conserved (rpi) type
public:
	xcs_typ(){ print_error("not allowed"); }
	xcs_typ(char *prefix){ Init(prefix); }
	~xcs_typ(){ Free(); }
	char	*PttrnRes(const char *name){
	   Int4 II,i,j,n;
	   II=GetRow(name);
	   if(II == 0) return 0;
	   char	*tmp; NEW(tmp,maxlen+3,char);
	   for(i=j=0; Pttrn[II][i]; i++){
		if(isalpha(Pttrn[II][i])){ j++; tmp[j]= Pttrn[II][i]; }
	   } if(0) fprintf(stderr,"%s\n",tmp);
	   return tmp;
	}
	Int4	*PttrnPos(const char *name){
	   Int4 II,i,j,n,*values=0;
	   II=GetRow(name);
	   if(II == 0) return 0;
	   char	*tmp; NEW(tmp,maxlen+3,char);
	   NEW(values, maxlen+3,Int4);
	   for(i=j=0; Pttrn[II][i]; i++){
		if(!isalpha(Pttrn[II][i])){ tmp[j]= Pttrn[II][i]; j++; }
	   } if(0) fprintf(stderr,"%s\n",tmp);
	   n=ParseIntegers(tmp,values,"xcs_typ::PttrnsRow()");
	   tmp[0]=n;
	   free(tmp);
	   return values;
	}
	Int4	GetNum(const char *name){
	   Int4	II=this->GetRow(name);
	   return this->NumRow[II];
	}
	Int4	GetRow(const char *name){
	   if(NumLines==0) return 0;
	   Int4	i,II=0;
	   for(i=1; i <= NumLines; i++){
		if(strcmp(name,Row[i]) == 0) return i; 
	   } return 0;
	}
	Int4	PutRow(FILE *fp,const char *name){
	   if(NumLines==0) return 0;
	   Int4 II=this->GetRow(name);
	   if(II > 0) fprintf(fp,"%d.%s:%s\n",NumRow[II],Row[II],Pttrn[II]);
	   return II;
	}
	void	Put(FILE *fp){
	   if(NumLines==0) return;
	   for(Int4 i=1; i <= NumLines; i++){
	     fprintf(fp,"%d.%s:%s\n",NumRow[i],Row[i],Pttrn[i]);
	   }
	}
private:
	char	**Row,**Pttrn;
	Int4	NumLines,maxlen,maxid,*NumRow;
	Int4	GetMaxLeng(FILE *fp){
		    Int4 max=0,n=0;
		    char c;
		    do {
		      for(n=0; (c=fgetc(fp)) != '\n'; ){
			if(c==EOF) break; else n++;
		      } if(max < n) max=n;
		    } while(c != EOF);
		    rewind(fp); return max;
		}
	void	Init(char *prefix){
	    char *str,filename[200]; 
	    Int4 i,j,k,x,n;
	    char *tmpstr,*Str;
	    sprintf(filename,"%s.xcs",prefix);
            FILE *xfp=fopen(filename,"r");
            if(xfp){
	    	maxlen=this->GetMaxLeng(xfp); rewind(xfp);
		str = new char[maxlen + 5];
		for(maxid=n=0; fgets(str,maxlen + 2,xfp) != NULL; ){
		   x=strlen(str);
		   // if(x > maxlen) maxlen=x;
		   if(sscanf(str,"%d.%*[^:]:%*s",&i) != 1){
		   	fprintf(stderr,"string=%s\n",str);
			print_error("xcs_typ: input error 1");
		   } else if(i > maxid) maxid=i; 
		   n++;
		} NumLines=n; rewind(xfp);
		NEW(Str,maxlen +5, char); NEW(tmpstr,maxlen +5, char);
		NEWP(Row,n+3,char); NEW(NumRow,n+3,Int4);
		NEWP(Pttrn,n+3,char); 
		for(Int4 i=0; fgets(str,maxlen+2,xfp) != NULL; ){
		   if(sscanf(str,"%d.%[^:]:%s",&x,tmpstr,Str) == 3){
			i++; NumRow[i]=x;
			Row[i]=AllocString(tmpstr);
			Pttrn[i]=AllocString(Str);
		   } else print_error("xcs_typ: input error 2"); 
		}
		free(Str); free(tmpstr);
		delete [] str;
		fclose(xfp);
	    } else {
		NumLines=0; 
		Row=Pttrn=0; NumRow=0;
	    }
	}
	void	Free(){ 
		if(Row){
		   for(Int4 i=1; i <= NumLines; i++){
			if(Row[i]) free(Row[i]);
		   } free(Row);
		}	
		if(Pttrn){
		   for(Int4 i=1; i <= NumLines; i++){
			if(Pttrn[i]) free(Pttrn[i]);
		   } free(Pttrn);
		}	
		if(NumRow){ free(NumRow); }	
	}

};

#endif

