/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined(_RANDOM_)
#define _RANDOM_
#include <stdio.h>
#include "probability.h"
#include "dheap.h"

#if defined(_OPENMP)
#include <omp.h>
#endif

/* Random no. seeder and generator */
Int4    random_integer(register Int4 max);
void	sRandom(Int4 x);
Int4    *RandomArray(Int4 N);
Int4	Random(void);
Int4	Rand_R(Int4 *seed);	// for parallelized code.
void	sRand_R(Int4 seed,Int4 n);
void	sRand_R_Free( );
double	ran1(Int4 *idum);
double	randOne(Int4 *idum);
double	bnldev(double pp, Int4 n, Int4 *idum);
double	expdev(Int4 *idum);
double  betadev(Int4 a, Int4 b, Int4 *seed);
double  DirichletDev(Int4 *a, double *p, Int4 dim, Int4 *seed);
double	gamdev(Int4 ia, Int4 *idum);
double	gasdev(Int4 *idum);
double	poidev(double xm, Int4 *idum);
void    SampleMultinomial(UInt4 Number, unsigned short classes,
        UInt4 *observed, double *freq);
double	lngamma(double x);
long double lngammal(long double x);


#define	SampleUniformProb()	((double)Random()/(double)0x7fffffff)
#define DIM(A)			(sizeof(A)/sizeof((A)[0]))
#define RANDOM_MAX		0x7fffffff 

#endif 

