/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_CLR_TYP_)
#define _CLR_TYP_

#include "stdinc.h"
#include "afnio.h"
#include <string>

class clr_typ {		// font & PyMOL coloring type.
public:
          // clr_typ( ){ assert(!"Illegal constructor"); }
	  clr_typ(){
		// if(colors==0){ } else { }
		Init();
	  }
	~clr_typ( ){ Free( ); }
	Int4    get_font_color_code(char ColorCode);

	// X=libchn/chn_cha.cc
	char    *GetFontColors(const char *ColorFont, Int4 NumAnalysis);

	// for X=libpdb/pml_typ.cc
	const char *RtnColorChn(char c);
	void	PrintResColor(FILE *fp,char *selection,char color);
	void    SetColorsPyMOL(FILE *fp);

	// X=libchn/chn_cha.cc libaln/cmsa_rtf.cc libaln/sma.cc
	void    PutRtfColorTbl(FILE *fptr);
	const char RtnClassPyMOL(Int4 i){ return clss[i]; }
	char	*RtnSideColorsPyMOL()
		{ return AllocString("WYROMGCBPTNLWWWWWWWWWWWWWWWDDDDDDDDDDDDDDDD"); }
	char	*RtnTraceColorsPyMOL()
		{ return AllocString("WYROMGCBPTNLWWWWWWWWWWWWWWWDDDDDDDDDDDDDDDD"); }
private:
	char *level;	// libsprs/scl_typ.cc
	// char *color_trace,*color_side;	// for libsarp/p2c_typ.cc
	char *clss;			// for libpdb/pml_typ.cc
	void	Init(){ 
		//  clss = AllocString(" YROMGCBPTNLFHIJKLNQSTUVWXZ ");
		clss = AllocString("WYROMGCBPTNLWWWWWWWWWWWWWWWDDDDDDDDDDDDDDDD"); 
		level= AllocString(" YROMGCBDDDDDDDDD  ");
		// color_trace = AllocString("WYROMGCBPTNLWWWWWWWWWWWWWWWDDDDDDDDDDDDDDDD");
		// color_side = AllocString("WYROMGCBPTNLWWWWWWWWWWWWWWWDDDDDDDDDDDDDDDD");
	}
	void	Free(){ 
		free(clss); free(level); // free(color_trace); free(color_side);
	}
};

#endif

