/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "clr_typ.h"

Int4    clr_typ::get_font_color_code(char ColorCode)
// code for rtf files.
{
        Int4    color;

    switch (ColorCode){         // get color for sequence name...
        case 'B': color = 2; break;     // blue
        case 'C': color = 3; break;     // cyan
        case 'G': color = 4; break;     // green
        case 'M': color = 5; break;     // magenta
        case 'R': color = 6; break;     // red
        case 'Y': color = 7; break;     // yellow
        case 'W': color = 8; break;     // white
        case 'b': color = 9; break;     // dk blue
        case 'T': color = 10; break;    // teal
        case 'g': color = 11; break;    // dk green
        case 'm': color = 12; break;    // violet
        case 'r': color = 13; break;    // dk red
        case 'y': color = 14; break;    // dk yellow
        case 'D': color = 15; break;    // dk grey
        case 'L': color = 16; break;    // lt grey
        case 'P': color = 17; break;    // purple
        case 'p': color = 18; break;    // pink
        case 'O': color = 19; break;    // orange
        case 'o': color = 20; break;    // dk orange
        case 'c': color = 21; break;    // dk cyan
        default: color = 1; break;       // black
    } return color;
}

char    *clr_typ::GetFontColors(const char *ColorFont, Int4 NumAnalysis)
//=============  Get font colors... ===============
{
    // fprintf(stderr,"NumAnalysis=%d; color=%s\n",NumAnalysis,ColorFont);
    // use 2,3,4,..,(NumAnalysis+1)/2;
    char        *color_font=0;
    if(ColorFont == 0){
//fprintf(stderr,"DEBUG color_font=0\n");
      Int4 n=(NumAnalysis+1)/2;
      switch(n){        // Make sure this is consistent with color_side[] in p2c_typ.cc
       case 1: color_font=AllocString(" y   "); break;
       case 2: color_font=AllocString(" Ly   "); break;
       case 3: color_font=AllocString(" LRy   "); break;
       case 4: color_font=AllocString(" LoRy   "); break;
       case 5: color_font=AllocString(" LMoRy   "); break;
       case 6: color_font=AllocString(" LgMoRy   "); break;
       case 7: color_font=AllocString(" LCgMoRy   "); break;
       case 8: color_font=AllocString(" LBCgMoRy   "); break;
       case 9: color_font=AllocString(" LPBCgMoRy   "); break;
       case 10: color_font=AllocString(" LTPBCgMoRy   "); break;
       case 11: color_font=AllocString(" LrTPBCgMoRy   "); break;
       case 12: color_font=AllocString(" WDrTPBCgMoRy   "); break;
       default: color_font=AllocString(" cDpBGRTmbgry                              ");
	fprintf(stderr,"%d colors requested\n",n);
        print_error("too many color categories for clr_typ::GetFontColors().");
        break;
      }
    } else color_font=AllocString(ColorFont);
//fprintf(stderr,"DEBUG color_font=%s\n",color_font);
    return color_font;
}

void	clr_typ::PutRtfColorTbl(FILE *fptr)
{
    fprintf(fptr,"{\\colortbl;\\red0\\green0\\blue0;"); // 1.black=default
    fprintf(fptr,"\\red0\\green0\\blue255;");		// 2.blue=B
    fprintf(fptr,"\\red20\\green210\\blue230;");	// 3.cyan=C
    fprintf(fptr,"\\red0\\green255\\blue0;");		// 4.green=G
    fprintf(fptr,"\\red230\\green5\\blue190;");		// 5.magenta=M
    fprintf(fptr,"\\red255\\green0\\blue0;");		// 6.red=R
    fprintf(fptr,"\\red255\\green255\\blue0;");		// 7.yellow=Y
    fprintf(fptr,"\\red255\\green255\\blue255;");	// 8.white=W
    fprintf(fptr,"\\red0\\green0\\blue128;");		// 9.dk blue=b
    fprintf(fptr,"\\red0\\green128\\blue128;");		// 10.teal=T
    fprintf(fptr,"\\red0\\green175\\blue0;");		// 11.dk green=g
    fprintf(fptr,"\\red128\\green0\\blue128;");		// 12.violet=m
    fprintf(fptr,"\\red150\\green0\\blue0;");		// 13.dk red=r
    fprintf(fptr,"\\red128\\green128\\blue0;");		// 14.dk yellow=y
    /** 15 dk grey; 16 lt grey (original) **/
    fprintf(fptr,"\\red128\\green128\\blue128;");	// 15.dk grey=D
    fprintf(fptr,"\\red192\\green192\\blue192;");	// 16.lt gray=L
    /** 17 pink; 18 orange; **/
    fprintf(fptr,"\\red128\\green0\\blue255;");		// 17.purple=P
    fprintf(fptr,"\\red255\\green102\\blue255;");	// 18.pink=p
    fprintf(fptr,"\\red225\\green180\\blue0;");		// 19.orange=O
    fprintf(fptr,"\\red225\\green110\\blue10;");	// 20.dk orange=o
    fprintf(fptr,"\\red57\\green154\\blue181;}");	// 21.dk cyan=c
}

static const char *pml_chn_colors[] = { "brown",
        "dkyellow", "lightblue", "palecyan","lightorange", "olive",
        "salmon", "palegreen", "limon","bluewhite", "dkorange",
        "firebrick", "deeppurple", "lightpink", "darksalmon", "deepteal",
        "dirtyviolet", "forest", "lightteal", "marine", "purple",
        "raspberry", "slate", "smudge", "wheat", "sulfur",
        "warmpink", "pink", "violetpurple", "sand", "splitpea",
        "yelloworange", "bluewhite", "grey80", "grey80", "grey80",
        "grey80"};

const char *clr_typ::RtnColorChn(char c)
{
        char  str[20];
        switch (c){
          case 'A': return pml_chn_colors[1];
          case 'B': return pml_chn_colors[2];   // "lightblue"
          case 'C': return pml_chn_colors[3];
          case 'D': return pml_chn_colors[4];
          case 'E': return pml_chn_colors[5];
          case 'F': return pml_chn_colors[6];
          case 'G': return pml_chn_colors[7];   // "palegreen"
          case 'H': return pml_chn_colors[8];
          case 'I': return pml_chn_colors[9];
          case 'J': return pml_chn_colors[10];
          case 'K': return pml_chn_colors[11];
          case 'L': return pml_chn_colors[12];
          case 'M': return pml_chn_colors[13];  // "lightpink"
          case 'N': return pml_chn_colors[14];
          case 'O': return pml_chn_colors[15];
          case 'P': return pml_chn_colors[16];
          case 'Q': return pml_chn_colors[17];
          case 'R': return pml_chn_colors[18];
          case 'S': return pml_chn_colors[19];
          case 'T': return pml_chn_colors[20];
          case 'U': return pml_chn_colors[21];
          case 'V': return pml_chn_colors[22];
          case 'W': return pml_chn_colors[23];
          case 'X': return pml_chn_colors[24];
          case 'Y': return pml_chn_colors[25];
          case 'Z': return pml_chn_colors[26];
          default: return pml_chn_colors[0];
        }
}

void	clr_typ::SetColorsPyMOL(FILE *fp)
{
	// use <color>1 for matches; <color>0 for mismatches.
        fprintf(fp,"cmd.set_color(\"yellow1\",\"[235,235,0]\")\n");
        fprintf(fp,"cmd.set_color(\"yellow0\",\"[255,255,150]\")\n");

        fprintf(fp,"cmd.set_color(\"red1\",\"[255,100,100]\")\n");
        fprintf(fp,"cmd.set_color(\"red0\",\"[255,190,190]\")\n");

        fprintf(fp,"cmd.set_color(\"orange1\",\"[225,178,51]\")\n");
        fprintf(fp,"cmd.set_color(\"orange0\",\"[255,204,127]\")\n");

        fprintf(fp,"cmd.set_color(\"magenta1\",\"[255,100,255]\")\n");
        fprintf(fp,"cmd.set_color(\"magenta0\",\"[255,190,255]\")\n");

        fprintf(fp,"cmd.set_color(\"green1\",\"[70,230,70]\")\n");
        fprintf(fp,"cmd.set_color(\"green0\",\"[180,255,180]\")\n");

        fprintf(fp,"cmd.set_color(\"cyan1\",\"[70,230,230]\")\n");
        fprintf(fp,"cmd.set_color(\"cyan0\",\"[180,255,255]\")\n");

        fprintf(fp,"cmd.set_color(\"blue1\",\"[140,160,255]\")\n");
        fprintf(fp,"cmd.set_color(\"blue0\",\"[190,200,255]\")\n");

        fprintf(fp,"cmd.set_color(\"purple1\",\"[190,120,255]\")\n");
        fprintf(fp,"cmd.set_color(\"purple0\",\"[230,195,255]\")\n");

        fprintf(fp,"cmd.set_color(\"teal1\",\"[30,190,180]\")\n");
        fprintf(fp,"cmd.set_color(\"teal0\",\"[140,205,190]\")\n");

        fprintf(fp,"cmd.set_color(\"brown1\",\"[205,105,60]\")\n");
        fprintf(fp,"cmd.set_color(\"brown0\",\"[230,185,160]\")\n");

        fprintf(fp,"cmd.set_color(\"gray1\",\"[178,178,178]\")\n");
        fprintf(fp,"cmd.set_color(\"gray0\",\"[255,255,255]\")\n"); // = white

	fprintf(fp,"cmd.set_color(\"gray2\",\"[170,170,170]\")\n");
	fprintf(fp,"cmd.set_color(\"blue2\",\"[200,200,255]\")\n");
}

void    clr_typ::PrintResColor(FILE *fp,char *selection,char color)
// for Pymol scripts only.
{
        char    *clr,mode=' ';
	Int4	code=0;
        static char Colors[][16]={" ","yellow1","red1","orange1","magenta1",
			"green1","cyan1","blue1","purple1","teal1","brown1",
			"gray1","white"};
        static char LtColors[][16]={" ","yellow0","red0","orange0","magenta0",
			"green0","cyan0","blue0","purple0","teal0","brown0",
			"gray0","white"};
	if(islower(color)) mode='L'; // mismatching residues are pale colored.
	color=toupper(color);
        switch (color){
           case 'Y': code=1; break;
           case 'R': code=2; break;
           case 'O': code=3; break;
           case 'M': code=4; break;
           case 'G': code=5; break;
           case 'C': code=6; break;
           case 'B': code=7; break;
           case 'P': code=8; break;
           case 'T': code=9; break;
	   case 'N': case 'D': code=10; break;	// nut or dark = brown
           case 'L': code=11; break;
           case 'W': code=12; break;
           default: code=11; break;
	}
	if(mode=='L') clr=LtColors[code]; else clr=Colors[code];
	fprintf(fp,"cmd.color(\"%s\",\"%s\")\n",clr,selection);
}

