/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_DDS_TYP_)
#define _DDS_TYP_

#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include "set_typ.h"
#include "dheap.h"
#include "stdinc.h"
#include "histogram.h"
#include "alphabet.h"
#include "residues.h"
#include "pdb.h"
#include "dheap.h"
#include "afnio.h"
#include "random.h"

class dds_typ {	// Distance Difference Score type.
public:
	dds_typ( ) { assert(!"Illegal constructor"); }
	dds_typ(pdb_typ *P,char *c, char **RX,char **RY,Int4 *AX, Int4 *AY,
		char **pdbID, BooLean vrbs=FALSE)
	   {
	    PDB=P; chn=c; ResX=RX; ResY=RY; AdjstX=AX; AdjstY=AY; 
	    PDBID=pdbID; GetLen();
	    if(vrbs) efp=stderr; else efp=0; Init();
	   }
	double	**Put(FILE *ofp=stdout,double cutoff=2.0);
	Int4	RtnNP(){ return NP; }
#if 0
	double	*RtnScoresA(){ return score[A]; }
	double	*RtnScoresB(){ return score[B]; }
#endif
	Int4	GetNotUsed(Int4 &MSA1,Int4 &MSA2)
		  { MSA1=CardSet(NotUsd[A]); MSA2=CardSet(NotUsd[B]); }
	~dds_typ( ) { Free(); }
private:
	//=============== internal functions ==================
	void	GetLen(){
		  char c;
		  LenX=LenY=0;
		  for(Int4 i=0; (c=ResX[1][i]) != 0; i++)
			if(isupper(c) || c == '-') LenX++;
		  for(Int4 i=0; (c=ResY[1][i]) != 0; i++)
			if(isupper(c) || c == '-') LenY++;
		}
	Int4	Refine(double **SD,double **score,double cutoff=2.0);
	double	**Run(FILE *ofp,Int4 *NumUsd[]);
	set_typ	FindCommonRes(res_typ *RsA, res_typ *RsB);
	void	Init();
	void	Free();
	res_typ *RES2COLS(res_typ *RsX,Int4 nres,Int4 &N);
	char	*MSA2COLS(char *RsX,Int4 &N);
	res_typ *CheckMSA(res_typ *AllRes,Int4 nres,char *RsX,Int4 &NumCol);
	res_typ *GetCol2K(char *RsX, Int4 min, Int4 max,Int4 Adjst,
			res_typ *AllRes,Int4 &Ncol);
	float   **CalcDist(res_typ *AllRes,Int4 nresX);
	double	CalcDistDiff(res_typ **AllRes,Int4 *nres,Int4 &CntUsd,
					set_typ not_usd=0);
	Int4    AddGaps(res_typ *col_res,set_typ Omit);
	//=============== input structures ==================
	Int4	LenX,LenY;
	char	**PDBID;
	pdb_typ *PDB;
	char	*chn,**ResX,**ResY;
        Int4	*AdjstX,*AdjstY;
	set_typ NotUsd[4];	// columns that are not used.

	//=============== internal structures ==================
	FILE	*efp;
	Int4	minCol;
	const Int4 X=0,Y=1,A=0,B=1;
	Int4	*nresX,*ncolX[4];
	a_type	AB;
	Int4	NP;
	res_typ **AllRes,**ColRes[4];
	Int4	*NumCols[4];
	atm_typ *atm0;
	res_typ	deleted;
	time_t  time1;
};

#endif

