/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "dds_typ.h"

res_typ *dds_typ::GetCol2K(char *RsX,Int4 min,Int4 max,Int4 Adjst,
		res_typ *AllRes,Int4 &Ncol)
#if 0
  RsX = "trka----GYLNarNKTGLVSSTWD": Adjst=9.
===== 4. pdb/2x18_H.pdb A (4..114; 111 res.; adjstX,Y= 3,-12) =====
msdvtivKEGWVQKRGEYIKNWRPRY... MSA 1: start is 3 ahead of pdb sequence.
geyi--------------K-NWRPRY... MSA 2: start is -12 (behind) pdb sequence.
   VTIVKEGWVQKRGEYIKNWRPRY... pdb: residues = 4..114

            |
gse--e-RT-WQG..	sqI; Adjst=7  initial i = 7;
............G..  pdbSq:
start: i = 7; k=1;  
after: del=4; adjst = 4; i=
#endif
{
	Int4	maxi,lstI,I,lsti,i,ii,lstk,k,N,M,col,del,pass;
	char	c,C;
	for(N=0,k=1; AllRes[k]; k++) N++;
	maxi = strlen(RsX)-1;
	M = MAXIMUM(Int4, N, max);
	res_typ	*colres; NEW(colres,strlen(RsX)+M+3,res_typ);
	for(lstk=lstI=lsti=0,pass=del=col=0,k=1; k <= N; k++){
	   I=ResidueID(AllRes[k]);
#if 0	// all getting put into a single res_typ???
	   // Are there alternative res at I? (with distinct iCodes?
	   while(k < N && I==ResidueID(AllRes[k+1])){	
		// assert(isprint(iCodeResidue(AllRes[k])));  // has an iCode?
		k++;
	   }
#endif
	   C=GetCharResidue(AllRes[k],AB);	// Residues from pdb file.
	   i = I - min + Adjst + del;
	   //===== Find MSA columns prior to start (I==min) of pdb seq. =====
	   if(pass==0 && k==1 && I == min && del==0 && i > 0){
		assert(i == Adjst);
		pass++;
		for(ii=0; ii < i; ii++){   // find '-' prior to pdb start.
		   c=RsX[ii];
		   if(c=='-'){
			col++; colres[col]=deleted; // == dummy residue
			if(efp) fprintf(efp,"%d: deletion '-'%d (not in pdb) %d\n",
				k,ii,col);
		 	del++; i++;  // move up the array by 1 ...
		   } else if(isupper(c)){
		        col++; colres[col]=deleted; // == dummy residue
	   	        if(efp) fprintf(efp,"%d: %c%d missing from pdb %d\n",
				k,c,ii,col);
		   } else if(islower(c)){
	   	        if(efp) fprintf(efp,"%d: %c%d missing from pdb %d\n",
				k,c,ii,col);
		   }
		} k--; continue;	// keep k == 1
	   } 

	   //============ 'i' larger when pdb missing residues. ============
	   if(i > maxi) break;	
	   if(k == 1){ lstI=I-1; lsti=i-1; }
	   //=============== MSA seq. starts within pdb seq... =============
	   if(i < 0){ 		
		if(efp) fprintf(efp,"%d: %c%d (i=%d; maxi=%d) missing from MSA %d\n",
				k,C,I,i,maxi,col);
		lstI=I; lsti=i; continue; 
	   } 
#if 0
	   if(efp) fprintf(stderr,
		"tmp->%d.%c%d: min=%d maxi=%d; col=%d; lstI/i=%d/%d; I=%d\n",
			k,RsX[i],i,min,maxi,col,lstI,lsti,I);
#endif
	   //=============== Deal with missing pdb residues... =============
	   if(i >= 0){	// Check to see whether there is a gap in pdb file.
		ii=lsti; ii++; 
		if(ii > maxi || (ii >= 0 && RsX[ii] == 0)) break;
		while(ii < i){	//==== ii == i if no gap is present. ====
		  // 'i' can be very large when pdb file is missing residues.
		  if(ii < 0){
	   	      if(efp) fprintf(efp,"%d.%d: X%d missing %d\n",k,i,ii,col);
		      ii++; continue; 
		  }
	   	  if((c=RsX[ii]) == 0) break;
		  else if(isupper(c) || c == '-'){
		     col++; colres[col]=deleted; 
		     if(c == '-'){ del++; i++; // i++ because del++ 
			// if(i > maxi || RsX[i] == 0) break; // old
		     }
		  } else if(!islower(c)){
			free(colres); return 0;
			print_error("GetCol2K() input error 0");
		  }
	   	  if(efp) fprintf(efp,"%d: missing %c%d %d (%d)\n",k,c,ii,col,i);
		  lsti=ii; ii++;	// diff with old version
		  if(ii > maxi || RsX[ii] == 0) break;
		} 
	   }
	   //======= 'i' very large when pdb file is missing residues. ========
	   if(i > maxi || (c=RsX[i]) == 0){ lsti=i; lstI=I; lstk=k; break; }
	   else if(isupper(c)){	// i = residue position in aligned seq
		col++; colres[col]=AllRes[k];
	   	if(efp) fprintf(efp,"%d: %c%d == %c%d  %d\n",k,C,I,c,i,col);
		if(C != c && c != 'X' && C != 'X'){
	   	  fprintf(stderr,"%d: %c%d != %c%d\n",k,C,I,c,i);
	   	  fprintf(stderr," min=%d; Adjst=%d; del=%d\n",min,Adjst,del);
		  fprintf(stderr,"RsX=");
		  while(RsX[i]){ fprintf(stderr,"%c",RsX[i]); i++; }
		  fprintf(stderr,"\n res_typ = %c%d",C,I);
	          I=ResidueID(AllRes[1]); C=GetCharResidue(AllRes[1],AB);
		  fprintf(stderr,"\n (1st: res_typ = %c%d)\n",C,I);
		  free(colres); return 0;
		  print_error("GetCol2K() input error 1");
		}
	   } else if(c == '-'){
		col++; colres[col]=deleted; // == dummy residue
		if(efp) fprintf(efp,"%d: deleted '%c'%d   %d\n",k,c,i,col);
		k--; del++; // repeat k;
	   } else if(islower(c)){
		if(efp) fprintf(efp,"%d. %c%d == %c%d insertion %d\n",k,C,I,c,i,col);
		if(c != 'x' && C != toupper(c)){
		   while(RsX[i]){ fprintf(stderr,"%c",RsX[i]); i++; }
		   fprintf(stderr,"%d. %c%d = %c%d insertion\n",k,C,I,c,i);
		   fprintf(stderr,"\n res_typ = %c%d; c='%c'",C,I,c);
		   fprintf(stderr,"\n min=%d; adjst=%d; I=%d; del=%d\n",
			min,Adjst,I,del);
		   free(colres); return 0;
		   print_error("GetCol2K() input error 2");
		}
	   } else {
		fprintf(stderr,"%d. error %c%d = %c%d; Adjst=%d\n",k,C,I,c,i,Adjst);
		while(RsX[i]){ fprintf(stderr,"%c",RsX[i]); i++; }
		free(colres); return 0;
		print_error("GetCol2K() input error 3");
	   } lstI=I; lsti=i; lstk=k;
	}
	if(efp) fprintf(efp,
		"%d/%d.%d: min=%d maxi=%d; col=%d; lstI/i=%d/%d; I=%d\nRsX=%s\n",
			k,N,i,min,maxi,col,lstI,lsti,I,RsX);
#if 0
	k=N; I=ResidueID(AllRes[k]); // C=GetCharResidue(AllRes[k],AB);
	i = I - min + Adjst + del; i++;
#else
	k=N; I=ResidueID(AllRes[k]); // C=GetCharResidue(AllRes[k],AB);
	i=lsti; i++; 
#endif
	// pdb seq ends prior to end of MSA seq.
	for( ; i <= maxi && (c=RsX[i]) != 0; i++){
	   if(isupper(c) || c == '-'){	// i = residue position in aligned seq
		col++; colres[col]=deleted;
		if(efp) fprintf(efp,"%d: absent in pdb '%c'%d (col=%d)\n",k,c,i,col);
	   }
	}
	Ncol=col;
	return colres;
}

