/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_CMPSS_TYP_)
#define _CMPSS_TYP_

#include <cstdlib>
# include <iostream>
# include <iomanip>
# include <omp.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

// #include <cuda.h>
// #include <cuda_runtime_api.h>

#include "ccmpred.h"
#include "evaluate_cpu.h"
#include "evaluate_cpu_omp.h"
#include "evaluate_cuda.h"
#include "evaluate_cuda_kernels.h"
#include "io.h"
// #include "meta.h"
#include "numdif.h"
#include "parseopt.h"
#include "reweighting.h"
#include "sequence.h"
#include "swaln.h"
#include "util.h"
#include <stdbool.h>
#include "conjugrad.h"

#if 0	// create libdrc.a
#include "ssd_typ.h"
#include "rdc_typ.h"
#endif

#include "c2a_typ.h"

#include "omc_typ.h"
#include "lha_typ.h"
#include "hierview.h"
#include "c2h_typ.h"
#include "hsc_typ.h"
#include "edc_typ.h"
#include "sprc_typ.h"
#include "scl_typ.h"
#include "dds_typ.h"
#include "drc_typ.h"

#include "stdinc.h"
#include "histogram.h"
#include "alphabet.h"
#include "residues.h"
#include "cmsa.h"
#include "dheap.h"
#include "afnio.h"
#include "random.h"

// # using namespace std;

extern "C" int run_ccmpred(int argc, char **argv);

class cps_typ { // Distance Difference Score type.
public:
        cps_typ( ) { assert(!"Illegal constructor"); }
        cps_typ(int ac, char *av[]) { argc=ac; argv=av; Init( ); }
        int	Run( ) {
		int rtn; 
		if(PutCommonMSAs){  PrepSP( ); rtn=0; }
		else if(mode=='C') rtn=Prepare(); else rtn=Compare(); 
		return rtn;
	}
        ~cps_typ( ) { Free(); }
private:
        int	PrepSP( )
	   { this->ReadPDB_ID(); this->RunPreDCA();}
	void    RunPreDCA();
	BooLean	PutCommonMSAs;
	BooLean	UseGoldStd;
	double	SignCut_dS;
	Int4	MaxXIJ;
	int	Compare(){ 	// must be run in this order...
		  this->ReadPDB_ID(); 
		  this->RunDCA(); 
		  this->RunMain(); 
		  if(KeepAllOut) this->DummyDDS(); else this->RunDDS(); 
		  this->Put(); 
		}
	void	DummyDDS(){
		  Int4 i,NP=NumPDB_ID;
		  NEWP(stdev,8,double);
        	  NEW(stdev[1],NP+3,double); NEW(stdev[2],NP+3,double); 
		  NEW(stdev[3],NP+3,double); NEW(stdev[4],NP+3,double);
		  for(i=1; i <= NP; i++){
		   stdev[1][i]=stdev[2][i]=1.0; stdev[3][i]=stdev[4][i]=2.5;
		  }
		}
	BooLean	KeepAllOut;
	double	CutDel;
	//================= cps_init.cc ===================
	void	Init();
	void	Free();
	char	*BaseName(char *path);
	float	ccm_wt,ccm_LF;

	Int4	PercentID;
	char	**GetKeyPDB(char *file, Int4 &num);
	set_typ	FindPurgePDBIDs(Int4 percent_ident,cma_typ cma);

	//================== cps_prep.cc ==================
	int	Prepare();

	//================== cps_run.cc ==================
	int	RunMain();
	char    *GetResidues(FILE *fp,Int4 ii,set_typ MstI, char *&resX,
			char *strI, char pdbID[]);
	void    PutDebug1(Int4 i,Int4 adj,char IJ, e_type sqE,e_type sqPDB,
                        Int4 min,Int4 rtn);
	e_type	RtnResI_SqI(FILE *fp,Int4 i,set_typ MstI, char *&resX,
                char *strI, char pdbID[],char *&ResI);

	//================== cps_dds.cc ==================
	int	RunDDS();

	//================== cps_typ.cc ==================
	double	**PutSqWts(FILE *fp,e_type *SEQ);
	BooLean IsTheSameSeqID(e_type E1, e_type E2);
	int	IsSameSeq(e_type E1, e_type E2,Int4 *Start,Int4 MinOverlap,
			Int4 &NumX,Int4 &NumM,BooLean IgnoreX=TRUE);
	cma_typ *RtnCommonCMSA(cma_typ cmaI, cma_typ cmaJ);
	cma_typ *RmInsrtColsCMSA(char *oper,cma_typ cmsaA,cma_typ cmsaB);
	cma_typ RmWrstJSDColsCMSA(set_typ SetI,cma_typ cmsaA);
	cma_typ RmInsertColumnsCMSA(char *Operation, cma_typ CMA);

	//============== cps_init.cc ======================
	FILE	*outfp;	// for *.cmps output file.
	char	**ArgV; 
	Int4	ArgC;

	//============== cps_pdb.cc ======================
	Int4    ReadPDB_ID();
	pdb_typ SafeOpenPDB(char *pdbID,Int4 &min,Int4 &max, Int4 &chnK);
	Int4	PercentIdentity(set_typ SetPDB,char **pdb_id,double **RD);
	Int4	RmPoorRefStrct(set_typ SetPDB,char **pdb_id,double **&RD);
	pdb_typ ChangeCMH2Cys(pdb_typ P,Int4 C);

	//============== cps_put.cc ======================
	void	Put();
	Int4	hpsz,minSpace;
	double	**stdev,mxD;

	//============== cps_dca.cc ======================
	void    RunDCA();

	//============== read pdb ======================
	char	*name1,*name2,**pdb_id,*CHN,**ResX,**ResY,**PDBID;
	Int4	NumPDB_ID,NN,*AdjstX,*AdjstY;
	double	*MaxPCID,*PCALN[3];
	set_typ *UsdSet;
	double  **RtnI,**RtnJ;
	pdb_typ *PDB; 
	dch_typ **DCH[4];
	e_type	*SEQ;

	Int4	NumRefStrctReject[4],NumBadMstStrct;
	Int4	NumMissingStrct,NumAlignedStrct,NumBadStrct,NumNoMatStrct;
	
	double	cutoff;
	UInt4   Seed;
	int	argc;
	char	*Str,str[200],**argv;
	Int4	gpu_num,thrds;
	char	mode;	// 'R' = run compass; 'C' == check MSAs. 
	FILE	*efp,*logfp;
	a_type	AB;
	BooLean	verbose;
	Int4	LenA,LenB;
	cma_typ	cmaA,cmaB;
	Int4	time1;
};

#endif

