
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

double	**cps_typ::PutSqWts(FILE *fp,e_type *SEQ)
{ 
	Int4	NN,i,n,m,sum,N,score,max,total,ave,Max;
	double	T,K,H,*pr,p,d;
	double	**RTN; 
	e_type	E1,E2;
	BooLean	xnu=TRUE,shuffle=FALSE;

	for(NN=0,i=1; SEQ[i]; i++) NN++;
	NEWP(RTN,4,double); NEW(RTN[1],NN+3,double); NEW(RTN[2],NN+3,double);
	if(fp){
	    fprintf(fp,"     ");
	    for(n=1; n <= NN; n++) fprintf(fp," %4d",n);
	    fprintf(fp," %4s\n","ave");
	}
	Int4 **scores = new Int4 *[NN + 2];
	for(n = 1; n <= NN; n++) scores[n] = new Int4 [NN+2];
	for(max=0,sum=N=0, n=1; n <= NN; n++){
	   E1=SEQ[n];
	    // PutXSeq(stdout,E1,AB);
	   if(fp) fprintf(fp," %4d",n);
	   Max=0;
	   for(ave=0,m=1; m <= NN; m++){
	   	E2=SEQ[m];
		score = FastAlnSeqSW(12, 4, E1, E2, AB);
		if(fp) fprintf(fp," %4d",score);
		if(n <= m) scores[n][m]=scores[m][n]=score;
		if(n<m) {max=MAXIMUM(Int4,score,max); sum+=score; N++; }
		if(n!=m){ ave+=score; Max=MAXIMUM(Int4,score,Max); }
	   }
	   RTN[1][n]=(double)ave/(double)(NN-1); RTN[2][n]=(double)Max;
	   if(fp) fprintf(fp," %4d\n",(Int4)RTN[1][n]);
	}
	if(fp) fprintf(fp,"\n\taverage score = %g; maximum = %d\n\n",
                (double)sum/(double)N,max);
	for(n = 1; n <= NN; n++) delete [] scores[n]; delete [ ] scores;
	return RTN;
}

BooLean cps_typ::IsTheSameSeqID(e_type E1, e_type E2)
// use this to replace IsSameSeqID() in cma_typ once well tested.
{
        char    *info1=E1->info,*info2=E2->info;
        Int4    i;
        for(i=0; info1[i] && info2[i]; i++){
                if(info1[i] != info2[i]) return FALSE;
                // if(info1[i] == ' ' && info2[i] == ' ') return TRUE;
                if(isspace(info1[i]) && isspace(info2[i])) return TRUE;
        } if(info1[i]==0 && info2[i]==0) return TRUE;
        else return FALSE;
}

cma_typ	*cps_typ::RtnCommonCMSA(cma_typ cmaI, cma_typ cmaJ)
// return two cma_files corresponding to the input cma_files with shared sequences.
// to find bifurcated seqs use: twkcma CDD_EEP_A -sameIDs
{
	//========== 
	Int4 I,J,nI=NumSeqsCMSA(cmaI),nJ=NumSeqsCMSA(cmaJ);
	set_typ setI=MakeSet(nI+5),setJ=MakeSet(nJ+5);
	ClearSet(setI); ClearSet(setJ);

	//========== fill in sequence sets ===========
	e_type	sqI,sqJ;
	for(I=1; I < nI; I++){
	   if(MemberSet(I,setI)) continue;
	   sqI=TrueSeqCMSA(I,cmaI);
	   for(J=1; J <= nJ; J++){
		if(MemberSet(J,setJ)) continue;
	   	sqJ=TrueSeqCMSA(J,cmaJ);
		if(IsTheSameSeqID(sqI,sqJ)){
		   Int4 rtn,AdjstI,MinOverlap=10,NumX,NumM;
	           rtn=this->IsSameSeq(sqI,sqJ,&AdjstI,MinOverlap,NumX,NumM);
	           if(rtn == 0 || NumX > NumM){
		      StrSeqID(str,20,sqI);
		      // fprintf(stderr,"Seqs fail to match %s; skipping\n",str);
		      if(efp){
		 	AlnSeqSW(efp,11,1,sqI,sqJ,AB); 
			fprintf(efp,"%s: rtn=%d; Adjst=%d\n",str,rtn,AdjstI);
		      } 
	   	   } else { AddSet(I,setI); AddSet(J,setJ); break; }
		}
	   }
	}
	if(CardSet(setI) < 1 || CardSet(setJ) < 1)
		print_error("MSAs share no sequences in common");
	//========== end fill in sequence sets ===========
	fprintf(stderr,"setI = %d; setJ = %d\n",CardSet(setI),CardSet(setJ));
	cma_typ	*rcma;  NEW(rcma,4,cma_typ);
	FILE *fp=tmpfile(); PutInSetCMSA(fp,setI,cmaI); rewind(fp); 
	rcma[1]=ReadCMSA(fp,AB); fclose(fp);
	fp=tmpfile(); PutInSetCMSA(fp,setJ,cmaJ); rewind(fp); 
	rcma[2]=ReadCMSA(fp,AB); fclose(fp);
	NilSet(setI); NilSet(setJ);
	return rcma;
}

cma_typ	*cps_typ::RmInsrtColsCMSA(char *oper,cma_typ cmsaA,cma_typ cmsaB)
{
	Int4	i,j,s,e,lenI,lenJ;
	cma_typ	*rtncma=0; NEW(rtncma, 4, cma_typ);
	cma_typ	cmaI=CopyCMSA(cmsaA),cmaJ=CopyCMSA(cmsaB);
	cma_typ	rcma,xcma;
	lenI=LengthCMSA(1,cmaI); lenJ=LengthCMSA(1,cmaJ);
	fprintf(stderr,"tb: '%s'\n",oper);
	fprintf(stderr,"TB: ");
	e=strlen(oper); e--;
	if(oper[e] == '*') e--;
	for(i=lenI,j=lenJ; e >= 0; e--){
	   switch(oper[e]){
		case 'm': i--; j--; break;
		case 'i': 
		  fprintf(stderr,"%d.%c --> rm I col %d\n",e,oper[e],i);
	    	  xcma=ConvertColsToInsertsCMSA(cmaI,1,i,i);
		  NilCMSA(cmaI); cmaI=xcma;
		  i--;
		  break;
		case 'd': 
		  fprintf(stderr,"%d.%c --> rm J col %d\n",e,oper[e],j);
	    	  xcma=ConvertColsToInsertsCMSA(cmaJ,1,i,i);
		  NilCMSA(cmaJ); cmaJ=xcma;
		  j--;
		  break;
		default: print_error("RmInsrtColsCMSA() input error");
	   }
	} fprintf(stderr,"\n");
	rtncma[1]=cmaI; rtncma[2]=cmaJ; 
	return rtncma;
}

cma_typ	cps_typ::RmWrstJSDColsCMSA(set_typ SetI,cma_typ cmsaA)
{
	Int4	i,j,lenI;
	cma_typ	xcma,cmaI=CopyCMSA(cmsaA);
	lenI=LengthCMSA(1,cmaI); 
	for(i=lenI; i > 0; i--){
	   if(MemberSet(i,SetI)){
		if(i==1){ // Trim
                  xcma=TrimBlkCMSA(cmaI,1,1,0,1);
		  // Blk=1; RmLeft < 0; RmRight=0; limit=1.
		} else if(i==lenI){
                  xcma=TrimBlkCMSA(cmaI,1,0,1,1);
		  // Blk=1; RmLeft=0; RmRight > 0; limit=1.
		  lenI = LengthCMSA(1,xcma);
		} else {
	    	  xcma=ConvertColsToInsertsCMSA(cmaI,1,i,i);
		} NilCMSA(cmaI); cmaI=xcma;
	   }
	} return cmaI;
}

cma_typ	cps_typ::RmInsertColumnsCMSA(char *Operation, cma_typ CMA)
// Remove the positions within CMA with an 'd' in corresponding Operation array.
{
	assert(nBlksCMSA(CMA) == 1);
	Int4	i,j,n,len=strlen(Operation)-2;
	Int4	start,end,o,Len=LengthCMSA(1,CMA);
	assert(Len==len);
	char	c;

	cma_typ xcma,rcma=CMA;
	for(i=Len; i > 0;  i--){
		start=end=0;
		c=tolower(Operation[i]);
		if(c == 'd'){
		   for(start=end=j=i; j > 0; ){ 
			j--; c=tolower(Operation[j]);
			if(c == 'd') start=j; else break; 
		   } i=start;
		   // fprintf(stderr,"start=%d; end=%d\n",start,end);
		   if(end == Len){
                      xcma=TrimBlkCMSA(rcma,1,0,end-start+1,1); // Blk=1; RmLeft=0; RmRight < 0; limit=1.
		      if(xcma==0){ if(rcma != CMA) NilCMSA(rcma); return 0; } // too many columns removed!
                   } else if(start==1){
                      xcma=TrimBlkCMSA(rcma,1,end,0,1); // Blk=1; RmLeft < 0; RmRight=0; limit=1.
		      if(xcma==0){ if(rcma != CMA) NilCMSA(rcma); return 0; } // too many columns removed!
		   } else {
	    	      xcma=ConvertColsToInsertsCMSA(rcma,1,start,end);
		  } if(rcma != CMA) NilCMSA(rcma); rcma=xcma;
	        }
	}
	if(rcma == CMA) return 0; else return rcma;
}

char	*cps_typ::BaseName(char *path)
{
	for(Int4 i=strlen(path)-1; i >= 0; i--){
	   if(path[i] == '/'){ i++; return AllocString(&path[i]); }
	} return 0;
}

