
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

int	cps_typ::RunMain( )
{
	Int4	arg,i,j,k,x,nI,nJ,N=NumPDB_ID,NumX,NumM;
	FILE	*tfp=0,*fpI=0,*fpJ=0;
	char	*sp,*spX,*strI,*strJ,pdbID[10],*resX,*resY;
        double	S;
	e_type	sqI,sqJ;

	nI=NumSeqsCMSA(cmaA); nJ=NumSeqsCMSA(cmaB);
	assert(nI==nJ);
	NEW(strI,10005,char); NEW(strJ,10005,char);

// efp=stderr;
	//=============================================================
	//=============== Get COMPASS input parameters ================
	//=============================================================
	NEWP(ArgV,25,char); ArgV[0]=AllocString("compass"); ArgC=1;
	ArgV[1]=AllocString(argv[3]); ArgC++; // path to pdb files.
	ArgV[2]=0; ArgC++; 
        sprintf(str,"-D=%lf",mxD); ArgV[ArgC]=AllocString(str); ArgC++;
        sprintf(str,"-m=%d",minSpace); ArgV[ArgC]=AllocString(str); ArgC++;

	sprintf(str,"%s_X_sprc_X",argv[1]); fpI=open_file(str,".mst","r");
	sprintf(str,"%s_X_sprc_X",argv[2]); fpJ=open_file(str,".mst","r");
	for(i=0; fgets(strI,10000,fpI) != NULL; i++) ; rewind(fpI); 
	for(j=0; fgets(strJ,10000,fpJ) != NULL; j++) ; rewind(fpJ);
	i = MAXIMUM(Int4,i,j);
	set_typ	MstI=MakeSet(i+3),MstJ=MakeSet(i+3);
	ClearSet(MstI); ClearSet(MstJ);
	double  mxPCID,*NewMaxPCID;  NEW(NewMaxPCID,N+5,double);

	for(NN=0,i=1; i <= N; i++){
	    //=============================================================
	    //============ Get seqs from the DCA alignment.. ===============
	    //=============================================================
#if 0
	    resX & resY correspond to the DCA alignment without leading 'x'.
	    ResI & ResJ correspond to resX & Y without leading gaps '-'.
	    sqI & sqJ are the e_type versions of resX and resY (i.e., without gaps).
	    sqPDB is the unaligned pdb sequence.
#endif
	    char *ResI=0,*ResJ=0; 	// correspond to resX & Y without '-'.
	    Int4 I,num_resC;
	    sqI=this->RtnResI_SqI(fpI,i,MstI,resX,strI,pdbID,ResI);
	    if(sqI == 0){ NumBadMstStrct++; rewind(fpI); continue; }
	    sqJ=this->RtnResI_SqI(fpJ,i,MstJ,resY,strJ,pdbID,ResJ);
	    if(sqJ == 0){
		free(resX); resX=0; rewind(fpJ); rewind(fpI); free(ResI);  
		NumBadMstStrct++; continue;
	    } rewind(fpJ); rewind(fpI);
// efp=stderr;
	    if(efp) fprintf(efp,
		"%d(%s): ResI=%s\n\tresX=%s\n\tResJ=%s\n\tresY=%s\n\n",
			i,pdb_id[i],ResI,resX,ResJ,resY);
#if 0
if(strncmp(pdb_id[i],"1H65",4)==0){
   fprintf(stderr,"%d(%s): ResI=%s\n\tresX=%s\n\tResJ=%s\n\tresY=%s\n\n",
			i,pdb_id[i],ResI,resX,ResJ,resY);
   PutSeq(stderr,sqI,AB); PutSeq(stderr,sqJ,AB);
}
#endif
// efp=0;
	    mxPCID=MaxPCID[i];	// to map to new value.
	    //=============================================================
	    //========= make sure that MSA 1 & 2 seqs are the same ========
	    //=============================================================
	    Int4 rtn,AdjstI,AdjstJ,MinOverlap=10;
	    rtn=this->IsSameSeq(sqI,sqJ,&AdjstI,MinOverlap,NumX,NumM);
	    if(rtn == 0 || NumX > NumM){
		fprintf(logfp,"%s: aligned seqs don't match; skipped\n",pdb_id[i]);
		NumNoMatStrct++;
		if(efp){
		   AlnSeqSW(stderr,11,1,sqI,sqJ,AB); 
		   fprintf(stderr,"%s: rtn=%d; Adjst=%d; numX=%d; numM=%d\n",
			pdb_id[i],rtn,AdjstI,NumX,NumM);
		} NilSeq(sqI); NilSeq(sqJ); free(ResI); free(ResJ); free(resX); resX=0;
		continue;
	   }
#if 0
if(strncmp(pdb_id[i],"5A3F",4)==0){ AlnSeqSW(stderr,11,1,sqI,sqJ,AB); }
#endif

	    //===========================================================
	    //================== Get pdb coordinates ====================
	    //===========================================================
	    char mode='M',chn=pdbID[5];
	    Int4 min,max,chnK;
	    pdb_typ pdb=this->SafeOpenPDB(pdbID,min,max,chnK); // truncates pdbID!
	    e_type  sqPDB=0;
	    if(pdb==0 || (sqPDB=GetPDBSeq(chnK,pdb)) == 0){
		if(pdb){ 
		  NilPDB(pdb);
		  if(logfp) fprintf(logfp,"%s%c does not exist; skipped\n",pdbID,chn); 
		  NumMissingStrct++;
		} NilSeq(sqI); NilSeq(sqJ); free(ResI); free(ResJ);
		free(resX); resX=0; continue;
	    }

	    //==============================================================
	    //=============== find start of overlap with pdb ===============
	    //==============================================================
	    // Int4 maxXIJ=50;	// maximum number of 'X' residues in pdb files.
	    Int4 rtnI,rtnJ,nXI=0,nXJ=0,nMI=0,nMJ=0;
	    rtnI=this->IsSameSeq(sqI,sqPDB,&AdjstI,MinOverlap,nXI,nMI);
	    if(rtnI != 0) rtnJ=this->IsSameSeq(sqJ,sqPDB,&AdjstJ,MinOverlap,nXJ,nMJ);
	    if(rtnI == 0 || rtnJ == 0 || (LenA/2) > nMI || (nMJ && (LenB/2) > nMJ)
		|| (nXI > MaxXIJ && nXJ > MaxXIJ))
	    {
		if(rtnI==0 || rtnJ==0){
		  fprintf(logfp,"%s: aligned seqs don't match '%s'; skipped\n",
			pdb_id[i],pdbID);
		  NumNoMatStrct++;
   		  // fprintf(logfp,"\tMSA 1=%s\n\tMSA 2=%s\n",resX,resY);
		} else {
		  Int4 nDel=MAXIMUM(Int4,LenA-nMI,LenB-nMJ);
		  if(0){
		    AlnSeqSW(stderr,11,1,sqI,sqPDB,AB); 
		    AlnSeqSW(stderr,11,1,sqJ,sqPDB,AB); 
		    PutSeq(stderr,sqI,AB); PutSeq(stderr,sqJ,AB);
		    PutSeq(stderr,sqPDB,AB);
		    fprintf(stderr,"LenA=%d; nMI=%d; LenB=%d; nMJ=%d\n",
						LenA,nMI,LenB,nMJ);
		    fprintf(stderr,"nXI=%d; MaxXIJ=%d; nXJ=%d; nDel=%d\n",
						nXI,MaxXIJ,nXJ,nDel);
		  }
		  fprintf(logfp,
		    "%s: seq alignment has %d deletions; skipped\n",pdbID,nDel);
		  NumNoMatStrct++; // NumRefStrctReject[0]++;
		}
// efp=stderr;
		if(efp){
   		   fprintf(stderr,
		       "%d(%s): ResI=%s\n\tresX=%s\n\tResJ=%s\n\tresY=%s\n\n",
			i,pdb_id[i],ResI,resX,ResJ,resY);
   		   PutSeq(stderr,sqI,AB); PutSeq(stderr,sqJ,AB);
		   PutSeq(stderr,sqPDB,AB);
		   AlnSeqSW(stderr,11,1,sqI,sqPDB,AB); 
		   AlnSeqSW(stderr,11,1,sqJ,sqPDB,AB); 
		   fprintf(stderr,
			"nXI=%d; nMI=%d; nXJ=%d; nMJ=%d; rtnI=%d; rtnJ=%d\n",
					nXI,nMI,nXJ,nMJ,rtnI,rtnJ);
		   fprintf(stderr,"%s: AdjstI=%d; AdjstJ=%d\n",pdb_id[i],AdjstI,AdjstJ);
// efp=0;
		} NilPDB(pdb); NilSeq(sqPDB); NilSeq(sqI); NilSeq(sqJ);
		free(ResI); free(ResJ); free(resX); resX=0;
		continue;
	    }
	    if(efp) fprintf(efp,"====== %s/%s_H.pdb (%d) ======\n",
					argv[3],pdbID, MinResPDB(chnK,pdb)); 
	    if(rtnI == 1) AdjstI *=-1; // sqI lacks an N-terminal extension.
	    if(efp){ this->PutDebug1(i,AdjstI,'I',sqI,sqPDB,min,rtn); }
	    if(rtnJ == 1) AdjstJ *=-1; // sqJ lacks an N-terminal extension.
	    if(efp){ this->PutDebug1(i,AdjstJ,'J',sqJ,sqPDB,min,rtn); }
	    //====================================================================
	    //======= map the residues in sqPDB that can be used for COMPASS. ====
	    //====================================================================
	    res_typ *ResALL=MakeResPDB(chnK,&num_resC,pdb);
	    if(efp){
	      fprintf(efp,"%d. %s: adjI=%d; adjJ=%d; nresC=%d; min=%d; max=%d\n\n",
			i,pdb_id[i],AdjstI,AdjstJ,num_resC,min,max);
	    }
	    set_typ SetUsd=MakeSet(max+5); ClearSet(SetUsd); 
//if(strncmp(pdb_id[i],"1ZPU",4)==0){ efp=stderr; AlnSeqSW(stderr,11,1,sqI,sqJ,AB); }
// set_typ SetA=MakeSet(LengthCMSA(1,cmaA)+max+5); ClearSet(SetA); 
// set_typ SetB=MakeSet(LengthCMSA(1,cmaB)+max+5); ClearSet(SetB); 
// efp=stderr;
// if(efp) fprintf(efp,"AdjstI=%d; AdjstJ=%d\n",AdjstI,AdjstJ);
	    for(k=1; k <= num_resC; k++){
		I=ResidueID(ResALL[k]);
		Int4 pos=I-min+1,hits=0,posI=pos+AdjstI,posJ=pos+AdjstJ;
	        if(efp) fprintf(efp,"%d. %c%d (%d)",k,
			AlphaChar(ResSeq(pos,sqPDB),AB),I,pos);
	        if(posI > 0 && posI <= LenSeq(sqI)){
		  if(efp)fprintf(efp,"\t%c%d %c", AlphaChar(ResSeq(posI,sqI),AB),
				posI,ResI[posI-1]);
		  if(isupper(ResI[posI-1])){ hits++; }
		  // if(isupper(ResI[posI-1])){ hits++; AddSet(posI,SetA); }
		} else if(efp) fprintf(efp,"\t");
	        if(posJ > 0 && posJ <= LenSeq(sqJ)){
		  if(efp) fprintf(efp,"\t%c%d %c", AlphaChar(ResSeq(posJ,sqJ),AB),
				posJ,ResJ[posJ-1]);
		  if(isupper(ResJ[posJ-1])){ hits++; }
		  // if(isupper(ResJ[posJ-1])){ hits++; AddSet(posJ,SetB); }
		}
		if(efp){ if(hits==2){ fprintf(efp,"*"); } fprintf(efp,"\n"); }
		if(hits == 2) AddSet(k,SetUsd);
	    } NilSeq(sqI); NilSeq(sqJ); 
// if(strncmp(pdb_id[i],"1ZPU",4)==0) efp=0;
// efp=0;

	    //==============================================================
	    //======================== Run SPARC ===========================
	    //==============================================================
#if 0	// output for Simulation study...
PutSet(stdout,SetUsd); 
PutSet(stdout,SetA); 
PutSet(stdout,SetB); 
NilSet(SetA); NilSet(SetB);
#endif
	    if((x=CardSet(SetUsd)) < 10){
		if(x==0){
		   fprintf(logfp,
			"%s: aligned seqs don't overlap (distinct domains?); skipped\n",
				pdb_id[i]);
		} else {
		   fprintf(logfp,
			"%s: too few (%d) shared columns for S-score; skipped\n",
			pdbID,CardSet(SetUsd));
		} NilPDB(pdb); free(resY); free(resX); NilSet(SetUsd); NilSeq(sqPDB);
	    } else {
	      if(efp) fprintf(stderr,"========== %s ==============\n",pdbID);
	      if(i > 1) mode='m';

	      double S1,S2,dS;
	      Int4   Rtn;
              sprc_typ *sprc=0;
              dch_typ *dch1= new dch_typ(hpsz);
	      if(ArgV[2]) free(ArgV[2]);
	      sprintf(str,"%s_X_sprc_X",argv[1]); ArgV[2]=AllocString(str); 
              sprc = new sprc_typ(ArgC,ArgV,dch1);
	      Rtn=sprc->RunCMPSS(strI,pdbID,chn,mode,logfp,SetUsd);
	      S1=dch1->GetMaxScore();
	      delete sprc;

              dch_typ *dch2= new dch_typ(hpsz);
	      if(ArgV[2]) free(ArgV[2]);
	      sprintf(str,"%s_X_sprc_X",argv[2]); ArgV[2]=AllocString(str);
              sprc = new sprc_typ(ArgC,ArgV,dch2);
	      Rtn=sprc->RunCMPSS(strJ,pdbID,chn,mode,logfp,SetUsd);
	      S2=dch2->GetMaxScore();
	      delete sprc;
	      //==============================================================
	      //====================== Save results ==========================
#if 0	//==== discard if shares > 90% identity with other seq. already on the list
	      for(Int4 nn=1; nn < NN; nn++){
		
	      }
#endif
	      //==============================================================
	      if(S1 >= 0.0 && S2 >= 0.0){
		dS=S1-S2; 
	        NN++; DCH[1][NN]=dch1; DCH[2][NN]=dch2;
		PDBID[NN]=AllocString(pdbID);
		NewMaxPCID[NN]=mxPCID;
#if 0
		if(strncmp(pdbID,"2z4d",4)==0){
			fprintf(stderr,"%s: %s\n  %s\n",pdbID,resX,resY); exit(1); }
#endif
	    	PDB[NN]=pdb; CHN[NN]=chn; ResX[NN]=resX; ResY[NN]=resY;
// ResX[NN]=ResI; ResY[NN]=ResJ;
		AdjstX[NN]=AdjstI; AdjstY[NN]=AdjstJ; UsdSet[NN]=SetUsd;
		SEQ[NN]=sqPDB;
	        if(efp) PutSet(efp,SetUsd);
	      } else { 
		fprintf(logfp,"Skipping %s; problematic structure\n",pdbID);
		delete dch1; delete dch2;
		NilPDB(pdb); free(resY); free(resX); NilSet(SetUsd); NilSeq(sqPDB);
	      }
	    } 
free(ResI); free(ResJ);
// free(resX); free(resY);
	    for(j=1; j <= num_resC; j++) if(ResALL[j]) NilRes(ResALL[j]); free(ResALL);
	}
	free(MaxPCID); MaxPCID=NewMaxPCID;
	fclose(fpI); fclose(fpJ); NilSet(MstI); NilSet(MstJ);
	free(strI); free(strJ); // free(Str);
	for(Int4 a=0; a < ArgC; a++){ free(ArgV[a]); ArgV[a]=0; } free(ArgV);
	return 0;
}

void	cps_typ::PutDebug1(Int4 i,Int4 adj,char IJ, e_type sqE,e_type sqPDB,
			Int4 min,Int4 rtn)
{
	if(efp){
	      fprintf(efp,"%d. %s: adj%c=%d; min=%d; rtn=%d\n",
				i,pdb_id[i],IJ,adj,min,rtn);
	      PutDiagonalSeq(efp,adj,sqE,sqPDB,AB);
	      PutSeq(efp,sqE,AB); AlnSeqSW(efp,11,1,sqPDB,sqE,AB);
	}
}

