
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

void	cps_typ::Put()
{
	double	avgS[6]; avgS[1]=avgS[2]=avgS[3]=avgS[4]=0.0;
	double	avg_dS; avg_dS=0.0;
	double	avg_dSn; avg_dSn=0.0;
	double	Avg_dS; Avg_dS=0.0;
	Int4	x,i,cnt=0,pos=0,neg=0,Pos=0,Neg=0;
	BooLean	TooSimilar=FALSE;
	double	SD,dS_mean,dS_sd;
	Int4   sumX[6]; sumX[1]=sumX[2]=sumX[3]=sumX[4]=0; 
	Int4   sumD[6]; sumD[1]=sumD[2]=sumD[3]=sumD[4]=0;
	fflush(outfp); fflush(stderr);

	fprintf(outfp,"============= STARC S-scores (z=%.1lf; m=%d) ===============\n",
		mxD,minSpace);
	h_type  HG=0; HG=Histogram("Delta S-scores",-100,100,0.1);
	h_type  aHG=0; aHG=Histogram("Delta S-scores",-100,100,0.1);
	fprintf(outfp,"     MSA 1: %s (%s)\n",name1,NameCMSA(cmaA));
	fprintf(outfp,"     MSA 2: %s (%s)\n\n",name2,NameCMSA(cmaB));
	// fprintf(outfp,"n\tS1\tX1\td1\tS2\tX2\td2\tdS\tpdb\tcols\tD\tL\tavgSW\tMaxSW\n");
    if(UseGoldStd){  // for simulations
	fprintf(outfp,"n\tS0\tS1\tdS\tSnorm\tpdbid\tcols\tL\n");
	Int4	x,i,cnt=0,pos=0,neg=0,Pos=0,Neg=0;
	BooLean	TooSimilar=FALSE;
	for(i=1; i <= NN; i++){
	        Int4 d1,d2,D1,D2,X1,X2,L1,L2;
		char *pdbID=PDBID[i],flag=' ',flg=' ';
	        double S1,S2,dS;
assert(DCH[1][i]->NumItemsInMHeap() ==1);
		S1=(double)DCH[1][i]->RtnMaxResults(D1,d1,X1,L1);
assert(DCH[2][i]->NumItemsInMHeap() ==1);
	        S2=(double)DCH[2][i]->RtnMaxResults(D2,d2,X2,L2);
#if 1
		if(D1 != D2 || L1 != L2){
		    print_error("The input MSAs contain different numbers of pairs\n");
		}
#else
	        assert(D1 == D2); assert(L1 == L2);
#endif
		if(stdev && stdev[1][i] >= cutoff){ flag=flg='*'; }
		else flag=' ';
		flg=flag;
	        fprintf(outfp,"%d\t%.1lf%c",i,S1,flag);
	        // fprintf(outfp,"\t%d\t%d",X1,d1);
		if(stdev && stdev[2][i] >= cutoff){ flag=flg='*'; }
		else flag=' ';
	        dS = S1-S2;
	        fprintf(outfp,"\t%.1lf%c",S2,flag);
	        // fprintf(outfp,"\t%d\t%d",X2,d2);
	        fprintf(outfp,"\t%.1lf\t%.4lf\t%s%c\t%d\t%d",
			dS,S2/S1,pdbID,CHN[i],CardSet(UsdSet[i]),L2);
		fprintf(outfp,"\n");
		if(flg == ' ') {
	          if(HG) IncdHist(dS,HG);
		  cnt++; avgS[1] += S1; sumX[1] += X1; sumD[1] += d1; 
	          avgS[2] += S2; avg_dS += dS; sumX[2]+=X2; sumD[2] += d2; 
		  avg_dSn += (S2/S1);
		  if(dS > 0.0) pos++; else if(dS < 0.0) neg++;
		}
		if(dS > 0.0) Pos++; else if(dS < 0.0) Neg++;
	        if(aHG) IncdHist(dS,aHG);
		avgS[3] += S1; sumX[3]+=X1; sumD[3] += d1; 
	        avgS[4] += S2; sumX[4]+=X2; sumD[4] += d2; Avg_dS+=dS;
                if(KeepAllOut || MaxPCID[i] > 0.0){
		   if(TooSimilar==FALSE){
			TooSimilar=TRUE;
                   	fprintf(logfp,"Reference structures sharing > 50%c identity:\n",
				'%');
		   }
                   fprintf(logfp,"%d.%s: %.1lf%c; S1=%.2lf; S2=%.2lf; dS=%.2lf;",
                        i,pdbID,100.*MaxPCID[i],'%',S1,S2,dS);
                   fprintf(logfp, " DD1=%.2lf; DD2=%.2lf; avg_DD=%.4lf\n",
			stdev[3][i],stdev[4][i],(stdev[3][i]+stdev[4][i])/2.0);
                }
	}
	SD=sqrt(VarianceHist(HG));
	dS_mean=MeanHist(HG);
	dS_sd=(avg_dS-dS_mean)/SD;
	fprintf(outfp,"avg\t%.1lf",avgS[1]/(double)cnt);
	fprintf(outfp,"\t%.1lf\t%.1lf\t%.1lf",avgS[2]/(double)cnt,
			avg_dS/(double)cnt,avg_dSn/(double)cnt);
	fprintf(outfp,"\t(%d outliers removed)\n",NN-cnt);
   } else {
	fprintf(outfp,"n\tS1\tX1\td1\tS2\tX2\td2\tdS\tpdbid\tcols\tD\tL\n");
	for(i=1; i <= NN; i++){
	        Int4 d1,d2,D1,D2,X1,X2,L1,L2;
		char *pdbID=PDBID[i],flag=' ',flg=' ';
	        double S1,S2,dS;
assert(DCH[1][i]->NumItemsInMHeap() ==1);
		S1=(double)DCH[1][i]->RtnMaxResults(D1,d1,X1,L1);
assert(DCH[2][i]->NumItemsInMHeap() ==1);
	        S2=(double)DCH[2][i]->RtnMaxResults(D2,d2,X2,L2);
		if(L1 != L2 || D1 != D2){
			fprintf(stderr,"L1=%d; L2=%d\n",L1,L2);
			fprintf(stderr,"D1=%d; D2=%d\n",D1,D2);
	        	assert(D1 == D2); assert(L1 == L2);
		}
		if(stdev && stdev[1][i] >= cutoff){ flag=flg='*'; }
		else flag=' ';
		flg=flag;
	        fprintf(outfp,"%d\t%.1lf%c",i,S1,flag);
	        fprintf(outfp,"\t%d\t%d",X1,d1);
		if(stdev && stdev[2][i] >= cutoff){ flag=flg='*'; }
		else flag=' ';
	        dS = S1-S2;
	        fprintf(outfp,"\t%.1lf%c",S2,flag);
	        fprintf(outfp,"\t%d\t%d",X2,d2);
	        fprintf(outfp,"\t%.1lf%c\t%s%c\t%d\t%d\t%d",
			dS,flg,pdbID,CHN[i],CardSet(UsdSet[i]),D2,L2);
		fprintf(outfp,"\n");
		if(flg == ' ') {
	          if(HG) IncdHist(dS,HG);
		  cnt++; avgS[1] += S1; sumX[1] += X1; sumD[1] += d1; 
	          avgS[2] += S2; avg_dS += dS; sumX[2]+=X2; sumD[2] += d2; 
		  if(std::abs(dS) >= SignCut_dS){
		    if(dS > 0.0) pos++; else if(dS < 0.0) neg++;
		  }
		}
		if(std::abs(dS) >= SignCut_dS){
		    if(dS > 0.0) Pos++; else if(dS < 0.0) Neg++;
		}
	        if(aHG) IncdHist(dS,aHG);
		avgS[3] += S1; sumX[3]+=X1; sumD[3] += d1; 
	        avgS[4] += S2; sumX[4]+=X2; sumD[4] += d2; Avg_dS+=dS;
                if(KeepAllOut || MaxPCID[i] > 0.0){
		   if(TooSimilar==FALSE){
			TooSimilar=TRUE;
                   	fprintf(logfp,"Reference structures sharing > 50%c identity:\n",
				'%');
		   }
                   fprintf(logfp,"%d.%s: %.1lf%c; S1=%.2lf; S2=%.2lf; dS=%.2lf;",
                        i,pdbID,100.*MaxPCID[i],'%',S1,S2,dS);
                   fprintf(logfp, " DD1=%.2lf; DD2=%.2lf; avg_DD=%.4lf\n",
			stdev[3][i],stdev[4][i],(stdev[3][i]+stdev[4][i])/2.0);
                }
	}
	SD=sqrt(VarianceHist(HG));
	dS_mean=MeanHist(HG);
	dS_sd=(avg_dS - dS_mean)/SD;
	fprintf(outfp,"avg\t%.1lf\t%.1lf\t%.1lf",avgS[1]/(double)cnt,
			(double)sumX[1]/(double)cnt,(double)sumD[1]/(double)cnt);
	fprintf(outfp,"\t%.1lf\t%.1lf\t%.1lf\t%.1lf +/- %.1lf",avgS[2]/(double)cnt,
			(double)sumX[2]/(double)cnt,(double)sumD[2]/(double)cnt,
			avg_dS/(double)cnt,SD);
	fprintf(outfp," (%d outliers removed)\n",NN-cnt);
   }
	if(stdev){
	  free(stdev[1]); free(stdev[2]);
	  free(stdev[3]); free(stdev[4]); free(stdev);
	}

    if(cnt != NN){	// all dS included...
	SD=sqrt(VarianceHist(aHG));
	dS_mean=MeanHist(aHG);
	dS_sd = (avg_dS - dS_mean)/SD;
	fprintf(outfp,"avg\t%.1lf\t%.1lf\t%.1lf",avgS[3]/(double)NN,
			(double)sumX[3]/(double)NN,(double)sumD[3]/(double)NN);
	fprintf(outfp,"\t%.1lf\t%.1lf\t%.1lf\t%.1lf +/- %.1lf",avgS[4]/(double)NN,
			(double)sumX[4]/(double)NN,(double)sumD[4]/(double)NN,
			Avg_dS/(double)NN,SD);
	fprintf(outfp," (no outliers removed)\n");
    }
	if(!KeepAllOut) {
	  fprintf(outfp,
	  "    * = outliers with avg. distance difference >= %.2lf SD above the mean...\n",
			cutoff);
	  fprintf(outfp,
	  "             ...(SD recomputed after removing outliers iteratively).\n\n");
	}
     	// Cumulative binomial probability:
	Int4 ps,ng;
	char	*title=0;
	if(KeepAllOut) x=2; else x=1;
#if 1	// output parameter settings;
	fprintf(outfp," settings: ");
	fprintf(outfp,
	   "wt=%.2lf; L1=%.1lf; maxX=%d; maxD=%.1lf; dScut=%.1lf; pc=%d%c\n\n",
		ccm_wt,ccm_LF,MaxXIJ,mxD,SignCut_dS,PercentID,'%');
#endif
	for( ; x <= 2; x++){
	  if(x==1){ ps=pos; ng=neg; title=AllocString("omit outliers"); }
	  else { ps=Pos; ng=Neg; title=AllocString("keep outliers"); }
	  double cbp=1.0,lgcbp=0.0;
	  if(ps > ng){
		cbp = 2.0*CumBinomProb(ps,ps+ng,0.5);
		lgcbp=log10(2.0) + Log10CBP(ps,ps+ng,0.5);
	  } else if(ps < ng){
		cbp = 2.0*CumBinomProb(ng,ps+ng,0.5);
		lgcbp=log10(2.0) + Log10CBP(ng,ps+ng,0.5);
	  }
	  if(cbp > 1.0) cbp=1.0;
	  // cbp += CumBinomProb(neg,pos+neg,0.5);
	  fprintf(outfp," %s (%2d vs %2d): 2-tail BP=%.2g; -log10(BP)=%.3g\n",
		title,ps,ng,cbp,-lgcbp,title);
	  free(title);
	} fprintf(outfp,"\n");
	for(i=1; i <=2; i++){ 
	   x=NumRefStrctReject[i];
	   if(x > 0) fprintf(outfp,
	          "\t!!! MSA %d: %d structures had too few aligned residues to use !!!\n",
			i,x);
	} fprintf(outfp,"\n");

	
	fprintf(outfp,"\t===== %d aligned reference structures =====\n",
			NumAlignedStrct);
	Int4	X,XX=0;
	X=NumMissingStrct + NumBadStrct + NumNoMatStrct + NumRefStrctReject[0];
	X = X + NumBadMstStrct;
	if(X > 0){
	  if((x=NumMissingStrct) > 0){
		fprintf(outfp, "\t%d structures not in pdb directory\n",x);
		XX+=x;
	  }
	  if((x=NumBadStrct) > 0){
		fprintf(outfp,"\t%d coordinate files had problems\n",x);
		XX+=x;
	  }
	  if((x=NumNoMatStrct) > 0){
		fprintf(outfp, "\t%d structure alignments lack correspondence\n",x);
		XX+=x;
	  }
	  if((x=NumRefStrctReject[0]) > 0){
		fprintf(outfp, "\t%d structures had too few aligned residues\n",x);
		XX+=x;
	  }
	  if((x=NumBadMstStrct) > 0){
		fprintf(outfp, "\t%d structures had DCA file problems\n",x);
		XX+=x;
	  }
	  if(NN > 0){
		fprintf(outfp, "\t----\n\t%d reference structures were used\n",NN);
		XX+=NN;
	  } fprintf(outfp,"\t----\n\tTotal=%d\n",XX);
	  fprintf(outfp,"\n");
	}
	// if(HG){ PutHist(stderr,60,HG); }
	if(HG){ NilHist(HG); }
	if(aHG){ NilHist(aHG); }
}


