
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

e_type	cps_typ::RtnResI_SqI(FILE *fp,Int4 i,set_typ MstI, char *&resX, 
		char *strI, char pdbID[],char *&ResI)
{
        Int4	j,k;
	ResI=this->GetResidues(fp,i,MstI,resX,strI,pdbID);
        if(ResI==0){
                fprintf(logfp,"Not found: pdb_id[%d]=%s\n",i,pdb_id[i]);
                return 0;
        }
        for(j=k=0; ResI[j]; j++){
                if(isalpha(ResI[j])){ Str[k]=ResI[j]; k++; }
        } Str[k]=0; free(ResI); ResI=AllocString(Str);
#if 1	// original version.
        for(k=j=0; ResI[k]; k++){
                if(isalpha(ResI[k])){ Str[j]=toupper(ResI[k]); j++; }
        } Str[j]=0;
#else
        for(k=j=0; resX[k]; k++){
                if(isalpha(resX[k])){ Str[j]=toupper(resX[k]); j++; }
        } Str[j]=0;
#endif
        e_type SqI=StringToSeq(Str,pdb_id[i],i,AB);
	return SqI;
}

char	*cps_typ::GetResidues(FILE *fp,Int4 ii,set_typ MstI,
		char *&resX, char *strI, char pdbID[])
// these arrays will be matched to residues for pdb structure files.
{
	Int4	MI;
	char	*sp,*ResI=0;
	for(MI=0; fgets(strI,10000,fp) != NULL; ){
		MI++; 
		if(sscanf(strI,"%6s: %s",pdbID,Str) == 2 
			&& (isalpha(Str[0]) || Str[0]=='-')
			&& strncmp(pdb_id[ii],pdbID,6)== 0
			&& !MemberSet(MI,MstI)){
		   resX=AllocString(Str); ResI=AllocString(Str); 
		   AddSet(MI,MstI); break;
		}
	}
	return ResI;
}

int	cps_typ::IsSameSeq(e_type E1, e_type E2,Int4 *Start,Int4 MinOverlap,
		Int4 &NumX,Int4 &NumM,BooLean IgnoreX)
// find out whether or not E1 and E2 are the same sequence.
// return 1 if seq E1 lacks an N-terminal extension.
// return 2 if seq E2 lacks an N-terminal extension.
{
        Int4    st,sp,sb,end,lenSb,lenSp,test,numX,numM,Overlap;
        int	rtn=0;
        unsigned char   *sup,*sub;      // superseq and subseq
        BooLean IsSub=FALSE;

   if(LenSeq(E1) < MinOverlap || LenSeq(E2) < MinOverlap) return 0;
#if 0
char sqid[20];
const char keyid[]="1H65_A";
StrSeqID(sqid, 8, E1);
fprintf(stderr,"sqid=%s; key=%s\n",sqid,keyid);
rtn=strcmp(sqid,"1H65_A");
if(rtn==0) { PutSeq(stderr,E1,AB); PutSeq(stderr,E2,AB); }
#endif
   for(rtn=1; rtn <= 2; rtn++){
      if(rtn==1){	// 1. start from sequence E1 and inch along seq. E2.
   	sup=SeqPtr(E2); sub=SeqPtr(E1); 
	lenSp=LenSeq(E2); lenSb=LenSeq(E1); 
      } else { 		// 2. if failed: start from sequence E2 and inch along seq. E1.
	sup=SeqPtr(E1); sub=SeqPtr(E2);
	lenSp=LenSeq(E1); lenSb=LenSeq(E2); 
      }
      end=lenSp - MinOverlap + 1;
      if(IgnoreX){ // ignore 'X' residues (in pdb files)
#if 0
	      1                lenSb
          sb  +---------+------+                         +---------+------+  sb
              |--MinOL--|                                |--MinOL--|
          sp  +---------+-----+  --> from..to -->  +-----+---------+         sp
             st=1             lenSp                      st=end    lenSp

             st=1             lenSp                      st=end    lenSp
          sp  +---------+------+                    +------+---------+  sb
              |--MinOL--|                                  |--MinOL--|
          sb  +---------+-----+  --> from..to -->          +---------+-----+ sp
	      1                                            1
#endif
        for(st=1; st<= end; st++){
	  if((lenSp-st+1) < MinOverlap) break;
	  Int4 ndummy=0;	// 'X' residues for both sequences
          for(numM=numX=0,IsSub=TRUE,sp=st,sb=1; sb <= lenSb && sp <= lenSp; sb++,sp++){
            if(sup[sp]==0 && sub[sb]==0){
		// if(numM == 0 && numX == 0) ndummy++;
		continue;  // don't count as 'X';
	    } else if(sup[sp]==0 || sub[sb]==0){
#if 0
		if(numM==0) { PutSeq(stderr,E1,AB); PutSeq(stderr,E2,AB); }
#endif
		numX++; continue; 
	    } else if(sup[sp] != sub[sb]){ IsSub=FALSE; break; 
	    } else numM++;
          }
          if(IsSub){
#if 0
		// Overlap=lenSb-st+1-numX;
		Int4 stop=MINIMUM(Int4,lenSb,lenSp);
		Overlap=stop-st+1-numX;
fprintf(stderr,"Overlap=%d < %d? st=%d; lenSp=%d; lenSb=%d;rtn=%d;numX=%d;numM=%d\n",
			Overlap,MinOverlap,st,lenSp,lenSb,rtn,numX,numM);
		if(Overlap < MinOverlap) continue; // can only get shorter from here...
#else
if(0) fprintf(stderr,"minOL=%d; st=%d; lenSp=%d; lenSb=%d;rtn=%d;numX=%d;numM=%d\n",
			MinOverlap,st-1,lenSp,lenSb,rtn,numX,numM);
		if(numM < MinOverlap) continue;
#endif
		// fprintf(stderr,"ndummy=%d\n",ndummy);
		*Start=st-1; // *Start=st-1+ndummy; 
		NumX=numX; NumM=numM; return rtn; 
	  }
        }
      } else {
        for(st=1; st<= end; st++){
	  if((lenSp-st+1) < MinOverlap) break;
          for(IsSub=TRUE,sp=st,sb=1; sb <= lenSb && sp <= lenSp; sb++,sp++){
            if(sup[sp] != sub[sb]){ IsSub=FALSE; break; }
          }
          if(IsSub){
		Overlap=lenSb-st+1;
		if(Overlap < MinOverlap) continue; // can only get shorter ...
		*Start=st-1; return rtn; 
	  }
        }
      }
   } return 0;
}

